/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.rubytime;

import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import org.embulk.util.rubytime.Format;
import org.embulk.util.rubytime.FormatDirective;
import org.embulk.util.rubytime.FormatDirectiveOptions;
import org.embulk.util.rubytime.FormatToken;
import org.embulk.util.rubytime.RubyDateTimeFormatter;

final class FormatterWithContext {
    private static final FormatDirectiveOptions DEFAULT;
    private static final int[] POW10;
    private static final Map<DayOfWeek, String> DAY_OF_WEEK_FULL_NAMES;
    private static final Map<DayOfWeek, String> DAY_OF_WEEK_ABBREVIATED_NAMES;
    private static final Map<Month, String> MONTH_FULL_NAMES;
    private static final Map<Month, String> MONTH_ABBREVIATED_NAMES;
    private final TemporalAccessor temporal;

    FormatterWithContext(TemporalAccessor temporal) {
        this.temporal = temporal;
    }

    String format(Format format) {
        return this.format(format, RubyDateTimeFormatter.ZoneNameStyle.NONE);
    }

    String format(Format format, RubyDateTimeFormatter.ZoneNameStyle zoneNameStyle) {
        StringBuilder builder = new StringBuilder();
        for (Format.TokenWithNext tokenWithNext : format) {
            FormatToken token = tokenWithNext.getToken();
            if (token.isImmediate()) {
                builder.append(token.getImmediate().get());
                continue;
            }
            FormatDirective directive = token.getFormatDirective().get();
            FormatDirectiveOptions options = token.getDirectiveOptions().get();
            switch (directive) {
                case IMMEDIATE_PERCENT: {
                    this.fillPadding(builder, options, ' ', 0, 1);
                    builder.append('%');
                    break;
                }
                case IMMEDIATE_NEWLINE: {
                    this.fillPadding(builder, options, ' ', 0, 1);
                    builder.append('\n');
                    break;
                }
                case IMMEDIATE_TAB: {
                    this.fillPadding(builder, options, ' ', 0, 1);
                    builder.append('\t');
                    break;
                }
                case DAY_OF_WEEK_ABBREVIATED_NAME: {
                    this.appendDayOfWeekName(builder, options, true);
                    break;
                }
                case DAY_OF_WEEK_FULL_NAME: {
                    this.appendDayOfWeekName(builder, options, false);
                    break;
                }
                case MONTH_OF_YEAR_ABBREVIATED_NAME: 
                case MONTH_OF_YEAR_ABBREVIATED_NAME_ALIAS_SMALL_H: {
                    this.appendMonthOfYearName(builder, options, true);
                    break;
                }
                case MONTH_OF_YEAR_FULL_NAME: {
                    this.appendMonthOfYearName(builder, options, false);
                    break;
                }
                case CENTURY: {
                    this.appendCentury(builder, options);
                    break;
                }
                case DAY_OF_MONTH_ZERO_PADDED: {
                    this.appendDayOfMonth(builder, options, '0');
                    break;
                }
                case DAY_OF_MONTH_BLANK_PADDED: {
                    this.appendDayOfMonth(builder, options, ' ');
                    break;
                }
                case WEEK_BASED_YEAR_WITH_CENTURY: {
                    this.appendWeekBasedYear(builder, options, true);
                    break;
                }
                case WEEK_BASED_YEAR_WITHOUT_CENTURY: {
                    this.appendWeekBasedYear(builder, options, false);
                    break;
                }
                case HOUR_OF_DAY_ZERO_PADDED: {
                    this.appendHourOfDay(builder, options, '0');
                    break;
                }
                case HOUR_OF_DAY_BLANK_PADDED: {
                    this.appendHourOfDay(builder, options, ' ');
                    break;
                }
                case HOUR_OF_AMPM_ZERO_PADDED: {
                    this.appendHourOfAmPm(builder, options, '0');
                    break;
                }
                case HOUR_OF_AMPM_BLANK_PADDED: {
                    this.appendHourOfAmPm(builder, options, ' ');
                    break;
                }
                case DAY_OF_YEAR: {
                    this.appendDayOfYear(builder, options);
                    break;
                }
                case MILLI_OF_SECOND: {
                    this.appendSubsecond(builder, options, 3);
                    break;
                }
                case NANO_OF_SECOND: {
                    this.appendSubsecond(builder, options, 9);
                    break;
                }
                case MINUTE_OF_HOUR: {
                    this.appendMinuteOfHour(builder, options);
                    break;
                }
                case MONTH_OF_YEAR: {
                    this.appendMonthOfYear(builder, options);
                    break;
                }
                case AMPM_OF_DAY_UPPER_CASE: {
                    this.appendAmPmOfDay(builder, options, true);
                    break;
                }
                case AMPM_OF_DAY_LOWER_CASE: {
                    this.appendAmPmOfDay(builder, options, false);
                    break;
                }
                case MILLISECONDS_SINCE_EPOCH: {
                    builder.append(token.getImmediate().orElse(""));
                    break;
                }
                case SECOND_OF_MINUTE: {
                    this.appendSecondOfMinute(builder, options);
                    break;
                }
                case SECONDS_SINCE_EPOCH: {
                    this.appendSecondsSinceEpoch(builder, options);
                    break;
                }
                case WEEK_OF_YEAR_STARTING_WITH_SUNDAY: {
                    this.appendWeekOfYear(builder, options, DayOfWeek.SUNDAY);
                    break;
                }
                case WEEK_OF_YEAR_STARTING_WITH_MONDAY: {
                    this.appendWeekOfYear(builder, options, DayOfWeek.MONDAY);
                    break;
                }
                case DAY_OF_WEEK_STARTING_WITH_MONDAY_1: {
                    this.appendDayOfWeek(builder, options, DayOfWeek.MONDAY);
                    break;
                }
                case WEEK_OF_WEEK_BASED_YEAR: {
                    this.appendWeekOfWeekBasedYear(builder, options);
                    break;
                }
                case DAY_OF_WEEK_STARTING_WITH_SUNDAY_0: {
                    this.appendDayOfWeek(builder, options, DayOfWeek.SUNDAY);
                    break;
                }
                case YEAR_WITH_CENTURY: {
                    this.appendYearWithCentury(builder, options);
                    break;
                }
                case YEAR_WITHOUT_CENTURY: {
                    this.appendYearWithoutCentury(builder, options);
                    break;
                }
                case TIME_ZONE_NAME: {
                    this.appendTimeZoneName(builder, options, zoneNameStyle);
                    break;
                }
                case TIME_OFFSET: {
                    this.appendTimeOffset(builder, token, options);
                    break;
                }
                case RECURRED_LOWER_C: {
                    StringBuilder innerBuilder = new StringBuilder();
                    this.appendDayOfWeekName(innerBuilder, DEFAULT, true);
                    innerBuilder.append(" ");
                    this.appendMonthOfYearName(innerBuilder, DEFAULT, true);
                    innerBuilder.append(" ");
                    this.appendDayOfMonth(innerBuilder, DEFAULT, ' ');
                    innerBuilder.append(" ");
                    this.appendHourOfDay(innerBuilder, DEFAULT, '0');
                    innerBuilder.append(":");
                    this.appendMinuteOfHour(innerBuilder, DEFAULT);
                    innerBuilder.append(":");
                    this.appendSecondOfMinute(innerBuilder, DEFAULT);
                    innerBuilder.append(" ");
                    this.appendYearWithCentury(innerBuilder, DEFAULT);
                    this.fillPadding(builder, options, ' ', 0, innerBuilder.length());
                    if (options.isUpper()) {
                        builder.append(innerBuilder.toString().toUpperCase(Locale.ROOT));
                        break;
                    }
                    builder.append(innerBuilder.toString());
                    break;
                }
                case RECURRED_UPPER_D: 
                case RECURRED_LOWER_X: {
                    StringBuilder innerBuilder = new StringBuilder();
                    this.appendMonthOfYear(innerBuilder, DEFAULT);
                    innerBuilder.append("/");
                    this.appendDayOfMonth(innerBuilder, DEFAULT, '0');
                    innerBuilder.append("/");
                    this.appendYearWithoutCentury(innerBuilder, DEFAULT);
                    this.fillPadding(builder, options, ' ', 0, innerBuilder.length());
                    builder.append(innerBuilder.toString());
                    break;
                }
                case RECURRED_UPPER_F: {
                    StringBuilder innerBuilder = new StringBuilder();
                    this.appendYearWithCentury(innerBuilder, DEFAULT);
                    innerBuilder.append("-");
                    this.appendMonthOfYear(innerBuilder, DEFAULT);
                    innerBuilder.append("-");
                    this.appendDayOfMonth(innerBuilder, DEFAULT, '0');
                    this.fillPadding(builder, options, ' ', 0, innerBuilder.length());
                    builder.append(innerBuilder.toString());
                    break;
                }
                case RECURRED_UPPER_R: {
                    StringBuilder innerBuilder = new StringBuilder();
                    this.appendHourOfDay(innerBuilder, DEFAULT, '0');
                    innerBuilder.append(":");
                    this.appendMinuteOfHour(innerBuilder, DEFAULT);
                    this.fillPadding(builder, options, ' ', 0, innerBuilder.length());
                    builder.append(innerBuilder.toString());
                    break;
                }
                case RECURRED_LOWER_R: {
                    StringBuilder innerBuilder = new StringBuilder();
                    this.appendHourOfAmPm(innerBuilder, DEFAULT, '0');
                    innerBuilder.append(":");
                    this.appendMinuteOfHour(innerBuilder, DEFAULT);
                    innerBuilder.append(":");
                    this.appendSecondOfMinute(innerBuilder, DEFAULT);
                    innerBuilder.append(" ");
                    this.appendAmPmOfDay(innerBuilder, DEFAULT, true);
                    this.fillPadding(builder, options, ' ', 0, innerBuilder.length());
                    builder.append(innerBuilder.toString());
                    break;
                }
                case RECURRED_UPPER_T: 
                case RECURRED_UPPER_X: {
                    StringBuilder innerBuilder = new StringBuilder();
                    this.appendHourOfDay(innerBuilder, DEFAULT, '0');
                    innerBuilder.append(":");
                    this.appendMinuteOfHour(innerBuilder, DEFAULT);
                    innerBuilder.append(":");
                    this.appendSecondOfMinute(innerBuilder, DEFAULT);
                    this.fillPadding(builder, options, ' ', 0, innerBuilder.length());
                    builder.append(innerBuilder.toString());
                    break;
                }
                case RECURRED_LOWER_V: {
                    StringBuilder innerBuilder = new StringBuilder();
                    this.appendDayOfMonth(innerBuilder, DEFAULT, ' ');
                    innerBuilder.append(":");
                    this.appendMonthOfYearName(innerBuilder, DEFAULT, true);
                    innerBuilder.append(":");
                    this.appendYearWithCentury(innerBuilder, DEFAULT);
                    this.fillPadding(builder, options, ' ', 0, innerBuilder.length());
                    if (options.isUpper()) {
                        builder.append(innerBuilder.toString().toUpperCase(Locale.ROOT));
                        break;
                    }
                    builder.append(innerBuilder.toString());
                    break;
                }
                case RECURRED_PLUS: {
                    builder.append(token.getImmediate().orElse(""));
                    break;
                }
            }
        }
        return builder.toString();
    }

    private void fillPadding(StringBuilder builder, FormatDirectiveOptions options, char defaultPadding, int defaultPrecision, int digits) {
        int precision = options.getPrecision(defaultPrecision);
        if (!options.isLeft() && precision > digits) {
            for (int i = 0; i < precision - digits; ++i) {
                builder.append(options.getPadding(defaultPadding));
            }
        }
    }

    private void appendDayOfWeekName(StringBuilder builder, FormatDirectiveOptions options, boolean abbreviated) {
        String dayOfWeek;
        int dayOfWeekNumber = this.temporal.get(ChronoField.DAY_OF_WEEK);
        if (dayOfWeekNumber < 1 || dayOfWeekNumber > 7) {
            dayOfWeek = "?";
        } else {
            String dayOfWeekBeforeCase = abbreviated ? DAY_OF_WEEK_ABBREVIATED_NAMES.get(DayOfWeek.of(dayOfWeekNumber)) : DAY_OF_WEEK_FULL_NAMES.get(DayOfWeek.of(dayOfWeekNumber));
            dayOfWeek = options.isUpper() || options.isChCase() ? dayOfWeekBeforeCase.toUpperCase(Locale.ROOT) : dayOfWeekBeforeCase;
        }
        this.fillPadding(builder, options, ' ', 0, dayOfWeek.length());
        builder.append(dayOfWeek);
    }

    private void appendMonthOfYearName(StringBuilder builder, FormatDirectiveOptions options, boolean abbreviated) {
        String month;
        int monthNumber = this.temporal.get(ChronoField.MONTH_OF_YEAR);
        if (monthNumber < 1 || monthNumber > 12) {
            month = "?";
        } else {
            String monthBeforeCase = abbreviated ? MONTH_ABBREVIATED_NAMES.get(Month.of(monthNumber)) : MONTH_FULL_NAMES.get(Month.of(monthNumber));
            month = options.isUpper() || options.isChCase() ? monthBeforeCase.toUpperCase(Locale.ROOT) : monthBeforeCase;
        }
        this.fillPadding(builder, options, ' ', 0, month.length());
        builder.append(month);
    }

    private void appendCentury(StringBuilder builder, FormatDirectiveOptions options) {
        this.appendLongFormatted(builder, this.temporal.getLong(ChronoField.YEAR) / 100L, options, '0', 2);
    }

    private void appendDayOfMonth(StringBuilder builder, FormatDirectiveOptions options, char defaultPadding) {
        this.appendIntegerFormatted(builder, this.temporal.get(ChronoField.DAY_OF_MONTH), options, defaultPadding, 2);
    }

    private void appendWeekBasedYear(StringBuilder builder, FormatDirectiveOptions options, boolean withCentury) {
        int iso8601WeekNumber = FormatterWithContext.calculateIso8601WeekNumber(this.temporal);
        long year = this.temporal.get(ChronoField.MONTH_OF_YEAR) == 12 && iso8601WeekNumber == 1 ? this.temporal.getLong(ChronoField.YEAR) + 1L : (this.temporal.get(ChronoField.MONTH_OF_YEAR) == 1 && iso8601WeekNumber >= 52 ? this.temporal.getLong(ChronoField.YEAR) - 1L : this.temporal.getLong(ChronoField.YEAR));
        if (withCentury) {
            this.appendLongFormatted(builder, year, options, '0', 0L <= year ? 4 : 5);
        } else {
            this.appendLongFormatted(builder, year / 100L, options, '0', 2);
        }
    }

    private void appendHourOfDay(StringBuilder builder, FormatDirectiveOptions options, char defaultPadding) {
        this.appendIntegerFormatted(builder, this.temporal.get(ChronoField.HOUR_OF_DAY), options, defaultPadding, 2);
    }

    private void appendHourOfAmPm(StringBuilder builder, FormatDirectiveOptions options, char defaultPadding) {
        int hourOfDay = this.temporal.get(ChronoField.HOUR_OF_DAY);
        if (hourOfDay == 0) {
            this.appendIntegerFormatted(builder, 12, options, defaultPadding, 2);
        } else if (hourOfDay > 12) {
            this.appendIntegerFormatted(builder, hourOfDay - 12, options, defaultPadding, 2);
        } else {
            this.appendIntegerFormatted(builder, hourOfDay, options, defaultPadding, 2);
        }
    }

    private void appendDayOfYear(StringBuilder builder, FormatDirectiveOptions options) {
        this.appendIntegerFormatted(builder, this.temporal.get(ChronoField.DAY_OF_YEAR), options, '0', 3);
    }

    private void appendSubsecond(StringBuilder builder, FormatDirectiveOptions options, int defaultPrecision) {
        int nanoOfSecond = this.temporal.get(ChronoField.NANO_OF_SECOND);
        int precision = options.getPrecision(defaultPrecision);
        if (9 < precision) {
            builder.append(String.format(Locale.ROOT, "%09d", nanoOfSecond));
            builder.append(String.format(Locale.ROOT, "%0" + (precision - 9) + "d", 0));
        } else {
            builder.append(String.format(Locale.ROOT, "%0" + precision + "d", nanoOfSecond / POW10[9 - precision]));
        }
    }

    private void appendMinuteOfHour(StringBuilder builder, FormatDirectiveOptions options) {
        this.appendIntegerFormatted(builder, this.temporal.get(ChronoField.MINUTE_OF_HOUR), options, '0', 2);
    }

    private void appendMonthOfYear(StringBuilder builder, FormatDirectiveOptions options) {
        this.appendIntegerFormatted(builder, this.temporal.get(ChronoField.MONTH_OF_YEAR), options, '0', 2);
    }

    private void appendAmPmOfDay(StringBuilder builder, FormatDirectiveOptions options, boolean isUpperCase) {
        this.fillPadding(builder, options, ' ', 0, 2);
        boolean lower = isUpperCase && options.isChCase() || !isUpperCase && !options.isChCase() && !options.isUpper();
        int hourOfDay = this.temporal.get(ChronoField.HOUR_OF_DAY);
        if (hourOfDay < 12) {
            builder.append(lower ? "am" : "AM");
        } else {
            builder.append(lower ? "pm" : "PM");
        }
    }

    private void appendSecondOfMinute(StringBuilder builder, FormatDirectiveOptions options) {
        this.appendIntegerFormatted(builder, this.temporal.get(ChronoField.SECOND_OF_MINUTE), options, '0', 2);
    }

    private void appendSecondsSinceEpoch(StringBuilder builder, FormatDirectiveOptions options) {
        this.appendLongFormatted(builder, this.temporal.getLong(ChronoField.INSTANT_SECONDS), options, '0', 0);
    }

    private void appendWeekOfYear(StringBuilder builder, FormatDirectiveOptions options, DayOfWeek starting) {
        this.appendIntegerFormatted(builder, FormatterWithContext.calculateWeekNumber(this.temporal, starting), options, '0', 2);
    }

    private void appendDayOfWeek(StringBuilder builder, FormatDirectiveOptions options, DayOfWeek starting) {
        if (starting == DayOfWeek.MONDAY) {
            this.appendIntegerFormatted(builder, this.temporal.get(ChronoField.DAY_OF_WEEK), options, '0', 1);
        } else {
            this.appendIntegerFormatted(builder, FormatterWithContext.getDayOfWeekInRuby(this.temporal), options, '0', 1);
        }
    }

    private void appendWeekOfWeekBasedYear(StringBuilder builder, FormatDirectiveOptions options) {
        this.appendIntegerFormatted(builder, FormatterWithContext.calculateIso8601WeekNumber(this.temporal), options, '0', 2);
    }

    private void appendYearWithCentury(StringBuilder builder, FormatDirectiveOptions options) {
        long year;
        this.appendLongFormatted(builder, year, options, '0', 0L <= (year = this.temporal.getLong(ChronoField.YEAR)) ? 4 : 5);
    }

    private void appendYearWithoutCentury(StringBuilder builder, FormatDirectiveOptions options) {
        long year = this.temporal.getLong(ChronoField.YEAR);
        this.appendIntegerFormatted(builder, (int)(year % 100L), options, '0', 2);
    }

    private void appendTimeZoneName(StringBuilder builder, FormatDirectiveOptions options, RubyDateTimeFormatter.ZoneNameStyle zoneNameStyle) {
        int offset = this.temporal.get(ChronoField.OFFSET_SECONDS);
        Optional<ZoneId> zoneId = FormatterWithContext.getZoneId(this.temporal);
        switch (zoneNameStyle) {
            case NONE: {
                if (offset == 0) {
                    this.fillPadding(builder, options, ' ', 0, 3);
                    if (options.isChCase()) {
                        builder.append("utc");
                        break;
                    }
                    builder.append("UTC");
                    break;
                }
                this.fillPadding(builder, options, ' ', 0, 0);
                builder.append("");
                break;
            }
            case SHORT: {
                if (zoneId.isPresent() && zoneId.get() instanceof ZoneOffset) {
                    String shortName = ((ZoneOffset)zoneId.get()).getTotalSeconds() == 0 ? (options.isChCase() ? "utc" : "UTC") : zoneId.get().getDisplayName(TextStyle.SHORT, Locale.ROOT);
                    this.fillPadding(builder, options, ' ', 0, shortName.length());
                    builder.append(shortName);
                    break;
                }
                if (zoneId.isPresent()) {
                    TimeZone legacyTimeZone = TimeZone.getTimeZone(zoneId.get());
                    boolean inDaylightTime = FormatterWithContext.isInDaylightTime(legacyTimeZone, this.temporal);
                    String shortName = legacyTimeZone.getDisplayName(inDaylightTime, 0, Locale.ROOT);
                    this.fillPadding(builder, options, ' ', 0, shortName.length());
                    if (options.isChCase()) {
                        builder.append(shortName.toLowerCase());
                        break;
                    }
                    builder.append(shortName);
                    break;
                }
                this.fillPadding(builder, options, ' ', 0, 0);
                builder.append("");
                break;
            }
        }
    }

    private void appendTimeOffset(StringBuilder builder, FormatToken token, FormatDirectiveOptions options) {
        int precision;
        int sign;
        int offset;
        int offsetSigned = this.temporal.get(ChronoField.OFFSET_SECONDS);
        char padding = options.getPadding('0');
        if (offsetSigned < 0) {
            offset = -offsetSigned;
            sign = -1;
        } else if (offsetSigned > 0) {
            offset = offsetSigned;
            sign = 1;
        } else {
            offset = 0;
            sign = 0;
        }
        int colons = options.getColons();
        int precisionSpecified = options.getPrecision(0);
        switch (colons) {
            case 0: {
                precision = precisionSpecified <= 5 ? 2 : precisionSpecified - 3;
                break;
            }
            case 1: {
                precision = precisionSpecified <= 6 ? 2 : precisionSpecified - 4;
                break;
            }
            case 2: {
                precision = precisionSpecified <= 9 ? 2 : precisionSpecified - 7;
                break;
            }
            case 3: {
                if (offset % 3600 == 0) {
                    precision = precisionSpecified <= 3 ? 2 : precisionSpecified - 1;
                    break;
                }
                if (offset % 60 == 0) {
                    precision = precisionSpecified <= 6 ? 2 : precisionSpecified - 4;
                    break;
                }
                precision = precisionSpecified <= 9 ? 2 : precisionSpecified - 7;
                break;
            }
            default: {
                builder.append(token.getImmediate().orElse(""));
                return;
            }
        }
        int hour = offset / 3600;
        if (padding == ' ') {
            String hourInString = (sign < 0 ? "-" : "+") + Integer.toString(hour);
            for (int i = 0; i < precision + 1 - hourInString.length(); ++i) {
                builder.append(padding);
            }
            builder.append(hourInString);
        } else {
            builder.append(sign < 0 ? "-" : "+");
            builder.append(String.format(Locale.ROOT, "%0" + precision + "d", hour));
        }
        int minuteInSeconds = offset % 3600;
        if (colons == 3 && minuteInSeconds == 0) {
            return;
        }
        if (1 <= colons) {
            builder.append(":");
        }
        builder.append(String.format(Locale.ROOT, "%02d", minuteInSeconds / 60));
        int second = minuteInSeconds % 60;
        if (colons == 3 && second == 0) {
            return;
        }
        if (2 <= colons) {
            builder.append(":");
            builder.append(String.format(Locale.ROOT, "%02d", second));
        }
    }

    private void appendIntegerFormatted(StringBuilder builder, int integer, FormatDirectiveOptions options, char defaultPadding, int defaultPrecision) {
        char padding = options.getPadding(defaultPadding);
        if (padding == '0' && integer < 0) {
            String integerInString = Integer.toString(-integer);
            builder.append("-");
            this.fillPadding(builder, options, defaultPadding, defaultPrecision, integerInString.length() + 1);
            builder.append(integerInString);
        } else {
            String integerInString = Integer.toString(integer);
            this.fillPadding(builder, options, defaultPadding, defaultPrecision, integerInString.length());
            builder.append(integerInString);
        }
    }

    private void appendLongFormatted(StringBuilder builder, long integer, FormatDirectiveOptions options, char defaultPadding, int defaultPrecision) {
        char padding = options.getPadding(defaultPadding);
        if (padding == '0' && integer < 0L) {
            String integerInString = Long.toString(-integer);
            builder.append("-");
            this.fillPadding(builder, options, defaultPadding, defaultPrecision, integerInString.length() + 1);
            builder.append(integerInString);
        } else {
            String integerInString = Long.toString(integer);
            this.fillPadding(builder, options, defaultPadding, defaultPrecision, integerInString.length());
            builder.append(integerInString);
        }
    }

    private static int calculateIso8601WeekNumber(TemporalAccessor temporal) {
        int weekNumber;
        int jan1DayOfWeek = FormatterWithContext.calculateJan1DayOfWeek(temporal);
        switch (jan1DayOfWeek) {
            case 1: {
                weekNumber = FormatterWithContext.calculateWeekNumber(temporal, DayOfWeek.MONDAY);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                weekNumber = FormatterWithContext.calculateWeekNumber(temporal, DayOfWeek.MONDAY) + 1;
                break;
            }
            case 0: 
            case 5: 
            case 6: {
                int temporaryWeekNumber = FormatterWithContext.calculateWeekNumber(temporal, DayOfWeek.MONDAY);
                if (temporaryWeekNumber == 0) {
                    LocalDate dec31LastYear = LocalDate.of(temporal.get(ChronoField.YEAR) - 1, 12, 31);
                    if (FormatterWithContext.getDayOfWeekInRuby(dec31LastYear) != (jan1DayOfWeek == 0 ? 6 : jan1DayOfWeek - 1)) {
                        throw new DateTimeException("Unexpected: wday of Dec 31, " + temporal.get(ChronoField.YEAR) + " is " + FormatterWithContext.getDayOfWeekInRuby(dec31LastYear) + ", not " + (jan1DayOfWeek == 0 ? 6 : jan1DayOfWeek - 1) + ".");
                    }
                    if (dec31LastYear.get(ChronoField.DAY_OF_YEAR) - 1 != (dec31LastYear.isLeapYear() ? 365 : 364)) {
                        throw new DateTimeException("Unexpected: yday of Dec 31, " + temporal.get(ChronoField.YEAR) + " is " + (dec31LastYear.get(ChronoField.DAY_OF_YEAR) - 1) + ", not " + (dec31LastYear.isLeapYear() ? 365 : 364) + ".");
                    }
                    weekNumber = FormatterWithContext.calculateIso8601WeekNumber(dec31LastYear);
                    break;
                }
                weekNumber = temporaryWeekNumber;
                break;
            }
            default: {
                throw new DateTimeException("Unexpected wday: " + jan1DayOfWeek);
            }
        }
        if (temporal.get(ChronoField.MONTH_OF_YEAR) == 12) {
            int wday = FormatterWithContext.getDayOfWeekInRuby(temporal);
            int mday = temporal.get(ChronoField.DAY_OF_MONTH);
            if (wday == 1 && mday >= 29 && mday <= 31 || wday == 2 && (mday == 30 || mday == 31) || wday == 3 && mday == 31) {
                return 1;
            }
        }
        return weekNumber;
    }

    private static int calculateWeekNumber(TemporalAccessor temporal, DayOfWeek firstDayOfWeek) {
        int dayOfWeekNumberInRuby = FormatterWithContext.getDayOfWeekInRuby(temporal);
        int dayOfWeekNumberAdjustedInRuby = firstDayOfWeek == DayOfWeek.MONDAY ? (dayOfWeekNumberInRuby == 0 ? 6 : dayOfWeekNumberInRuby - 1) : dayOfWeekNumberInRuby;
        int dayOfYearInRuby = temporal.get(ChronoField.DAY_OF_YEAR) - 1;
        int result = (dayOfYearInRuby + 7 - dayOfWeekNumberAdjustedInRuby) / 7;
        if (result < 0) {
            return 0;
        }
        return result;
    }

    private static int calculateJan1DayOfWeek(TemporalAccessor temporal) {
        int jan1DayOfWeek = FormatterWithContext.getDayOfWeekInRuby(temporal) - (temporal.get(ChronoField.DAY_OF_YEAR) - 1) % 7;
        if (jan1DayOfWeek < 0) {
            return jan1DayOfWeek + 7;
        }
        return jan1DayOfWeek;
    }

    private static int getDayOfWeekInRuby(TemporalAccessor temporal) {
        int dayOfWeekNumberInJava = temporal.get(ChronoField.DAY_OF_WEEK);
        if (dayOfWeekNumberInJava < 1 || dayOfWeekNumberInJava > 7) {
            throw new DateTimeException("Illegal day of week.");
        }
        if (dayOfWeekNumberInJava == 7) {
            return 0;
        }
        return dayOfWeekNumberInJava;
    }

    private static Optional<ZoneId> getZoneId(TemporalAccessor temporal) {
        try {
            ZoneId zoneId = temporal.query(TemporalQueries.zoneId());
            if (zoneId != null) {
                return Optional.of(zoneId.normalized());
            }
        }
        catch (DateTimeException zoneId) {
            // empty catch block
        }
        try {
            int offset = temporal.get(ChronoField.OFFSET_SECONDS);
            return Optional.of(ZoneOffset.ofTotalSeconds(offset));
        }
        catch (DateTimeException ex) {
            return Optional.empty();
        }
    }

    private static boolean isInDaylightTime(TimeZone legacyTimeZone, TemporalAccessor temporalAsOf) {
        Instant instant;
        try {
            instant = Instant.from(temporalAsOf);
        }
        catch (DateTimeException ex) {
            return false;
        }
        return legacyTimeZone.inDaylightTime(Date.from(instant));
    }

    static {
        EnumMap<DayOfWeek, String> weekdayFullNames = new EnumMap<DayOfWeek, String>(DayOfWeek.class);
        weekdayFullNames.put(DayOfWeek.SUNDAY, "Sunday");
        weekdayFullNames.put(DayOfWeek.MONDAY, "Monday");
        weekdayFullNames.put(DayOfWeek.TUESDAY, "Tuesday");
        weekdayFullNames.put(DayOfWeek.WEDNESDAY, "Wednesday");
        weekdayFullNames.put(DayOfWeek.THURSDAY, "Thursday");
        weekdayFullNames.put(DayOfWeek.FRIDAY, "Friday");
        weekdayFullNames.put(DayOfWeek.SATURDAY, "Saturday");
        DAY_OF_WEEK_FULL_NAMES = Collections.unmodifiableMap(weekdayFullNames);
        EnumMap<DayOfWeek, String> weekdayAbbreviatedNames = new EnumMap<DayOfWeek, String>(DayOfWeek.class);
        weekdayAbbreviatedNames.put(DayOfWeek.SUNDAY, "Sun");
        weekdayAbbreviatedNames.put(DayOfWeek.MONDAY, "Mon");
        weekdayAbbreviatedNames.put(DayOfWeek.TUESDAY, "Tue");
        weekdayAbbreviatedNames.put(DayOfWeek.WEDNESDAY, "Wed");
        weekdayAbbreviatedNames.put(DayOfWeek.THURSDAY, "Thu");
        weekdayAbbreviatedNames.put(DayOfWeek.FRIDAY, "Fri");
        weekdayAbbreviatedNames.put(DayOfWeek.SATURDAY, "Sat");
        DAY_OF_WEEK_ABBREVIATED_NAMES = Collections.unmodifiableMap(weekdayAbbreviatedNames);
        EnumMap<Month, String> monthFullNames = new EnumMap<Month, String>(Month.class);
        monthFullNames.put(Month.JANUARY, "January");
        monthFullNames.put(Month.FEBRUARY, "February");
        monthFullNames.put(Month.MARCH, "March");
        monthFullNames.put(Month.APRIL, "April");
        monthFullNames.put(Month.MAY, "May");
        monthFullNames.put(Month.JUNE, "June");
        monthFullNames.put(Month.JULY, "July");
        monthFullNames.put(Month.AUGUST, "August");
        monthFullNames.put(Month.SEPTEMBER, "September");
        monthFullNames.put(Month.OCTOBER, "October");
        monthFullNames.put(Month.NOVEMBER, "November");
        monthFullNames.put(Month.DECEMBER, "December");
        MONTH_FULL_NAMES = Collections.unmodifiableMap(monthFullNames);
        EnumMap<Month, String> monthAbbreviatedNames = new EnumMap<Month, String>(Month.class);
        monthAbbreviatedNames.put(Month.JANUARY, "Jan");
        monthAbbreviatedNames.put(Month.FEBRUARY, "Feb");
        monthAbbreviatedNames.put(Month.MARCH, "Mar");
        monthAbbreviatedNames.put(Month.APRIL, "Apr");
        monthAbbreviatedNames.put(Month.MAY, "May");
        monthAbbreviatedNames.put(Month.JUNE, "Jun");
        monthAbbreviatedNames.put(Month.JULY, "Jul");
        monthAbbreviatedNames.put(Month.AUGUST, "Aug");
        monthAbbreviatedNames.put(Month.SEPTEMBER, "Sep");
        monthAbbreviatedNames.put(Month.OCTOBER, "Oct");
        monthAbbreviatedNames.put(Month.NOVEMBER, "Nov");
        monthAbbreviatedNames.put(Month.DECEMBER, "Dec");
        MONTH_ABBREVIATED_NAMES = Collections.unmodifiableMap(monthAbbreviatedNames);
        DEFAULT = FormatDirectiveOptions.EMPTY;
        POW10 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    }
}

