/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.ssl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.ByteArrayInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import org.embulk.config.ConfigException;
import org.embulk.util.config.Config;
import org.embulk.util.config.ConfigDefault;
import org.embulk.util.ssl.TrustManagers;

public class SSLPlugins {
    private static final List<byte[]> EMPTY_CERTIFICATES = Collections.unmodifiableList(new ArrayList());

    private SSLPlugins() {
    }

    public static SSLPluginConfig configure(SSLPluginTask task) {
        return SSLPlugins.configure(task, DefaultVerifyMode.VERIFY_BY_JVM_TRUSTED_CA_CERTS);
    }

    public static SSLPluginConfig configure(SSLPluginTask task, DefaultVerifyMode defaultVerifyMode) {
        boolean verify = task.getSslVerify().orElse(defaultVerifyMode != DefaultVerifyMode.NO_VERIFY);
        if (verify) {
            Optional<List<X509Certificate>> certs = SSLPlugins.readTrustedCertificates(task);
            if (certs.isPresent()) {
                return new SSLPluginConfig(certs.get(), task.getSslVerifyHostname());
            }
            return SSLPluginConfig.useJvmDefault(task.getSslVerifyHostname());
        }
        return SSLPluginConfig.NO_VERIFY;
    }

    public static Optional<List<X509Certificate>> readTrustedCertificates(SSLPluginTask task) {
        List<X509Certificate> certs;
        Reader reader;
        String optionName;
        if (task.getSslTrustedCaCertData().isPresent()) {
            optionName = "ssl_trusted_ca_cert_data";
            reader = new StringReader(task.getSslTrustedCaCertData().get());
        } else if (task.getSslTrustedCaCertFile().isPresent()) {
            optionName = "ssl_trusted_ca_cert_file '" + task.getSslTrustedCaCertFile().get() + "'";
            try {
                reader = new FileReader(task.getSslTrustedCaCertFile().get());
            }
            catch (IOException ex) {
                throw new ConfigException("Failed to open " + optionName, (Throwable)ex);
            }
        } else {
            return Optional.empty();
        }
        try (StringReader r = reader;){
            certs = TrustManagers.readPemEncodedX509Certificates(r);
            if (certs.isEmpty()) {
                throw new ConfigException(optionName + " does not include valid X.509 PEM certificates");
            }
        }
        catch (IOException | CertificateException ex) {
            throw new ConfigException("Failed to read " + optionName, (Throwable)ex);
        }
        return Optional.of(certs);
    }

    public static SSLSocketFactory newSSLSocketFactory(SSLPluginConfig config, String hostname) {
        try {
            return TrustManagers.newSSLSocketFactory(null, config.newTrustManager(), config.getVerifyHostname() ? hostname : null);
        }
        catch (KeyManagementException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static X509TrustManager getNoVerifyTrustManager() {
        return NoVerifyTrustManager.INSTANCE;
    }

    private static class NoVerifyTrustManager
    implements X509TrustManager {
        static final NoVerifyTrustManager INSTANCE = new NoVerifyTrustManager();

        private NoVerifyTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }

    public static enum DefaultVerifyMode {
        VERIFY_BY_JVM_TRUSTED_CA_CERTS,
        NO_VERIFY;

    }

    public static class SSLPluginConfig {
        static SSLPluginConfig NO_VERIFY = new SSLPluginConfig(VerifyMode.NO_VERIFY, false, SSLPlugins.access$000());
        private final VerifyMode verifyMode;
        private final boolean verifyHostname;
        private final List<X509Certificate> certificates;

        @JsonCreator
        private SSLPluginConfig(@JsonProperty(value="verifyMode") VerifyMode verifyMode, @JsonProperty(value="verifyHostname") boolean verifyHostname, @JsonProperty(value="certificates") List<byte[]> certificates) {
            this.verifyMode = verifyMode;
            this.verifyHostname = verifyHostname;
            this.certificates = Collections.unmodifiableList(certificates.stream().map(data -> {
                try (ByteArrayInputStream in = new ByteArrayInputStream((byte[])data);){
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    X509Certificate x509Certificate = (X509Certificate)cf.generateCertificate(in);
                    return x509Certificate;
                }
                catch (IOException | CertificateException ex) {
                    throw new RuntimeException(ex);
                }
            }).collect(Collectors.toList()));
        }

        SSLPluginConfig(List<X509Certificate> certificates, boolean verifyHostname) {
            this.verifyMode = VerifyMode.CERTIFICATES;
            this.verifyHostname = verifyHostname;
            this.certificates = certificates;
        }

        static SSLPluginConfig useJvmDefault(boolean verifyHostname) {
            return new SSLPluginConfig(VerifyMode.JVM_DEFAULT, verifyHostname, EMPTY_CERTIFICATES);
        }

        @JsonProperty(value="verifyMode")
        private VerifyMode getVerifyMode() {
            return this.verifyMode;
        }

        @JsonProperty(value="verifyHostname")
        private boolean getVerifyHostname() {
            return this.verifyHostname;
        }

        @JsonProperty(value="certificates")
        private List<byte[]> getCertData() {
            return Collections.unmodifiableList(this.certificates.stream().map(cert -> {
                try {
                    return cert.getEncoded();
                }
                catch (CertificateEncodingException ex) {
                    throw new RuntimeException(ex);
                }
            }).collect(Collectors.toList()));
        }

        @JsonIgnore
        public X509TrustManager[] newTrustManager() {
            try {
                switch (this.verifyMode) {
                    case NO_VERIFY: {
                        return new X509TrustManager[]{SSLPlugins.getNoVerifyTrustManager()};
                    }
                    case CERTIFICATES: {
                        return TrustManagers.newTrustManager(this.certificates);
                    }
                }
                return TrustManagers.newDefaultJavaTrustManager();
            }
            catch (IOException | GeneralSecurityException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private static enum VerifyMode {
        NO_VERIFY,
        CERTIFICATES,
        JVM_DEFAULT;

    }

    public static interface SSLPluginTask {
        @Config(value="ssl_verify")
        @ConfigDefault(value="null")
        public Optional<Boolean> getSslVerify();

        @Config(value="ssl_verify_hostname")
        @ConfigDefault(value="true")
        public boolean getSslVerifyHostname();

        @Config(value="ssl_trusted_ca_cert_file")
        @ConfigDefault(value="null")
        public Optional<String> getSslTrustedCaCertFile();

        @Config(value="ssl_trusted_ca_cert_data")
        @ConfigDefault(value="null")
        public Optional<String> getSslTrustedCaCertData();
    }
}

