/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMParser;
import sun.security.ssl.SSLSocketImpl;

public class TrustManagers {
    private TrustManagers() {
    }

    public static KeyStore readDefaultJavaKeyStore() throws IOException, KeyStoreException, CertificateException {
        String path = (System.getProperty("java.home") + "/lib/security/cacerts").replace('/', File.separatorChar);
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            try (FileInputStream in = new FileInputStream(path);){
                keyStore.load(in, null);
            }
            return keyStore;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static List<X509Certificate> readDefaultJavaTrustedCertificates() throws IOException, CertificateException, KeyStoreException, InvalidAlgorithmParameterException {
        KeyStore keyStore = TrustManagers.readDefaultJavaKeyStore();
        PKIXParameters params = new PKIXParameters(keyStore);
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        for (TrustAnchor trustAnchor : params.getTrustAnchors()) {
            certs.add(trustAnchor.getTrustedCert());
        }
        return certs;
    }

    public static List<X509Certificate> readPemEncodedX509Certificates(Reader reader) throws IOException, CertificateException {
        JcaX509CertificateConverter conv = new JcaX509CertificateConverter();
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        try {
            Object pem;
            PEMParser pemParser = new PEMParser(reader);
            while ((pem = pemParser.readObject()) != null) {
                if (!(pem instanceof X509CertificateHolder)) continue;
                X509Certificate cert = conv.getCertificate((X509CertificateHolder)pem);
                certs.add(cert);
            }
        }
        catch (PEMException ex) {
            throw new CertificateParsingException(ex);
        }
        catch (IOException ex) {
            if (ex.getClass().equals(IOException.class)) {
                String message = ex.getMessage();
                if (message.startsWith("unrecognised object: ")) {
                    throw new CertificateParsingException(ex);
                }
                if (message.startsWith("-----END ") && message.endsWith(" not found")) {
                    throw new CertificateParsingException(ex);
                }
            }
            throw ex;
        }
        return certs;
    }

    public static KeyStore buildKeyStoreFromTrustedCertificates(List<X509Certificate> certificates) throws KeyStoreException {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        try {
            keyStore.load(null);
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException ex) {
            throw new RuntimeException(ex);
        }
        int i = 0;
        for (X509Certificate cert : certificates) {
            keyStore.setCertificateEntry("cert_" + i, cert);
            ++i;
        }
        return keyStore;
    }

    public static X509TrustManager[] newTrustManager(List<X509Certificate> trustedCertificates) throws KeyStoreException {
        try {
            TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            KeyStore keyStore = TrustManagers.buildKeyStoreFromTrustedCertificates(trustedCertificates);
            factory.init(keyStore);
            ArrayList<X509TrustManager> tms = new ArrayList<X509TrustManager>();
            for (TrustManager tm : factory.getTrustManagers()) {
                if (!(tm instanceof X509TrustManager)) continue;
                tms.add((X509TrustManager)tm);
            }
            return tms.toArray(new X509TrustManager[tms.size()]);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static X509TrustManager[] newDefaultJavaTrustManager() throws IOException, CertificateException, KeyStoreException, InvalidAlgorithmParameterException {
        return TrustManagers.newTrustManager(TrustManagers.readDefaultJavaTrustedCertificates());
    }

    public static SSLContext newSSLContext(KeyManager[] keyManager, X509TrustManager[] trustManager) throws KeyManagementException {
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(keyManager, trustManager, new SecureRandom());
            return context;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static SSLSocketFactory newSSLSocketFactory(KeyManager[] keyManager, X509TrustManager[] trustManager, String verifyHostname) throws KeyManagementException {
        SSLContext context = TrustManagers.newSSLContext(keyManager, trustManager);
        SSLSocketFactory factory = context.getSocketFactory();
        if (verifyHostname == null) {
            return factory;
        }
        return new VerifyHostNameSSLSocketFactory(factory, verifyHostname);
    }

    private static class VerifyHostNameSSLSocketFactory
    extends SSLSocketFactory {
        private final SSLSocketFactory next;
        private final String hostname;

        public VerifyHostNameSSLSocketFactory(SSLSocketFactory next, String hostname) {
            this.next = next;
            this.hostname = hostname;
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.next.getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.next.getSupportedCipherSuites();
        }

        @Override
        public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
            Socket sock = this.next.createSocket(s, host, port, autoClose);
            this.setSSLParameters(sock, false);
            return sock;
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            Socket sock = this.next.createSocket(host, port);
            this.setSSLParameters(sock, false);
            return sock;
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
            Socket sock = this.next.createSocket(host, port, localHost, localPort);
            this.setSSLParameters(sock, false);
            return sock;
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            Socket sock = this.next.createSocket(host, port);
            this.setSSLParameters(sock, true);
            return sock;
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            Socket sock = this.next.createSocket(address, port, localAddress, localPort);
            this.setSSLParameters(sock, true);
            return sock;
        }

        private void setSSLParameters(Socket sock, boolean setHostname) {
            SSLSocket s;
            String identAlgorithm;
            if (sock instanceof SSLSocket && ((identAlgorithm = (s = (SSLSocket)sock).getSSLParameters().getEndpointIdentificationAlgorithm()) == null || !identAlgorithm.equalsIgnoreCase("HTTPS"))) {
                if (setHostname && s instanceof SSLSocketImpl) {
                    ((SSLSocketImpl)s).setHost(this.hostname);
                }
                SSLParameters params = s.getSSLParameters();
                params.setEndpointIdentificationAlgorithm("HTTPS");
                s.setSSLParameters(params);
            }
        }
    }
}

