/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.embulk.util.text.LineDelimiter;

class LineReader
extends BufferedReader {
    private static final int UNREAD = -1;
    private int offset;
    private int charsRead;
    private final LineDelimiter lineDelimiter;
    private final char[] buffer;

    private LineReader(Reader reader, LineDelimiter lineDelimiter, int bufferSize) {
        super(reader);
        this.lineDelimiter = lineDelimiter;
        this.buffer = new char[bufferSize];
        this.offset = -1;
        this.charsRead = 0;
    }

    static BufferedReader of(Reader reader, LineDelimiter lineDelimiter, int bufferSize) {
        if (lineDelimiter == null) {
            return new BufferedReader(reader);
        }
        return new LineReader(reader, lineDelimiter, bufferSize);
    }

    @Override
    public String readLine() throws IOException {
        StringBuilder line = null;
        int prevChar = 0;
        block5: while (this.offset != -1 || (this.charsRead = this.read(this.buffer)) != -1) {
            if (this.offset == -1) {
                this.offset = 0;
            }
            if (line == null) {
                line = new StringBuilder();
            }
            for (int i = this.offset; i < this.charsRead; ++i) {
                int c = this.buffer[i];
                boolean isEol = false;
                switch (this.lineDelimiter) {
                    case CR: {
                        Character next;
                        if (c != 13 || (next = this.readNext()) != null && next.charValue() == '\n') break;
                        isEol = true;
                        break;
                    }
                    case LF: {
                        if (prevChar == 13 || c != 10) break;
                        isEol = true;
                        break;
                    }
                    case CRLF: {
                        if (prevChar != 13 || c != 10) break;
                        line.deleteCharAt(line.length() - 1);
                        isEol = true;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported line delimiter " + (Object)((Object)this.lineDelimiter));
                    }
                }
                ++this.offset;
                if (isEol) break block5;
                line.append((char)c);
                prevChar = c;
            }
            this.offset = -1;
        }
        if (line != null) {
            return line.toString();
        }
        return null;
    }

    private Character readNext() throws IOException {
        if (this.offset < this.charsRead - 1) {
            return Character.valueOf(this.buffer[this.offset + 1]);
        }
        this.mark(1);
        char[] tmp = new char[1];
        int read = this.read(tmp);
        this.reset();
        if (read == -1) {
            return null;
        }
        return Character.valueOf(tmp[0]);
    }
}

