/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.timestamp;

import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.embulk.util.rubytime.RubyDateTimeZones;

public final class LegacyDateTimeZones {
    private static final Map<String, String> ALIASES;

    private LegacyDateTimeZones() {
    }

    public static ZoneId toZoneId(String zoneName) {
        if (zoneName == null) {
            return null;
        }
        if (zoneName.equals("Z")) {
            return ZoneOffset.UTC;
        }
        try {
            return ZoneId.of(zoneName, ALIASES);
        }
        catch (DateTimeException ex) {
            int offsetInSeconds = RubyDateTimeZones.toOffsetInSeconds((String)zoneName);
            if (offsetInSeconds != Integer.MIN_VALUE) {
                return ZoneOffset.ofTotalSeconds(offsetInSeconds);
            }
            return null;
        }
    }

    static {
        HashMap<String, String> aliases = new HashMap<String, String>();
        aliases.put("EST", "-05:00");
        aliases.put("EDT", "-05:00");
        aliases.put("CST", "-06:00");
        aliases.put("CDT", "-06:00");
        aliases.put("MST", "-07:00");
        aliases.put("MDT", "-07:00");
        aliases.put("PST", "-08:00");
        aliases.put("PDT", "-08:00");
        aliases.put("HST", "-10:00");
        aliases.put("ROC", "Asia/Taipei");
        ALIASES = Collections.unmodifiableMap(aliases);
    }
}

