/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.timestamp;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQuery;
import java.time.temporal.ValueRange;
import java.util.Optional;
import org.embulk.util.rubytime.RubyChronoFields;
import org.embulk.util.rubytime.RubyDateTimeResolver;
import org.embulk.util.rubytime.RubyTemporalQueries;
import org.embulk.util.rubytime.RubyTemporalQueryResolver;
import org.embulk.util.timestamp.LegacyDateTimeZones;

final class LegacyRubyTimeResolver
extends RubyDateTimeResolver {
    private static final int[] leapYearMonthDays = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] commonYearMonthDays = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private final ZoneId defaultZoneId;
    private final int defaultYear;
    private final int defaultMonthOfYear;
    private final int defaultDayOfMonth;
    private final int defaultHourOfDay;
    private final int defaultMinuteOfHour;
    private final int defaultSecondOfMinute;
    private final int defaultNanoOfSecond;

    LegacyRubyTimeResolver(ZoneId defaultZoneId, int defaultYear, int defaultMonthOfYear, int defaultDayOfMonth, int defaultHourOfDay, int defaultMinuteOfHour, int defaultSecondOfMinute, int defaultNanoOfSecond) {
        this.defaultZoneId = defaultZoneId;
        this.defaultYear = defaultYear;
        this.defaultMonthOfYear = defaultMonthOfYear;
        this.defaultDayOfMonth = defaultDayOfMonth;
        this.defaultHourOfDay = defaultHourOfDay;
        this.defaultMinuteOfHour = defaultMinuteOfHour;
        this.defaultSecondOfMinute = defaultSecondOfMinute;
        this.defaultNanoOfSecond = defaultNanoOfSecond;
    }

    public TemporalAccessor resolve(TemporalAccessor original) {
        return new ResolvedFromInstant(original, this.toInstant(original));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Instant toInstant(TemporalAccessor original) {
        ZonedDateTime datetime;
        int excessDays;
        int hour;
        ZoneId zoneId;
        String zoneName = (String)original.query(RubyTemporalQueries.zone());
        if (original.isSupported(ChronoField.INSTANT_SECONDS) || original.isSupported(RubyChronoFields.INSTANT_MILLIS)) {
            Instant instant;
            if (original.isSupported(RubyChronoFields.INSTANT_MILLIS)) {
                long instantMillis = original.getLong(RubyChronoFields.INSTANT_MILLIS);
                instant = Instant.ofEpochMilli(instantMillis);
            } else {
                long instantSeconds = original.getLong(ChronoField.INSTANT_SECONDS);
                instant = Instant.ofEpochSecond(instantSeconds);
            }
            if (!this.defaultZoneId.equals(ZoneOffset.UTC)) {
                // empty if block
            }
            if (zoneName != null) {
                // empty if block
            }
            if (!original.isSupported(ChronoField.NANO_OF_SECOND)) return instant;
            int nanoOfSecond = original.get(ChronoField.NANO_OF_SECOND);
            if (instant.isBefore(Instant.EPOCH)) return instant.minusNanos(nanoOfSecond);
            return instant.plusNanos(nanoOfSecond);
        }
        if (zoneName != null) {
            zoneId = LegacyDateTimeZones.toZoneId(zoneName);
            if (zoneId == null) {
                Optional originalText = Optional.ofNullable(original.query(RubyTemporalQueries.originalText()));
                throw new DateTimeParseException("Invalid time zone ID '" + zoneName + "'", originalText.orElse(""), 0);
            }
        } else {
            zoneId = this.defaultZoneId;
        }
        int secondOfMinute = original.isSupported(ChronoField.SECOND_OF_MINUTE) ? original.get(ChronoField.SECOND_OF_MINUTE) : 0;
        if (original.isSupported(ChronoField.HOUR_OF_DAY)) {
            hour = original.get(ChronoField.HOUR_OF_DAY);
            Period parsedExcessDays = original.query(DateTimeFormatter.parsedExcessDays());
            if (parsedExcessDays == null || parsedExcessDays.isZero()) {
                excessDays = 0;
            } else {
                if (parsedExcessDays.getDays() != 1 || parsedExcessDays.getMonths() != 0 || parsedExcessDays.getYears() != 0) throw new DateTimeParseException("Hour is not in the range of 0-24.", "", 0);
                excessDays = 1;
            }
        } else {
            hour = 0;
            excessDays = 0;
        }
        int year = original.isSupported(ChronoField.YEAR) ? original.get(ChronoField.YEAR) : this.defaultYear;
        int minuteOfHour = original.isSupported(ChronoField.MINUTE_OF_HOUR) ? original.get(ChronoField.MINUTE_OF_HOUR) : this.defaultMinuteOfHour;
        int nanoOfSecond = original.isSupported(ChronoField.NANO_OF_SECOND) ? original.get(ChronoField.NANO_OF_SECOND) : this.defaultNanoOfSecond;
        if (original.isSupported(ChronoField.DAY_OF_YEAR)) {
            datetime = ZonedDateTime.of(year, 1, 1, hour, minuteOfHour, secondOfMinute, nanoOfSecond, zoneId).withDayOfYear(original.get(ChronoField.DAY_OF_YEAR)).plusDays(excessDays);
            return datetime.toInstant();
        } else {
            int monthOfYear = original.isSupported(ChronoField.MONTH_OF_YEAR) ? original.get(ChronoField.MONTH_OF_YEAR) : this.defaultMonthOfYear;
            int dayOfMonth = original.isSupported(ChronoField.DAY_OF_MONTH) ? original.get(ChronoField.DAY_OF_MONTH) : this.defaultDayOfMonth;
            int updatedYear = year;
            int updatedMonthOfYear = monthOfYear;
            int updatedDayOfMonth = dayOfMonth;
            int daysInMonth = LegacyRubyTimeResolver.monthDays(updatedYear, updatedMonthOfYear);
            if (daysInMonth < updatedDayOfMonth) {
                if (12 < ++updatedMonthOfYear) {
                    updatedMonthOfYear = 1;
                    ++updatedYear;
                }
                updatedDayOfMonth -= daysInMonth;
            }
            datetime = ZonedDateTime.of(updatedYear, updatedMonthOfYear, updatedDayOfMonth, hour, minuteOfHour, secondOfMinute, nanoOfSecond, zoneId).plusDays(excessDays);
        }
        return datetime.toInstant();
    }

    private static int monthDays(int year, int monthOfYear) {
        if (year % 4 == 0 && year % 100 != 0 || year % 400 == 0) {
            return leapYearMonthDays[monthOfYear - 1];
        }
        return commonYearMonthDays[monthOfYear - 1];
    }

    private class ResolvedFromInstant
    implements TemporalAccessor,
    RubyTemporalQueryResolver {
        private final TemporalAccessor original;
        private final Instant resolvedInstant;
        private final OffsetDateTime resolvedDateTime;

        private ResolvedFromInstant(TemporalAccessor original, Instant resolvedInstant) {
            this.original = original;
            this.resolvedInstant = resolvedInstant;
            this.resolvedDateTime = OffsetDateTime.ofInstant(resolvedInstant, ZoneOffset.UTC);
        }

        @Override
        public long getLong(TemporalField field) {
            if (this.resolvedInstant.isSupported(field)) {
                return this.resolvedInstant.getLong(field);
            }
            return this.resolvedDateTime.getLong(field);
        }

        @Override
        public boolean isSupported(TemporalField field) {
            if (this.resolvedInstant.isSupported(field)) {
                return true;
            }
            return this.resolvedDateTime.isSupported(field);
        }

        @Override
        public <R> R query(TemporalQuery<R> query) {
            R resultOriginal;
            if (RubyTemporalQueries.isSpecificQuery(query) && (resultOriginal = this.original.query(query)) != null) {
                return resultOriginal;
            }
            R resultFromResolvedInstant = this.resolvedInstant.query(query);
            if (resultFromResolvedInstant != null) {
                return resultFromResolvedInstant;
            }
            return this.resolvedDateTime.query(query);
        }

        @Override
        public ValueRange range(TemporalField field) {
            if (this.resolvedInstant.isSupported(field)) {
                return this.resolvedInstant.range(field);
            }
            return this.resolvedDateTime.range(field);
        }

        public String getOriginalText() {
            if (this.original instanceof RubyTemporalQueryResolver) {
                RubyTemporalQueryResolver resolver = (RubyTemporalQueryResolver)this.original;
                return resolver.getOriginalText();
            }
            return null;
        }

        public String getZone() {
            if (this.original instanceof RubyTemporalQueryResolver) {
                RubyTemporalQueryResolver resolver = (RubyTemporalQueryResolver)this.original;
                return resolver.getZone();
            }
            return null;
        }

        public String getLeftover() {
            if (this.original instanceof RubyTemporalQueryResolver) {
                RubyTemporalQueryResolver resolver = (RubyTemporalQueryResolver)this.original;
                return resolver.getLeftover();
            }
            return null;
        }
    }
}

