/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.timestamp;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Locale;
import org.embulk.util.timestamp.TimestampFormatter;

class JavaTimestampFormatter
extends TimestampFormatter {
    private final DateTimeFormatter formatter;
    private final String pattern;
    private final ZoneOffset defaultZoneOffset;

    JavaTimestampFormatter(String pattern, ZoneOffset defaultZoneOffset) {
        this.formatter = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern(pattern).toFormatter(Locale.ENGLISH).withResolverStyle(ResolverStyle.STRICT);
        this.pattern = pattern;
        this.defaultZoneOffset = defaultZoneOffset;
    }

    @Override
    public final String format(Instant instant) {
        if (instant == null) {
            throw new NullPointerException("instant is null.");
        }
        return this.formatter.format(instant.atOffset(this.defaultZoneOffset));
    }

    @Override
    public final Instant parse(String text) {
        if (text == null) {
            throw new DateTimeParseException("text is null.", text, 0, new NullPointerException());
        }
        if (text.isEmpty()) {
            throw new DateTimeParseException("text is empty.", text, 0);
        }
        TemporalAccessor temporal = this.formatter.parse(text);
        return this.buildOffsetDateTime(temporal, text).toInstant();
    }

    private OffsetDateTime buildOffsetDateTime(TemporalAccessor given, String text) {
        LocalTime timeFromDefault;
        LocalDate dateFromDefault;
        ZoneId givenZoneId = given.query(TemporalQueries.zoneId());
        if (givenZoneId != null) {
            throw new DateTimeParseException("Non-offset zone IDs are unaccepted in 'java:' formats: " + this.pattern, text, 0);
        }
        ZoneOffset givenZoneOffset = given.query(TemporalQueries.offset());
        if (given.isSupported(ChronoField.EPOCH_DAY) && given.isSupported(ChronoField.NANO_OF_DAY)) {
            if (givenZoneOffset != null) {
                return OffsetDateTime.from(given);
            }
            return OffsetDateTime.of(LocalDateTime.from(given), this.defaultZoneOffset);
        }
        if (given.isSupported(ChronoField.EPOCH_DAY)) {
            dateFromDefault = LocalDate.from(given);
        } else {
            int year = given.isSupported(ChronoField.YEAR) ? given.get(ChronoField.YEAR) : (given.isSupported(ChronoField.YEAR_OF_ERA) ? given.get(ChronoField.YEAR_OF_ERA) : 1970);
            if (given.isSupported(ChronoField.DAY_OF_YEAR)) {
                dateFromDefault = LocalDate.ofYearDay(year, given.get(ChronoField.DAY_OF_YEAR));
            } else {
                int month = given.isSupported(ChronoField.MONTH_OF_YEAR) ? given.get(ChronoField.MONTH_OF_YEAR) : 1;
                int dayOfMonth = given.isSupported(ChronoField.DAY_OF_MONTH) ? given.get(ChronoField.DAY_OF_MONTH) : 1;
                dateFromDefault = LocalDate.of(year, month, dayOfMonth);
            }
        }
        if (given.isSupported(ChronoField.NANO_OF_DAY)) {
            timeFromDefault = LocalTime.from(given);
        } else if (given.isSupported(ChronoField.NANO_OF_DAY)) {
            timeFromDefault = LocalTime.ofNanoOfDay(given.getLong(ChronoField.NANO_OF_DAY));
        } else if (given.isSupported(ChronoField.MILLI_OF_DAY)) {
            timeFromDefault = LocalTime.ofNanoOfDay(given.getLong(ChronoField.MILLI_OF_DAY) * 1000000L);
        } else if (given.isSupported(ChronoField.SECOND_OF_DAY)) {
            timeFromDefault = LocalTime.ofSecondOfDay(given.getLong(ChronoField.SECOND_OF_DAY));
        } else if (given.isSupported(ChronoField.MINUTE_OF_DAY)) {
            timeFromDefault = LocalTime.ofSecondOfDay(given.getLong(ChronoField.MINUTE_OF_DAY) * 60L);
        } else {
            int hourOfDay;
            if (given.isSupported(ChronoField.HOUR_OF_DAY)) {
                hourOfDay = given.get(ChronoField.HOUR_OF_DAY);
            } else if (given.isSupported(ChronoField.CLOCK_HOUR_OF_DAY)) {
                hourOfDay = given.get(ChronoField.CLOCK_HOUR_OF_DAY) % 24;
            } else if (given.isSupported(ChronoField.AMPM_OF_DAY)) {
                int ampmOfDay = given.get(ChronoField.AMPM_OF_DAY) * 12;
                hourOfDay = given.isSupported(ChronoField.HOUR_OF_AMPM) ? given.get(ChronoField.HOUR_OF_AMPM) + ampmOfDay : (given.isSupported(ChronoField.CLOCK_HOUR_OF_AMPM) ? given.get(ChronoField.CLOCK_HOUR_OF_AMPM) + ampmOfDay : 0);
            } else {
                hourOfDay = 0;
            }
            int minuteOfHour = given.isSupported(ChronoField.MINUTE_OF_HOUR) ? given.get(ChronoField.MINUTE_OF_HOUR) : 0;
            int secondOfMinute = given.isSupported(ChronoField.SECOND_OF_MINUTE) ? given.get(ChronoField.SECOND_OF_MINUTE) : 0;
            int nanoOfSecond = given.isSupported(ChronoField.NANO_OF_SECOND) ? given.get(ChronoField.NANO_OF_SECOND) : (given.isSupported(ChronoField.MICRO_OF_SECOND) ? given.get(ChronoField.MICRO_OF_SECOND) * 1000 : (given.isSupported(ChronoField.MILLI_OF_SECOND) ? given.get(ChronoField.MILLI_OF_SECOND) * 1000000 : 0));
            timeFromDefault = LocalTime.of(hourOfDay, minuteOfHour, secondOfMinute, nanoOfSecond);
        }
        if (givenZoneOffset != null) {
            return OffsetDateTime.of(dateFromDefault, timeFromDefault, givenZoneOffset);
        }
        return OffsetDateTime.of(dateFromDefault, timeFromDefault, this.defaultZoneOffset);
    }
}

