/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.util.timestamp;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import org.embulk.util.rubytime.RubyDateTimeFormatter;
import org.embulk.util.rubytime.RubyDateTimeResolver;
import org.embulk.util.timestamp.TimestampFormatter;

class RubyTimestampFormatter
extends TimestampFormatter {
    private final RubyDateTimeFormatter rubyFormatter;
    private final String pattern;
    private final ZoneOffset defaultZoneOffset;

    RubyTimestampFormatter(String pattern, ZoneOffset defaultZoneOffset) {
        this.rubyFormatter = defaultZoneOffset.equals(ZoneOffset.UTC) ? RubyDateTimeFormatter.ofPattern((String)pattern) : RubyDateTimeFormatter.ofPattern((String)pattern).withResolver(RubyDateTimeResolver.withDefaultZoneOffset((ZoneOffset)defaultZoneOffset));
        this.pattern = pattern;
        this.defaultZoneOffset = defaultZoneOffset;
    }

    @Override
    public final String format(Instant instant) {
        if (instant == null) {
            throw new NullPointerException("instant is null.");
        }
        return this.rubyFormatter.formatWithZoneNameStyle((TemporalAccessor)instant.atOffset(this.defaultZoneOffset), RubyDateTimeFormatter.ZoneNameStyle.SHORT);
    }

    @Override
    public final Instant parse(String text) {
        if (text == null) {
            throw new DateTimeParseException("text is null.", text, 0, new NullPointerException());
        }
        if (text.isEmpty()) {
            throw new DateTimeParseException("text is empty.", text, 0);
        }
        TemporalAccessor parsed = this.rubyFormatter.parse(text);
        return Instant.from(parsed);
    }
}

