/*
 * Decompiled with CFR 0.152.
 */
package org.embulk.guice;

import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.embulk.guice.LifeCycleListener;
import org.embulk.guice.LifeCycleMethods;
import org.embulk.guice.LifeCycleMethodsMap;

public final class LifeCycleManager {
    private final AtomicReference<State> state = new AtomicReference<State>(State.LATENT);
    private final Queue<Object> managedInstances = new ConcurrentLinkedQueue<Object>();
    private final LifeCycleMethodsMap methodsMap;
    private final List<LifeCycleListener> listeners;

    public LifeCycleManager(List<Object> managedInstances, LifeCycleMethodsMap methodsMap, List<LifeCycleListener> listeners) throws Exception {
        this.methodsMap = methodsMap != null ? methodsMap : new LifeCycleMethodsMap();
        this.listeners = listeners;
        for (Object instance : managedInstances) {
            this.addInstance(instance);
        }
    }

    public int size() {
        return this.managedInstances.size();
    }

    public void start() {
        if (!this.state.compareAndSet(State.LATENT, State.STARTING)) {
            throw new IllegalStateException("System already starting");
        }
        for (LifeCycleListener lifeCycleListener : this.listeners) {
            lifeCycleListener.startingLifeCycle();
        }
        for (LifeCycleListener lifeCycleListener : this.managedInstances) {
            LifeCycleMethods methods = this.methodsMap.get(lifeCycleListener.getClass());
            if (methods.hasFor(PreDestroy.class)) continue;
            this.managedInstances.remove(lifeCycleListener);
        }
        this.state.set(State.STARTED);
        for (LifeCycleListener lifeCycleListener : this.listeners) {
            lifeCycleListener.startedLifeCycle();
        }
    }

    public void destroyOnShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    LifeCycleManager.this.destroy();
                }
                catch (Exception e) {
                    System.err.print("Exception in life cycle shutdown handler ");
                    e.printStackTrace(System.err);
                }
            }
        });
    }

    public void destroy() throws Exception {
        if (!this.state.compareAndSet(State.STARTED, State.STOPPING)) {
            return;
        }
        for (LifeCycleListener listener : this.listeners) {
            listener.stoppingLifeCycle();
        }
        ArrayList reversedInstances = Lists.newArrayList(this.managedInstances);
        Collections.reverse(reversedInstances);
        for (Object obj : reversedInstances) {
            for (LifeCycleListener listener : this.listeners) {
                listener.stoppingInstance(obj);
            }
            LifeCycleMethods methods = this.methodsMap.get(obj.getClass());
            for (Method preDestroy : methods.methodsFor(PreDestroy.class)) {
                for (LifeCycleListener listener : this.listeners) {
                    listener.preDestroyingInstance(obj, preDestroy);
                }
                preDestroy.invoke(obj, new Object[0]);
            }
        }
        this.state.set(State.STOPPED);
        for (LifeCycleListener listener : this.listeners) {
            listener.stoppedLifeCycle();
        }
    }

    public boolean isDestroyed() {
        State currentState = this.state.get();
        return currentState == State.STOPPING || currentState == State.STOPPED;
    }

    public void addInstance(Object instance) throws Exception {
        if (this.isDestroyed()) {
            throw new IllegalStateException("System already stopped");
        }
        this.startInstance(instance);
        if (this.methodsMap.get(instance.getClass()).hasFor(PreDestroy.class)) {
            this.managedInstances.add(instance);
        }
    }

    private void startInstance(Object obj) throws IllegalAccessException, InvocationTargetException {
        for (LifeCycleListener listener : this.listeners) {
            listener.startingInstance(obj);
        }
        LifeCycleMethods methods = this.methodsMap.get(obj.getClass());
        for (Method postConstruct : methods.methodsFor(PostConstruct.class)) {
            for (LifeCycleListener listener : this.listeners) {
                listener.postConstructingInstance(obj, postConstruct);
            }
            postConstruct.invoke(obj, new Object[0]);
        }
    }

    private static enum State {
        LATENT,
        STARTING,
        STARTED,
        STOPPING,
        STOPPED;

    }
}

