/*
 * Decompiled with CFR 0.152.
 */
package org.emergent.gittle.maven.extension;

import com.google.gson.JsonElement;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.Strings;
import org.apache.maven.model.Build;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.emergent.gittle.core.Config;
import org.emergent.gittle.core.GittleException;
import org.emergent.gittle.core.PropCodec;
import org.emergent.gittle.core.Util;
import org.emergent.gittle.core.gson.GsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExtensionUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExtensionUtil.class);
    public static final String REVISION = "revision";
    public static final String $_REVISION = "${revision}";

    ExtensionUtil() {
    }

    static Model readModelFromPom(Path pomPath) {
        Model model;
        block8: {
            InputStream inputStream = Files.newInputStream(pomPath, new OpenOption[0]);
            try {
                MavenXpp3Reader reader = new MavenXpp3Reader();
                model = reader.read(inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | XmlPullParserException e) {
                    throw new GittleException(e.getMessage(), e);
                }
            }
            inputStream.close();
        }
        return model;
    }

    static void writeModelToPom(Model projectModel, Path newPomPath) {
        try (BufferedWriter fileWriter = Files.newBufferedWriter(newPomPath, Charset.defaultCharset(), new OpenOption[0]);){
            MavenXpp3Writer writer = new MavenXpp3Writer();
            writer.write((Writer)fileWriter, projectModel);
        }
        catch (IOException e) {
            throw new GittleException(e.getMessage(), (Throwable)e);
        }
    }

    public static Xpp3Dom toXml(Config src) {
        JsonElement json = PropCodec.toJsonTree((Object)src, Config.class);
        Map map = (Map)PropCodec.fromJsonTree((JsonElement)json, (Type)GsonUtil.OBJ_MAP_TT.getType());
        return ExtensionUtil.toXml("configuration", map);
    }

    private static Xpp3Dom toXml(String name, Object value) {
        Xpp3Dom dom = new Xpp3Dom(name);
        if (value instanceof Map) {
            Map m = (Map)value;
            ExtensionUtil.toXml(m).forEach(arg_0 -> ((Xpp3Dom)dom).addChild(arg_0));
        } else if (value != null) {
            dom.setValue(String.valueOf(value));
        }
        return dom;
    }

    private static List<Xpp3Dom> toXml(Map<?, ?> map) {
        return map.entrySet().stream().filter(e -> e.getKey() instanceof String).filter(e -> Objects.nonNull(e.getValue())).map(e -> ExtensionUtil.toXml((String)e.getKey(), e.getValue())).toList();
    }

    public static boolean copyVersions(Model src, Model tgt) {
        String versionString = Optional.ofNullable(src.getProperties().getProperty(REVISION)).filter(v -> !$_REVISION.equals(v)).orElse(null);
        if (versionString == null && Optional.ofNullable(tgt.getVersion()).filter($_REVISION::equals).isPresent()) {
            versionString = src.getVersion();
        }
        if (versionString == null && Optional.ofNullable(tgt.getParent()).map(Parent::getVersion).filter($_REVISION::equals).isPresent()) {
            versionString = Optional.ofNullable(src.getParent()).map(Parent::getVersion).orElse(null);
        }
        return versionString != null && ExtensionUtil.replaceRevision(tgt, versionString);
    }

    public static boolean replaceRevision(Model model, String versionString) {
        Build build = Optional.ofNullable(model.getBuild()).orElseGet(() -> {
            model.setBuild(new Build());
            return model.getBuild();
        });
        PluginManagement pluginMgmt = Optional.ofNullable(build.getPluginManagement()).orElseGet(() -> {
            build.setPluginManagement(new PluginManagement());
            return build.getPluginManagement();
        });
        DependencyManagement depsMgmt = Optional.ofNullable(model.getDependencyManagement()).orElseGet(() -> {
            model.setDependencyManagement(new DependencyManagement());
            return model.getDependencyManagement();
        });
        Properties properties = model.getProperties();
        AtomicReference<Boolean> modified = new AtomicReference<Boolean>(false);
        Supplier<String> ver = () -> {
            modified.set(true);
            return versionString;
        };
        if (Optional.ofNullable(model.getVersion()).filter($_REVISION::equals).isPresent()) {
            model.setVersion(ver.get());
        }
        if (Optional.ofNullable(model.getParent()).map(Parent::getVersion).filter($_REVISION::equals).isPresent()) {
            Parent parent = model.getParent();
            log.info("Setting parent {} version to {}", (Object)parent, (Object)versionString);
            model.getParent().setVersion(ver.get());
        }
        properties.stringPropertyNames().stream().map(k -> Map.entry(k, properties.getProperty((String)k))).filter(e -> Util.contains((String)((String)e.getValue()), (String)$_REVISION)).forEach(e -> {
            String replacement = Strings.CS.replace((String)e.getValue(), $_REVISION, (String)ver.get());
            properties.setProperty((String)e.getKey(), replacement);
        });
        Stream.concat(build.getPlugins().stream(), pluginMgmt.getPlugins().stream()).filter(p -> $_REVISION.equals(p.getVersion())).forEach(p -> p.setVersion((String)ver.get()));
        Stream.concat(Stream.concat(model.getDependencies().stream(), depsMgmt.getDependencies().stream()), Stream.concat(build.getPlugins().stream(), pluginMgmt.getPlugins().stream()).flatMap(plugin -> plugin.getDependencies().stream())).filter(d -> $_REVISION.equals(d.getVersion())).forEach(d -> d.setVersion((String)ver.get()));
        if (properties.containsKey(REVISION)) {
            properties.setProperty(REVISION, ver.get());
        }
        return modified.get();
    }
}

