/*
 * Decompiled with CFR 0.152.
 */
package org.emergent.gittle.maven.extension;

import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.emergent.gittle.core.Util;
import org.emergent.gittle.maven.extension.ExtensionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="gittle-lifecycle-participant")
@Singleton
public class GittleMavenLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    private static final Logger LOGGER = LoggerFactory.getLogger(GittleMavenLifecycleParticipant.class);
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        super.afterProjectsRead(session);
        this.updateProjects(session);
    }

    private void updateProjects(MavenSession session) {
        session.getAllProjects().forEach(this::updateProject);
    }

    private void updateProject(MavenProject project) {
        if (Util.isDisabled()) {
            if (this.initialized.compareAndSet(false, true)) {
                LOGGER.debug("{} is disabled", (Object)((Object)((Object)this)).getClass().getSimpleName());
            }
            return;
        }
        Model originalModel = project.getModel();
        Path originalPomFile = originalModel.getPomFile().toPath().toAbsolutePath();
        Path gittlePomFile = originalPomFile.resolveSibling(".gittle-pom.xml");
        try {
            Model gittleModel = ExtensionUtil.readModelFromPom(originalPomFile);
            ExtensionUtil.copyVersions(originalModel, gittleModel);
            ExtensionUtil.writeModelToPom(gittleModel, gittlePomFile);
            project.setPomFile(gittlePomFile.toFile());
            LOGGER.debug("Updated project with newly generated gittle pom {}", (Object)gittlePomFile);
        }
        catch (Exception e) {
            LOGGER.error("Failed creating new gittle pom at {}", (Object)gittlePomFile, (Object)e);
        }
    }
}

