/*
 * Decompiled with CFR 0.152.
 */
package org.emergent.gittle.maven.extension;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Named;
import javax.inject.Singleton;
import lombok.Generated;
import org.apache.maven.building.Source;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.building.DefaultModelProcessor;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.sisu.Priority;
import org.eclipse.sisu.Typed;
import org.emergent.gittle.core.Config;
import org.emergent.gittle.core.Coordinates;
import org.emergent.gittle.core.Util;
import org.emergent.gittle.core.strategy.StrategyFactory;
import org.emergent.gittle.core.strategy.VersionStrategy;
import org.emergent.gittle.maven.extension.ExtensionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=1)
@Named(value="core-default")
@Singleton
@Typed(value={ModelProcessor.class})
public class GittleModelProcessor
extends DefaultModelProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GittleModelProcessor.class);
    private final Set<Path> relatedPoms = new HashSet<Path>();
    private final AtomicReference<VersionStrategy> strategyRef = new AtomicReference();
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final boolean addProperties;
    private final boolean addPlugin;
    private final boolean configurePlugin;

    public GittleModelProcessor() {
        this.addProperties = true;
        this.addPlugin = false;
        this.configurePlugin = false;
    }

    public Model read(File input, Map<String, ?> options) throws IOException {
        return this.processModel(super.read(input, options), options);
    }

    public Model read(Reader input, Map<String, ?> options) throws IOException {
        return this.processModel(super.read(input, options), options);
    }

    public Model read(InputStream input, Map<String, ?> options) throws IOException {
        return this.processModel(super.read(input, options), options);
    }

    public Model processModel(Model projectModel, Map<String, ?> options) {
        if (Util.isDisabled()) {
            if (this.initialized.compareAndSet(false, true)) {
                log.debug("{} is disabled", (Object)((Object)((Object)this)).getClass().getSimpleName());
            }
            return projectModel;
        }
        Source pomSource = (Source)options.get("org.apache.maven.model.building.source");
        Optional<String> pomLoc = Optional.ofNullable(pomSource).map(Source::getLocation);
        pomLoc.ifPresent(loc -> projectModel.setPomFile(new File((String)loc)));
        if (pomLoc.filter(loc -> loc.endsWith(".xml")).isEmpty()) {
            return projectModel;
        }
        VersionStrategy versionStrategy = this.strategyRef.updateAndGet(curStrat -> {
            if (curStrat != null) {
                return curStrat;
            }
            this.relatedPoms.addAll(GittleModelProcessor.findRelatedProjects(projectModel));
            return this.getVersionStrategy(projectModel);
        });
        this.processRelatedProjects(projectModel, versionStrategy);
        return projectModel;
    }

    private VersionStrategy getVersionStrategy(Model projectModel) {
        if (Util.useExistingRevision()) {
            String revision = this.relatedPoms.stream().sorted(Comparator.comparing(p -> p.toString().length())).map(ExtensionUtil::readModelFromPom).map(m -> m.getProperties().getProperty("revision")).filter(Objects::nonNull).findFirst().orElseGet(() -> System.getProperty("revision"));
            return StrategyFactory.getInstance((String)revision);
        }
        Config config = this.loadConfig(projectModel);
        Coordinates extensionGAV = Util.getExtensionCoordinates();
        log.info(MessageUtils.buffer().a((CharSequence)"--- ").mojo((Object)extensionGAV).a((CharSequence)" ").strong((Object)"[core-extension]").a((CharSequence)" ---").build());
        File basedir = projectModel.getProjectDirectory();
        return StrategyFactory.getInstance((Config)config, (File)basedir);
    }

    private Config loadConfig(Model projectModel) {
        Path currentDir = projectModel.getProjectDirectory().toPath().toAbsolutePath();
        Path extConfigFile = Util.getExtensionPropsFile((Path)currentDir);
        Map fileProps = Util.toMap((Properties)Util.loadPropsFromFile((Path)extConfigFile));
        log.info("Loaded configuration from file {}:{}", (Object)extConfigFile, (Object)Util.join((Map)fileProps));
        Config config = Config.from((Map)fileProps);
        if (!fileProps.equals(config.asMap())) {
            log.warn("Round-trip configuration to properties:{}", (Object)Util.join((Map)Util.appendPrefix((String)"gittle.", (Map)config.asMap())));
        }
        return config;
    }

    private static Set<Path> findRelatedProjects(Model model) {
        HashSet<Path> relatedPoms = new HashSet<Path>();
        Path basedir = model.getProjectDirectory().toPath();
        log.debug("Finding related projects for {} {}", (Object)model.getArtifactId(), (Object)basedir);
        relatedPoms.add(model.getPomFile().toPath());
        List<Path> modulePoms = model.getModules().stream().map(module -> basedir.resolve((String)module).resolve("pom.xml")).toList();
        log.debug("Modules found:{}", (Object)modulePoms.stream().map(Path::toString).collect(Collectors.joining("\n", "\n", "")));
        relatedPoms.addAll(modulePoms);
        return relatedPoms;
    }

    private void processRelatedProjects(Model model, VersionStrategy strategy) {
        String versionString = strategy.version();
        Path modelPomPath = Optional.ofNullable(model.getPomFile()).map(File::toPath).orElse(null);
        if (modelPomPath == null || !this.relatedPoms.contains(modelPomPath)) {
            return;
        }
        log.debug("Processing model for {}", (Object)modelPomPath);
        Coordinates projectGav = Coordinates.builder().setGroupId(GittleModelProcessor.getGroupId(model).orElse("")).setArtifactId(model.getArtifactId()).setVersion(versionString).build();
        log.debug("Project {}:{}, Computed version: {}", new Object[]{projectGav.getGroupId(), projectGav.getArtifactId(), MessageUtils.buffer().strong((Object)projectGav.getVersion())});
        ExtensionUtil.replaceRevision(model, versionString);
        if (this.addProperties) {
            Map newProps = strategy.asMap();
            log.debug("Adding properties to project {}", (Object)MessageUtils.buffer().mojo((Object)projectGav).a((CharSequence)Util.join((Map)newProps)));
            model.getProperties().putAll((Map<?, ?>)newProps);
        }
        if (this.addPlugin) {
            this.addBuildPlugin(model, strategy);
        }
    }

    private void addBuildPlugin(Model projectModel, VersionStrategy strategy) {
        PluginManagement pluginMgmt;
        Coordinates coordinates = Util.getPluginCoordinates();
        log.debug("Adding build plugin version {}", (Object)coordinates);
        Build build = Optional.ofNullable(projectModel.getBuild()).orElseGet(() -> {
            projectModel.setBuild(new Build());
            return projectModel.getBuild();
        });
        if (Optional.ofNullable(build.getPlugins()).isEmpty()) {
            build.setPlugins(new ArrayList());
        }
        if (Optional.ofNullable((pluginMgmt = Optional.ofNullable(build.getPluginManagement()).orElseGet(() -> {
            build.setPluginManagement(new PluginManagement());
            return build.getPluginManagement();
        })).getPlugins()).isEmpty()) {
            pluginMgmt.setPlugins(new ArrayList());
        }
        Plugin plugin = new Plugin();
        plugin.setGroupId(coordinates.getGroupId());
        plugin.setArtifactId(coordinates.getArtifactId());
        plugin.setVersion(coordinates.getVersion());
        String key = plugin.getKey();
        Plugin normPlugin = (Plugin)build.getPluginsAsMap().get(key);
        Plugin mgmtPlugin = (Plugin)pluginMgmt.getPluginsAsMap().get(key);
        Optional<Plugin> found = Stream.of(normPlugin, mgmtPlugin).filter(Objects::nonNull).findFirst();
        found.ifPresent(existing -> log.warn(MessageUtils.buffer().mojo(existing).warning((Object)" version is different than ").mojo((Object)coordinates).newline().a((CharSequence)"This can introduce unexpected behaviors.").build()));
        if (found.isEmpty()) {
            if (this.configurePlugin) {
                GittleModelProcessor.addPluginConfiguration(plugin, strategy.config());
            }
            pluginMgmt.getPlugins().add(0, plugin);
        }
    }

    private static void addPluginConfiguration(Plugin plugin, Config config) {
        Xpp3Dom dom = ExtensionUtil.toXml(config);
        if (dom.getChildCount() != 0 || Util.isNotEmpty((String)dom.getValue())) {
            plugin.setConfiguration((Object)dom);
        }
    }

    private static Optional<String> getGroupId(Model projectModel) {
        Optional<String> groupId = Optional.ofNullable(projectModel.getGroupId());
        if (groupId.isEmpty()) {
            groupId = Optional.ofNullable(projectModel.getParent()).map(Parent::getGroupId);
        }
        return groupId;
    }
}

