/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.mysql;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.mysqlclient.MySQLBatchException;
import io.vertx.mysqlclient.MySQLException;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.enodeframework.common.exception.EventStoreException;
import org.enodeframework.common.exception.IORuntimeException;
import org.enodeframework.eventing.AggregateEventAppendResult;
import org.enodeframework.eventing.EventAppendStatus;
import org.enodeframework.eventing.EventStoreOptions;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00020\u0001B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0002H\u0016R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/enodeframework/mysql/MySQLAddDomainEventsHandler;", "Lio/vertx/core/Handler;", "Lio/vertx/core/AsyncResult;", "Lio/vertx/sqlclient/RowSet;", "Lio/vertx/sqlclient/Row;", "options", "Lorg/enodeframework/eventing/EventStoreOptions;", "msg", "", "(Lorg/enodeframework/eventing/EventStoreOptions;Ljava/lang/String;)V", "future", "Ljava/util/concurrent/CompletableFuture;", "Lorg/enodeframework/eventing/AggregateEventAppendResult;", "getFuture", "()Ljava/util/concurrent/CompletableFuture;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "handle", "", "ar", "enode-mysql"})
public final class MySQLAddDomainEventsHandler
implements Handler<AsyncResult<RowSet<Row>>> {
    @NotNull
    private final EventStoreOptions options;
    @NotNull
    private final String msg;
    private final Logger logger;
    @NotNull
    private final CompletableFuture<AggregateEventAppendResult> future;

    public MySQLAddDomainEventsHandler(@NotNull EventStoreOptions options, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.options = options;
        this.msg = msg;
        this.logger = LoggerFactory.getLogger(MySQLAddDomainEventsHandler.class);
        this.future = new CompletableFuture();
    }

    @NotNull
    public final CompletableFuture<AggregateEventAppendResult> getFuture() {
        return this.future;
    }

    public void handle(@NotNull AsyncResult<RowSet<Row>> ar) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter(ar, (String)"ar");
        if (ar.succeeded()) {
            AggregateEventAppendResult appendResult = new AggregateEventAppendResult(EventAppendStatus.Success);
            this.future.complete(appendResult);
            return;
        }
        Throwable throwable = ar.cause();
        Object message = "";
        if (throwable instanceof MySQLException && (object2 = throwable.getMessage()) == null) {
            object2 = message = "";
        }
        if (throwable.getCause() instanceof MySQLException) {
            Throwable throwable2 = throwable.getCause();
            Intrinsics.checkNotNull((Object)throwable2, (String)"null cannot be cast to non-null type io.vertx.mysqlclient.MySQLException");
            Object object3 = ((MySQLException)throwable2).getMessage();
            if (object3 == null) {
                object3 = message = "";
            }
        }
        if (throwable instanceof MySQLBatchException && ((object = (Throwable)CollectionsKt.firstOrNull((Iterable)((MySQLBatchException)throwable).getIterationError().values())) == null || (object = ((Throwable)object).getMessage()) == null)) {
            object = message = "";
        }
        if (StringsKt.contains$default((CharSequence)((CharSequence)message), (CharSequence)this.options.getEventVersionUkName(), (boolean)false, (int)2, null)) {
            AggregateEventAppendResult appendResult = new AggregateEventAppendResult(EventAppendStatus.DuplicateEvent);
            this.future.complete(appendResult);
            return;
        }
        if (StringsKt.contains$default((CharSequence)((CharSequence)message), (CharSequence)this.options.getEventCommandIdUkName(), (boolean)false, (int)2, null)) {
            AggregateEventAppendResult appendResult = new AggregateEventAppendResult(EventAppendStatus.DuplicateCommand);
            String commandId = this.options.seekCommandId((String)message);
            if (!Strings.isNullOrEmpty((String)commandId)) {
                Object[] objectArray = new String[]{commandId};
                ArrayList arrayList = Lists.newArrayList((Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList(...)");
                appendResult.setDuplicateCommandIds((List)arrayList);
            } else {
                Object[] objectArray = new String[]{message};
                ArrayList arrayList = Lists.newArrayList((Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList(...)");
                appendResult.setDuplicateCommandIds((List)arrayList);
            }
            this.future.complete(appendResult);
            return;
        }
        this.logger.error("Batch append event has exception. {}", (Object)this.msg, (Object)throwable);
        if (throwable instanceof MySQLException) {
            this.future.completeExceptionally((Throwable)new IORuntimeException(throwable));
            return;
        }
        this.future.completeExceptionally((Throwable)new EventStoreException(throwable));
    }
}

