/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.mysql;

import com.google.common.collect.Maps;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.mysqlclient.MySQLException;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.enodeframework.common.exception.EventStoreException;
import org.enodeframework.common.exception.IORuntimeException;
import org.enodeframework.common.serializing.SerializeService;
import org.enodeframework.eventing.DomainEventStream;
import org.enodeframework.eventing.EventSerializer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00020\u0001B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001c\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/enodeframework/mysql/MySQLFindDomainEventsHandler;", "Lio/vertx/core/Handler;", "Lio/vertx/core/AsyncResult;", "Lio/vertx/sqlclient/RowSet;", "Lio/vertx/sqlclient/Row;", "eventSerializer", "Lorg/enodeframework/eventing/EventSerializer;", "serializeService", "Lorg/enodeframework/common/serializing/SerializeService;", "msg", "", "(Lorg/enodeframework/eventing/EventSerializer;Lorg/enodeframework/common/serializing/SerializeService;Ljava/lang/String;)V", "future", "Ljava/util/concurrent/CompletableFuture;", "", "Lorg/enodeframework/eventing/DomainEventStream;", "getFuture", "()Ljava/util/concurrent/CompletableFuture;", "setFuture", "(Ljava/util/concurrent/CompletableFuture;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "convertFrom", "record", "Lio/vertx/core/json/JsonObject;", "handle", "", "ar", "enode-mysql"})
@SourceDebugExtension(value={"SMAP\nMySQLHandlers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MySQLHandlers.kt\norg/enodeframework/mysql/MySQLFindDomainEventsHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,179:1\n1549#2:180\n1620#2,3:181\n*S KotlinDebug\n*F\n+ 1 MySQLHandlers.kt\norg/enodeframework/mysql/MySQLFindDomainEventsHandler\n*L\n86#1:180\n86#1:181,3\n*E\n"})
public final class MySQLFindDomainEventsHandler
implements Handler<AsyncResult<RowSet<Row>>> {
    @NotNull
    private final EventSerializer eventSerializer;
    @NotNull
    private final SerializeService serializeService;
    @NotNull
    private final String msg;
    private final Logger logger;
    @NotNull
    private CompletableFuture<List<DomainEventStream>> future;

    public MySQLFindDomainEventsHandler(@NotNull EventSerializer eventSerializer, @NotNull SerializeService serializeService, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)eventSerializer, (String)"eventSerializer");
        Intrinsics.checkNotNullParameter((Object)serializeService, (String)"serializeService");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.eventSerializer = eventSerializer;
        this.serializeService = serializeService;
        this.msg = msg;
        this.logger = LoggerFactory.getLogger(MySQLFindDomainEventsHandler.class);
        this.future = new CompletableFuture();
    }

    @NotNull
    public final CompletableFuture<List<DomainEventStream>> getFuture() {
        return this.future;
    }

    public final void setFuture(@NotNull CompletableFuture<List<DomainEventStream>> completableFuture) {
        Intrinsics.checkNotNullParameter(completableFuture, (String)"<set-?>");
        this.future = completableFuture;
    }

    /*
     * WARNING - void declaration
     */
    public void handle(@NotNull AsyncResult<RowSet<Row>> ar) {
        Intrinsics.checkNotNullParameter(ar, (String)"ar");
        if (ar.succeeded()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object object = ar.result();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"result(...)");
            Iterable iterable = (Iterable)object;
            CompletableFuture<List<DomainEventStream>> completableFuture = this.future;
            boolean $i$f$map = false;
            void var4_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void row;
                Row row2 = (Row)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                JsonObject jsonObject = row.toJson();
                Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"toJson(...)");
                collection.add(this.convertFrom(jsonObject));
            }
            completableFuture.complete(CollectionsKt.toList((Iterable)((List)destination$iv$iv)));
            return;
        }
        Throwable throwable = ar.cause();
        this.logger.error("Find event has exception, msg: {}", (Object)this.msg, (Object)throwable);
        if (throwable instanceof MySQLException) {
            this.future.completeExceptionally((Throwable)new IORuntimeException(this.msg, throwable));
            return;
        }
        this.future.completeExceptionally((Throwable)new EventStoreException(this.msg, throwable));
    }

    private final DomainEventStream convertFrom(JsonObject record) {
        String string = record.getString("command_id");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        String string2 = record.getString("aggregate_root_id");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        String string3 = record.getString("aggregate_root_type_name");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
        Long l = record.getLong("create_at");
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getLong(...)");
        Date date = new Date(((Number)l).longValue());
        String string4 = record.getString("events");
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
        Object object = this.serializeService.deserialize(string4, Map.class);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.String>");
        List list = this.eventSerializer.deserialize(TypeIntrinsics.asMutableMap((Object)object));
        HashMap hashMap = Maps.newHashMap();
        Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"newHashMap(...)");
        return new DomainEventStream(string, string2, string3, date, list, (Map)hashMap);
    }
}

