/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.mysql;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.mysqlclient.MySQLException;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.enodeframework.common.exception.IORuntimeException;
import org.enodeframework.common.exception.PublishedVersionStoreException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00020\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0002H\u0016R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/enodeframework/mysql/MySQLFindPublishedVersionHandler;", "Lio/vertx/core/Handler;", "Lio/vertx/core/AsyncResult;", "Lio/vertx/sqlclient/RowSet;", "Lio/vertx/sqlclient/Row;", "msg", "", "(Ljava/lang/String;)V", "future", "Ljava/util/concurrent/CompletableFuture;", "", "getFuture", "()Ljava/util/concurrent/CompletableFuture;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "handle", "", "ar", "enode-mysql"})
public final class MySQLFindPublishedVersionHandler
implements Handler<AsyncResult<RowSet<Row>>> {
    @NotNull
    private final String msg;
    private final Logger logger;
    @NotNull
    private final CompletableFuture<Integer> future;

    public MySQLFindPublishedVersionHandler(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.msg = msg;
        this.logger = LoggerFactory.getLogger(MySQLFindPublishedVersionHandler.class);
        this.future = new CompletableFuture();
    }

    @NotNull
    public final CompletableFuture<Integer> getFuture() {
        return this.future;
    }

    public void handle(@NotNull AsyncResult<RowSet<Row>> ar) {
        Intrinsics.checkNotNullParameter(ar, (String)"ar");
        if (ar.succeeded()) {
            Object object = ar.result();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"result(...)");
            Row row = (Row)CollectionsKt.firstOrNull((Iterable)((Iterable)object));
            Integer n = row != null ? row.getInteger(0) : null;
            this.future.complete(n == null ? 0 : n);
            return;
        }
        Throwable throwable = ar.cause();
        this.logger.error("Get aggregate published version has sql exception. msg: {}", (Object)this.msg, (Object)throwable);
        if (throwable instanceof MySQLException) {
            this.future.completeExceptionally((Throwable)new IORuntimeException(this.msg, throwable));
            return;
        }
        this.future.completeExceptionally((Throwable)new PublishedVersionStoreException(this.msg, throwable));
    }
}

