/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.mysql;

import io.vertx.core.Handler;
import io.vertx.mysqlclient.MySQLPool;
import io.vertx.sqlclient.Tuple;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.enodeframework.common.io.IOHelper;
import org.enodeframework.eventing.EventStoreOptions;
import org.enodeframework.eventing.PublishedVersionStore;
import org.enodeframework.mysql.MySQLFindPublishedVersionHandler;
import org.enodeframework.mysql.MySQLUpsertPublishedVersionHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0002J&\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0016J.\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\tH\u0002J.\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\tH\u0002J.\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\tH\u0016J.\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/enodeframework/mysql/MySQLPublishedVersionStore;", "Lorg/enodeframework/eventing/PublishedVersionStore;", "client", "Lio/vertx/mysqlclient/MySQLPool;", "options", "Lorg/enodeframework/eventing/EventStoreOptions;", "(Lio/vertx/mysqlclient/MySQLPool;Lorg/enodeframework/eventing/EventStoreOptions;)V", "getPublishedVersion", "Ljava/util/concurrent/CompletableFuture;", "", "processorName", "", "aggregateRootTypeName", "aggregateRootId", "getPublishedVersionAsync", "insertVersionAsync", "publishedVersion", "updatePublishedVersion", "updatePublishedVersionAsync", "updateVersionAsync", "Companion", "enode-mysql"})
public final class MySQLPublishedVersionStore
implements PublishedVersionStore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MySQLPool client;
    @NotNull
    private final EventStoreOptions options;
    @NotNull
    private static final String INSERT_SQL = "INSERT INTO %s (processor_name, aggregate_root_type_name, aggregate_root_id, version, create_at, update_at) VALUES (?, ?, ?, ?, ?, ?)";
    @NotNull
    private static final String UPDATE_SQL = "UPDATE %s SET version = ?, update_at = ? WHERE processor_name = ? AND aggregate_root_id = ? AND version = ?";
    @NotNull
    private static final String SELECT_SQL = "SELECT version FROM %s WHERE processor_name = ? AND aggregate_root_id = ?";

    public MySQLPublishedVersionStore(@NotNull MySQLPool client, @NotNull EventStoreOptions options) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.client = client;
        this.options = options;
    }

    @NotNull
    public CompletableFuture<Integer> updatePublishedVersionAsync(@NotNull String processorName, @NotNull String aggregateRootTypeName, @NotNull String aggregateRootId, int publishedVersion) {
        Intrinsics.checkNotNullParameter((Object)processorName, (String)"processorName");
        Intrinsics.checkNotNullParameter((Object)aggregateRootTypeName, (String)"aggregateRootTypeName");
        Intrinsics.checkNotNullParameter((Object)aggregateRootId, (String)"aggregateRootId");
        return IOHelper.tryIOFuncAsync(() -> MySQLPublishedVersionStore.updatePublishedVersionAsync$lambda$0(this, processorName, aggregateRootTypeName, aggregateRootId, publishedVersion), (String)"UpdatePublishedVersionAsync");
    }

    private final CompletableFuture<Integer> updatePublishedVersion(String processorName, String aggregateRootTypeName, String aggregateRootId, int publishedVersion) {
        boolean insert;
        boolean bl = insert = publishedVersion == 1;
        if (insert) {
            return this.insertVersionAsync(processorName, aggregateRootTypeName, aggregateRootId, publishedVersion);
        }
        return this.updateVersionAsync(processorName, aggregateRootTypeName, aggregateRootId, publishedVersion);
    }

    private final CompletableFuture<Integer> updateVersionAsync(String processorName, String aggregateRootTypeName, String aggregateRootId, int publishedVersion) {
        MySQLUpsertPublishedVersionHandler handler = new MySQLUpsertPublishedVersionHandler(this.options.getPublishedUkName(), processorName + "#" + aggregateRootTypeName + "#" + aggregateRootId + "#" + publishedVersion);
        String string = UPDATE_SQL;
        Object[] objectArray = new Object[]{this.options.getPublishedTableName()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        String sql = string2;
        Tuple tuple = Tuple.of((Object)publishedVersion, (Object)System.currentTimeMillis(), (Object)processorName, (Object)aggregateRootId, (Object)(publishedVersion - 1));
        this.client.preparedQuery(sql).execute(tuple).onComplete((Handler)handler);
        return handler.getFuture();
    }

    private final CompletableFuture<Integer> insertVersionAsync(String processorName, String aggregateRootTypeName, String aggregateRootId, int publishedVersion) {
        MySQLUpsertPublishedVersionHandler handler = new MySQLUpsertPublishedVersionHandler(this.options.getPublishedUkName(), processorName + "#" + aggregateRootTypeName + "#" + aggregateRootId + "#" + publishedVersion);
        long now = System.currentTimeMillis();
        String string = INSERT_SQL;
        Object[] objectArray = new Object[]{this.options.getPublishedTableName()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        String sql = string2;
        Tuple tuple = Tuple.of((Object)processorName, (Object)aggregateRootTypeName, (Object)aggregateRootId, (Object)1, (Object)now, (Object)now);
        this.client.preparedQuery(sql).execute(tuple).onComplete((Handler)handler);
        return handler.getFuture();
    }

    @NotNull
    public CompletableFuture<Integer> getPublishedVersionAsync(@NotNull String processorName, @NotNull String aggregateRootTypeName, @NotNull String aggregateRootId) {
        Intrinsics.checkNotNullParameter((Object)processorName, (String)"processorName");
        Intrinsics.checkNotNullParameter((Object)aggregateRootTypeName, (String)"aggregateRootTypeName");
        Intrinsics.checkNotNullParameter((Object)aggregateRootId, (String)"aggregateRootId");
        return IOHelper.tryIOFuncAsync(() -> MySQLPublishedVersionStore.getPublishedVersionAsync$lambda$1(this, processorName, aggregateRootTypeName, aggregateRootId), (String)"UpdatePublishedVersionAsync");
    }

    private final CompletableFuture<Integer> getPublishedVersion(String processorName, String aggregateRootTypeName, String aggregateRootId) {
        MySQLFindPublishedVersionHandler handler = new MySQLFindPublishedVersionHandler(aggregateRootId + "#" + processorName + "#" + aggregateRootTypeName);
        String string = SELECT_SQL;
        Object[] objectArray = new Object[]{this.options.getPublishedTableName()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        String sql = string2;
        this.client.preparedQuery(sql).execute(Tuple.of((Object)processorName, (Object)aggregateRootId)).onComplete((Handler)handler);
        return handler.getFuture();
    }

    private static final CompletableFuture updatePublishedVersionAsync$lambda$0(MySQLPublishedVersionStore this$0, String $processorName, String $aggregateRootTypeName, String $aggregateRootId, int $publishedVersion) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$processorName, (String)"$processorName");
        Intrinsics.checkNotNullParameter((Object)$aggregateRootTypeName, (String)"$aggregateRootTypeName");
        Intrinsics.checkNotNullParameter((Object)$aggregateRootId, (String)"$aggregateRootId");
        return this$0.updatePublishedVersion($processorName, $aggregateRootTypeName, $aggregateRootId, $publishedVersion);
    }

    private static final CompletableFuture getPublishedVersionAsync$lambda$1(MySQLPublishedVersionStore this$0, String $processorName, String $aggregateRootTypeName, String $aggregateRootId) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$processorName, (String)"$processorName");
        Intrinsics.checkNotNullParameter((Object)$aggregateRootTypeName, (String)"$aggregateRootTypeName");
        Intrinsics.checkNotNullParameter((Object)$aggregateRootId, (String)"$aggregateRootId");
        return this$0.getPublishedVersion($processorName, $aggregateRootTypeName, $aggregateRootId);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/enodeframework/mysql/MySQLPublishedVersionStore$Companion;", "", "()V", "INSERT_SQL", "", "SELECT_SQL", "UPDATE_SQL", "enode-mysql"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

