/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.mysql;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.mysqlclient.MySQLBatchException;
import io.vertx.mysqlclient.MySQLException;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.enodeframework.common.exception.IORuntimeException;
import org.enodeframework.common.exception.PublishedVersionStoreException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00020\u0001B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0002H\u0016R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/enodeframework/mysql/MySQLUpsertPublishedVersionHandler;", "Lio/vertx/core/Handler;", "Lio/vertx/core/AsyncResult;", "Lio/vertx/sqlclient/RowSet;", "Lio/vertx/sqlclient/Row;", "publishedUkName", "", "msg", "(Ljava/lang/String;Ljava/lang/String;)V", "future", "Ljava/util/concurrent/CompletableFuture;", "", "getFuture", "()Ljava/util/concurrent/CompletableFuture;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "handle", "", "ar", "enode-mysql"})
public final class MySQLUpsertPublishedVersionHandler
implements Handler<AsyncResult<RowSet<Row>>> {
    @NotNull
    private final String publishedUkName;
    @NotNull
    private final String msg;
    private final Logger logger;
    @NotNull
    private final CompletableFuture<Integer> future;

    public MySQLUpsertPublishedVersionHandler(@NotNull String publishedUkName, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)publishedUkName, (String)"publishedUkName");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.publishedUkName = publishedUkName;
        this.msg = msg;
        this.logger = LoggerFactory.getLogger(MySQLUpsertPublishedVersionHandler.class);
        this.future = new CompletableFuture();
    }

    @NotNull
    public final CompletableFuture<Integer> getFuture() {
        return this.future;
    }

    public void handle(@NotNull AsyncResult<RowSet<Row>> ar) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter(ar, (String)"ar");
        if (ar.succeeded()) {
            if (((RowSet)ar.result()).rowCount() == 0) {
                this.future.completeExceptionally((Throwable)new PublishedVersionStoreException("version update rows is 0. " + this.msg));
                return;
            }
            this.future.complete(((RowSet)ar.result()).rowCount());
            return;
        }
        Throwable throwable = ar.cause();
        Object message = "";
        if (throwable instanceof MySQLBatchException && ((object2 = (Throwable)CollectionsKt.firstOrNull((Iterable)((MySQLBatchException)throwable).getIterationError().values())) == null || (object2 = ((Throwable)object2).getMessage()) == null)) {
            object2 = message = "";
        }
        if (throwable.getCause() instanceof MySQLBatchException) {
            Throwable throwable2 = throwable.getCause();
            Intrinsics.checkNotNull((Object)throwable2, (String)"null cannot be cast to non-null type io.vertx.mysqlclient.MySQLBatchException");
            Object object3 = (Throwable)CollectionsKt.firstOrNull((Iterable)((MySQLBatchException)throwable2).getIterationError().values());
            if (object3 == null || (object3 = ((Throwable)object3).getMessage()) == null) {
                object3 = message = "";
            }
        }
        if (throwable instanceof MySQLException && (object = throwable.getMessage()) == null) {
            object = message = "";
        }
        if (throwable.getCause() instanceof MySQLException) {
            Throwable throwable3 = throwable.getCause();
            Intrinsics.checkNotNull((Object)throwable3, (String)"null cannot be cast to non-null type io.vertx.mysqlclient.MySQLException");
            String string = ((MySQLException)throwable3).getMessage();
            if (string == null) {
                string = "";
            }
            message = string;
        }
        this.logger.error("Upsert aggregate published version has exception. {}", (Object)this.msg, (Object)throwable);
        if (StringsKt.contains$default((CharSequence)((CharSequence)message), (CharSequence)this.publishedUkName, (boolean)false, (int)2, null)) {
            this.future.complete(1);
            return;
        }
        if (throwable instanceof MySQLException) {
            this.future.completeExceptionally((Throwable)new IORuntimeException(this.msg, throwable));
            return;
        }
        this.future.completeExceptionally((Throwable)new PublishedVersionStoreException(this.msg, throwable));
    }
}

