/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.rocketmq.message;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.MQProducer;
import org.apache.rocketmq.client.producer.MessageQueueSelector;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.selector.SelectMessageQueueByHash;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.enodeframework.common.exception.IORuntimeException;
import org.enodeframework.queue.QueueMessage;
import org.enodeframework.queue.SendMessageResult;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\n\u001a\u00020\u000bR\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/enodeframework/rocketmq/message/RocketMQProducerHolder;", "", "producer", "Lorg/apache/rocketmq/client/producer/MQProducer;", "(Lorg/apache/rocketmq/client/producer/MQProducer;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "covertToProducerRecord", "Lorg/apache/rocketmq/common/message/Message;", "queueMessage", "Lorg/enodeframework/queue/QueueMessage;", "send", "Ljava/util/concurrent/CompletableFuture;", "Lorg/enodeframework/queue/SendMessageResult;", "enode-rocketmq"})
public final class RocketMQProducerHolder {
    @NotNull
    private final MQProducer producer;
    private final Logger logger;

    public RocketMQProducerHolder(@NotNull MQProducer producer) {
        Intrinsics.checkNotNullParameter((Object)producer, (String)"producer");
        this.producer = producer;
        this.logger = LoggerFactory.getLogger(RocketMQProducerHolder.class);
    }

    @NotNull
    public final CompletableFuture<SendMessageResult> send(@NotNull QueueMessage queueMessage) {
        Intrinsics.checkNotNullParameter((Object)queueMessage, (String)"queueMessage");
        CompletableFuture<SendMessageResult> future = new CompletableFuture<SendMessageResult>();
        Message message = this.covertToProducerRecord(queueMessage);
        try {
            this.producer.send(message, (MessageQueueSelector)new SelectMessageQueueByHash(), (Object)queueMessage.getRouteKey(), new SendCallback(this, queueMessage, future){
                final /* synthetic */ RocketMQProducerHolder this$0;
                final /* synthetic */ QueueMessage $queueMessage;
                final /* synthetic */ CompletableFuture<SendMessageResult> $future;
                {
                    this.this$0 = $receiver;
                    this.$queueMessage = $queueMessage;
                    this.$future = $future;
                }

                public void onSuccess(@NotNull SendResult result) {
                    Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                    if (RocketMQProducerHolder.access$getLogger$p(this.this$0).isDebugEnabled()) {
                        RocketMQProducerHolder.access$getLogger$p(this.this$0).debug("Async send message success, sendResult: {}, message: {}", (Object)result, (Object)this.$queueMessage);
                    }
                    HashMap hashMap = Maps.newHashMap();
                    Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"newHashMap(...)");
                    Map items = hashMap;
                    items.put("result", result);
                    String string = result.getMsgId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMsgId(...)");
                    this.$future.complete(new SendMessageResult(string, items));
                }

                public void onException(@NotNull Throwable ex) {
                    Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
                    this.$future.completeExceptionally((Throwable)new IORuntimeException(ex));
                    RocketMQProducerHolder.access$getLogger$p(this.this$0).error("Async send message has exception, message: {}", (Object)this.$queueMessage, (Object)ex);
                }
            });
        }
        catch (MQClientException ex) {
            future.completeExceptionally((Throwable)new IORuntimeException((Throwable)ex));
            this.logger.error("Async send message has exception, message: {}", (Object)queueMessage, (Object)ex);
        }
        catch (RemotingException ex) {
            future.completeExceptionally((Throwable)new IORuntimeException((Throwable)ex));
            this.logger.error("Async send message has exception, message: {}", (Object)queueMessage, (Object)ex);
        }
        catch (InterruptedException ex) {
            future.completeExceptionally(ex);
            this.logger.error("Async send message has exception, message: {}", (Object)queueMessage, (Object)ex);
        }
        return future;
    }

    private final Message covertToProducerRecord(QueueMessage queueMessage) {
        Message message = new Message(queueMessage.getTopic(), queueMessage.getTag(), queueMessage.getKey(), queueMessage.getBody());
        message.putUserProperty("ETYPE", queueMessage.getType());
        return message;
    }

    public static final /* synthetic */ Logger access$getLogger$p(RocketMQProducerHolder $this) {
        return $this.logger;
    }
}

