/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.v2_3.system_information;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.entur.gbfs.v2_3.system_information.GBFSBrandAssets;
import org.entur.gbfs.v2_3.system_information.GBFSRentalApps;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"system_id", "language", "name", "short_name", "operator", "url", "purchase_url", "start_date", "phone_number", "email", "feed_contact_email", "timezone", "license_url", "brand_assets", "terms_url", "terms_last_updated", "privacy_url", "privacy_last_updated", "rental_apps"})
public class GBFSData
implements Serializable {
    @JsonProperty(value="system_id")
    @JsonPropertyDescription(value="Identifier for this vehicle share system. This should be globally unique (even between different systems).")
    private String systemId;
    @JsonProperty(value="language")
    @JsonPropertyDescription(value="The language that will be used throughout the rest of the files. It must match the value in the gbfs.json file.")
    private String language;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name of the system to be displayed to customers.")
    private String name;
    @JsonProperty(value="short_name")
    @JsonPropertyDescription(value="Optional abbreviation for a system.")
    private String shortName;
    @JsonProperty(value="operator")
    @JsonPropertyDescription(value="Name of the operator")
    private String operator;
    @JsonProperty(value="url")
    @JsonPropertyDescription(value="The URL of the vehicle share system.")
    private String url;
    @JsonProperty(value="purchase_url")
    @JsonPropertyDescription(value="URL where a customer can purchase a membership.")
    private String purchaseUrl;
    @JsonProperty(value="start_date")
    @JsonPropertyDescription(value="Date that the system began operations.")
    private String startDate;
    @JsonProperty(value="phone_number")
    @JsonPropertyDescription(value="A single voice telephone number for the specified system that presents the telephone number as typical for the system's service area.")
    private String phoneNumber;
    @JsonProperty(value="email")
    @JsonPropertyDescription(value="Email address actively monitored by the operator's customer service department.")
    private String email;
    @JsonProperty(value="feed_contact_email")
    @JsonPropertyDescription(value="A single contact email address for consumers of this feed to report technical issues (added in v1.1).")
    private String feedContactEmail;
    @JsonProperty(value="timezone")
    @JsonPropertyDescription(value="The time zone where the system is located.")
    private String timezone;
    @JsonProperty(value="license_url")
    @JsonPropertyDescription(value="A fully qualified URL of a page that defines the license terms for the GBFS data for this system.")
    private String licenseUrl;
    @JsonProperty(value="brand_assets")
    @JsonPropertyDescription(value="An object where each key defines one of the items listed below (added in v2.3-RC).")
    private GBFSBrandAssets brandAssets;
    @JsonProperty(value="terms_url")
    @JsonPropertyDescription(value="A fully qualified URL pointing to the terms of service (added in v2.3-RC)")
    private String termsUrl;
    @JsonProperty(value="terms_last_updated")
    @JsonPropertyDescription(value="The date that the terms of service provided at terms_url were last updated (added in v2.3-RC)")
    private String termsLastUpdated;
    @JsonProperty(value="privacy_url")
    @JsonPropertyDescription(value="A fully qualified URL pointing to the privacy policy for the service (added in v2.3-RC).")
    private String privacyUrl;
    @JsonProperty(value="privacy_last_updated")
    @JsonPropertyDescription(value="The date that the privacy policy provided at privacy_url was last updated (added in v2.3-RC).")
    private String privacyLastUpdated;
    @JsonProperty(value="rental_apps")
    @JsonPropertyDescription(value="Contains rental app information in the android and ios JSON objects (added in v1.1).")
    private GBFSRentalApps rentalApps;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    private static final long serialVersionUID = 5168762506612278873L;

    @JsonProperty(value="system_id")
    public String getSystemId() {
        return this.systemId;
    }

    @JsonProperty(value="system_id")
    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public GBFSData withSystemId(String systemId) {
        this.systemId = systemId;
        return this;
    }

    @JsonProperty(value="language")
    public String getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    public void setLanguage(String language) {
        this.language = language;
    }

    public GBFSData withLanguage(String language) {
        this.language = language;
        return this;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public GBFSData withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="short_name")
    public String getShortName() {
        return this.shortName;
    }

    @JsonProperty(value="short_name")
    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public GBFSData withShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    @JsonProperty(value="operator")
    public String getOperator() {
        return this.operator;
    }

    @JsonProperty(value="operator")
    public void setOperator(String operator) {
        this.operator = operator;
    }

    public GBFSData withOperator(String operator) {
        this.operator = operator;
        return this;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    public void setUrl(String url) {
        this.url = url;
    }

    public GBFSData withUrl(String url) {
        this.url = url;
        return this;
    }

    @JsonProperty(value="purchase_url")
    public String getPurchaseUrl() {
        return this.purchaseUrl;
    }

    @JsonProperty(value="purchase_url")
    public void setPurchaseUrl(String purchaseUrl) {
        this.purchaseUrl = purchaseUrl;
    }

    public GBFSData withPurchaseUrl(String purchaseUrl) {
        this.purchaseUrl = purchaseUrl;
        return this;
    }

    @JsonProperty(value="start_date")
    public String getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="start_date")
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public GBFSData withStartDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    @JsonProperty(value="phone_number")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonProperty(value="phone_number")
    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public GBFSData withPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    public void setEmail(String email) {
        this.email = email;
    }

    public GBFSData withEmail(String email) {
        this.email = email;
        return this;
    }

    @JsonProperty(value="feed_contact_email")
    public String getFeedContactEmail() {
        return this.feedContactEmail;
    }

    @JsonProperty(value="feed_contact_email")
    public void setFeedContactEmail(String feedContactEmail) {
        this.feedContactEmail = feedContactEmail;
    }

    public GBFSData withFeedContactEmail(String feedContactEmail) {
        this.feedContactEmail = feedContactEmail;
        return this;
    }

    @JsonProperty(value="timezone")
    public String getTimezone() {
        return this.timezone;
    }

    @JsonProperty(value="timezone")
    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public GBFSData withTimezone(String timezone) {
        this.timezone = timezone;
        return this;
    }

    @JsonProperty(value="license_url")
    public String getLicenseUrl() {
        return this.licenseUrl;
    }

    @JsonProperty(value="license_url")
    public void setLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    public GBFSData withLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
        return this;
    }

    @JsonProperty(value="brand_assets")
    public GBFSBrandAssets getBrandAssets() {
        return this.brandAssets;
    }

    @JsonProperty(value="brand_assets")
    public void setBrandAssets(GBFSBrandAssets brandAssets) {
        this.brandAssets = brandAssets;
    }

    public GBFSData withBrandAssets(GBFSBrandAssets brandAssets) {
        this.brandAssets = brandAssets;
        return this;
    }

    @JsonProperty(value="terms_url")
    public String getTermsUrl() {
        return this.termsUrl;
    }

    @JsonProperty(value="terms_url")
    public void setTermsUrl(String termsUrl) {
        this.termsUrl = termsUrl;
    }

    public GBFSData withTermsUrl(String termsUrl) {
        this.termsUrl = termsUrl;
        return this;
    }

    @JsonProperty(value="terms_last_updated")
    public String getTermsLastUpdated() {
        return this.termsLastUpdated;
    }

    @JsonProperty(value="terms_last_updated")
    public void setTermsLastUpdated(String termsLastUpdated) {
        this.termsLastUpdated = termsLastUpdated;
    }

    public GBFSData withTermsLastUpdated(String termsLastUpdated) {
        this.termsLastUpdated = termsLastUpdated;
        return this;
    }

    @JsonProperty(value="privacy_url")
    public String getPrivacyUrl() {
        return this.privacyUrl;
    }

    @JsonProperty(value="privacy_url")
    public void setPrivacyUrl(String privacyUrl) {
        this.privacyUrl = privacyUrl;
    }

    public GBFSData withPrivacyUrl(String privacyUrl) {
        this.privacyUrl = privacyUrl;
        return this;
    }

    @JsonProperty(value="privacy_last_updated")
    public String getPrivacyLastUpdated() {
        return this.privacyLastUpdated;
    }

    @JsonProperty(value="privacy_last_updated")
    public void setPrivacyLastUpdated(String privacyLastUpdated) {
        this.privacyLastUpdated = privacyLastUpdated;
    }

    public GBFSData withPrivacyLastUpdated(String privacyLastUpdated) {
        this.privacyLastUpdated = privacyLastUpdated;
        return this;
    }

    @JsonProperty(value="rental_apps")
    public GBFSRentalApps getRentalApps() {
        return this.rentalApps;
    }

    @JsonProperty(value="rental_apps")
    public void setRentalApps(GBFSRentalApps rentalApps) {
        this.rentalApps = rentalApps;
    }

    public GBFSData withRentalApps(GBFSRentalApps rentalApps) {
        this.rentalApps = rentalApps;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public GBFSData withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GBFSData.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("systemId");
        sb.append('=');
        sb.append(this.systemId == null ? "<null>" : this.systemId);
        sb.append(',');
        sb.append("language");
        sb.append('=');
        sb.append(this.language == null ? "<null>" : this.language);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("shortName");
        sb.append('=');
        sb.append(this.shortName == null ? "<null>" : this.shortName);
        sb.append(',');
        sb.append("operator");
        sb.append('=');
        sb.append(this.operator == null ? "<null>" : this.operator);
        sb.append(',');
        sb.append("url");
        sb.append('=');
        sb.append(this.url == null ? "<null>" : this.url);
        sb.append(',');
        sb.append("purchaseUrl");
        sb.append('=');
        sb.append(this.purchaseUrl == null ? "<null>" : this.purchaseUrl);
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(this.startDate == null ? "<null>" : this.startDate);
        sb.append(',');
        sb.append("phoneNumber");
        sb.append('=');
        sb.append(this.phoneNumber == null ? "<null>" : this.phoneNumber);
        sb.append(',');
        sb.append("email");
        sb.append('=');
        sb.append(this.email == null ? "<null>" : this.email);
        sb.append(',');
        sb.append("feedContactEmail");
        sb.append('=');
        sb.append(this.feedContactEmail == null ? "<null>" : this.feedContactEmail);
        sb.append(',');
        sb.append("timezone");
        sb.append('=');
        sb.append(this.timezone == null ? "<null>" : this.timezone);
        sb.append(',');
        sb.append("licenseUrl");
        sb.append('=');
        sb.append(this.licenseUrl == null ? "<null>" : this.licenseUrl);
        sb.append(',');
        sb.append("brandAssets");
        sb.append('=');
        sb.append(this.brandAssets == null ? "<null>" : this.brandAssets);
        sb.append(',');
        sb.append("termsUrl");
        sb.append('=');
        sb.append(this.termsUrl == null ? "<null>" : this.termsUrl);
        sb.append(',');
        sb.append("termsLastUpdated");
        sb.append('=');
        sb.append(this.termsLastUpdated == null ? "<null>" : this.termsLastUpdated);
        sb.append(',');
        sb.append("privacyUrl");
        sb.append('=');
        sb.append(this.privacyUrl == null ? "<null>" : this.privacyUrl);
        sb.append(',');
        sb.append("privacyLastUpdated");
        sb.append('=');
        sb.append(this.privacyLastUpdated == null ? "<null>" : this.privacyLastUpdated);
        sb.append(',');
        sb.append("rentalApps");
        sb.append('=');
        sb.append(this.rentalApps == null ? "<null>" : this.rentalApps);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.privacyUrl == null ? 0 : this.privacyUrl.hashCode());
        result = result * 31 + (this.licenseUrl == null ? 0 : this.licenseUrl.hashCode());
        result = result * 31 + (this.systemId == null ? 0 : this.systemId.hashCode());
        result = result * 31 + (this.privacyLastUpdated == null ? 0 : this.privacyLastUpdated.hashCode());
        result = result * 31 + (this.timezone == null ? 0 : this.timezone.hashCode());
        result = result * 31 + (this.rentalApps == null ? 0 : this.rentalApps.hashCode());
        result = result * 31 + (this.language == null ? 0 : this.language.hashCode());
        result = result * 31 + (this.operator == null ? 0 : this.operator.hashCode());
        result = result * 31 + (this.url == null ? 0 : this.url.hashCode());
        result = result * 31 + (this.purchaseUrl == null ? 0 : this.purchaseUrl.hashCode());
        result = result * 31 + (this.phoneNumber == null ? 0 : this.phoneNumber.hashCode());
        result = result * 31 + (this.termsUrl == null ? 0 : this.termsUrl.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.feedContactEmail == null ? 0 : this.feedContactEmail.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.shortName == null ? 0 : this.shortName.hashCode());
        result = result * 31 + (this.termsLastUpdated == null ? 0 : this.termsLastUpdated.hashCode());
        result = result * 31 + (this.startDate == null ? 0 : this.startDate.hashCode());
        result = result * 31 + (this.email == null ? 0 : this.email.hashCode());
        result = result * 31 + (this.brandAssets == null ? 0 : this.brandAssets.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof GBFSData)) {
            return false;
        }
        GBFSData rhs = (GBFSData)other;
        return (this.privacyUrl == rhs.privacyUrl || this.privacyUrl != null && this.privacyUrl.equals(rhs.privacyUrl)) && (this.licenseUrl == rhs.licenseUrl || this.licenseUrl != null && this.licenseUrl.equals(rhs.licenseUrl)) && (this.systemId == rhs.systemId || this.systemId != null && this.systemId.equals(rhs.systemId)) && (this.privacyLastUpdated == rhs.privacyLastUpdated || this.privacyLastUpdated != null && this.privacyLastUpdated.equals(rhs.privacyLastUpdated)) && (this.timezone == rhs.timezone || this.timezone != null && this.timezone.equals(rhs.timezone)) && (this.rentalApps == rhs.rentalApps || this.rentalApps != null && this.rentalApps.equals(rhs.rentalApps)) && (this.language == rhs.language || this.language != null && this.language.equals(rhs.language)) && (this.operator == rhs.operator || this.operator != null && this.operator.equals(rhs.operator)) && (this.url == rhs.url || this.url != null && this.url.equals(rhs.url)) && (this.purchaseUrl == rhs.purchaseUrl || this.purchaseUrl != null && this.purchaseUrl.equals(rhs.purchaseUrl)) && (this.phoneNumber == rhs.phoneNumber || this.phoneNumber != null && this.phoneNumber.equals(rhs.phoneNumber)) && (this.termsUrl == rhs.termsUrl || this.termsUrl != null && this.termsUrl.equals(rhs.termsUrl)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.feedContactEmail == rhs.feedContactEmail || this.feedContactEmail != null && this.feedContactEmail.equals(rhs.feedContactEmail)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.shortName == rhs.shortName || this.shortName != null && this.shortName.equals(rhs.shortName)) && (this.termsLastUpdated == rhs.termsLastUpdated || this.termsLastUpdated != null && this.termsLastUpdated.equals(rhs.termsLastUpdated)) && (this.startDate == rhs.startDate || this.startDate != null && this.startDate.equals(rhs.startDate)) && (this.email == rhs.email || this.email != null && this.email.equals(rhs.email)) && (this.brandAssets == rhs.brandAssets || this.brandAssets != null && this.brandAssets.equals(rhs.brandAssets));
    }
}

