/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.v3_0_RC.gbfs;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "url"})
public class GBFSFeed
implements Serializable {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Key identifying the type of feed this is. The key must be the base file name defined in the spec for the corresponding feed type.")
    private Name name;
    @JsonProperty(value="url")
    @JsonPropertyDescription(value="URL for the feed.")
    private String url;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    private static final long serialVersionUID = -7251647554361500764L;

    @JsonProperty(value="name")
    public Name getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(Name name) {
        this.name = name;
    }

    public GBFSFeed withName(Name name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    public void setUrl(String url) {
        this.url = url;
    }

    public GBFSFeed withUrl(String url) {
        this.url = url;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public GBFSFeed withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GBFSFeed.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("url");
        sb.append('=');
        sb.append(this.url == null ? "<null>" : this.url);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof GBFSFeed)) {
            return false;
        }
        GBFSFeed rhs = (GBFSFeed)other;
        return (this.name == rhs.name || this.name != null && this.name.equals((Object)rhs.name)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.url == rhs.url || this.url != null && this.url.equals(rhs.url));
    }

    public static enum Name {
        GBFS("gbfs"),
        GBFS_VERSIONS("gbfs_versions"),
        SYSTEM_INFORMATION("system_information"),
        VEHICLE_TYPES("vehicle_types"),
        STATION_INFORMATION("station_information"),
        STATION_STATUS("station_status"),
        VEHICLE_STATUS("vehicle_status"),
        SYSTEM_ALERTS("system_alerts"),
        SYSTEM_REGIONS("system_regions"),
        SYSTEM_PRICING_PLANS("system_pricing_plans"),
        GEOFENCING_ZONES("geofencing_zones");

        private final String value;
        private static final Map<String, Name> CONSTANTS;

        private Name(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Name fromValue(String value) {
            Name constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Name>();
            for (Name c : Name.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

