/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.v3_0_RC2.geofencing_zones;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"vehicle_type_ids", "ride_start_allowed", "ride_end_allowed", "ride_through_allowed", "maximum_speed_kph", "station_parking"})
public class GBFSGlobalRule
implements Serializable {
    @JsonProperty(value="vehicle_type_ids")
    @JsonPropertyDescription(value="Array of vehicle type IDs for which these restrictions apply.")
    private List<String> vehicleTypeIds;
    @JsonProperty(value="ride_start_allowed")
    @JsonPropertyDescription(value="Is the ride allowed to start in this zone?")
    private Boolean rideStartAllowed;
    @JsonProperty(value="ride_end_allowed")
    @JsonPropertyDescription(value="Is the ride allowed to end in this zone?")
    private Boolean rideEndAllowed;
    @JsonProperty(value="ride_through_allowed")
    @JsonPropertyDescription(value="Is the ride allowed to travel through this zone?")
    private Boolean rideThroughAllowed;
    @JsonProperty(value="maximum_speed_kph")
    @JsonPropertyDescription(value="What is the maximum speed allowed, in kilometers per hour?")
    private Integer maximumSpeedKph;
    @JsonProperty(value="station_parking")
    @JsonPropertyDescription(value="Vehicle MUST be parked at stations defined in station_information.json within this geofence zone")
    private Boolean stationParking;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    private static final long serialVersionUID = 4873821006561475336L;

    @JsonProperty(value="vehicle_type_ids")
    public List<String> getVehicleTypeIds() {
        return this.vehicleTypeIds;
    }

    @JsonProperty(value="vehicle_type_ids")
    public void setVehicleTypeIds(List<String> vehicleTypeIds) {
        this.vehicleTypeIds = vehicleTypeIds;
    }

    public GBFSGlobalRule withVehicleTypeIds(List<String> vehicleTypeIds) {
        this.vehicleTypeIds = vehicleTypeIds;
        return this;
    }

    @JsonProperty(value="ride_start_allowed")
    public Boolean getRideStartAllowed() {
        return this.rideStartAllowed;
    }

    @JsonProperty(value="ride_start_allowed")
    public void setRideStartAllowed(Boolean rideStartAllowed) {
        this.rideStartAllowed = rideStartAllowed;
    }

    public GBFSGlobalRule withRideStartAllowed(Boolean rideStartAllowed) {
        this.rideStartAllowed = rideStartAllowed;
        return this;
    }

    @JsonProperty(value="ride_end_allowed")
    public Boolean getRideEndAllowed() {
        return this.rideEndAllowed;
    }

    @JsonProperty(value="ride_end_allowed")
    public void setRideEndAllowed(Boolean rideEndAllowed) {
        this.rideEndAllowed = rideEndAllowed;
    }

    public GBFSGlobalRule withRideEndAllowed(Boolean rideEndAllowed) {
        this.rideEndAllowed = rideEndAllowed;
        return this;
    }

    @JsonProperty(value="ride_through_allowed")
    public Boolean getRideThroughAllowed() {
        return this.rideThroughAllowed;
    }

    @JsonProperty(value="ride_through_allowed")
    public void setRideThroughAllowed(Boolean rideThroughAllowed) {
        this.rideThroughAllowed = rideThroughAllowed;
    }

    public GBFSGlobalRule withRideThroughAllowed(Boolean rideThroughAllowed) {
        this.rideThroughAllowed = rideThroughAllowed;
        return this;
    }

    @JsonProperty(value="maximum_speed_kph")
    public Integer getMaximumSpeedKph() {
        return this.maximumSpeedKph;
    }

    @JsonProperty(value="maximum_speed_kph")
    public void setMaximumSpeedKph(Integer maximumSpeedKph) {
        this.maximumSpeedKph = maximumSpeedKph;
    }

    public GBFSGlobalRule withMaximumSpeedKph(Integer maximumSpeedKph) {
        this.maximumSpeedKph = maximumSpeedKph;
        return this;
    }

    @JsonProperty(value="station_parking")
    public Boolean getStationParking() {
        return this.stationParking;
    }

    @JsonProperty(value="station_parking")
    public void setStationParking(Boolean stationParking) {
        this.stationParking = stationParking;
    }

    public GBFSGlobalRule withStationParking(Boolean stationParking) {
        this.stationParking = stationParking;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public GBFSGlobalRule withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GBFSGlobalRule.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("vehicleTypeIds");
        sb.append('=');
        sb.append(this.vehicleTypeIds == null ? "<null>" : this.vehicleTypeIds);
        sb.append(',');
        sb.append("rideStartAllowed");
        sb.append('=');
        sb.append(this.rideStartAllowed == null ? "<null>" : this.rideStartAllowed);
        sb.append(',');
        sb.append("rideEndAllowed");
        sb.append('=');
        sb.append(this.rideEndAllowed == null ? "<null>" : this.rideEndAllowed);
        sb.append(',');
        sb.append("rideThroughAllowed");
        sb.append('=');
        sb.append(this.rideThroughAllowed == null ? "<null>" : this.rideThroughAllowed);
        sb.append(',');
        sb.append("maximumSpeedKph");
        sb.append('=');
        sb.append(this.maximumSpeedKph == null ? "<null>" : this.maximumSpeedKph);
        sb.append(',');
        sb.append("stationParking");
        sb.append('=');
        sb.append(this.stationParking == null ? "<null>" : this.stationParking);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.vehicleTypeIds == null ? 0 : this.vehicleTypeIds.hashCode());
        result = result * 31 + (this.rideStartAllowed == null ? 0 : this.rideStartAllowed.hashCode());
        result = result * 31 + (this.rideThroughAllowed == null ? 0 : this.rideThroughAllowed.hashCode());
        result = result * 31 + (this.maximumSpeedKph == null ? 0 : this.maximumSpeedKph.hashCode());
        result = result * 31 + (this.rideEndAllowed == null ? 0 : this.rideEndAllowed.hashCode());
        result = result * 31 + (this.stationParking == null ? 0 : this.stationParking.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof GBFSGlobalRule)) {
            return false;
        }
        GBFSGlobalRule rhs = (GBFSGlobalRule)other;
        return (this.vehicleTypeIds == rhs.vehicleTypeIds || this.vehicleTypeIds != null && this.vehicleTypeIds.equals(rhs.vehicleTypeIds)) && (this.rideStartAllowed == rhs.rideStartAllowed || this.rideStartAllowed != null && this.rideStartAllowed.equals(rhs.rideStartAllowed)) && (this.rideThroughAllowed == rhs.rideThroughAllowed || this.rideThroughAllowed != null && this.rideThroughAllowed.equals(rhs.rideThroughAllowed)) && (this.maximumSpeedKph == rhs.maximumSpeedKph || this.maximumSpeedKph != null && this.maximumSpeedKph.equals(rhs.maximumSpeedKph)) && (this.rideEndAllowed == rhs.rideEndAllowed || this.rideEndAllowed != null && this.rideEndAllowed.equals(rhs.rideEndAllowed)) && (this.stationParking == rhs.stationParking || this.stationParking != null && this.stationParking.equals(rhs.stationParking)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties));
    }
}

