/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.v3_0_RC2.vehicle_status;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.entur.gbfs.v3_0_RC2.vehicle_status.GBFSRentalUris;
import org.entur.gbfs.v3_0_RC2.vehicle_status.VehicleEquipment;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"vehicle_id", "lat", "lon", "is_reserved", "is_disabled", "rental_uris", "vehicle_type_id", "last_reported", "current_range_meters", "current_fuel_percent", "station_id", "home_station_id", "pricing_plan_id", "vehicle_equipment", "available_until"})
public class GBFSVehicle
implements Serializable {
    @JsonProperty(value="vehicle_id")
    @JsonPropertyDescription(value="Rotating (as of v2.0) identifier of a vehicle.")
    private String vehicleId;
    @JsonProperty(value="lat")
    @JsonPropertyDescription(value="The latitude of the vehicle.")
    private Double lat;
    @JsonProperty(value="lon")
    @JsonPropertyDescription(value="The longitude of the vehicle.")
    private Double lon;
    @JsonProperty(value="is_reserved")
    @JsonPropertyDescription(value="Is the vehicle currently reserved?")
    private Boolean isReserved;
    @JsonProperty(value="is_disabled")
    @JsonPropertyDescription(value="Is the vehicle currently disabled (broken)?")
    private Boolean isDisabled;
    @JsonProperty(value="rental_uris")
    @JsonPropertyDescription(value="Contains rental uris for Android, iOS, and web in the android, ios, and web fields (added in v1.1).")
    private GBFSRentalUris rentalUris;
    @JsonProperty(value="vehicle_type_id")
    @JsonPropertyDescription(value="The vehicle_type_id of this vehicle (added in v2.1-RC).")
    private String vehicleTypeId;
    @JsonProperty(value="last_reported")
    @JsonPropertyDescription(value="The last time this vehicle reported its status to the operator's backend in RFC3339 format (added in v2.1-RC).")
    private Date lastReported;
    @JsonProperty(value="current_range_meters")
    @JsonPropertyDescription(value="The furthest distance in meters that the vehicle can travel without recharging or refueling with the vehicle's current charge or fuel (added in v2.1-RC).")
    private Double currentRangeMeters;
    @JsonProperty(value="current_fuel_percent")
    @JsonPropertyDescription(value="This value represents the current percentage, expressed from 0 to 1, of fuel or battery power remaining in the vehicle. Added in v2.3-RC.")
    private Double currentFuelPercent;
    @JsonProperty(value="station_id")
    @JsonPropertyDescription(value="Identifier referencing the station_id if the vehicle is currently at a station (added in v2.1-RC2).")
    private String stationId;
    @JsonProperty(value="home_station_id")
    @JsonPropertyDescription(value="The station_id of the station this vehicle must be returned to (added in v2.3-RC).")
    private String homeStationId;
    @JsonProperty(value="pricing_plan_id")
    @JsonPropertyDescription(value="The plan_id of the pricing plan this vehicle is eligible for (added in v2.2).")
    private String pricingPlanId;
    @JsonProperty(value="vehicle_equipment")
    @JsonPropertyDescription(value="List of vehicle equipment provided by the operator in addition to the accessories already provided in the vehicle. Added in v2.3.")
    private List<VehicleEquipment> vehicleEquipment;
    @JsonProperty(value="available_until")
    @JsonPropertyDescription(value="The date and time when any rental of the vehicle must be completed. Added in v2.3.")
    private String availableUntil;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    private static final long serialVersionUID = 2876629584369034887L;

    @JsonProperty(value="vehicle_id")
    public String getVehicleId() {
        return this.vehicleId;
    }

    @JsonProperty(value="vehicle_id")
    public void setVehicleId(String vehicleId) {
        this.vehicleId = vehicleId;
    }

    public GBFSVehicle withVehicleId(String vehicleId) {
        this.vehicleId = vehicleId;
        return this;
    }

    @JsonProperty(value="lat")
    public Double getLat() {
        return this.lat;
    }

    @JsonProperty(value="lat")
    public void setLat(Double lat) {
        this.lat = lat;
    }

    public GBFSVehicle withLat(Double lat) {
        this.lat = lat;
        return this;
    }

    @JsonProperty(value="lon")
    public Double getLon() {
        return this.lon;
    }

    @JsonProperty(value="lon")
    public void setLon(Double lon) {
        this.lon = lon;
    }

    public GBFSVehicle withLon(Double lon) {
        this.lon = lon;
        return this;
    }

    @JsonProperty(value="is_reserved")
    public Boolean getIsReserved() {
        return this.isReserved;
    }

    @JsonProperty(value="is_reserved")
    public void setIsReserved(Boolean isReserved) {
        this.isReserved = isReserved;
    }

    public GBFSVehicle withIsReserved(Boolean isReserved) {
        this.isReserved = isReserved;
        return this;
    }

    @JsonProperty(value="is_disabled")
    public Boolean getIsDisabled() {
        return this.isDisabled;
    }

    @JsonProperty(value="is_disabled")
    public void setIsDisabled(Boolean isDisabled) {
        this.isDisabled = isDisabled;
    }

    public GBFSVehicle withIsDisabled(Boolean isDisabled) {
        this.isDisabled = isDisabled;
        return this;
    }

    @JsonProperty(value="rental_uris")
    public GBFSRentalUris getRentalUris() {
        return this.rentalUris;
    }

    @JsonProperty(value="rental_uris")
    public void setRentalUris(GBFSRentalUris rentalUris) {
        this.rentalUris = rentalUris;
    }

    public GBFSVehicle withRentalUris(GBFSRentalUris rentalUris) {
        this.rentalUris = rentalUris;
        return this;
    }

    @JsonProperty(value="vehicle_type_id")
    public String getVehicleTypeId() {
        return this.vehicleTypeId;
    }

    @JsonProperty(value="vehicle_type_id")
    public void setVehicleTypeId(String vehicleTypeId) {
        this.vehicleTypeId = vehicleTypeId;
    }

    public GBFSVehicle withVehicleTypeId(String vehicleTypeId) {
        this.vehicleTypeId = vehicleTypeId;
        return this;
    }

    @JsonProperty(value="last_reported")
    public Date getLastReported() {
        return this.lastReported;
    }

    @JsonProperty(value="last_reported")
    public void setLastReported(Date lastReported) {
        this.lastReported = lastReported;
    }

    public GBFSVehicle withLastReported(Date lastReported) {
        this.lastReported = lastReported;
        return this;
    }

    @JsonProperty(value="current_range_meters")
    public Double getCurrentRangeMeters() {
        return this.currentRangeMeters;
    }

    @JsonProperty(value="current_range_meters")
    public void setCurrentRangeMeters(Double currentRangeMeters) {
        this.currentRangeMeters = currentRangeMeters;
    }

    public GBFSVehicle withCurrentRangeMeters(Double currentRangeMeters) {
        this.currentRangeMeters = currentRangeMeters;
        return this;
    }

    @JsonProperty(value="current_fuel_percent")
    public Double getCurrentFuelPercent() {
        return this.currentFuelPercent;
    }

    @JsonProperty(value="current_fuel_percent")
    public void setCurrentFuelPercent(Double currentFuelPercent) {
        this.currentFuelPercent = currentFuelPercent;
    }

    public GBFSVehicle withCurrentFuelPercent(Double currentFuelPercent) {
        this.currentFuelPercent = currentFuelPercent;
        return this;
    }

    @JsonProperty(value="station_id")
    public String getStationId() {
        return this.stationId;
    }

    @JsonProperty(value="station_id")
    public void setStationId(String stationId) {
        this.stationId = stationId;
    }

    public GBFSVehicle withStationId(String stationId) {
        this.stationId = stationId;
        return this;
    }

    @JsonProperty(value="home_station_id")
    public String getHomeStationId() {
        return this.homeStationId;
    }

    @JsonProperty(value="home_station_id")
    public void setHomeStationId(String homeStationId) {
        this.homeStationId = homeStationId;
    }

    public GBFSVehicle withHomeStationId(String homeStationId) {
        this.homeStationId = homeStationId;
        return this;
    }

    @JsonProperty(value="pricing_plan_id")
    public String getPricingPlanId() {
        return this.pricingPlanId;
    }

    @JsonProperty(value="pricing_plan_id")
    public void setPricingPlanId(String pricingPlanId) {
        this.pricingPlanId = pricingPlanId;
    }

    public GBFSVehicle withPricingPlanId(String pricingPlanId) {
        this.pricingPlanId = pricingPlanId;
        return this;
    }

    @JsonProperty(value="vehicle_equipment")
    public List<VehicleEquipment> getVehicleEquipment() {
        return this.vehicleEquipment;
    }

    @JsonProperty(value="vehicle_equipment")
    public void setVehicleEquipment(List<VehicleEquipment> vehicleEquipment) {
        this.vehicleEquipment = vehicleEquipment;
    }

    public GBFSVehicle withVehicleEquipment(List<VehicleEquipment> vehicleEquipment) {
        this.vehicleEquipment = vehicleEquipment;
        return this;
    }

    @JsonProperty(value="available_until")
    public String getAvailableUntil() {
        return this.availableUntil;
    }

    @JsonProperty(value="available_until")
    public void setAvailableUntil(String availableUntil) {
        this.availableUntil = availableUntil;
    }

    public GBFSVehicle withAvailableUntil(String availableUntil) {
        this.availableUntil = availableUntil;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public GBFSVehicle withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GBFSVehicle.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("vehicleId");
        sb.append('=');
        sb.append(this.vehicleId == null ? "<null>" : this.vehicleId);
        sb.append(',');
        sb.append("lat");
        sb.append('=');
        sb.append(this.lat == null ? "<null>" : this.lat);
        sb.append(',');
        sb.append("lon");
        sb.append('=');
        sb.append(this.lon == null ? "<null>" : this.lon);
        sb.append(',');
        sb.append("isReserved");
        sb.append('=');
        sb.append(this.isReserved == null ? "<null>" : this.isReserved);
        sb.append(',');
        sb.append("isDisabled");
        sb.append('=');
        sb.append(this.isDisabled == null ? "<null>" : this.isDisabled);
        sb.append(',');
        sb.append("rentalUris");
        sb.append('=');
        sb.append(this.rentalUris == null ? "<null>" : this.rentalUris);
        sb.append(',');
        sb.append("vehicleTypeId");
        sb.append('=');
        sb.append(this.vehicleTypeId == null ? "<null>" : this.vehicleTypeId);
        sb.append(',');
        sb.append("lastReported");
        sb.append('=');
        sb.append(this.lastReported == null ? "<null>" : this.lastReported);
        sb.append(',');
        sb.append("currentRangeMeters");
        sb.append('=');
        sb.append(this.currentRangeMeters == null ? "<null>" : this.currentRangeMeters);
        sb.append(',');
        sb.append("currentFuelPercent");
        sb.append('=');
        sb.append(this.currentFuelPercent == null ? "<null>" : this.currentFuelPercent);
        sb.append(',');
        sb.append("stationId");
        sb.append('=');
        sb.append(this.stationId == null ? "<null>" : this.stationId);
        sb.append(',');
        sb.append("homeStationId");
        sb.append('=');
        sb.append(this.homeStationId == null ? "<null>" : this.homeStationId);
        sb.append(',');
        sb.append("pricingPlanId");
        sb.append('=');
        sb.append(this.pricingPlanId == null ? "<null>" : this.pricingPlanId);
        sb.append(',');
        sb.append("vehicleEquipment");
        sb.append('=');
        sb.append(this.vehicleEquipment == null ? "<null>" : this.vehicleEquipment);
        sb.append(',');
        sb.append("availableUntil");
        sb.append('=');
        sb.append(this.availableUntil == null ? "<null>" : this.availableUntil);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.vehicleTypeId == null ? 0 : this.vehicleTypeId.hashCode());
        result = result * 31 + (this.rentalUris == null ? 0 : this.rentalUris.hashCode());
        result = result * 31 + (this.vehicleEquipment == null ? 0 : this.vehicleEquipment.hashCode());
        result = result * 31 + (this.isReserved == null ? 0 : this.isReserved.hashCode());
        result = result * 31 + (this.lon == null ? 0 : this.lon.hashCode());
        result = result * 31 + (this.currentFuelPercent == null ? 0 : this.currentFuelPercent.hashCode());
        result = result * 31 + (this.homeStationId == null ? 0 : this.homeStationId.hashCode());
        result = result * 31 + (this.pricingPlanId == null ? 0 : this.pricingPlanId.hashCode());
        result = result * 31 + (this.availableUntil == null ? 0 : this.availableUntil.hashCode());
        result = result * 31 + (this.lastReported == null ? 0 : this.lastReported.hashCode());
        result = result * 31 + (this.currentRangeMeters == null ? 0 : this.currentRangeMeters.hashCode());
        result = result * 31 + (this.vehicleId == null ? 0 : this.vehicleId.hashCode());
        result = result * 31 + (this.isDisabled == null ? 0 : this.isDisabled.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.lat == null ? 0 : this.lat.hashCode());
        result = result * 31 + (this.stationId == null ? 0 : this.stationId.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof GBFSVehicle)) {
            return false;
        }
        GBFSVehicle rhs = (GBFSVehicle)other;
        return (this.vehicleTypeId == rhs.vehicleTypeId || this.vehicleTypeId != null && this.vehicleTypeId.equals(rhs.vehicleTypeId)) && (this.rentalUris == rhs.rentalUris || this.rentalUris != null && this.rentalUris.equals(rhs.rentalUris)) && (this.vehicleEquipment == rhs.vehicleEquipment || this.vehicleEquipment != null && this.vehicleEquipment.equals(rhs.vehicleEquipment)) && (this.isReserved == rhs.isReserved || this.isReserved != null && this.isReserved.equals(rhs.isReserved)) && (this.lon == rhs.lon || this.lon != null && this.lon.equals(rhs.lon)) && (this.currentFuelPercent == rhs.currentFuelPercent || this.currentFuelPercent != null && this.currentFuelPercent.equals(rhs.currentFuelPercent)) && (this.homeStationId == rhs.homeStationId || this.homeStationId != null && this.homeStationId.equals(rhs.homeStationId)) && (this.pricingPlanId == rhs.pricingPlanId || this.pricingPlanId != null && this.pricingPlanId.equals(rhs.pricingPlanId)) && (this.availableUntil == rhs.availableUntil || this.availableUntil != null && this.availableUntil.equals(rhs.availableUntil)) && (this.lastReported == rhs.lastReported || this.lastReported != null && this.lastReported.equals(rhs.lastReported)) && (this.currentRangeMeters == rhs.currentRangeMeters || this.currentRangeMeters != null && this.currentRangeMeters.equals(rhs.currentRangeMeters)) && (this.vehicleId == rhs.vehicleId || this.vehicleId != null && this.vehicleId.equals(rhs.vehicleId)) && (this.isDisabled == rhs.isDisabled || this.isDisabled != null && this.isDisabled.equals(rhs.isDisabled)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.lat == rhs.lat || this.lat != null && this.lat.equals(rhs.lat)) && (this.stationId == rhs.stationId || this.stationId != null && this.stationId.equals(rhs.stationId));
    }
}

