/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.v3_0.geofencing_zones;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.entur.gbfs.v3_0.geofencing_zones.GBFSProperties;
import org.geojson.MultiPolygon;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"type", "properties", "geometry"})
public class GBFSFeature
implements Serializable {
    @JsonProperty(value="type")
    private Type type;
    @JsonProperty(value="properties")
    @JsonPropertyDescription(value="Describing travel allowances and limitations.")
    private GBFSProperties properties;
    @JsonProperty(value="geometry")
    @JsonPropertyDescription(value="A polygon that describes where rides might not be able to start, end, go through, or have other limitations. Must follow the right-hand rule.")
    private MultiPolygon geometry;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    private static final long serialVersionUID = 2206440217850559273L;

    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(Type type) {
        this.type = type;
    }

    public GBFSFeature withType(Type type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="properties")
    public GBFSProperties getProperties() {
        return this.properties;
    }

    @JsonProperty(value="properties")
    public void setProperties(GBFSProperties properties) {
        this.properties = properties;
    }

    public GBFSFeature withProperties(GBFSProperties properties) {
        this.properties = properties;
        return this;
    }

    @JsonProperty(value="geometry")
    public MultiPolygon getGeometry() {
        return this.geometry;
    }

    @JsonProperty(value="geometry")
    public void setGeometry(MultiPolygon geometry) {
        this.geometry = geometry;
    }

    public GBFSFeature withGeometry(MultiPolygon geometry) {
        this.geometry = geometry;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public GBFSFeature withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GBFSFeature.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("properties");
        sb.append('=');
        sb.append(this.properties == null ? "<null>" : this.properties);
        sb.append(',');
        sb.append("geometry");
        sb.append('=');
        sb.append((Object)(this.geometry == null ? "<null>" : this.geometry));
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.geometry == null ? 0 : this.geometry.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof GBFSFeature)) {
            return false;
        }
        GBFSFeature rhs = (GBFSFeature)other;
        return (this.geometry == rhs.geometry || this.geometry != null && this.geometry.equals((Object)rhs.geometry)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.properties == rhs.properties || this.properties != null && this.properties.equals(rhs.properties));
    }

    public static enum Type {
        FEATURE("Feature");

        private final String value;
        private static final Map<String, Type> CONSTANTS;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Type fromValue(String value) {
            Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Type>();
            for (Type c : Type.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

