/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;
import org.entur.gbfs.GbfsSubscriptionOptions;
import org.entur.gbfs.loader.GbfsSubscription;
import org.entur.gbfs.loader.v2.GbfsV2Delivery;
import org.entur.gbfs.loader.v2.GbfsV2Subscription;
import org.entur.gbfs.loader.v3.GbfsV3Delivery;
import org.entur.gbfs.loader.v3.GbfsV3Subscription;

public class GbfsSubscriptionManager {
    private final Map<String, GbfsSubscription> subscriptions = new ConcurrentHashMap<String, GbfsSubscription>();
    private ForkJoinPool customThreadPool;

    public GbfsSubscriptionManager() {
    }

    public GbfsSubscriptionManager(ForkJoinPool customThreadPool) {
        this.customThreadPool = customThreadPool;
    }

    public String subscribeV2(GbfsSubscriptionOptions options, Consumer<GbfsV2Delivery> consumer) {
        return this.subscribe(new GbfsV2Subscription(options, consumer));
    }

    public String subscribeV3(GbfsSubscriptionOptions options, Consumer<GbfsV3Delivery> consumer) {
        return this.subscribe(new GbfsV3Subscription(options, consumer));
    }

    public void update() {
        Optional.ofNullable(this.customThreadPool).orElse(ForkJoinPool.commonPool()).execute(() -> this.subscriptions.values().parallelStream().forEach(GbfsSubscription::update));
    }

    public void unsubscribe(String identifier) {
        this.subscriptions.remove(identifier);
    }

    private String subscribe(GbfsSubscription subscription) {
        String id = UUID.randomUUID().toString();
        subscription.init();
        if (subscription.getSetupComplete()) {
            this.subscriptions.put(id, subscription);
            return id;
        }
        return null;
    }
}

