/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.mapper;

import java.util.List;
import org.entur.gbfs.mapper.SystemInformationDataMapper;
import org.entur.gbfs.v3_0.system_information.GBFSData;
import org.entur.gbfs.v3_0.system_information.GBFSName;
import org.entur.gbfs.v3_0.system_information.GBFSOperator;
import org.entur.gbfs.v3_0.system_information.GBFSPrivacyUrl;
import org.entur.gbfs.v3_0.system_information.GBFSShortName;
import org.entur.gbfs.v3_0.system_information.GBFSTermsUrl;
import org.mapstruct.Context;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

@Mapper(imports={List.class})
public abstract class SystemInformationAdditionalMapper {
    @SystemInformationDataMapper
    @Mapping(target="languages", expression="java(List.of(language))")
    abstract GBFSData mapData(org.entur.gbfs.v2_3.system_information.GBFSData var1, @Context String var2);

    @SystemInformationDataMapper
    @Mapping(target="language", expression="java(language)")
    abstract org.entur.gbfs.v2_3.system_information.GBFSData mapDataInverse(GBFSData var1, @Context String var2);

    List<GBFSName> mapName(String value, @Context String language) {
        if (value == null) {
            return null;
        }
        return List.of(new GBFSName().withText(value).withLanguage(language));
    }

    String mapNameInverse(List<GBFSName> values, @Context String language) {
        if (values == null) {
            return null;
        }
        return values.stream().filter(name -> name.getLanguage().equals(language)).map(GBFSName::getText).findFirst().orElse(null);
    }

    List<GBFSShortName> mapShortName(String value, @Context String language) {
        if (value == null) {
            return null;
        }
        return List.of(new GBFSShortName().withText(value).withLanguage(language));
    }

    String mapShortNameInverse(List<GBFSShortName> values, @Context String language) {
        if (values == null) {
            return null;
        }
        return values.stream().filter(name -> name.getLanguage().equals(language)).map(GBFSShortName::getText).findFirst().orElse(null);
    }

    List<GBFSOperator> mapOperator(String operator, @Context String language) {
        if (operator == null) {
            return null;
        }
        return List.of(new GBFSOperator().withText(operator).withLanguage(language));
    }

    String mapOperatorInverse(List<GBFSOperator> values, @Context String language) {
        if (values == null) {
            return null;
        }
        return values.stream().filter(name -> name.getLanguage().equals(language)).map(GBFSOperator::getText).findFirst().orElse(null);
    }

    List<GBFSTermsUrl> mapTermsUrl(String termsUrl, @Context String language) {
        if (termsUrl == null) {
            return null;
        }
        return List.of(new GBFSTermsUrl().withText(termsUrl).withLanguage(language));
    }

    String mapTermsUrlInverse(List<GBFSTermsUrl> values, @Context String language) {
        if (values == null) {
            return null;
        }
        return values.stream().filter(name -> name.getLanguage().equals(language)).map(GBFSTermsUrl::getText).findFirst().orElse(null);
    }

    List<GBFSPrivacyUrl> mapPrivacyUrl(String privacyUrl, @Context String language) {
        if (privacyUrl == null) {
            return null;
        }
        return List.of(new GBFSPrivacyUrl().withText(privacyUrl).withLanguage(language));
    }

    String mapPrivacyUrlInverse(List<GBFSPrivacyUrl> values, @Context String language) {
        if (values == null) {
            return null;
        }
        return values.stream().filter(name -> name.getLanguage().equals(language)).map(GBFSPrivacyUrl::getText).findFirst().orElse(null);
    }
}

