/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.mapper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.entur.gbfs.mapper.DateMapper;
import org.entur.gbfs.mapper.VehicleStatusAdditionalMapper;
import org.entur.gbfs.v2_3.free_bike_status.GBFSBike;
import org.entur.gbfs.v2_3.free_bike_status.GBFSData;
import org.entur.gbfs.v2_3.free_bike_status.GBFSRentalUris;
import org.entur.gbfs.v2_3.free_bike_status.VehicleEquipment;
import org.entur.gbfs.v3_0.vehicle_status.GBFSVehicle;
import org.mapstruct.factory.Mappers;

public class VehicleStatusAdditionalMapperImpl
extends VehicleStatusAdditionalMapper {
    private final DateMapper dateMapper = (DateMapper)Mappers.getMapper(DateMapper.class);

    @Override
    GBFSData mapData(org.entur.gbfs.v3_0.vehicle_status.GBFSData source) {
        Map map;
        if (source == null) {
            return null;
        }
        GBFSData gBFSData = new GBFSData();
        gBFSData.setBikes(this.gBFSVehicleListToGBFSBikeList(source.getVehicles()));
        if (gBFSData.getAdditionalProperties() != null && (map = source.getAdditionalProperties()) != null) {
            gBFSData.getAdditionalProperties().putAll(map);
        }
        return gBFSData;
    }

    @Override
    org.entur.gbfs.v3_0.vehicle_status.GBFSData mapDataInverse(GBFSData source) {
        Map map;
        if (source == null) {
            return null;
        }
        org.entur.gbfs.v3_0.vehicle_status.GBFSData gBFSData = new org.entur.gbfs.v3_0.vehicle_status.GBFSData();
        gBFSData.setVehicles(this.gBFSBikeListToGBFSVehicleList(source.getBikes()));
        if (gBFSData.getAdditionalProperties() != null && (map = source.getAdditionalProperties()) != null) {
            gBFSData.getAdditionalProperties().putAll(map);
        }
        return gBFSData;
    }

    @Override
    GBFSBike mapVehicle(GBFSVehicle source) {
        Map map;
        if (source == null) {
            return null;
        }
        GBFSBike gBFSBike = new GBFSBike();
        gBFSBike.setBikeId(source.getVehicleId());
        gBFSBike.setLat(source.getLat());
        gBFSBike.setLon(source.getLon());
        gBFSBike.setIsReserved(source.getIsReserved());
        gBFSBike.setIsDisabled(source.getIsDisabled());
        gBFSBike.setRentalUris(this.gBFSRentalUrisToGBFSRentalUris(source.getRentalUris()));
        gBFSBike.setVehicleTypeId(source.getVehicleTypeId());
        gBFSBike.setLastReported(this.dateMapper.mapDateToDouble(source.getLastReported()));
        gBFSBike.setCurrentRangeMeters(source.getCurrentRangeMeters());
        gBFSBike.setCurrentFuelPercent(source.getCurrentFuelPercent());
        gBFSBike.setStationId(source.getStationId());
        gBFSBike.setHomeStationId(source.getHomeStationId());
        gBFSBike.setPricingPlanId(source.getPricingPlanId());
        gBFSBike.setVehicleEquipment(this.vehicleEquipmentListToVehicleEquipmentList(source.getVehicleEquipment()));
        gBFSBike.setAvailableUntil(source.getAvailableUntil());
        if (gBFSBike.getAdditionalProperties() != null && (map = source.getAdditionalProperties()) != null) {
            gBFSBike.getAdditionalProperties().putAll(map);
        }
        return gBFSBike;
    }

    @Override
    GBFSVehicle mapVehicleInverse(GBFSBike source) {
        Map map;
        if (source == null) {
            return null;
        }
        GBFSVehicle gBFSVehicle = new GBFSVehicle();
        gBFSVehicle.setVehicleId(source.getBikeId());
        gBFSVehicle.setLat(source.getLat());
        gBFSVehicle.setLon(source.getLon());
        gBFSVehicle.setIsReserved(source.getIsReserved());
        gBFSVehicle.setIsDisabled(source.getIsDisabled());
        gBFSVehicle.setRentalUris(this.gBFSRentalUrisToGBFSRentalUris1(source.getRentalUris()));
        gBFSVehicle.setVehicleTypeId(source.getVehicleTypeId());
        gBFSVehicle.setLastReported(this.dateMapper.mapDoubleToDate(source.getLastReported()));
        gBFSVehicle.setCurrentRangeMeters(source.getCurrentRangeMeters());
        gBFSVehicle.setCurrentFuelPercent(source.getCurrentFuelPercent());
        gBFSVehicle.setStationId(source.getStationId());
        gBFSVehicle.setHomeStationId(source.getHomeStationId());
        gBFSVehicle.setPricingPlanId(source.getPricingPlanId());
        gBFSVehicle.setVehicleEquipment(this.vehicleEquipmentListToVehicleEquipmentList1(source.getVehicleEquipment()));
        gBFSVehicle.setAvailableUntil(source.getAvailableUntil());
        if (gBFSVehicle.getAdditionalProperties() != null && (map = source.getAdditionalProperties()) != null) {
            gBFSVehicle.getAdditionalProperties().putAll(map);
        }
        return gBFSVehicle;
    }

    protected List<GBFSBike> gBFSVehicleListToGBFSBikeList(List<GBFSVehicle> list) {
        if (list == null) {
            return null;
        }
        ArrayList<GBFSBike> list1 = new ArrayList<GBFSBike>(list.size());
        for (GBFSVehicle gBFSVehicle : list) {
            list1.add(this.mapVehicle(gBFSVehicle));
        }
        return list1;
    }

    protected List<GBFSVehicle> gBFSBikeListToGBFSVehicleList(List<GBFSBike> list) {
        if (list == null) {
            return null;
        }
        ArrayList<GBFSVehicle> list1 = new ArrayList<GBFSVehicle>(list.size());
        for (GBFSBike gBFSBike : list) {
            list1.add(this.mapVehicleInverse(gBFSBike));
        }
        return list1;
    }

    protected GBFSRentalUris gBFSRentalUrisToGBFSRentalUris(org.entur.gbfs.v3_0.vehicle_status.GBFSRentalUris gBFSRentalUris) {
        Map map;
        if (gBFSRentalUris == null) {
            return null;
        }
        GBFSRentalUris gBFSRentalUris1 = new GBFSRentalUris();
        gBFSRentalUris1.setAndroid(gBFSRentalUris.getAndroid());
        gBFSRentalUris1.setIos(gBFSRentalUris.getIos());
        gBFSRentalUris1.setWeb(gBFSRentalUris.getWeb());
        if (gBFSRentalUris1.getAdditionalProperties() != null && (map = gBFSRentalUris.getAdditionalProperties()) != null) {
            gBFSRentalUris1.getAdditionalProperties().putAll(map);
        }
        return gBFSRentalUris1;
    }

    protected VehicleEquipment vehicleEquipmentToVehicleEquipment(org.entur.gbfs.v3_0.vehicle_status.VehicleEquipment vehicleEquipment) {
        if (vehicleEquipment == null) {
            return null;
        }
        return switch (vehicleEquipment) {
            case org.entur.gbfs.v3_0.vehicle_status.VehicleEquipment.CHILD_SEAT_A -> VehicleEquipment.CHILD_SEAT_A;
            case org.entur.gbfs.v3_0.vehicle_status.VehicleEquipment.CHILD_SEAT_B -> VehicleEquipment.CHILD_SEAT_B;
            case org.entur.gbfs.v3_0.vehicle_status.VehicleEquipment.CHILD_SEAT_C -> VehicleEquipment.CHILD_SEAT_C;
            case org.entur.gbfs.v3_0.vehicle_status.VehicleEquipment.WINTER_TIRES -> VehicleEquipment.WINTER_TIRES;
            case org.entur.gbfs.v3_0.vehicle_status.VehicleEquipment.SNOW_CHAINS -> VehicleEquipment.SNOW_CHAINS;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + vehicleEquipment);
        };
    }

    protected List<VehicleEquipment> vehicleEquipmentListToVehicleEquipmentList(List<org.entur.gbfs.v3_0.vehicle_status.VehicleEquipment> list) {
        if (list == null) {
            return null;
        }
        ArrayList<VehicleEquipment> list1 = new ArrayList<VehicleEquipment>(list.size());
        for (org.entur.gbfs.v3_0.vehicle_status.VehicleEquipment vehicleEquipment : list) {
            list1.add(this.vehicleEquipmentToVehicleEquipment(vehicleEquipment));
        }
        return list1;
    }

    protected org.entur.gbfs.v3_0.vehicle_status.GBFSRentalUris gBFSRentalUrisToGBFSRentalUris1(GBFSRentalUris gBFSRentalUris) {
        Map map;
        if (gBFSRentalUris == null) {
            return null;
        }
        org.entur.gbfs.v3_0.vehicle_status.GBFSRentalUris gBFSRentalUris1 = new org.entur.gbfs.v3_0.vehicle_status.GBFSRentalUris();
        gBFSRentalUris1.setAndroid(gBFSRentalUris.getAndroid());
        gBFSRentalUris1.setIos(gBFSRentalUris.getIos());
        gBFSRentalUris1.setWeb(gBFSRentalUris.getWeb());
        if (gBFSRentalUris1.getAdditionalProperties() != null && (map = gBFSRentalUris.getAdditionalProperties()) != null) {
            gBFSRentalUris1.getAdditionalProperties().putAll(map);
        }
        return gBFSRentalUris1;
    }

    protected org.entur.gbfs.v3_0.vehicle_status.VehicleEquipment vehicleEquipmentToVehicleEquipment1(VehicleEquipment vehicleEquipment) {
        if (vehicleEquipment == null) {
            return null;
        }
        return switch (vehicleEquipment) {
            case VehicleEquipment.CHILD_SEAT_A -> org.entur.gbfs.v3_0.vehicle_status.VehicleEquipment.CHILD_SEAT_A;
            case VehicleEquipment.CHILD_SEAT_B -> org.entur.gbfs.v3_0.vehicle_status.VehicleEquipment.CHILD_SEAT_B;
            case VehicleEquipment.CHILD_SEAT_C -> org.entur.gbfs.v3_0.vehicle_status.VehicleEquipment.CHILD_SEAT_C;
            case VehicleEquipment.WINTER_TIRES -> org.entur.gbfs.v3_0.vehicle_status.VehicleEquipment.WINTER_TIRES;
            case VehicleEquipment.SNOW_CHAINS -> org.entur.gbfs.v3_0.vehicle_status.VehicleEquipment.SNOW_CHAINS;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + vehicleEquipment);
        };
    }

    protected List<org.entur.gbfs.v3_0.vehicle_status.VehicleEquipment> vehicleEquipmentListToVehicleEquipmentList1(List<VehicleEquipment> list) {
        if (list == null) {
            return null;
        }
        ArrayList<org.entur.gbfs.v3_0.vehicle_status.VehicleEquipment> list1 = new ArrayList<org.entur.gbfs.v3_0.vehicle_status.VehicleEquipment>(list.size());
        for (VehicleEquipment vehicleEquipment : list) {
            list1.add(this.vehicleEquipmentToVehicleEquipment1(vehicleEquipment));
        }
        return list1;
    }
}

