/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.mapper;

import java.net.URI;
import java.util.List;
import java.util.Map;
import org.entur.gbfs.mapper.GBFSFeedNameMapper;
import org.entur.gbfs.v2_3.gbfs.GBFSFeed;
import org.entur.gbfs.v2_3.gbfs.GBFSFeedName;
import org.entur.gbfs.v2_3.gbfs.GBFSFeeds;
import org.entur.gbfs.v3_0.gbfs.GBFSData;
import org.mapstruct.Context;

public class DiscoveryFileAdditionalMapper {
    private static GBFSFeedNameMapper feedNameMapper = GBFSFeedNameMapper.INSTANCE;

    public GBFSData map(Map<String, GBFSFeeds> source, @Context String sourceLanguage) {
        List<org.entur.gbfs.v3_0.gbfs.GBFSFeed> mappedFeeds = source.get(sourceLanguage).getFeeds().stream().filter(this::filterLegacySourceFeeds).map(this::map).toList();
        return new GBFSData().withFeeds(mappedFeeds);
    }

    public Map<String, GBFSFeeds> map(GBFSData source, @Context String targetLanguage) {
        GBFSFeeds mappedFeeds = new GBFSFeeds();
        mappedFeeds.setFeeds(source.getFeeds().stream().map(this::map).toList());
        return Map.of(targetLanguage, mappedFeeds);
    }

    private boolean filterLegacySourceFeeds(GBFSFeed sourceFeed) {
        return !List.of(GBFSFeedName.SystemHours, GBFSFeedName.SystemCalendar).contains(sourceFeed.getName());
    }

    private org.entur.gbfs.v3_0.gbfs.GBFSFeed map(GBFSFeed sourceFeed) {
        org.entur.gbfs.v3_0.gbfs.GBFSFeed targetFeed = new org.entur.gbfs.v3_0.gbfs.GBFSFeed();
        targetFeed.setName(feedNameMapper.map(sourceFeed.getName()));
        targetFeed.setUrl(sourceFeed.getUrl().toString());
        return targetFeed;
    }

    private GBFSFeed map(org.entur.gbfs.v3_0.gbfs.GBFSFeed sourceFeed) {
        GBFSFeed targetFeed = new GBFSFeed();
        targetFeed.setName(feedNameMapper.map(sourceFeed.getName()));
        targetFeed.setUrl(URI.create(sourceFeed.getUrl()));
        return targetFeed;
    }
}

