/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.mapper;

import java.util.List;
import org.entur.gbfs.v2_3.station_information.GBFSStation;
import org.entur.gbfs.v2_3.station_information.GBFSVehicleCapacity;
import org.entur.gbfs.v2_3.station_information.GBFSVehicleTypeCapacity;
import org.entur.gbfs.v3_0.station_information.GBFSName;
import org.entur.gbfs.v3_0.station_information.GBFSShortName;
import org.entur.gbfs.v3_0.station_information.GBFSVehicleDocksCapacity;
import org.entur.gbfs.v3_0.station_information.GBFSVehicleTypesCapacity;
import org.mapstruct.Context;
import org.mapstruct.InheritInverseConfiguration;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;

@Mapper
public abstract class StationInformationAdditionalMapper {
    List<GBFSName> mapName(String value, @Context String language) {
        if (value == null) {
            return null;
        }
        return List.of(new GBFSName().withText(value).withLanguage(language));
    }

    String mapNameInverse(List<GBFSName> values, @Context String language) {
        if (values == null) {
            return null;
        }
        return values.stream().filter(name -> name.getLanguage().equals(language)).map(GBFSName::getText).findFirst().orElse(null);
    }

    List<GBFSShortName> mapShortName(String value, @Context String language) {
        if (value == null) {
            return null;
        }
        return List.of(new GBFSShortName().withText(value).withLanguage(language));
    }

    String mapShortNameInverse(List<GBFSShortName> values, @Context String language) {
        if (values == null) {
            return null;
        }
        return values.stream().filter(name -> name.getLanguage().equals(language)).map(GBFSShortName::getText).findFirst().orElse(null);
    }

    @Mappings(value={@Mapping(source="vehicleCapacity", target="vehicleTypesCapacity"), @Mapping(source="vehicleTypeCapacity", target="vehicleDocksCapacity")})
    abstract org.entur.gbfs.v3_0.station_information.GBFSStation mapStation(GBFSStation var1, @Context String var2);

    List<GBFSVehicleTypesCapacity> mapVehicleTypeAreaCapacity(GBFSVehicleCapacity source) {
        if (source == null) {
            return null;
        }
        return source.getAdditionalProperties().entrySet().stream().map(entry -> new GBFSVehicleTypesCapacity().withVehicleTypeIds(List.of((String)entry.getKey())).withCount(Integer.valueOf(((Double)entry.getValue()).intValue()))).toList();
    }

    List<GBFSVehicleDocksCapacity> mapVehicleTypeDockCapacity(GBFSVehicleTypeCapacity source) {
        if (source == null) {
            return null;
        }
        return source.getAdditionalProperties().entrySet().stream().map(entry -> new GBFSVehicleDocksCapacity().withVehicleTypeIds(List.of((String)entry.getKey())).withCount(Integer.valueOf(((Double)entry.getValue()).intValue()))).toList();
    }

    @InheritInverseConfiguration
    abstract GBFSStation mapStationInverse(org.entur.gbfs.v3_0.station_information.GBFSStation var1, @Context String var2);

    GBFSVehicleCapacity mapVehicleTypeAreaCapacityInverse(List<GBFSVehicleTypesCapacity> source) {
        if (source == null) {
            return null;
        }
        GBFSVehicleCapacity mapped = new GBFSVehicleCapacity();
        source.forEach(gbfsVehicleTypesCapacity -> gbfsVehicleTypesCapacity.getVehicleTypeIds().forEach(vehicleTypeId -> mapped.setAdditionalProperty(vehicleTypeId, Double.valueOf(gbfsVehicleTypesCapacity.getCount().doubleValue()))));
        return mapped;
    }

    GBFSVehicleTypeCapacity mapVehicleTypeDockCapacityInverse(List<GBFSVehicleDocksCapacity> source) {
        if (source == null) {
            return null;
        }
        GBFSVehicleTypeCapacity mapped = new GBFSVehicleTypeCapacity();
        source.forEach(gbfsVehicleTypeDockCapacity -> gbfsVehicleTypeDockCapacity.getVehicleTypeIds().forEach(vehicleTypeId -> mapped.setAdditionalProperty(vehicleTypeId, Double.valueOf(gbfsVehicleTypeDockCapacity.getCount().doubleValue()))));
        return mapped;
    }
}

