/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.mapper;

import java.util.List;
import org.mapstruct.Context;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mobilitydata.gbfs.v2_3.geofencing_zones.GBFSRule;
import org.mobilitydata.gbfs.v3_0.geofencing_zones.GBFSName;

@Mapper
public abstract class GeofencingZonesAdditionalMapper {
    List<GBFSName> mapName(String value, @Context String language) {
        if (value == null) {
            return null;
        }
        return List.of(new GBFSName().withText(value).withLanguage(language));
    }

    String mapNameInverse(List<GBFSName> values, @Context String language) {
        if (values == null) {
            return null;
        }
        return values.stream().filter(name -> name.getLanguage().equals(language)).map(GBFSName::getText).findFirst().orElse(null);
    }

    @Mappings(value={@Mapping(target="rideStartAllowed", source="rideAllowed"), @Mapping(target="rideEndAllowed", source="rideAllowed"), @Mapping(target="vehicleTypeIds", source="vehicleTypeId")})
    abstract org.mobilitydata.gbfs.v3_0.geofencing_zones.GBFSRule mapRule(GBFSRule var1);

    @Mappings(value={@Mapping(target="rideAllowed", expression="java(source.getRideStartAllowed() && source.getRideEndAllowed())"), @Mapping(target="vehicleTypeId", source="vehicleTypeIds")})
    abstract GBFSRule mapRuleInverse(org.mobilitydata.gbfs.v3_0.geofencing_zones.GBFSRule var1);
}

