/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.mapper;

import java.util.List;
import java.util.Map;
import org.entur.gbfs.mapper.SystemInformationAdditionalMapper;
import org.mobilitydata.gbfs.v2_3.system_information.GBFSBrandAssets;
import org.mobilitydata.gbfs.v2_3.system_information.GBFSData;
import org.mobilitydata.gbfs.v2_3.system_information.GBFSRentalApps;
import org.mobilitydata.gbfs.v3_0.system_information.GBFSAndroid;
import org.mobilitydata.gbfs.v3_0.system_information.GBFSData;
import org.mobilitydata.gbfs.v3_0.system_information.GBFSIos;

public class SystemInformationAdditionalMapperImpl
extends SystemInformationAdditionalMapper {
    @Override
    GBFSData mapData(org.mobilitydata.gbfs.v2_3.system_information.GBFSData source, String language) {
        if (source == null) {
            return null;
        }
        GBFSData gBFSData = new GBFSData();
        gBFSData.setSystemId(source.getSystemId());
        gBFSData.setName(this.mapName(source.getName(), language));
        gBFSData.setShortName(this.mapShortName(source.getShortName(), language));
        gBFSData.setOperator(this.mapOperator(source.getOperator(), language));
        gBFSData.setUrl(source.getUrl());
        gBFSData.setPurchaseUrl(source.getPurchaseUrl());
        gBFSData.setStartDate(source.getStartDate());
        gBFSData.setPhoneNumber(source.getPhoneNumber());
        gBFSData.setEmail(source.getEmail());
        gBFSData.setFeedContactEmail(source.getFeedContactEmail());
        gBFSData.setTimezone(this.timezoneToTimezone(source.getTimezone(), language));
        gBFSData.setLicenseUrl(source.getLicenseUrl());
        gBFSData.setBrandAssets(this.gBFSBrandAssetsToGBFSBrandAssets(source.getBrandAssets(), language));
        gBFSData.setTermsUrl(this.mapTermsUrl(source.getTermsUrl(), language));
        gBFSData.setTermsLastUpdated(source.getTermsLastUpdated());
        gBFSData.setPrivacyUrl(this.mapPrivacyUrl(source.getPrivacyUrl(), language));
        gBFSData.setPrivacyLastUpdated(source.getPrivacyLastUpdated());
        gBFSData.setRentalApps(this.gBFSRentalAppsToGBFSRentalApps(source.getRentalApps(), language));
        gBFSData.setLanguages(List.of(language));
        return gBFSData;
    }

    @Override
    org.mobilitydata.gbfs.v2_3.system_information.GBFSData mapDataInverse(GBFSData source, String language) {
        if (source == null) {
            return null;
        }
        org.mobilitydata.gbfs.v2_3.system_information.GBFSData gBFSData = new org.mobilitydata.gbfs.v2_3.system_information.GBFSData();
        gBFSData.setSystemId(source.getSystemId());
        gBFSData.setName(this.mapNameInverse(source.getName(), language));
        gBFSData.setShortName(this.mapShortNameInverse(source.getShortName(), language));
        gBFSData.setOperator(this.mapOperatorInverse(source.getOperator(), language));
        gBFSData.setUrl(source.getUrl());
        gBFSData.setPurchaseUrl(source.getPurchaseUrl());
        gBFSData.setStartDate(source.getStartDate());
        gBFSData.setPhoneNumber(source.getPhoneNumber());
        gBFSData.setEmail(source.getEmail());
        gBFSData.setFeedContactEmail(source.getFeedContactEmail());
        gBFSData.setTimezone(this.timezoneToTimezone1(source.getTimezone(), language));
        gBFSData.setLicenseUrl(source.getLicenseUrl());
        gBFSData.setBrandAssets(this.gBFSBrandAssetsToGBFSBrandAssets1(source.getBrandAssets(), language));
        gBFSData.setTermsUrl(this.mapTermsUrlInverse(source.getTermsUrl(), language));
        gBFSData.setTermsLastUpdated(source.getTermsLastUpdated());
        gBFSData.setPrivacyUrl(this.mapPrivacyUrlInverse(source.getPrivacyUrl(), language));
        gBFSData.setPrivacyLastUpdated(source.getPrivacyLastUpdated());
        gBFSData.setRentalApps(this.gBFSRentalAppsToGBFSRentalApps1(source.getRentalApps(), language));
        gBFSData.setLanguage(language);
        return gBFSData;
    }

    protected GBFSData.Timezone timezoneToTimezone(GBFSData.Timezone timezone, String language) {
        if (timezone == null) {
            return null;
        }
        return switch (timezone) {
            case GBFSData.Timezone.AFRICA_ABIDJAN -> GBFSData.Timezone.AFRICA_ABIDJAN;
            case GBFSData.Timezone.AFRICA_ACCRA -> GBFSData.Timezone.AFRICA_ACCRA;
            case GBFSData.Timezone.AFRICA_ADDIS_ABABA -> GBFSData.Timezone.AFRICA_ADDIS_ABABA;
            case GBFSData.Timezone.AFRICA_ALGIERS -> GBFSData.Timezone.AFRICA_ALGIERS;
            case GBFSData.Timezone.AFRICA_ASMARA -> GBFSData.Timezone.AFRICA_ASMARA;
            case GBFSData.Timezone.AFRICA_ASMERA -> GBFSData.Timezone.AFRICA_ASMERA;
            case GBFSData.Timezone.AFRICA_BAMAKO -> GBFSData.Timezone.AFRICA_BAMAKO;
            case GBFSData.Timezone.AFRICA_BANGUI -> GBFSData.Timezone.AFRICA_BANGUI;
            case GBFSData.Timezone.AFRICA_BANJUL -> GBFSData.Timezone.AFRICA_BANJUL;
            case GBFSData.Timezone.AFRICA_BISSAU -> GBFSData.Timezone.AFRICA_BISSAU;
            case GBFSData.Timezone.AFRICA_BLANTYRE -> GBFSData.Timezone.AFRICA_BLANTYRE;
            case GBFSData.Timezone.AFRICA_BRAZZAVILLE -> GBFSData.Timezone.AFRICA_BRAZZAVILLE;
            case GBFSData.Timezone.AFRICA_BUJUMBURA -> GBFSData.Timezone.AFRICA_BUJUMBURA;
            case GBFSData.Timezone.AFRICA_CAIRO -> GBFSData.Timezone.AFRICA_CAIRO;
            case GBFSData.Timezone.AFRICA_CASABLANCA -> GBFSData.Timezone.AFRICA_CASABLANCA;
            case GBFSData.Timezone.AFRICA_CEUTA -> GBFSData.Timezone.AFRICA_CEUTA;
            case GBFSData.Timezone.AFRICA_CONAKRY -> GBFSData.Timezone.AFRICA_CONAKRY;
            case GBFSData.Timezone.AFRICA_DAKAR -> GBFSData.Timezone.AFRICA_DAKAR;
            case GBFSData.Timezone.AFRICA_DAR_ES_SALAAM -> GBFSData.Timezone.AFRICA_DAR_ES_SALAAM;
            case GBFSData.Timezone.AFRICA_DJIBOUTI -> GBFSData.Timezone.AFRICA_DJIBOUTI;
            case GBFSData.Timezone.AFRICA_DOUALA -> GBFSData.Timezone.AFRICA_DOUALA;
            case GBFSData.Timezone.AFRICA_EL_AAIUN -> GBFSData.Timezone.AFRICA_EL_AAIUN;
            case GBFSData.Timezone.AFRICA_FREETOWN -> GBFSData.Timezone.AFRICA_FREETOWN;
            case GBFSData.Timezone.AFRICA_GABORONE -> GBFSData.Timezone.AFRICA_GABORONE;
            case GBFSData.Timezone.AFRICA_HARARE -> GBFSData.Timezone.AFRICA_HARARE;
            case GBFSData.Timezone.AFRICA_JOHANNESBURG -> GBFSData.Timezone.AFRICA_JOHANNESBURG;
            case GBFSData.Timezone.AFRICA_JUBA -> GBFSData.Timezone.AFRICA_JUBA;
            case GBFSData.Timezone.AFRICA_KAMPALA -> GBFSData.Timezone.AFRICA_KAMPALA;
            case GBFSData.Timezone.AFRICA_KHARTOUM -> GBFSData.Timezone.AFRICA_KHARTOUM;
            case GBFSData.Timezone.AFRICA_KIGALI -> GBFSData.Timezone.AFRICA_KIGALI;
            case GBFSData.Timezone.AFRICA_KINSHASA -> GBFSData.Timezone.AFRICA_KINSHASA;
            case GBFSData.Timezone.AFRICA_LAGOS -> GBFSData.Timezone.AFRICA_LAGOS;
            case GBFSData.Timezone.AFRICA_LIBREVILLE -> GBFSData.Timezone.AFRICA_LIBREVILLE;
            case GBFSData.Timezone.AFRICA_LOME -> GBFSData.Timezone.AFRICA_LOME;
            case GBFSData.Timezone.AFRICA_LUANDA -> GBFSData.Timezone.AFRICA_LUANDA;
            case GBFSData.Timezone.AFRICA_LUBUMBASHI -> GBFSData.Timezone.AFRICA_LUBUMBASHI;
            case GBFSData.Timezone.AFRICA_LUSAKA -> GBFSData.Timezone.AFRICA_LUSAKA;
            case GBFSData.Timezone.AFRICA_MALABO -> GBFSData.Timezone.AFRICA_MALABO;
            case GBFSData.Timezone.AFRICA_MAPUTO -> GBFSData.Timezone.AFRICA_MAPUTO;
            case GBFSData.Timezone.AFRICA_MASERU -> GBFSData.Timezone.AFRICA_MASERU;
            case GBFSData.Timezone.AFRICA_MBABANE -> GBFSData.Timezone.AFRICA_MBABANE;
            case GBFSData.Timezone.AFRICA_MOGADISHU -> GBFSData.Timezone.AFRICA_MOGADISHU;
            case GBFSData.Timezone.AFRICA_MONROVIA -> GBFSData.Timezone.AFRICA_MONROVIA;
            case GBFSData.Timezone.AFRICA_NAIROBI -> GBFSData.Timezone.AFRICA_NAIROBI;
            case GBFSData.Timezone.AFRICA_NDJAMENA -> GBFSData.Timezone.AFRICA_NDJAMENA;
            case GBFSData.Timezone.AFRICA_NIAMEY -> GBFSData.Timezone.AFRICA_NIAMEY;
            case GBFSData.Timezone.AFRICA_NOUAKCHOTT -> GBFSData.Timezone.AFRICA_NOUAKCHOTT;
            case GBFSData.Timezone.AFRICA_OUAGADOUGOU -> GBFSData.Timezone.AFRICA_OUAGADOUGOU;
            case GBFSData.Timezone.AFRICA_PORTO_NOVO -> GBFSData.Timezone.AFRICA_PORTO_NOVO;
            case GBFSData.Timezone.AFRICA_SAO_TOME -> GBFSData.Timezone.AFRICA_SAO_TOME;
            case GBFSData.Timezone.AFRICA_TIMBUKTU -> GBFSData.Timezone.AFRICA_TIMBUKTU;
            case GBFSData.Timezone.AFRICA_TRIPOLI -> GBFSData.Timezone.AFRICA_TRIPOLI;
            case GBFSData.Timezone.AFRICA_TUNIS -> GBFSData.Timezone.AFRICA_TUNIS;
            case GBFSData.Timezone.AFRICA_WINDHOEK -> GBFSData.Timezone.AFRICA_WINDHOEK;
            case GBFSData.Timezone.AMERICA_ADAK -> GBFSData.Timezone.AMERICA_ADAK;
            case GBFSData.Timezone.AMERICA_ANCHORAGE -> GBFSData.Timezone.AMERICA_ANCHORAGE;
            case GBFSData.Timezone.AMERICA_ANGUILLA -> GBFSData.Timezone.AMERICA_ANGUILLA;
            case GBFSData.Timezone.AMERICA_ANTIGUA -> GBFSData.Timezone.AMERICA_ANTIGUA;
            case GBFSData.Timezone.AMERICA_ARAGUAINA -> GBFSData.Timezone.AMERICA_ARAGUAINA;
            case GBFSData.Timezone.AMERICA_ARGENTINA_BUENOS_AIRES -> GBFSData.Timezone.AMERICA_ARGENTINA_BUENOS_AIRES;
            case GBFSData.Timezone.AMERICA_ARGENTINA_CATAMARCA -> GBFSData.Timezone.AMERICA_ARGENTINA_CATAMARCA;
            case GBFSData.Timezone.AMERICA_ARGENTINA_COMOD_RIVADAVIA -> GBFSData.Timezone.AMERICA_ARGENTINA_COMOD_RIVADAVIA;
            case GBFSData.Timezone.AMERICA_ARGENTINA_CORDOBA -> GBFSData.Timezone.AMERICA_ARGENTINA_CORDOBA;
            case GBFSData.Timezone.AMERICA_ARGENTINA_JUJUY -> GBFSData.Timezone.AMERICA_ARGENTINA_JUJUY;
            case GBFSData.Timezone.AMERICA_ARGENTINA_LA_RIOJA -> GBFSData.Timezone.AMERICA_ARGENTINA_LA_RIOJA;
            case GBFSData.Timezone.AMERICA_ARGENTINA_MENDOZA -> GBFSData.Timezone.AMERICA_ARGENTINA_MENDOZA;
            case GBFSData.Timezone.AMERICA_ARGENTINA_RIO_GALLEGOS -> GBFSData.Timezone.AMERICA_ARGENTINA_RIO_GALLEGOS;
            case GBFSData.Timezone.AMERICA_ARGENTINA_SALTA -> GBFSData.Timezone.AMERICA_ARGENTINA_SALTA;
            case GBFSData.Timezone.AMERICA_ARGENTINA_SAN_JUAN -> GBFSData.Timezone.AMERICA_ARGENTINA_SAN_JUAN;
            case GBFSData.Timezone.AMERICA_ARGENTINA_SAN_LUIS -> GBFSData.Timezone.AMERICA_ARGENTINA_SAN_LUIS;
            case GBFSData.Timezone.AMERICA_ARGENTINA_TUCUMAN -> GBFSData.Timezone.AMERICA_ARGENTINA_TUCUMAN;
            case GBFSData.Timezone.AMERICA_ARGENTINA_USHUAIA -> GBFSData.Timezone.AMERICA_ARGENTINA_USHUAIA;
            case GBFSData.Timezone.AMERICA_ARUBA -> GBFSData.Timezone.AMERICA_ARUBA;
            case GBFSData.Timezone.AMERICA_ASUNCION -> GBFSData.Timezone.AMERICA_ASUNCION;
            case GBFSData.Timezone.AMERICA_ATIKOKAN -> GBFSData.Timezone.AMERICA_ATIKOKAN;
            case GBFSData.Timezone.AMERICA_ATKA -> GBFSData.Timezone.AMERICA_ATKA;
            case GBFSData.Timezone.AMERICA_BAHIA -> GBFSData.Timezone.AMERICA_BAHIA;
            case GBFSData.Timezone.AMERICA_BAHIA_BANDERAS -> GBFSData.Timezone.AMERICA_BAHIA_BANDERAS;
            case GBFSData.Timezone.AMERICA_BARBADOS -> GBFSData.Timezone.AMERICA_BARBADOS;
            case GBFSData.Timezone.AMERICA_BELEM -> GBFSData.Timezone.AMERICA_BELEM;
            case GBFSData.Timezone.AMERICA_BELIZE -> GBFSData.Timezone.AMERICA_BELIZE;
            case GBFSData.Timezone.AMERICA_BLANC_SABLON -> GBFSData.Timezone.AMERICA_BLANC_SABLON;
            case GBFSData.Timezone.AMERICA_BOA_VISTA -> GBFSData.Timezone.AMERICA_BOA_VISTA;
            case GBFSData.Timezone.AMERICA_BOGOTA -> GBFSData.Timezone.AMERICA_BOGOTA;
            case GBFSData.Timezone.AMERICA_BOISE -> GBFSData.Timezone.AMERICA_BOISE;
            case GBFSData.Timezone.AMERICA_BUENOS_AIRES -> GBFSData.Timezone.AMERICA_BUENOS_AIRES;
            case GBFSData.Timezone.AMERICA_CAMBRIDGE_BAY -> GBFSData.Timezone.AMERICA_CAMBRIDGE_BAY;
            case GBFSData.Timezone.AMERICA_CAMPO_GRANDE -> GBFSData.Timezone.AMERICA_CAMPO_GRANDE;
            case GBFSData.Timezone.AMERICA_CANCUN -> GBFSData.Timezone.AMERICA_CANCUN;
            case GBFSData.Timezone.AMERICA_CARACAS -> GBFSData.Timezone.AMERICA_CARACAS;
            case GBFSData.Timezone.AMERICA_CATAMARCA -> GBFSData.Timezone.AMERICA_CATAMARCA;
            case GBFSData.Timezone.AMERICA_CAYENNE -> GBFSData.Timezone.AMERICA_CAYENNE;
            case GBFSData.Timezone.AMERICA_CAYMAN -> GBFSData.Timezone.AMERICA_CAYMAN;
            case GBFSData.Timezone.AMERICA_CHICAGO -> GBFSData.Timezone.AMERICA_CHICAGO;
            case GBFSData.Timezone.AMERICA_CHIHUAHUA -> GBFSData.Timezone.AMERICA_CHIHUAHUA;
            case GBFSData.Timezone.AMERICA_CIUDAD_JUAREZ -> GBFSData.Timezone.AMERICA_CIUDAD_JUAREZ;
            case GBFSData.Timezone.AMERICA_CORAL_HARBOUR -> GBFSData.Timezone.AMERICA_CORAL_HARBOUR;
            case GBFSData.Timezone.AMERICA_CORDOBA -> GBFSData.Timezone.AMERICA_CORDOBA;
            case GBFSData.Timezone.AMERICA_COSTA_RICA -> GBFSData.Timezone.AMERICA_COSTA_RICA;
            case GBFSData.Timezone.AMERICA_CRESTON -> GBFSData.Timezone.AMERICA_CRESTON;
            case GBFSData.Timezone.AMERICA_CUIABA -> GBFSData.Timezone.AMERICA_CUIABA;
            case GBFSData.Timezone.AMERICA_CURACAO -> GBFSData.Timezone.AMERICA_CURACAO;
            case GBFSData.Timezone.AMERICA_DANMARKSHAVN -> GBFSData.Timezone.AMERICA_DANMARKSHAVN;
            case GBFSData.Timezone.AMERICA_DAWSON -> GBFSData.Timezone.AMERICA_DAWSON;
            case GBFSData.Timezone.AMERICA_DAWSON_CREEK -> GBFSData.Timezone.AMERICA_DAWSON_CREEK;
            case GBFSData.Timezone.AMERICA_DENVER -> GBFSData.Timezone.AMERICA_DENVER;
            case GBFSData.Timezone.AMERICA_DETROIT -> GBFSData.Timezone.AMERICA_DETROIT;
            case GBFSData.Timezone.AMERICA_DOMINICA -> GBFSData.Timezone.AMERICA_DOMINICA;
            case GBFSData.Timezone.AMERICA_EDMONTON -> GBFSData.Timezone.AMERICA_EDMONTON;
            case GBFSData.Timezone.AMERICA_EIRUNEPE -> GBFSData.Timezone.AMERICA_EIRUNEPE;
            case GBFSData.Timezone.AMERICA_EL_SALVADOR -> GBFSData.Timezone.AMERICA_EL_SALVADOR;
            case GBFSData.Timezone.AMERICA_ENSENADA -> GBFSData.Timezone.AMERICA_ENSENADA;
            case GBFSData.Timezone.AMERICA_FORT_NELSON -> GBFSData.Timezone.AMERICA_FORT_NELSON;
            case GBFSData.Timezone.AMERICA_FORT_WAYNE -> GBFSData.Timezone.AMERICA_FORT_WAYNE;
            case GBFSData.Timezone.AMERICA_FORTALEZA -> GBFSData.Timezone.AMERICA_FORTALEZA;
            case GBFSData.Timezone.AMERICA_GLACE_BAY -> GBFSData.Timezone.AMERICA_GLACE_BAY;
            case GBFSData.Timezone.AMERICA_GODTHAB -> GBFSData.Timezone.AMERICA_GODTHAB;
            case GBFSData.Timezone.AMERICA_GOOSE_BAY -> GBFSData.Timezone.AMERICA_GOOSE_BAY;
            case GBFSData.Timezone.AMERICA_GRAND_TURK -> GBFSData.Timezone.AMERICA_GRAND_TURK;
            case GBFSData.Timezone.AMERICA_GRENADA -> GBFSData.Timezone.AMERICA_GRENADA;
            case GBFSData.Timezone.AMERICA_GUADELOUPE -> GBFSData.Timezone.AMERICA_GUADELOUPE;
            case GBFSData.Timezone.AMERICA_GUATEMALA -> GBFSData.Timezone.AMERICA_GUATEMALA;
            case GBFSData.Timezone.AMERICA_GUAYAQUIL -> GBFSData.Timezone.AMERICA_GUAYAQUIL;
            case GBFSData.Timezone.AMERICA_GUYANA -> GBFSData.Timezone.AMERICA_GUYANA;
            case GBFSData.Timezone.AMERICA_HALIFAX -> GBFSData.Timezone.AMERICA_HALIFAX;
            case GBFSData.Timezone.AMERICA_HAVANA -> GBFSData.Timezone.AMERICA_HAVANA;
            case GBFSData.Timezone.AMERICA_HERMOSILLO -> GBFSData.Timezone.AMERICA_HERMOSILLO;
            case GBFSData.Timezone.AMERICA_INDIANA_INDIANAPOLIS -> GBFSData.Timezone.AMERICA_INDIANA_INDIANAPOLIS;
            case GBFSData.Timezone.AMERICA_INDIANA_KNOX -> GBFSData.Timezone.AMERICA_INDIANA_KNOX;
            case GBFSData.Timezone.AMERICA_INDIANA_MARENGO -> GBFSData.Timezone.AMERICA_INDIANA_MARENGO;
            case GBFSData.Timezone.AMERICA_INDIANA_PETERSBURG -> GBFSData.Timezone.AMERICA_INDIANA_PETERSBURG;
            case GBFSData.Timezone.AMERICA_INDIANA_TELL_CITY -> GBFSData.Timezone.AMERICA_INDIANA_TELL_CITY;
            case GBFSData.Timezone.AMERICA_INDIANA_VEVAY -> GBFSData.Timezone.AMERICA_INDIANA_VEVAY;
            case GBFSData.Timezone.AMERICA_INDIANA_VINCENNES -> GBFSData.Timezone.AMERICA_INDIANA_VINCENNES;
            case GBFSData.Timezone.AMERICA_INDIANA_WINAMAC -> GBFSData.Timezone.AMERICA_INDIANA_WINAMAC;
            case GBFSData.Timezone.AMERICA_INDIANAPOLIS -> GBFSData.Timezone.AMERICA_INDIANAPOLIS;
            case GBFSData.Timezone.AMERICA_INUVIK -> GBFSData.Timezone.AMERICA_INUVIK;
            case GBFSData.Timezone.AMERICA_IQALUIT -> GBFSData.Timezone.AMERICA_IQALUIT;
            case GBFSData.Timezone.AMERICA_JAMAICA -> GBFSData.Timezone.AMERICA_JAMAICA;
            case GBFSData.Timezone.AMERICA_JUJUY -> GBFSData.Timezone.AMERICA_JUJUY;
            case GBFSData.Timezone.AMERICA_JUNEAU -> GBFSData.Timezone.AMERICA_JUNEAU;
            case GBFSData.Timezone.AMERICA_KENTUCKY_LOUISVILLE -> GBFSData.Timezone.AMERICA_KENTUCKY_LOUISVILLE;
            case GBFSData.Timezone.AMERICA_KENTUCKY_MONTICELLO -> GBFSData.Timezone.AMERICA_KENTUCKY_MONTICELLO;
            case GBFSData.Timezone.AMERICA_KNOX_IN -> GBFSData.Timezone.AMERICA_KNOX_IN;
            case GBFSData.Timezone.AMERICA_KRALENDIJK -> GBFSData.Timezone.AMERICA_KRALENDIJK;
            case GBFSData.Timezone.AMERICA_LA_PAZ -> GBFSData.Timezone.AMERICA_LA_PAZ;
            case GBFSData.Timezone.AMERICA_LIMA -> GBFSData.Timezone.AMERICA_LIMA;
            case GBFSData.Timezone.AMERICA_LOS_ANGELES -> GBFSData.Timezone.AMERICA_LOS_ANGELES;
            case GBFSData.Timezone.AMERICA_LOUISVILLE -> GBFSData.Timezone.AMERICA_LOUISVILLE;
            case GBFSData.Timezone.AMERICA_LOWER_PRINCES -> GBFSData.Timezone.AMERICA_LOWER_PRINCES;
            case GBFSData.Timezone.AMERICA_MACEIO -> GBFSData.Timezone.AMERICA_MACEIO;
            case GBFSData.Timezone.AMERICA_MANAGUA -> GBFSData.Timezone.AMERICA_MANAGUA;
            case GBFSData.Timezone.AMERICA_MANAUS -> GBFSData.Timezone.AMERICA_MANAUS;
            case GBFSData.Timezone.AMERICA_MARIGOT -> GBFSData.Timezone.AMERICA_MARIGOT;
            case GBFSData.Timezone.AMERICA_MARTINIQUE -> GBFSData.Timezone.AMERICA_MARTINIQUE;
            case GBFSData.Timezone.AMERICA_MATAMOROS -> GBFSData.Timezone.AMERICA_MATAMOROS;
            case GBFSData.Timezone.AMERICA_MAZATLAN -> GBFSData.Timezone.AMERICA_MAZATLAN;
            case GBFSData.Timezone.AMERICA_MENDOZA -> GBFSData.Timezone.AMERICA_MENDOZA;
            case GBFSData.Timezone.AMERICA_MENOMINEE -> GBFSData.Timezone.AMERICA_MENOMINEE;
            case GBFSData.Timezone.AMERICA_MERIDA -> GBFSData.Timezone.AMERICA_MERIDA;
            case GBFSData.Timezone.AMERICA_METLAKATLA -> GBFSData.Timezone.AMERICA_METLAKATLA;
            case GBFSData.Timezone.AMERICA_MEXICO_CITY -> GBFSData.Timezone.AMERICA_MEXICO_CITY;
            case GBFSData.Timezone.AMERICA_MIQUELON -> GBFSData.Timezone.AMERICA_MIQUELON;
            case GBFSData.Timezone.AMERICA_MONCTON -> GBFSData.Timezone.AMERICA_MONCTON;
            case GBFSData.Timezone.AMERICA_MONTERREY -> GBFSData.Timezone.AMERICA_MONTERREY;
            case GBFSData.Timezone.AMERICA_MONTEVIDEO -> GBFSData.Timezone.AMERICA_MONTEVIDEO;
            case GBFSData.Timezone.AMERICA_MONTREAL -> GBFSData.Timezone.AMERICA_MONTREAL;
            case GBFSData.Timezone.AMERICA_MONTSERRAT -> GBFSData.Timezone.AMERICA_MONTSERRAT;
            case GBFSData.Timezone.AMERICA_NASSAU -> GBFSData.Timezone.AMERICA_NASSAU;
            case GBFSData.Timezone.AMERICA_NEW_YORK -> GBFSData.Timezone.AMERICA_NEW_YORK;
            case GBFSData.Timezone.AMERICA_NIPIGON -> GBFSData.Timezone.AMERICA_NIPIGON;
            case GBFSData.Timezone.AMERICA_NOME -> GBFSData.Timezone.AMERICA_NOME;
            case GBFSData.Timezone.AMERICA_NORONHA -> GBFSData.Timezone.AMERICA_NORONHA;
            case GBFSData.Timezone.AMERICA_NORTH_DAKOTA_BEULAH -> GBFSData.Timezone.AMERICA_NORTH_DAKOTA_BEULAH;
            case GBFSData.Timezone.AMERICA_NORTH_DAKOTA_CENTER -> GBFSData.Timezone.AMERICA_NORTH_DAKOTA_CENTER;
            case GBFSData.Timezone.AMERICA_NORTH_DAKOTA_NEW_SALEM -> GBFSData.Timezone.AMERICA_NORTH_DAKOTA_NEW_SALEM;
            case GBFSData.Timezone.AMERICA_NUUK -> GBFSData.Timezone.AMERICA_NUUK;
            case GBFSData.Timezone.AMERICA_OJINAGA -> GBFSData.Timezone.AMERICA_OJINAGA;
            case GBFSData.Timezone.AMERICA_PANAMA -> GBFSData.Timezone.AMERICA_PANAMA;
            case GBFSData.Timezone.AMERICA_PANGNIRTUNG -> GBFSData.Timezone.AMERICA_PANGNIRTUNG;
            case GBFSData.Timezone.AMERICA_PARAMARIBO -> GBFSData.Timezone.AMERICA_PARAMARIBO;
            case GBFSData.Timezone.AMERICA_PHOENIX -> GBFSData.Timezone.AMERICA_PHOENIX;
            case GBFSData.Timezone.AMERICA_PORT_AU_PRINCE -> GBFSData.Timezone.AMERICA_PORT_AU_PRINCE;
            case GBFSData.Timezone.AMERICA_PORT_OF_SPAIN -> GBFSData.Timezone.AMERICA_PORT_OF_SPAIN;
            case GBFSData.Timezone.AMERICA_PORTO_ACRE -> GBFSData.Timezone.AMERICA_PORTO_ACRE;
            case GBFSData.Timezone.AMERICA_PORTO_VELHO -> GBFSData.Timezone.AMERICA_PORTO_VELHO;
            case GBFSData.Timezone.AMERICA_PUERTO_RICO -> GBFSData.Timezone.AMERICA_PUERTO_RICO;
            case GBFSData.Timezone.AMERICA_PUNTA_ARENAS -> GBFSData.Timezone.AMERICA_PUNTA_ARENAS;
            case GBFSData.Timezone.AMERICA_RAINY_RIVER -> GBFSData.Timezone.AMERICA_RAINY_RIVER;
            case GBFSData.Timezone.AMERICA_RANKIN_INLET -> GBFSData.Timezone.AMERICA_RANKIN_INLET;
            case GBFSData.Timezone.AMERICA_RECIFE -> GBFSData.Timezone.AMERICA_RECIFE;
            case GBFSData.Timezone.AMERICA_REGINA -> GBFSData.Timezone.AMERICA_REGINA;
            case GBFSData.Timezone.AMERICA_RESOLUTE -> GBFSData.Timezone.AMERICA_RESOLUTE;
            case GBFSData.Timezone.AMERICA_RIO_BRANCO -> GBFSData.Timezone.AMERICA_RIO_BRANCO;
            case GBFSData.Timezone.AMERICA_ROSARIO -> GBFSData.Timezone.AMERICA_ROSARIO;
            case GBFSData.Timezone.AMERICA_SANTA_ISABEL -> GBFSData.Timezone.AMERICA_SANTA_ISABEL;
            case GBFSData.Timezone.AMERICA_SANTAREM -> GBFSData.Timezone.AMERICA_SANTAREM;
            case GBFSData.Timezone.AMERICA_SANTIAGO -> GBFSData.Timezone.AMERICA_SANTIAGO;
            case GBFSData.Timezone.AMERICA_SANTO_DOMINGO -> GBFSData.Timezone.AMERICA_SANTO_DOMINGO;
            case GBFSData.Timezone.AMERICA_SAO_PAULO -> GBFSData.Timezone.AMERICA_SAO_PAULO;
            case GBFSData.Timezone.AMERICA_SCORESBYSUND -> GBFSData.Timezone.AMERICA_SCORESBYSUND;
            case GBFSData.Timezone.AMERICA_SHIPROCK -> GBFSData.Timezone.AMERICA_SHIPROCK;
            case GBFSData.Timezone.AMERICA_SITKA -> GBFSData.Timezone.AMERICA_SITKA;
            case GBFSData.Timezone.AMERICA_ST_BARTHELEMY -> GBFSData.Timezone.AMERICA_ST_BARTHELEMY;
            case GBFSData.Timezone.AMERICA_ST_JOHNS -> GBFSData.Timezone.AMERICA_ST_JOHNS;
            case GBFSData.Timezone.AMERICA_ST_KITTS -> GBFSData.Timezone.AMERICA_ST_KITTS;
            case GBFSData.Timezone.AMERICA_ST_LUCIA -> GBFSData.Timezone.AMERICA_ST_LUCIA;
            case GBFSData.Timezone.AMERICA_ST_THOMAS -> GBFSData.Timezone.AMERICA_ST_THOMAS;
            case GBFSData.Timezone.AMERICA_ST_VINCENT -> GBFSData.Timezone.AMERICA_ST_VINCENT;
            case GBFSData.Timezone.AMERICA_SWIFT_CURRENT -> GBFSData.Timezone.AMERICA_SWIFT_CURRENT;
            case GBFSData.Timezone.AMERICA_TEGUCIGALPA -> GBFSData.Timezone.AMERICA_TEGUCIGALPA;
            case GBFSData.Timezone.AMERICA_THULE -> GBFSData.Timezone.AMERICA_THULE;
            case GBFSData.Timezone.AMERICA_THUNDER_BAY -> GBFSData.Timezone.AMERICA_THUNDER_BAY;
            case GBFSData.Timezone.AMERICA_TIJUANA -> GBFSData.Timezone.AMERICA_TIJUANA;
            case GBFSData.Timezone.AMERICA_TORONTO -> GBFSData.Timezone.AMERICA_TORONTO;
            case GBFSData.Timezone.AMERICA_TORTOLA -> GBFSData.Timezone.AMERICA_TORTOLA;
            case GBFSData.Timezone.AMERICA_VANCOUVER -> GBFSData.Timezone.AMERICA_VANCOUVER;
            case GBFSData.Timezone.AMERICA_VIRGIN -> GBFSData.Timezone.AMERICA_VIRGIN;
            case GBFSData.Timezone.AMERICA_WHITEHORSE -> GBFSData.Timezone.AMERICA_WHITEHORSE;
            case GBFSData.Timezone.AMERICA_WINNIPEG -> GBFSData.Timezone.AMERICA_WINNIPEG;
            case GBFSData.Timezone.AMERICA_YAKUTAT -> GBFSData.Timezone.AMERICA_YAKUTAT;
            case GBFSData.Timezone.AMERICA_YELLOWKNIFE -> GBFSData.Timezone.AMERICA_YELLOWKNIFE;
            case GBFSData.Timezone.ANTARCTICA_CASEY -> GBFSData.Timezone.ANTARCTICA_CASEY;
            case GBFSData.Timezone.ANTARCTICA_DAVIS -> GBFSData.Timezone.ANTARCTICA_DAVIS;
            case GBFSData.Timezone.ANTARCTICA_DUMONT_D_URVILLE -> GBFSData.Timezone.ANTARCTICA_DUMONT_D_URVILLE;
            case GBFSData.Timezone.ANTARCTICA_MACQUARIE -> GBFSData.Timezone.ANTARCTICA_MACQUARIE;
            case GBFSData.Timezone.ANTARCTICA_MAWSON -> GBFSData.Timezone.ANTARCTICA_MAWSON;
            case GBFSData.Timezone.ANTARCTICA_MC_MURDO -> GBFSData.Timezone.ANTARCTICA_MC_MURDO;
            case GBFSData.Timezone.ANTARCTICA_PALMER -> GBFSData.Timezone.ANTARCTICA_PALMER;
            case GBFSData.Timezone.ANTARCTICA_ROTHERA -> GBFSData.Timezone.ANTARCTICA_ROTHERA;
            case GBFSData.Timezone.ANTARCTICA_SOUTH_POLE -> GBFSData.Timezone.ANTARCTICA_SOUTH_POLE;
            case GBFSData.Timezone.ANTARCTICA_SYOWA -> GBFSData.Timezone.ANTARCTICA_SYOWA;
            case GBFSData.Timezone.ANTARCTICA_TROLL -> GBFSData.Timezone.ANTARCTICA_TROLL;
            case GBFSData.Timezone.ANTARCTICA_VOSTOK -> GBFSData.Timezone.ANTARCTICA_VOSTOK;
            case GBFSData.Timezone.ARCTIC_LONGYEARBYEN -> GBFSData.Timezone.ARCTIC_LONGYEARBYEN;
            case GBFSData.Timezone.ASIA_ADEN -> GBFSData.Timezone.ASIA_ADEN;
            case GBFSData.Timezone.ASIA_ALMATY -> GBFSData.Timezone.ASIA_ALMATY;
            case GBFSData.Timezone.ASIA_AMMAN -> GBFSData.Timezone.ASIA_AMMAN;
            case GBFSData.Timezone.ASIA_ANADYR -> GBFSData.Timezone.ASIA_ANADYR;
            case GBFSData.Timezone.ASIA_AQTAU -> GBFSData.Timezone.ASIA_AQTAU;
            case GBFSData.Timezone.ASIA_AQTOBE -> GBFSData.Timezone.ASIA_AQTOBE;
            case GBFSData.Timezone.ASIA_ASHGABAT -> GBFSData.Timezone.ASIA_ASHGABAT;
            case GBFSData.Timezone.ASIA_ASHKHABAD -> GBFSData.Timezone.ASIA_ASHKHABAD;
            case GBFSData.Timezone.ASIA_ATYRAU -> GBFSData.Timezone.ASIA_ATYRAU;
            case GBFSData.Timezone.ASIA_BAGHDAD -> GBFSData.Timezone.ASIA_BAGHDAD;
            case GBFSData.Timezone.ASIA_BAHRAIN -> GBFSData.Timezone.ASIA_BAHRAIN;
            case GBFSData.Timezone.ASIA_BAKU -> GBFSData.Timezone.ASIA_BAKU;
            case GBFSData.Timezone.ASIA_BANGKOK -> GBFSData.Timezone.ASIA_BANGKOK;
            case GBFSData.Timezone.ASIA_BARNAUL -> GBFSData.Timezone.ASIA_BARNAUL;
            case GBFSData.Timezone.ASIA_BEIRUT -> GBFSData.Timezone.ASIA_BEIRUT;
            case GBFSData.Timezone.ASIA_BISHKEK -> GBFSData.Timezone.ASIA_BISHKEK;
            case GBFSData.Timezone.ASIA_BRUNEI -> GBFSData.Timezone.ASIA_BRUNEI;
            case GBFSData.Timezone.ASIA_CALCUTTA -> GBFSData.Timezone.ASIA_CALCUTTA;
            case GBFSData.Timezone.ASIA_CHITA -> GBFSData.Timezone.ASIA_CHITA;
            case GBFSData.Timezone.ASIA_CHOIBALSAN -> GBFSData.Timezone.ASIA_CHOIBALSAN;
            case GBFSData.Timezone.ASIA_CHONGQING -> GBFSData.Timezone.ASIA_CHONGQING;
            case GBFSData.Timezone.ASIA_CHUNGKING -> GBFSData.Timezone.ASIA_CHUNGKING;
            case GBFSData.Timezone.ASIA_COLOMBO -> GBFSData.Timezone.ASIA_COLOMBO;
            case GBFSData.Timezone.ASIA_DACCA -> GBFSData.Timezone.ASIA_DACCA;
            case GBFSData.Timezone.ASIA_DAMASCUS -> GBFSData.Timezone.ASIA_DAMASCUS;
            case GBFSData.Timezone.ASIA_DHAKA -> GBFSData.Timezone.ASIA_DHAKA;
            case GBFSData.Timezone.ASIA_DILI -> GBFSData.Timezone.ASIA_DILI;
            case GBFSData.Timezone.ASIA_DUBAI -> GBFSData.Timezone.ASIA_DUBAI;
            case GBFSData.Timezone.ASIA_DUSHANBE -> GBFSData.Timezone.ASIA_DUSHANBE;
            case GBFSData.Timezone.ASIA_FAMAGUSTA -> GBFSData.Timezone.ASIA_FAMAGUSTA;
            case GBFSData.Timezone.ASIA_GAZA -> GBFSData.Timezone.ASIA_GAZA;
            case GBFSData.Timezone.ASIA_HARBIN -> GBFSData.Timezone.ASIA_HARBIN;
            case GBFSData.Timezone.ASIA_HEBRON -> GBFSData.Timezone.ASIA_HEBRON;
            case GBFSData.Timezone.ASIA_HO_CHI_MINH -> GBFSData.Timezone.ASIA_HO_CHI_MINH;
            case GBFSData.Timezone.ASIA_HONG_KONG -> GBFSData.Timezone.ASIA_HONG_KONG;
            case GBFSData.Timezone.ASIA_HOVD -> GBFSData.Timezone.ASIA_HOVD;
            case GBFSData.Timezone.ASIA_IRKUTSK -> GBFSData.Timezone.ASIA_IRKUTSK;
            case GBFSData.Timezone.ASIA_ISTANBUL -> GBFSData.Timezone.ASIA_ISTANBUL;
            case GBFSData.Timezone.ASIA_JAKARTA -> GBFSData.Timezone.ASIA_JAKARTA;
            case GBFSData.Timezone.ASIA_JAYAPURA -> GBFSData.Timezone.ASIA_JAYAPURA;
            case GBFSData.Timezone.ASIA_JERUSALEM -> GBFSData.Timezone.ASIA_JERUSALEM;
            case GBFSData.Timezone.ASIA_KABUL -> GBFSData.Timezone.ASIA_KABUL;
            case GBFSData.Timezone.ASIA_KAMCHATKA -> GBFSData.Timezone.ASIA_KAMCHATKA;
            case GBFSData.Timezone.ASIA_KARACHI -> GBFSData.Timezone.ASIA_KARACHI;
            case GBFSData.Timezone.ASIA_KASHGAR -> GBFSData.Timezone.ASIA_KASHGAR;
            case GBFSData.Timezone.ASIA_KATHMANDU -> GBFSData.Timezone.ASIA_KATHMANDU;
            case GBFSData.Timezone.ASIA_KATMANDU -> GBFSData.Timezone.ASIA_KATMANDU;
            case GBFSData.Timezone.ASIA_KHANDYGA -> GBFSData.Timezone.ASIA_KHANDYGA;
            case GBFSData.Timezone.ASIA_KOLKATA -> GBFSData.Timezone.ASIA_KOLKATA;
            case GBFSData.Timezone.ASIA_KRASNOYARSK -> GBFSData.Timezone.ASIA_KRASNOYARSK;
            case GBFSData.Timezone.ASIA_KUALA_LUMPUR -> GBFSData.Timezone.ASIA_KUALA_LUMPUR;
            case GBFSData.Timezone.ASIA_KUCHING -> GBFSData.Timezone.ASIA_KUCHING;
            case GBFSData.Timezone.ASIA_KUWAIT -> GBFSData.Timezone.ASIA_KUWAIT;
            case GBFSData.Timezone.ASIA_MACAO -> GBFSData.Timezone.ASIA_MACAO;
            case GBFSData.Timezone.ASIA_MACAU -> GBFSData.Timezone.ASIA_MACAU;
            case GBFSData.Timezone.ASIA_MAGADAN -> GBFSData.Timezone.ASIA_MAGADAN;
            case GBFSData.Timezone.ASIA_MAKASSAR -> GBFSData.Timezone.ASIA_MAKASSAR;
            case GBFSData.Timezone.ASIA_MANILA -> GBFSData.Timezone.ASIA_MANILA;
            case GBFSData.Timezone.ASIA_MUSCAT -> GBFSData.Timezone.ASIA_MUSCAT;
            case GBFSData.Timezone.ASIA_NICOSIA -> GBFSData.Timezone.ASIA_NICOSIA;
            case GBFSData.Timezone.ASIA_NOVOKUZNETSK -> GBFSData.Timezone.ASIA_NOVOKUZNETSK;
            case GBFSData.Timezone.ASIA_NOVOSIBIRSK -> GBFSData.Timezone.ASIA_NOVOSIBIRSK;
            case GBFSData.Timezone.ASIA_OMSK -> GBFSData.Timezone.ASIA_OMSK;
            case GBFSData.Timezone.ASIA_ORAL -> GBFSData.Timezone.ASIA_ORAL;
            case GBFSData.Timezone.ASIA_PHNOM_PENH -> GBFSData.Timezone.ASIA_PHNOM_PENH;
            case GBFSData.Timezone.ASIA_PONTIANAK -> GBFSData.Timezone.ASIA_PONTIANAK;
            case GBFSData.Timezone.ASIA_PYONGYANG -> GBFSData.Timezone.ASIA_PYONGYANG;
            case GBFSData.Timezone.ASIA_QATAR -> GBFSData.Timezone.ASIA_QATAR;
            case GBFSData.Timezone.ASIA_QOSTANAY -> GBFSData.Timezone.ASIA_QOSTANAY;
            case GBFSData.Timezone.ASIA_QYZYLORDA -> GBFSData.Timezone.ASIA_QYZYLORDA;
            case GBFSData.Timezone.ASIA_RANGOON -> GBFSData.Timezone.ASIA_RANGOON;
            case GBFSData.Timezone.ASIA_RIYADH -> GBFSData.Timezone.ASIA_RIYADH;
            case GBFSData.Timezone.ASIA_SAIGON -> GBFSData.Timezone.ASIA_SAIGON;
            case GBFSData.Timezone.ASIA_SAKHALIN -> GBFSData.Timezone.ASIA_SAKHALIN;
            case GBFSData.Timezone.ASIA_SAMARKAND -> GBFSData.Timezone.ASIA_SAMARKAND;
            case GBFSData.Timezone.ASIA_SEOUL -> GBFSData.Timezone.ASIA_SEOUL;
            case GBFSData.Timezone.ASIA_SHANGHAI -> GBFSData.Timezone.ASIA_SHANGHAI;
            case GBFSData.Timezone.ASIA_SINGAPORE -> GBFSData.Timezone.ASIA_SINGAPORE;
            case GBFSData.Timezone.ASIA_SREDNEKOLYMSK -> GBFSData.Timezone.ASIA_SREDNEKOLYMSK;
            case GBFSData.Timezone.ASIA_TAIPEI -> GBFSData.Timezone.ASIA_TAIPEI;
            case GBFSData.Timezone.ASIA_TASHKENT -> GBFSData.Timezone.ASIA_TASHKENT;
            case GBFSData.Timezone.ASIA_TBILISI -> GBFSData.Timezone.ASIA_TBILISI;
            case GBFSData.Timezone.ASIA_TEHRAN -> GBFSData.Timezone.ASIA_TEHRAN;
            case GBFSData.Timezone.ASIA_TEL_AVIV -> GBFSData.Timezone.ASIA_TEL_AVIV;
            case GBFSData.Timezone.ASIA_THIMBU -> GBFSData.Timezone.ASIA_THIMBU;
            case GBFSData.Timezone.ASIA_THIMPHU -> GBFSData.Timezone.ASIA_THIMPHU;
            case GBFSData.Timezone.ASIA_TOKYO -> GBFSData.Timezone.ASIA_TOKYO;
            case GBFSData.Timezone.ASIA_TOMSK -> GBFSData.Timezone.ASIA_TOMSK;
            case GBFSData.Timezone.ASIA_UJUNG_PANDANG -> GBFSData.Timezone.ASIA_UJUNG_PANDANG;
            case GBFSData.Timezone.ASIA_ULAANBAATAR -> GBFSData.Timezone.ASIA_ULAANBAATAR;
            case GBFSData.Timezone.ASIA_ULAN_BATOR -> GBFSData.Timezone.ASIA_ULAN_BATOR;
            case GBFSData.Timezone.ASIA_URUMQI -> GBFSData.Timezone.ASIA_URUMQI;
            case GBFSData.Timezone.ASIA_UST_NERA -> GBFSData.Timezone.ASIA_UST_NERA;
            case GBFSData.Timezone.ASIA_VIENTIANE -> GBFSData.Timezone.ASIA_VIENTIANE;
            case GBFSData.Timezone.ASIA_VLADIVOSTOK -> GBFSData.Timezone.ASIA_VLADIVOSTOK;
            case GBFSData.Timezone.ASIA_YAKUTSK -> GBFSData.Timezone.ASIA_YAKUTSK;
            case GBFSData.Timezone.ASIA_YANGON -> GBFSData.Timezone.ASIA_YANGON;
            case GBFSData.Timezone.ASIA_YEKATERINBURG -> GBFSData.Timezone.ASIA_YEKATERINBURG;
            case GBFSData.Timezone.ASIA_YEREVAN -> GBFSData.Timezone.ASIA_YEREVAN;
            case GBFSData.Timezone.ATLANTIC_AZORES -> GBFSData.Timezone.ATLANTIC_AZORES;
            case GBFSData.Timezone.ATLANTIC_BERMUDA -> GBFSData.Timezone.ATLANTIC_BERMUDA;
            case GBFSData.Timezone.ATLANTIC_CANARY -> GBFSData.Timezone.ATLANTIC_CANARY;
            case GBFSData.Timezone.ATLANTIC_CAPE_VERDE -> GBFSData.Timezone.ATLANTIC_CAPE_VERDE;
            case GBFSData.Timezone.ATLANTIC_FAEROE -> GBFSData.Timezone.ATLANTIC_FAEROE;
            case GBFSData.Timezone.ATLANTIC_FAROE -> GBFSData.Timezone.ATLANTIC_FAROE;
            case GBFSData.Timezone.ATLANTIC_JAN_MAYEN -> GBFSData.Timezone.ATLANTIC_JAN_MAYEN;
            case GBFSData.Timezone.ATLANTIC_MADEIRA -> GBFSData.Timezone.ATLANTIC_MADEIRA;
            case GBFSData.Timezone.ATLANTIC_REYKJAVIK -> GBFSData.Timezone.ATLANTIC_REYKJAVIK;
            case GBFSData.Timezone.ATLANTIC_SOUTH_GEORGIA -> GBFSData.Timezone.ATLANTIC_SOUTH_GEORGIA;
            case GBFSData.Timezone.ATLANTIC_ST_HELENA -> GBFSData.Timezone.ATLANTIC_ST_HELENA;
            case GBFSData.Timezone.ATLANTIC_STANLEY -> GBFSData.Timezone.ATLANTIC_STANLEY;
            case GBFSData.Timezone.AUSTRALIA_ACT -> GBFSData.Timezone.AUSTRALIA_ACT;
            case GBFSData.Timezone.AUSTRALIA_ADELAIDE -> GBFSData.Timezone.AUSTRALIA_ADELAIDE;
            case GBFSData.Timezone.AUSTRALIA_BRISBANE -> GBFSData.Timezone.AUSTRALIA_BRISBANE;
            case GBFSData.Timezone.AUSTRALIA_BROKEN_HILL -> GBFSData.Timezone.AUSTRALIA_BROKEN_HILL;
            case GBFSData.Timezone.AUSTRALIA_CANBERRA -> GBFSData.Timezone.AUSTRALIA_CANBERRA;
            case GBFSData.Timezone.AUSTRALIA_CURRIE -> GBFSData.Timezone.AUSTRALIA_CURRIE;
            case GBFSData.Timezone.AUSTRALIA_DARWIN -> GBFSData.Timezone.AUSTRALIA_DARWIN;
            case GBFSData.Timezone.AUSTRALIA_EUCLA -> GBFSData.Timezone.AUSTRALIA_EUCLA;
            case GBFSData.Timezone.AUSTRALIA_HOBART -> GBFSData.Timezone.AUSTRALIA_HOBART;
            case GBFSData.Timezone.AUSTRALIA_LHI -> GBFSData.Timezone.AUSTRALIA_LHI;
            case GBFSData.Timezone.AUSTRALIA_LINDEMAN -> GBFSData.Timezone.AUSTRALIA_LINDEMAN;
            case GBFSData.Timezone.AUSTRALIA_LORD_HOWE -> GBFSData.Timezone.AUSTRALIA_LORD_HOWE;
            case GBFSData.Timezone.AUSTRALIA_MELBOURNE -> GBFSData.Timezone.AUSTRALIA_MELBOURNE;
            case GBFSData.Timezone.AUSTRALIA_NORTH -> GBFSData.Timezone.AUSTRALIA_NORTH;
            case GBFSData.Timezone.AUSTRALIA_NSW -> GBFSData.Timezone.AUSTRALIA_NSW;
            case GBFSData.Timezone.AUSTRALIA_PERTH -> GBFSData.Timezone.AUSTRALIA_PERTH;
            case GBFSData.Timezone.AUSTRALIA_QUEENSLAND -> GBFSData.Timezone.AUSTRALIA_QUEENSLAND;
            case GBFSData.Timezone.AUSTRALIA_SOUTH -> GBFSData.Timezone.AUSTRALIA_SOUTH;
            case GBFSData.Timezone.AUSTRALIA_SYDNEY -> GBFSData.Timezone.AUSTRALIA_SYDNEY;
            case GBFSData.Timezone.AUSTRALIA_TASMANIA -> GBFSData.Timezone.AUSTRALIA_TASMANIA;
            case GBFSData.Timezone.AUSTRALIA_VICTORIA -> GBFSData.Timezone.AUSTRALIA_VICTORIA;
            case GBFSData.Timezone.AUSTRALIA_WEST -> GBFSData.Timezone.AUSTRALIA_WEST;
            case GBFSData.Timezone.AUSTRALIA_YANCOWINNA -> GBFSData.Timezone.AUSTRALIA_YANCOWINNA;
            case GBFSData.Timezone.BRAZIL_ACRE -> GBFSData.Timezone.BRAZIL_ACRE;
            case GBFSData.Timezone.BRAZIL_DE_NORONHA -> GBFSData.Timezone.BRAZIL_DE_NORONHA;
            case GBFSData.Timezone.BRAZIL_EAST -> GBFSData.Timezone.BRAZIL_EAST;
            case GBFSData.Timezone.BRAZIL_WEST -> GBFSData.Timezone.BRAZIL_WEST;
            case GBFSData.Timezone.CANADA_ATLANTIC -> GBFSData.Timezone.CANADA_ATLANTIC;
            case GBFSData.Timezone.CANADA_CENTRAL -> GBFSData.Timezone.CANADA_CENTRAL;
            case GBFSData.Timezone.CANADA_EASTERN -> GBFSData.Timezone.CANADA_EASTERN;
            case GBFSData.Timezone.CANADA_MOUNTAIN -> GBFSData.Timezone.CANADA_MOUNTAIN;
            case GBFSData.Timezone.CANADA_NEWFOUNDLAND -> GBFSData.Timezone.CANADA_NEWFOUNDLAND;
            case GBFSData.Timezone.CANADA_PACIFIC -> GBFSData.Timezone.CANADA_PACIFIC;
            case GBFSData.Timezone.CANADA_SASKATCHEWAN -> GBFSData.Timezone.CANADA_SASKATCHEWAN;
            case GBFSData.Timezone.CANADA_YUKON -> GBFSData.Timezone.CANADA_YUKON;
            case GBFSData.Timezone.CET -> GBFSData.Timezone.CET;
            case GBFSData.Timezone.CHILE_CONTINENTAL -> GBFSData.Timezone.CHILE_CONTINENTAL;
            case GBFSData.Timezone.CHILE_EASTER_ISLAND -> GBFSData.Timezone.CHILE_EASTER_ISLAND;
            case GBFSData.Timezone.CST_6_CDT -> GBFSData.Timezone.CST_6_CDT;
            case GBFSData.Timezone.CUBA -> GBFSData.Timezone.CUBA;
            case GBFSData.Timezone.EET -> GBFSData.Timezone.EET;
            case GBFSData.Timezone.EGYPT -> GBFSData.Timezone.EGYPT;
            case GBFSData.Timezone.EIRE -> GBFSData.Timezone.EIRE;
            case GBFSData.Timezone.EST -> GBFSData.Timezone.EST;
            case GBFSData.Timezone.EST_5_EDT -> GBFSData.Timezone.EST_5_EDT;
            case GBFSData.Timezone.ETC_GMT -> GBFSData.Timezone.ETC_GMT;
            case GBFSData.Timezone.ETC_GMT_0 -> GBFSData.Timezone.ETC_GMT_0;
            case GBFSData.Timezone.ETC_GMT_1 -> GBFSData.Timezone.ETC_GMT_1;
            case GBFSData.Timezone.ETC_GMT_10 -> GBFSData.Timezone.ETC_GMT_10;
            case GBFSData.Timezone.ETC_GMT_11 -> GBFSData.Timezone.ETC_GMT_11;
            case GBFSData.Timezone.ETC_GMT_12 -> GBFSData.Timezone.ETC_GMT_12;
            case GBFSData.Timezone.ETC_GMT_2 -> GBFSData.Timezone.ETC_GMT_2;
            case GBFSData.Timezone.ETC_GMT_3 -> GBFSData.Timezone.ETC_GMT_3;
            case GBFSData.Timezone.ETC_GMT_4 -> GBFSData.Timezone.ETC_GMT_4;
            case GBFSData.Timezone.ETC_GMT_5 -> GBFSData.Timezone.ETC_GMT_5;
            case GBFSData.Timezone.ETC_GMT_6 -> GBFSData.Timezone.ETC_GMT_6;
            case GBFSData.Timezone.ETC_GMT_7 -> GBFSData.Timezone.ETC_GMT_7;
            case GBFSData.Timezone.ETC_GMT_8 -> GBFSData.Timezone.ETC_GMT_8;
            case GBFSData.Timezone.ETC_GMT_9 -> GBFSData.Timezone.ETC_GMT_9;
            case GBFSData.Timezone.ETC_GMT_0_ -> GBFSData.Timezone.ETC_GMT_0_;
            case GBFSData.Timezone.ETC_GMT_1_ -> GBFSData.Timezone.ETC_GMT_1_;
            case GBFSData.Timezone.ETC_GMT_10_ -> GBFSData.Timezone.ETC_GMT_10_;
            case GBFSData.Timezone.ETC_GMT_11_ -> GBFSData.Timezone.ETC_GMT_11_;
            case GBFSData.Timezone.ETC_GMT_12_ -> GBFSData.Timezone.ETC_GMT_12_;
            case GBFSData.Timezone.ETC_GMT_13 -> GBFSData.Timezone.ETC_GMT_13;
            case GBFSData.Timezone.ETC_GMT_14 -> GBFSData.Timezone.ETC_GMT_14;
            case GBFSData.Timezone.ETC_GMT_2_ -> GBFSData.Timezone.ETC_GMT_2_;
            case GBFSData.Timezone.ETC_GMT_3_ -> GBFSData.Timezone.ETC_GMT_3_;
            case GBFSData.Timezone.ETC_GMT_4_ -> GBFSData.Timezone.ETC_GMT_4_;
            case GBFSData.Timezone.ETC_GMT_5_ -> GBFSData.Timezone.ETC_GMT_5_;
            case GBFSData.Timezone.ETC_GMT_6_ -> GBFSData.Timezone.ETC_GMT_6_;
            case GBFSData.Timezone.ETC_GMT_7_ -> GBFSData.Timezone.ETC_GMT_7_;
            case GBFSData.Timezone.ETC_GMT_8_ -> GBFSData.Timezone.ETC_GMT_8_;
            case GBFSData.Timezone.ETC_GMT_9_ -> GBFSData.Timezone.ETC_GMT_9_;
            case GBFSData.Timezone.ETC_GMT_0__ -> GBFSData.Timezone.ETC_GMT_0__;
            case GBFSData.Timezone.ETC_GREENWICH -> GBFSData.Timezone.ETC_GREENWICH;
            case GBFSData.Timezone.ETC_UCT -> GBFSData.Timezone.ETC_UCT;
            case GBFSData.Timezone.ETC_UNIVERSAL -> GBFSData.Timezone.ETC_UNIVERSAL;
            case GBFSData.Timezone.ETC_UTC -> GBFSData.Timezone.ETC_UTC;
            case GBFSData.Timezone.ETC_ZULU -> GBFSData.Timezone.ETC_ZULU;
            case GBFSData.Timezone.EUROPE_AMSTERDAM -> GBFSData.Timezone.EUROPE_AMSTERDAM;
            case GBFSData.Timezone.EUROPE_ANDORRA -> GBFSData.Timezone.EUROPE_ANDORRA;
            case GBFSData.Timezone.EUROPE_ASTRAKHAN -> GBFSData.Timezone.EUROPE_ASTRAKHAN;
            case GBFSData.Timezone.EUROPE_ATHENS -> GBFSData.Timezone.EUROPE_ATHENS;
            case GBFSData.Timezone.EUROPE_BELFAST -> GBFSData.Timezone.EUROPE_BELFAST;
            case GBFSData.Timezone.EUROPE_BELGRADE -> GBFSData.Timezone.EUROPE_BELGRADE;
            case GBFSData.Timezone.EUROPE_BERLIN -> GBFSData.Timezone.EUROPE_BERLIN;
            case GBFSData.Timezone.EUROPE_BRATISLAVA -> GBFSData.Timezone.EUROPE_BRATISLAVA;
            case GBFSData.Timezone.EUROPE_BRUSSELS -> GBFSData.Timezone.EUROPE_BRUSSELS;
            case GBFSData.Timezone.EUROPE_BUCHAREST -> GBFSData.Timezone.EUROPE_BUCHAREST;
            case GBFSData.Timezone.EUROPE_BUDAPEST -> GBFSData.Timezone.EUROPE_BUDAPEST;
            case GBFSData.Timezone.EUROPE_BUSINGEN -> GBFSData.Timezone.EUROPE_BUSINGEN;
            case GBFSData.Timezone.EUROPE_CHISINAU -> GBFSData.Timezone.EUROPE_CHISINAU;
            case GBFSData.Timezone.EUROPE_COPENHAGEN -> GBFSData.Timezone.EUROPE_COPENHAGEN;
            case GBFSData.Timezone.EUROPE_DUBLIN -> GBFSData.Timezone.EUROPE_DUBLIN;
            case GBFSData.Timezone.EUROPE_GIBRALTAR -> GBFSData.Timezone.EUROPE_GIBRALTAR;
            case GBFSData.Timezone.EUROPE_GUERNSEY -> GBFSData.Timezone.EUROPE_GUERNSEY;
            case GBFSData.Timezone.EUROPE_HELSINKI -> GBFSData.Timezone.EUROPE_HELSINKI;
            case GBFSData.Timezone.EUROPE_ISLE_OF_MAN -> GBFSData.Timezone.EUROPE_ISLE_OF_MAN;
            case GBFSData.Timezone.EUROPE_ISTANBUL -> GBFSData.Timezone.EUROPE_ISTANBUL;
            case GBFSData.Timezone.EUROPE_JERSEY -> GBFSData.Timezone.EUROPE_JERSEY;
            case GBFSData.Timezone.EUROPE_KALININGRAD -> GBFSData.Timezone.EUROPE_KALININGRAD;
            case GBFSData.Timezone.EUROPE_KIEV -> GBFSData.Timezone.EUROPE_KIEV;
            case GBFSData.Timezone.EUROPE_KIROV -> GBFSData.Timezone.EUROPE_KIROV;
            case GBFSData.Timezone.EUROPE_KYIV -> GBFSData.Timezone.EUROPE_KYIV;
            case GBFSData.Timezone.EUROPE_LISBON -> GBFSData.Timezone.EUROPE_LISBON;
            case GBFSData.Timezone.EUROPE_LJUBLJANA -> GBFSData.Timezone.EUROPE_LJUBLJANA;
            case GBFSData.Timezone.EUROPE_LONDON -> GBFSData.Timezone.EUROPE_LONDON;
            case GBFSData.Timezone.EUROPE_LUXEMBOURG -> GBFSData.Timezone.EUROPE_LUXEMBOURG;
            case GBFSData.Timezone.EUROPE_MADRID -> GBFSData.Timezone.EUROPE_MADRID;
            case GBFSData.Timezone.EUROPE_MALTA -> GBFSData.Timezone.EUROPE_MALTA;
            case GBFSData.Timezone.EUROPE_MARIEHAMN -> GBFSData.Timezone.EUROPE_MARIEHAMN;
            case GBFSData.Timezone.EUROPE_MINSK -> GBFSData.Timezone.EUROPE_MINSK;
            case GBFSData.Timezone.EUROPE_MONACO -> GBFSData.Timezone.EUROPE_MONACO;
            case GBFSData.Timezone.EUROPE_MOSCOW -> GBFSData.Timezone.EUROPE_MOSCOW;
            case GBFSData.Timezone.EUROPE_NICOSIA -> GBFSData.Timezone.EUROPE_NICOSIA;
            case GBFSData.Timezone.EUROPE_OSLO -> GBFSData.Timezone.EUROPE_OSLO;
            case GBFSData.Timezone.EUROPE_PARIS -> GBFSData.Timezone.EUROPE_PARIS;
            case GBFSData.Timezone.EUROPE_PODGORICA -> GBFSData.Timezone.EUROPE_PODGORICA;
            case GBFSData.Timezone.EUROPE_PRAGUE -> GBFSData.Timezone.EUROPE_PRAGUE;
            case GBFSData.Timezone.EUROPE_RIGA -> GBFSData.Timezone.EUROPE_RIGA;
            case GBFSData.Timezone.EUROPE_ROME -> GBFSData.Timezone.EUROPE_ROME;
            case GBFSData.Timezone.EUROPE_SAMARA -> GBFSData.Timezone.EUROPE_SAMARA;
            case GBFSData.Timezone.EUROPE_SAN_MARINO -> GBFSData.Timezone.EUROPE_SAN_MARINO;
            case GBFSData.Timezone.EUROPE_SARAJEVO -> GBFSData.Timezone.EUROPE_SARAJEVO;
            case GBFSData.Timezone.EUROPE_SARATOV -> GBFSData.Timezone.EUROPE_SARATOV;
            case GBFSData.Timezone.EUROPE_SIMFEROPOL -> GBFSData.Timezone.EUROPE_SIMFEROPOL;
            case GBFSData.Timezone.EUROPE_SKOPJE -> GBFSData.Timezone.EUROPE_SKOPJE;
            case GBFSData.Timezone.EUROPE_SOFIA -> GBFSData.Timezone.EUROPE_SOFIA;
            case GBFSData.Timezone.EUROPE_STOCKHOLM -> GBFSData.Timezone.EUROPE_STOCKHOLM;
            case GBFSData.Timezone.EUROPE_TALLINN -> GBFSData.Timezone.EUROPE_TALLINN;
            case GBFSData.Timezone.EUROPE_TIRANE -> GBFSData.Timezone.EUROPE_TIRANE;
            case GBFSData.Timezone.EUROPE_TIRASPOL -> GBFSData.Timezone.EUROPE_TIRASPOL;
            case GBFSData.Timezone.EUROPE_ULYANOVSK -> GBFSData.Timezone.EUROPE_ULYANOVSK;
            case GBFSData.Timezone.EUROPE_UZHGOROD -> GBFSData.Timezone.EUROPE_UZHGOROD;
            case GBFSData.Timezone.EUROPE_VADUZ -> GBFSData.Timezone.EUROPE_VADUZ;
            case GBFSData.Timezone.EUROPE_VATICAN -> GBFSData.Timezone.EUROPE_VATICAN;
            case GBFSData.Timezone.EUROPE_VIENNA -> GBFSData.Timezone.EUROPE_VIENNA;
            case GBFSData.Timezone.EUROPE_VILNIUS -> GBFSData.Timezone.EUROPE_VILNIUS;
            case GBFSData.Timezone.EUROPE_VOLGOGRAD -> GBFSData.Timezone.EUROPE_VOLGOGRAD;
            case GBFSData.Timezone.EUROPE_WARSAW -> GBFSData.Timezone.EUROPE_WARSAW;
            case GBFSData.Timezone.EUROPE_ZAGREB -> GBFSData.Timezone.EUROPE_ZAGREB;
            case GBFSData.Timezone.EUROPE_ZAPOROZHYE -> GBFSData.Timezone.EUROPE_ZAPOROZHYE;
            case GBFSData.Timezone.EUROPE_ZURICH -> GBFSData.Timezone.EUROPE_ZURICH;
            case GBFSData.Timezone.FACTORY -> GBFSData.Timezone.FACTORY;
            case GBFSData.Timezone.GB -> GBFSData.Timezone.GB;
            case GBFSData.Timezone.GB_EIRE -> GBFSData.Timezone.GB_EIRE;
            case GBFSData.Timezone.GMT -> GBFSData.Timezone.GMT;
            case GBFSData.Timezone.GMT_0 -> GBFSData.Timezone.GMT_0;
            case GBFSData.Timezone.GMT_0_ -> GBFSData.Timezone.GMT_0_;
            case GBFSData.Timezone.GMT_0__ -> GBFSData.Timezone.GMT_0__;
            case GBFSData.Timezone.GREENWICH -> GBFSData.Timezone.GREENWICH;
            case GBFSData.Timezone.HONGKONG -> GBFSData.Timezone.HONGKONG;
            case GBFSData.Timezone.HST -> GBFSData.Timezone.HST;
            case GBFSData.Timezone.ICELAND -> GBFSData.Timezone.ICELAND;
            case GBFSData.Timezone.INDIAN_ANTANANARIVO -> GBFSData.Timezone.INDIAN_ANTANANARIVO;
            case GBFSData.Timezone.INDIAN_CHAGOS -> GBFSData.Timezone.INDIAN_CHAGOS;
            case GBFSData.Timezone.INDIAN_CHRISTMAS -> GBFSData.Timezone.INDIAN_CHRISTMAS;
            case GBFSData.Timezone.INDIAN_COCOS -> GBFSData.Timezone.INDIAN_COCOS;
            case GBFSData.Timezone.INDIAN_COMORO -> GBFSData.Timezone.INDIAN_COMORO;
            case GBFSData.Timezone.INDIAN_KERGUELEN -> GBFSData.Timezone.INDIAN_KERGUELEN;
            case GBFSData.Timezone.INDIAN_MAHE -> GBFSData.Timezone.INDIAN_MAHE;
            case GBFSData.Timezone.INDIAN_MALDIVES -> GBFSData.Timezone.INDIAN_MALDIVES;
            case GBFSData.Timezone.INDIAN_MAURITIUS -> GBFSData.Timezone.INDIAN_MAURITIUS;
            case GBFSData.Timezone.INDIAN_MAYOTTE -> GBFSData.Timezone.INDIAN_MAYOTTE;
            case GBFSData.Timezone.INDIAN_REUNION -> GBFSData.Timezone.INDIAN_REUNION;
            case GBFSData.Timezone.IRAN -> GBFSData.Timezone.IRAN;
            case GBFSData.Timezone.ISRAEL -> GBFSData.Timezone.ISRAEL;
            case GBFSData.Timezone.JAMAICA -> GBFSData.Timezone.JAMAICA;
            case GBFSData.Timezone.JAPAN -> GBFSData.Timezone.JAPAN;
            case GBFSData.Timezone.KWAJALEIN -> GBFSData.Timezone.KWAJALEIN;
            case GBFSData.Timezone.LIBYA -> GBFSData.Timezone.LIBYA;
            case GBFSData.Timezone.MET -> GBFSData.Timezone.MET;
            case GBFSData.Timezone.MEXICO_BAJA_NORTE -> GBFSData.Timezone.MEXICO_BAJA_NORTE;
            case GBFSData.Timezone.MEXICO_BAJA_SUR -> GBFSData.Timezone.MEXICO_BAJA_SUR;
            case GBFSData.Timezone.MEXICO_GENERAL -> GBFSData.Timezone.MEXICO_GENERAL;
            case GBFSData.Timezone.MST -> GBFSData.Timezone.MST;
            case GBFSData.Timezone.MST_7_MDT -> GBFSData.Timezone.MST_7_MDT;
            case GBFSData.Timezone.NAVAJO -> GBFSData.Timezone.NAVAJO;
            case GBFSData.Timezone.NZ -> GBFSData.Timezone.NZ;
            case GBFSData.Timezone.NZ_CHAT -> GBFSData.Timezone.NZ_CHAT;
            case GBFSData.Timezone.PACIFIC_APIA -> GBFSData.Timezone.PACIFIC_APIA;
            case GBFSData.Timezone.PACIFIC_AUCKLAND -> GBFSData.Timezone.PACIFIC_AUCKLAND;
            case GBFSData.Timezone.PACIFIC_BOUGAINVILLE -> GBFSData.Timezone.PACIFIC_BOUGAINVILLE;
            case GBFSData.Timezone.PACIFIC_CHATHAM -> GBFSData.Timezone.PACIFIC_CHATHAM;
            case GBFSData.Timezone.PACIFIC_CHUUK -> GBFSData.Timezone.PACIFIC_CHUUK;
            case GBFSData.Timezone.PACIFIC_EASTER -> GBFSData.Timezone.PACIFIC_EASTER;
            case GBFSData.Timezone.PACIFIC_EFATE -> GBFSData.Timezone.PACIFIC_EFATE;
            case GBFSData.Timezone.PACIFIC_ENDERBURY -> GBFSData.Timezone.PACIFIC_ENDERBURY;
            case GBFSData.Timezone.PACIFIC_FAKAOFO -> GBFSData.Timezone.PACIFIC_FAKAOFO;
            case GBFSData.Timezone.PACIFIC_FIJI -> GBFSData.Timezone.PACIFIC_FIJI;
            case GBFSData.Timezone.PACIFIC_FUNAFUTI -> GBFSData.Timezone.PACIFIC_FUNAFUTI;
            case GBFSData.Timezone.PACIFIC_GALAPAGOS -> GBFSData.Timezone.PACIFIC_GALAPAGOS;
            case GBFSData.Timezone.PACIFIC_GAMBIER -> GBFSData.Timezone.PACIFIC_GAMBIER;
            case GBFSData.Timezone.PACIFIC_GUADALCANAL -> GBFSData.Timezone.PACIFIC_GUADALCANAL;
            case GBFSData.Timezone.PACIFIC_GUAM -> GBFSData.Timezone.PACIFIC_GUAM;
            case GBFSData.Timezone.PACIFIC_HONOLULU -> GBFSData.Timezone.PACIFIC_HONOLULU;
            case GBFSData.Timezone.PACIFIC_JOHNSTON -> GBFSData.Timezone.PACIFIC_JOHNSTON;
            case GBFSData.Timezone.PACIFIC_KANTON -> GBFSData.Timezone.PACIFIC_KANTON;
            case GBFSData.Timezone.PACIFIC_KIRITIMATI -> GBFSData.Timezone.PACIFIC_KIRITIMATI;
            case GBFSData.Timezone.PACIFIC_KOSRAE -> GBFSData.Timezone.PACIFIC_KOSRAE;
            case GBFSData.Timezone.PACIFIC_KWAJALEIN -> GBFSData.Timezone.PACIFIC_KWAJALEIN;
            case GBFSData.Timezone.PACIFIC_MAJURO -> GBFSData.Timezone.PACIFIC_MAJURO;
            case GBFSData.Timezone.PACIFIC_MARQUESAS -> GBFSData.Timezone.PACIFIC_MARQUESAS;
            case GBFSData.Timezone.PACIFIC_MIDWAY -> GBFSData.Timezone.PACIFIC_MIDWAY;
            case GBFSData.Timezone.PACIFIC_NAURU -> GBFSData.Timezone.PACIFIC_NAURU;
            case GBFSData.Timezone.PACIFIC_NIUE -> GBFSData.Timezone.PACIFIC_NIUE;
            case GBFSData.Timezone.PACIFIC_NORFOLK -> GBFSData.Timezone.PACIFIC_NORFOLK;
            case GBFSData.Timezone.PACIFIC_NOUMEA -> GBFSData.Timezone.PACIFIC_NOUMEA;
            case GBFSData.Timezone.PACIFIC_PAGO_PAGO -> GBFSData.Timezone.PACIFIC_PAGO_PAGO;
            case GBFSData.Timezone.PACIFIC_PALAU -> GBFSData.Timezone.PACIFIC_PALAU;
            case GBFSData.Timezone.PACIFIC_PITCAIRN -> GBFSData.Timezone.PACIFIC_PITCAIRN;
            case GBFSData.Timezone.PACIFIC_POHNPEI -> GBFSData.Timezone.PACIFIC_POHNPEI;
            case GBFSData.Timezone.PACIFIC_PONAPE -> GBFSData.Timezone.PACIFIC_PONAPE;
            case GBFSData.Timezone.PACIFIC_PORT_MORESBY -> GBFSData.Timezone.PACIFIC_PORT_MORESBY;
            case GBFSData.Timezone.PACIFIC_RAROTONGA -> GBFSData.Timezone.PACIFIC_RAROTONGA;
            case GBFSData.Timezone.PACIFIC_SAIPAN -> GBFSData.Timezone.PACIFIC_SAIPAN;
            case GBFSData.Timezone.PACIFIC_SAMOA -> GBFSData.Timezone.PACIFIC_SAMOA;
            case GBFSData.Timezone.PACIFIC_TAHITI -> GBFSData.Timezone.PACIFIC_TAHITI;
            case GBFSData.Timezone.PACIFIC_TARAWA -> GBFSData.Timezone.PACIFIC_TARAWA;
            case GBFSData.Timezone.PACIFIC_TONGATAPU -> GBFSData.Timezone.PACIFIC_TONGATAPU;
            case GBFSData.Timezone.PACIFIC_TRUK -> GBFSData.Timezone.PACIFIC_TRUK;
            case GBFSData.Timezone.PACIFIC_WAKE -> GBFSData.Timezone.PACIFIC_WAKE;
            case GBFSData.Timezone.PACIFIC_WALLIS -> GBFSData.Timezone.PACIFIC_WALLIS;
            case GBFSData.Timezone.PACIFIC_YAP -> GBFSData.Timezone.PACIFIC_YAP;
            case GBFSData.Timezone.POLAND -> GBFSData.Timezone.POLAND;
            case GBFSData.Timezone.PORTUGAL -> GBFSData.Timezone.PORTUGAL;
            case GBFSData.Timezone.PRC -> GBFSData.Timezone.PRC;
            case GBFSData.Timezone.PST_8_PDT -> GBFSData.Timezone.PST_8_PDT;
            case GBFSData.Timezone.ROC -> GBFSData.Timezone.ROC;
            case GBFSData.Timezone.ROK -> GBFSData.Timezone.ROK;
            case GBFSData.Timezone.SINGAPORE -> GBFSData.Timezone.SINGAPORE;
            case GBFSData.Timezone.TURKEY -> GBFSData.Timezone.TURKEY;
            case GBFSData.Timezone.UCT -> GBFSData.Timezone.UCT;
            case GBFSData.Timezone.UNIVERSAL -> GBFSData.Timezone.UNIVERSAL;
            case GBFSData.Timezone.US_ALASKA -> GBFSData.Timezone.US_ALASKA;
            case GBFSData.Timezone.US_ALEUTIAN -> GBFSData.Timezone.US_ALEUTIAN;
            case GBFSData.Timezone.US_ARIZONA -> GBFSData.Timezone.US_ARIZONA;
            case GBFSData.Timezone.US_CENTRAL -> GBFSData.Timezone.US_CENTRAL;
            case GBFSData.Timezone.US_EAST_INDIANA -> GBFSData.Timezone.US_EAST_INDIANA;
            case GBFSData.Timezone.US_EASTERN -> GBFSData.Timezone.US_EASTERN;
            case GBFSData.Timezone.US_HAWAII -> GBFSData.Timezone.US_HAWAII;
            case GBFSData.Timezone.US_INDIANA_STARKE -> GBFSData.Timezone.US_INDIANA_STARKE;
            case GBFSData.Timezone.US_MICHIGAN -> GBFSData.Timezone.US_MICHIGAN;
            case GBFSData.Timezone.US_MOUNTAIN -> GBFSData.Timezone.US_MOUNTAIN;
            case GBFSData.Timezone.US_PACIFIC -> GBFSData.Timezone.US_PACIFIC;
            case GBFSData.Timezone.US_SAMOA -> GBFSData.Timezone.US_SAMOA;
            case GBFSData.Timezone.UTC -> GBFSData.Timezone.UTC;
            case GBFSData.Timezone.W_SU -> GBFSData.Timezone.W_SU;
            case GBFSData.Timezone.WET -> GBFSData.Timezone.WET;
            case GBFSData.Timezone.ZULU -> GBFSData.Timezone.ZULU;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + timezone);
        };
    }

    protected org.mobilitydata.gbfs.v3_0.system_information.GBFSBrandAssets gBFSBrandAssetsToGBFSBrandAssets(GBFSBrandAssets gBFSBrandAssets, String language) {
        Map map;
        if (gBFSBrandAssets == null) {
            return null;
        }
        org.mobilitydata.gbfs.v3_0.system_information.GBFSBrandAssets gBFSBrandAssets1 = new org.mobilitydata.gbfs.v3_0.system_information.GBFSBrandAssets();
        gBFSBrandAssets1.setBrandLastModified(gBFSBrandAssets.getBrandLastModified());
        gBFSBrandAssets1.setBrandTermsUrl(gBFSBrandAssets.getBrandTermsUrl());
        gBFSBrandAssets1.setBrandImageUrl(gBFSBrandAssets.getBrandImageUrl());
        gBFSBrandAssets1.setBrandImageUrlDark(gBFSBrandAssets.getBrandImageUrlDark());
        gBFSBrandAssets1.setColor(gBFSBrandAssets.getColor());
        if (gBFSBrandAssets1.getAdditionalProperties() != null && (map = gBFSBrandAssets.getAdditionalProperties()) != null) {
            gBFSBrandAssets1.getAdditionalProperties().putAll(map);
        }
        return gBFSBrandAssets1;
    }

    protected GBFSAndroid gBFSAndroidToGBFSAndroid(org.mobilitydata.gbfs.v2_3.system_information.GBFSAndroid gBFSAndroid, String language) {
        Map map;
        if (gBFSAndroid == null) {
            return null;
        }
        GBFSAndroid gBFSAndroid1 = new GBFSAndroid();
        gBFSAndroid1.setStoreUri(gBFSAndroid.getStoreUri());
        gBFSAndroid1.setDiscoveryUri(gBFSAndroid.getDiscoveryUri());
        if (gBFSAndroid1.getAdditionalProperties() != null && (map = gBFSAndroid.getAdditionalProperties()) != null) {
            gBFSAndroid1.getAdditionalProperties().putAll(map);
        }
        return gBFSAndroid1;
    }

    protected GBFSIos gBFSIosToGBFSIos(org.mobilitydata.gbfs.v2_3.system_information.GBFSIos gBFSIos, String language) {
        Map map;
        if (gBFSIos == null) {
            return null;
        }
        GBFSIos gBFSIos1 = new GBFSIos();
        gBFSIos1.setStoreUri(gBFSIos.getStoreUri());
        gBFSIos1.setDiscoveryUri(gBFSIos.getDiscoveryUri());
        if (gBFSIos1.getAdditionalProperties() != null && (map = gBFSIos.getAdditionalProperties()) != null) {
            gBFSIos1.getAdditionalProperties().putAll(map);
        }
        return gBFSIos1;
    }

    protected org.mobilitydata.gbfs.v3_0.system_information.GBFSRentalApps gBFSRentalAppsToGBFSRentalApps(GBFSRentalApps gBFSRentalApps, String language) {
        Map map;
        if (gBFSRentalApps == null) {
            return null;
        }
        org.mobilitydata.gbfs.v3_0.system_information.GBFSRentalApps gBFSRentalApps1 = new org.mobilitydata.gbfs.v3_0.system_information.GBFSRentalApps();
        gBFSRentalApps1.setAndroid(this.gBFSAndroidToGBFSAndroid(gBFSRentalApps.getAndroid(), language));
        gBFSRentalApps1.setIos(this.gBFSIosToGBFSIos(gBFSRentalApps.getIos(), language));
        if (gBFSRentalApps1.getAdditionalProperties() != null && (map = gBFSRentalApps.getAdditionalProperties()) != null) {
            gBFSRentalApps1.getAdditionalProperties().putAll(map);
        }
        return gBFSRentalApps1;
    }

    protected GBFSData.Timezone timezoneToTimezone1(GBFSData.Timezone timezone, String language) {
        if (timezone == null) {
            return null;
        }
        return switch (timezone) {
            case GBFSData.Timezone.AFRICA_ABIDJAN -> GBFSData.Timezone.AFRICA_ABIDJAN;
            case GBFSData.Timezone.AFRICA_ACCRA -> GBFSData.Timezone.AFRICA_ACCRA;
            case GBFSData.Timezone.AFRICA_ADDIS_ABABA -> GBFSData.Timezone.AFRICA_ADDIS_ABABA;
            case GBFSData.Timezone.AFRICA_ALGIERS -> GBFSData.Timezone.AFRICA_ALGIERS;
            case GBFSData.Timezone.AFRICA_ASMARA -> GBFSData.Timezone.AFRICA_ASMARA;
            case GBFSData.Timezone.AFRICA_ASMERA -> GBFSData.Timezone.AFRICA_ASMERA;
            case GBFSData.Timezone.AFRICA_BAMAKO -> GBFSData.Timezone.AFRICA_BAMAKO;
            case GBFSData.Timezone.AFRICA_BANGUI -> GBFSData.Timezone.AFRICA_BANGUI;
            case GBFSData.Timezone.AFRICA_BANJUL -> GBFSData.Timezone.AFRICA_BANJUL;
            case GBFSData.Timezone.AFRICA_BISSAU -> GBFSData.Timezone.AFRICA_BISSAU;
            case GBFSData.Timezone.AFRICA_BLANTYRE -> GBFSData.Timezone.AFRICA_BLANTYRE;
            case GBFSData.Timezone.AFRICA_BRAZZAVILLE -> GBFSData.Timezone.AFRICA_BRAZZAVILLE;
            case GBFSData.Timezone.AFRICA_BUJUMBURA -> GBFSData.Timezone.AFRICA_BUJUMBURA;
            case GBFSData.Timezone.AFRICA_CAIRO -> GBFSData.Timezone.AFRICA_CAIRO;
            case GBFSData.Timezone.AFRICA_CASABLANCA -> GBFSData.Timezone.AFRICA_CASABLANCA;
            case GBFSData.Timezone.AFRICA_CEUTA -> GBFSData.Timezone.AFRICA_CEUTA;
            case GBFSData.Timezone.AFRICA_CONAKRY -> GBFSData.Timezone.AFRICA_CONAKRY;
            case GBFSData.Timezone.AFRICA_DAKAR -> GBFSData.Timezone.AFRICA_DAKAR;
            case GBFSData.Timezone.AFRICA_DAR_ES_SALAAM -> GBFSData.Timezone.AFRICA_DAR_ES_SALAAM;
            case GBFSData.Timezone.AFRICA_DJIBOUTI -> GBFSData.Timezone.AFRICA_DJIBOUTI;
            case GBFSData.Timezone.AFRICA_DOUALA -> GBFSData.Timezone.AFRICA_DOUALA;
            case GBFSData.Timezone.AFRICA_EL_AAIUN -> GBFSData.Timezone.AFRICA_EL_AAIUN;
            case GBFSData.Timezone.AFRICA_FREETOWN -> GBFSData.Timezone.AFRICA_FREETOWN;
            case GBFSData.Timezone.AFRICA_GABORONE -> GBFSData.Timezone.AFRICA_GABORONE;
            case GBFSData.Timezone.AFRICA_HARARE -> GBFSData.Timezone.AFRICA_HARARE;
            case GBFSData.Timezone.AFRICA_JOHANNESBURG -> GBFSData.Timezone.AFRICA_JOHANNESBURG;
            case GBFSData.Timezone.AFRICA_JUBA -> GBFSData.Timezone.AFRICA_JUBA;
            case GBFSData.Timezone.AFRICA_KAMPALA -> GBFSData.Timezone.AFRICA_KAMPALA;
            case GBFSData.Timezone.AFRICA_KHARTOUM -> GBFSData.Timezone.AFRICA_KHARTOUM;
            case GBFSData.Timezone.AFRICA_KIGALI -> GBFSData.Timezone.AFRICA_KIGALI;
            case GBFSData.Timezone.AFRICA_KINSHASA -> GBFSData.Timezone.AFRICA_KINSHASA;
            case GBFSData.Timezone.AFRICA_LAGOS -> GBFSData.Timezone.AFRICA_LAGOS;
            case GBFSData.Timezone.AFRICA_LIBREVILLE -> GBFSData.Timezone.AFRICA_LIBREVILLE;
            case GBFSData.Timezone.AFRICA_LOME -> GBFSData.Timezone.AFRICA_LOME;
            case GBFSData.Timezone.AFRICA_LUANDA -> GBFSData.Timezone.AFRICA_LUANDA;
            case GBFSData.Timezone.AFRICA_LUBUMBASHI -> GBFSData.Timezone.AFRICA_LUBUMBASHI;
            case GBFSData.Timezone.AFRICA_LUSAKA -> GBFSData.Timezone.AFRICA_LUSAKA;
            case GBFSData.Timezone.AFRICA_MALABO -> GBFSData.Timezone.AFRICA_MALABO;
            case GBFSData.Timezone.AFRICA_MAPUTO -> GBFSData.Timezone.AFRICA_MAPUTO;
            case GBFSData.Timezone.AFRICA_MASERU -> GBFSData.Timezone.AFRICA_MASERU;
            case GBFSData.Timezone.AFRICA_MBABANE -> GBFSData.Timezone.AFRICA_MBABANE;
            case GBFSData.Timezone.AFRICA_MOGADISHU -> GBFSData.Timezone.AFRICA_MOGADISHU;
            case GBFSData.Timezone.AFRICA_MONROVIA -> GBFSData.Timezone.AFRICA_MONROVIA;
            case GBFSData.Timezone.AFRICA_NAIROBI -> GBFSData.Timezone.AFRICA_NAIROBI;
            case GBFSData.Timezone.AFRICA_NDJAMENA -> GBFSData.Timezone.AFRICA_NDJAMENA;
            case GBFSData.Timezone.AFRICA_NIAMEY -> GBFSData.Timezone.AFRICA_NIAMEY;
            case GBFSData.Timezone.AFRICA_NOUAKCHOTT -> GBFSData.Timezone.AFRICA_NOUAKCHOTT;
            case GBFSData.Timezone.AFRICA_OUAGADOUGOU -> GBFSData.Timezone.AFRICA_OUAGADOUGOU;
            case GBFSData.Timezone.AFRICA_PORTO_NOVO -> GBFSData.Timezone.AFRICA_PORTO_NOVO;
            case GBFSData.Timezone.AFRICA_SAO_TOME -> GBFSData.Timezone.AFRICA_SAO_TOME;
            case GBFSData.Timezone.AFRICA_TIMBUKTU -> GBFSData.Timezone.AFRICA_TIMBUKTU;
            case GBFSData.Timezone.AFRICA_TRIPOLI -> GBFSData.Timezone.AFRICA_TRIPOLI;
            case GBFSData.Timezone.AFRICA_TUNIS -> GBFSData.Timezone.AFRICA_TUNIS;
            case GBFSData.Timezone.AFRICA_WINDHOEK -> GBFSData.Timezone.AFRICA_WINDHOEK;
            case GBFSData.Timezone.AMERICA_ADAK -> GBFSData.Timezone.AMERICA_ADAK;
            case GBFSData.Timezone.AMERICA_ANCHORAGE -> GBFSData.Timezone.AMERICA_ANCHORAGE;
            case GBFSData.Timezone.AMERICA_ANGUILLA -> GBFSData.Timezone.AMERICA_ANGUILLA;
            case GBFSData.Timezone.AMERICA_ANTIGUA -> GBFSData.Timezone.AMERICA_ANTIGUA;
            case GBFSData.Timezone.AMERICA_ARAGUAINA -> GBFSData.Timezone.AMERICA_ARAGUAINA;
            case GBFSData.Timezone.AMERICA_ARGENTINA_BUENOS_AIRES -> GBFSData.Timezone.AMERICA_ARGENTINA_BUENOS_AIRES;
            case GBFSData.Timezone.AMERICA_ARGENTINA_CATAMARCA -> GBFSData.Timezone.AMERICA_ARGENTINA_CATAMARCA;
            case GBFSData.Timezone.AMERICA_ARGENTINA_COMOD_RIVADAVIA -> GBFSData.Timezone.AMERICA_ARGENTINA_COMOD_RIVADAVIA;
            case GBFSData.Timezone.AMERICA_ARGENTINA_CORDOBA -> GBFSData.Timezone.AMERICA_ARGENTINA_CORDOBA;
            case GBFSData.Timezone.AMERICA_ARGENTINA_JUJUY -> GBFSData.Timezone.AMERICA_ARGENTINA_JUJUY;
            case GBFSData.Timezone.AMERICA_ARGENTINA_LA_RIOJA -> GBFSData.Timezone.AMERICA_ARGENTINA_LA_RIOJA;
            case GBFSData.Timezone.AMERICA_ARGENTINA_MENDOZA -> GBFSData.Timezone.AMERICA_ARGENTINA_MENDOZA;
            case GBFSData.Timezone.AMERICA_ARGENTINA_RIO_GALLEGOS -> GBFSData.Timezone.AMERICA_ARGENTINA_RIO_GALLEGOS;
            case GBFSData.Timezone.AMERICA_ARGENTINA_SALTA -> GBFSData.Timezone.AMERICA_ARGENTINA_SALTA;
            case GBFSData.Timezone.AMERICA_ARGENTINA_SAN_JUAN -> GBFSData.Timezone.AMERICA_ARGENTINA_SAN_JUAN;
            case GBFSData.Timezone.AMERICA_ARGENTINA_SAN_LUIS -> GBFSData.Timezone.AMERICA_ARGENTINA_SAN_LUIS;
            case GBFSData.Timezone.AMERICA_ARGENTINA_TUCUMAN -> GBFSData.Timezone.AMERICA_ARGENTINA_TUCUMAN;
            case GBFSData.Timezone.AMERICA_ARGENTINA_USHUAIA -> GBFSData.Timezone.AMERICA_ARGENTINA_USHUAIA;
            case GBFSData.Timezone.AMERICA_ARUBA -> GBFSData.Timezone.AMERICA_ARUBA;
            case GBFSData.Timezone.AMERICA_ASUNCION -> GBFSData.Timezone.AMERICA_ASUNCION;
            case GBFSData.Timezone.AMERICA_ATIKOKAN -> GBFSData.Timezone.AMERICA_ATIKOKAN;
            case GBFSData.Timezone.AMERICA_ATKA -> GBFSData.Timezone.AMERICA_ATKA;
            case GBFSData.Timezone.AMERICA_BAHIA -> GBFSData.Timezone.AMERICA_BAHIA;
            case GBFSData.Timezone.AMERICA_BAHIA_BANDERAS -> GBFSData.Timezone.AMERICA_BAHIA_BANDERAS;
            case GBFSData.Timezone.AMERICA_BARBADOS -> GBFSData.Timezone.AMERICA_BARBADOS;
            case GBFSData.Timezone.AMERICA_BELEM -> GBFSData.Timezone.AMERICA_BELEM;
            case GBFSData.Timezone.AMERICA_BELIZE -> GBFSData.Timezone.AMERICA_BELIZE;
            case GBFSData.Timezone.AMERICA_BLANC_SABLON -> GBFSData.Timezone.AMERICA_BLANC_SABLON;
            case GBFSData.Timezone.AMERICA_BOA_VISTA -> GBFSData.Timezone.AMERICA_BOA_VISTA;
            case GBFSData.Timezone.AMERICA_BOGOTA -> GBFSData.Timezone.AMERICA_BOGOTA;
            case GBFSData.Timezone.AMERICA_BOISE -> GBFSData.Timezone.AMERICA_BOISE;
            case GBFSData.Timezone.AMERICA_BUENOS_AIRES -> GBFSData.Timezone.AMERICA_BUENOS_AIRES;
            case GBFSData.Timezone.AMERICA_CAMBRIDGE_BAY -> GBFSData.Timezone.AMERICA_CAMBRIDGE_BAY;
            case GBFSData.Timezone.AMERICA_CAMPO_GRANDE -> GBFSData.Timezone.AMERICA_CAMPO_GRANDE;
            case GBFSData.Timezone.AMERICA_CANCUN -> GBFSData.Timezone.AMERICA_CANCUN;
            case GBFSData.Timezone.AMERICA_CARACAS -> GBFSData.Timezone.AMERICA_CARACAS;
            case GBFSData.Timezone.AMERICA_CATAMARCA -> GBFSData.Timezone.AMERICA_CATAMARCA;
            case GBFSData.Timezone.AMERICA_CAYENNE -> GBFSData.Timezone.AMERICA_CAYENNE;
            case GBFSData.Timezone.AMERICA_CAYMAN -> GBFSData.Timezone.AMERICA_CAYMAN;
            case GBFSData.Timezone.AMERICA_CHICAGO -> GBFSData.Timezone.AMERICA_CHICAGO;
            case GBFSData.Timezone.AMERICA_CHIHUAHUA -> GBFSData.Timezone.AMERICA_CHIHUAHUA;
            case GBFSData.Timezone.AMERICA_CIUDAD_JUAREZ -> GBFSData.Timezone.AMERICA_CIUDAD_JUAREZ;
            case GBFSData.Timezone.AMERICA_CORAL_HARBOUR -> GBFSData.Timezone.AMERICA_CORAL_HARBOUR;
            case GBFSData.Timezone.AMERICA_CORDOBA -> GBFSData.Timezone.AMERICA_CORDOBA;
            case GBFSData.Timezone.AMERICA_COSTA_RICA -> GBFSData.Timezone.AMERICA_COSTA_RICA;
            case GBFSData.Timezone.AMERICA_CRESTON -> GBFSData.Timezone.AMERICA_CRESTON;
            case GBFSData.Timezone.AMERICA_CUIABA -> GBFSData.Timezone.AMERICA_CUIABA;
            case GBFSData.Timezone.AMERICA_CURACAO -> GBFSData.Timezone.AMERICA_CURACAO;
            case GBFSData.Timezone.AMERICA_DANMARKSHAVN -> GBFSData.Timezone.AMERICA_DANMARKSHAVN;
            case GBFSData.Timezone.AMERICA_DAWSON -> GBFSData.Timezone.AMERICA_DAWSON;
            case GBFSData.Timezone.AMERICA_DAWSON_CREEK -> GBFSData.Timezone.AMERICA_DAWSON_CREEK;
            case GBFSData.Timezone.AMERICA_DENVER -> GBFSData.Timezone.AMERICA_DENVER;
            case GBFSData.Timezone.AMERICA_DETROIT -> GBFSData.Timezone.AMERICA_DETROIT;
            case GBFSData.Timezone.AMERICA_DOMINICA -> GBFSData.Timezone.AMERICA_DOMINICA;
            case GBFSData.Timezone.AMERICA_EDMONTON -> GBFSData.Timezone.AMERICA_EDMONTON;
            case GBFSData.Timezone.AMERICA_EIRUNEPE -> GBFSData.Timezone.AMERICA_EIRUNEPE;
            case GBFSData.Timezone.AMERICA_EL_SALVADOR -> GBFSData.Timezone.AMERICA_EL_SALVADOR;
            case GBFSData.Timezone.AMERICA_ENSENADA -> GBFSData.Timezone.AMERICA_ENSENADA;
            case GBFSData.Timezone.AMERICA_FORT_NELSON -> GBFSData.Timezone.AMERICA_FORT_NELSON;
            case GBFSData.Timezone.AMERICA_FORT_WAYNE -> GBFSData.Timezone.AMERICA_FORT_WAYNE;
            case GBFSData.Timezone.AMERICA_FORTALEZA -> GBFSData.Timezone.AMERICA_FORTALEZA;
            case GBFSData.Timezone.AMERICA_GLACE_BAY -> GBFSData.Timezone.AMERICA_GLACE_BAY;
            case GBFSData.Timezone.AMERICA_GODTHAB -> GBFSData.Timezone.AMERICA_GODTHAB;
            case GBFSData.Timezone.AMERICA_GOOSE_BAY -> GBFSData.Timezone.AMERICA_GOOSE_BAY;
            case GBFSData.Timezone.AMERICA_GRAND_TURK -> GBFSData.Timezone.AMERICA_GRAND_TURK;
            case GBFSData.Timezone.AMERICA_GRENADA -> GBFSData.Timezone.AMERICA_GRENADA;
            case GBFSData.Timezone.AMERICA_GUADELOUPE -> GBFSData.Timezone.AMERICA_GUADELOUPE;
            case GBFSData.Timezone.AMERICA_GUATEMALA -> GBFSData.Timezone.AMERICA_GUATEMALA;
            case GBFSData.Timezone.AMERICA_GUAYAQUIL -> GBFSData.Timezone.AMERICA_GUAYAQUIL;
            case GBFSData.Timezone.AMERICA_GUYANA -> GBFSData.Timezone.AMERICA_GUYANA;
            case GBFSData.Timezone.AMERICA_HALIFAX -> GBFSData.Timezone.AMERICA_HALIFAX;
            case GBFSData.Timezone.AMERICA_HAVANA -> GBFSData.Timezone.AMERICA_HAVANA;
            case GBFSData.Timezone.AMERICA_HERMOSILLO -> GBFSData.Timezone.AMERICA_HERMOSILLO;
            case GBFSData.Timezone.AMERICA_INDIANA_INDIANAPOLIS -> GBFSData.Timezone.AMERICA_INDIANA_INDIANAPOLIS;
            case GBFSData.Timezone.AMERICA_INDIANA_KNOX -> GBFSData.Timezone.AMERICA_INDIANA_KNOX;
            case GBFSData.Timezone.AMERICA_INDIANA_MARENGO -> GBFSData.Timezone.AMERICA_INDIANA_MARENGO;
            case GBFSData.Timezone.AMERICA_INDIANA_PETERSBURG -> GBFSData.Timezone.AMERICA_INDIANA_PETERSBURG;
            case GBFSData.Timezone.AMERICA_INDIANA_TELL_CITY -> GBFSData.Timezone.AMERICA_INDIANA_TELL_CITY;
            case GBFSData.Timezone.AMERICA_INDIANA_VEVAY -> GBFSData.Timezone.AMERICA_INDIANA_VEVAY;
            case GBFSData.Timezone.AMERICA_INDIANA_VINCENNES -> GBFSData.Timezone.AMERICA_INDIANA_VINCENNES;
            case GBFSData.Timezone.AMERICA_INDIANA_WINAMAC -> GBFSData.Timezone.AMERICA_INDIANA_WINAMAC;
            case GBFSData.Timezone.AMERICA_INDIANAPOLIS -> GBFSData.Timezone.AMERICA_INDIANAPOLIS;
            case GBFSData.Timezone.AMERICA_INUVIK -> GBFSData.Timezone.AMERICA_INUVIK;
            case GBFSData.Timezone.AMERICA_IQALUIT -> GBFSData.Timezone.AMERICA_IQALUIT;
            case GBFSData.Timezone.AMERICA_JAMAICA -> GBFSData.Timezone.AMERICA_JAMAICA;
            case GBFSData.Timezone.AMERICA_JUJUY -> GBFSData.Timezone.AMERICA_JUJUY;
            case GBFSData.Timezone.AMERICA_JUNEAU -> GBFSData.Timezone.AMERICA_JUNEAU;
            case GBFSData.Timezone.AMERICA_KENTUCKY_LOUISVILLE -> GBFSData.Timezone.AMERICA_KENTUCKY_LOUISVILLE;
            case GBFSData.Timezone.AMERICA_KENTUCKY_MONTICELLO -> GBFSData.Timezone.AMERICA_KENTUCKY_MONTICELLO;
            case GBFSData.Timezone.AMERICA_KNOX_IN -> GBFSData.Timezone.AMERICA_KNOX_IN;
            case GBFSData.Timezone.AMERICA_KRALENDIJK -> GBFSData.Timezone.AMERICA_KRALENDIJK;
            case GBFSData.Timezone.AMERICA_LA_PAZ -> GBFSData.Timezone.AMERICA_LA_PAZ;
            case GBFSData.Timezone.AMERICA_LIMA -> GBFSData.Timezone.AMERICA_LIMA;
            case GBFSData.Timezone.AMERICA_LOS_ANGELES -> GBFSData.Timezone.AMERICA_LOS_ANGELES;
            case GBFSData.Timezone.AMERICA_LOUISVILLE -> GBFSData.Timezone.AMERICA_LOUISVILLE;
            case GBFSData.Timezone.AMERICA_LOWER_PRINCES -> GBFSData.Timezone.AMERICA_LOWER_PRINCES;
            case GBFSData.Timezone.AMERICA_MACEIO -> GBFSData.Timezone.AMERICA_MACEIO;
            case GBFSData.Timezone.AMERICA_MANAGUA -> GBFSData.Timezone.AMERICA_MANAGUA;
            case GBFSData.Timezone.AMERICA_MANAUS -> GBFSData.Timezone.AMERICA_MANAUS;
            case GBFSData.Timezone.AMERICA_MARIGOT -> GBFSData.Timezone.AMERICA_MARIGOT;
            case GBFSData.Timezone.AMERICA_MARTINIQUE -> GBFSData.Timezone.AMERICA_MARTINIQUE;
            case GBFSData.Timezone.AMERICA_MATAMOROS -> GBFSData.Timezone.AMERICA_MATAMOROS;
            case GBFSData.Timezone.AMERICA_MAZATLAN -> GBFSData.Timezone.AMERICA_MAZATLAN;
            case GBFSData.Timezone.AMERICA_MENDOZA -> GBFSData.Timezone.AMERICA_MENDOZA;
            case GBFSData.Timezone.AMERICA_MENOMINEE -> GBFSData.Timezone.AMERICA_MENOMINEE;
            case GBFSData.Timezone.AMERICA_MERIDA -> GBFSData.Timezone.AMERICA_MERIDA;
            case GBFSData.Timezone.AMERICA_METLAKATLA -> GBFSData.Timezone.AMERICA_METLAKATLA;
            case GBFSData.Timezone.AMERICA_MEXICO_CITY -> GBFSData.Timezone.AMERICA_MEXICO_CITY;
            case GBFSData.Timezone.AMERICA_MIQUELON -> GBFSData.Timezone.AMERICA_MIQUELON;
            case GBFSData.Timezone.AMERICA_MONCTON -> GBFSData.Timezone.AMERICA_MONCTON;
            case GBFSData.Timezone.AMERICA_MONTERREY -> GBFSData.Timezone.AMERICA_MONTERREY;
            case GBFSData.Timezone.AMERICA_MONTEVIDEO -> GBFSData.Timezone.AMERICA_MONTEVIDEO;
            case GBFSData.Timezone.AMERICA_MONTREAL -> GBFSData.Timezone.AMERICA_MONTREAL;
            case GBFSData.Timezone.AMERICA_MONTSERRAT -> GBFSData.Timezone.AMERICA_MONTSERRAT;
            case GBFSData.Timezone.AMERICA_NASSAU -> GBFSData.Timezone.AMERICA_NASSAU;
            case GBFSData.Timezone.AMERICA_NEW_YORK -> GBFSData.Timezone.AMERICA_NEW_YORK;
            case GBFSData.Timezone.AMERICA_NIPIGON -> GBFSData.Timezone.AMERICA_NIPIGON;
            case GBFSData.Timezone.AMERICA_NOME -> GBFSData.Timezone.AMERICA_NOME;
            case GBFSData.Timezone.AMERICA_NORONHA -> GBFSData.Timezone.AMERICA_NORONHA;
            case GBFSData.Timezone.AMERICA_NORTH_DAKOTA_BEULAH -> GBFSData.Timezone.AMERICA_NORTH_DAKOTA_BEULAH;
            case GBFSData.Timezone.AMERICA_NORTH_DAKOTA_CENTER -> GBFSData.Timezone.AMERICA_NORTH_DAKOTA_CENTER;
            case GBFSData.Timezone.AMERICA_NORTH_DAKOTA_NEW_SALEM -> GBFSData.Timezone.AMERICA_NORTH_DAKOTA_NEW_SALEM;
            case GBFSData.Timezone.AMERICA_NUUK -> GBFSData.Timezone.AMERICA_NUUK;
            case GBFSData.Timezone.AMERICA_OJINAGA -> GBFSData.Timezone.AMERICA_OJINAGA;
            case GBFSData.Timezone.AMERICA_PANAMA -> GBFSData.Timezone.AMERICA_PANAMA;
            case GBFSData.Timezone.AMERICA_PANGNIRTUNG -> GBFSData.Timezone.AMERICA_PANGNIRTUNG;
            case GBFSData.Timezone.AMERICA_PARAMARIBO -> GBFSData.Timezone.AMERICA_PARAMARIBO;
            case GBFSData.Timezone.AMERICA_PHOENIX -> GBFSData.Timezone.AMERICA_PHOENIX;
            case GBFSData.Timezone.AMERICA_PORT_AU_PRINCE -> GBFSData.Timezone.AMERICA_PORT_AU_PRINCE;
            case GBFSData.Timezone.AMERICA_PORT_OF_SPAIN -> GBFSData.Timezone.AMERICA_PORT_OF_SPAIN;
            case GBFSData.Timezone.AMERICA_PORTO_ACRE -> GBFSData.Timezone.AMERICA_PORTO_ACRE;
            case GBFSData.Timezone.AMERICA_PORTO_VELHO -> GBFSData.Timezone.AMERICA_PORTO_VELHO;
            case GBFSData.Timezone.AMERICA_PUERTO_RICO -> GBFSData.Timezone.AMERICA_PUERTO_RICO;
            case GBFSData.Timezone.AMERICA_PUNTA_ARENAS -> GBFSData.Timezone.AMERICA_PUNTA_ARENAS;
            case GBFSData.Timezone.AMERICA_RAINY_RIVER -> GBFSData.Timezone.AMERICA_RAINY_RIVER;
            case GBFSData.Timezone.AMERICA_RANKIN_INLET -> GBFSData.Timezone.AMERICA_RANKIN_INLET;
            case GBFSData.Timezone.AMERICA_RECIFE -> GBFSData.Timezone.AMERICA_RECIFE;
            case GBFSData.Timezone.AMERICA_REGINA -> GBFSData.Timezone.AMERICA_REGINA;
            case GBFSData.Timezone.AMERICA_RESOLUTE -> GBFSData.Timezone.AMERICA_RESOLUTE;
            case GBFSData.Timezone.AMERICA_RIO_BRANCO -> GBFSData.Timezone.AMERICA_RIO_BRANCO;
            case GBFSData.Timezone.AMERICA_ROSARIO -> GBFSData.Timezone.AMERICA_ROSARIO;
            case GBFSData.Timezone.AMERICA_SANTA_ISABEL -> GBFSData.Timezone.AMERICA_SANTA_ISABEL;
            case GBFSData.Timezone.AMERICA_SANTAREM -> GBFSData.Timezone.AMERICA_SANTAREM;
            case GBFSData.Timezone.AMERICA_SANTIAGO -> GBFSData.Timezone.AMERICA_SANTIAGO;
            case GBFSData.Timezone.AMERICA_SANTO_DOMINGO -> GBFSData.Timezone.AMERICA_SANTO_DOMINGO;
            case GBFSData.Timezone.AMERICA_SAO_PAULO -> GBFSData.Timezone.AMERICA_SAO_PAULO;
            case GBFSData.Timezone.AMERICA_SCORESBYSUND -> GBFSData.Timezone.AMERICA_SCORESBYSUND;
            case GBFSData.Timezone.AMERICA_SHIPROCK -> GBFSData.Timezone.AMERICA_SHIPROCK;
            case GBFSData.Timezone.AMERICA_SITKA -> GBFSData.Timezone.AMERICA_SITKA;
            case GBFSData.Timezone.AMERICA_ST_BARTHELEMY -> GBFSData.Timezone.AMERICA_ST_BARTHELEMY;
            case GBFSData.Timezone.AMERICA_ST_JOHNS -> GBFSData.Timezone.AMERICA_ST_JOHNS;
            case GBFSData.Timezone.AMERICA_ST_KITTS -> GBFSData.Timezone.AMERICA_ST_KITTS;
            case GBFSData.Timezone.AMERICA_ST_LUCIA -> GBFSData.Timezone.AMERICA_ST_LUCIA;
            case GBFSData.Timezone.AMERICA_ST_THOMAS -> GBFSData.Timezone.AMERICA_ST_THOMAS;
            case GBFSData.Timezone.AMERICA_ST_VINCENT -> GBFSData.Timezone.AMERICA_ST_VINCENT;
            case GBFSData.Timezone.AMERICA_SWIFT_CURRENT -> GBFSData.Timezone.AMERICA_SWIFT_CURRENT;
            case GBFSData.Timezone.AMERICA_TEGUCIGALPA -> GBFSData.Timezone.AMERICA_TEGUCIGALPA;
            case GBFSData.Timezone.AMERICA_THULE -> GBFSData.Timezone.AMERICA_THULE;
            case GBFSData.Timezone.AMERICA_THUNDER_BAY -> GBFSData.Timezone.AMERICA_THUNDER_BAY;
            case GBFSData.Timezone.AMERICA_TIJUANA -> GBFSData.Timezone.AMERICA_TIJUANA;
            case GBFSData.Timezone.AMERICA_TORONTO -> GBFSData.Timezone.AMERICA_TORONTO;
            case GBFSData.Timezone.AMERICA_TORTOLA -> GBFSData.Timezone.AMERICA_TORTOLA;
            case GBFSData.Timezone.AMERICA_VANCOUVER -> GBFSData.Timezone.AMERICA_VANCOUVER;
            case GBFSData.Timezone.AMERICA_VIRGIN -> GBFSData.Timezone.AMERICA_VIRGIN;
            case GBFSData.Timezone.AMERICA_WHITEHORSE -> GBFSData.Timezone.AMERICA_WHITEHORSE;
            case GBFSData.Timezone.AMERICA_WINNIPEG -> GBFSData.Timezone.AMERICA_WINNIPEG;
            case GBFSData.Timezone.AMERICA_YAKUTAT -> GBFSData.Timezone.AMERICA_YAKUTAT;
            case GBFSData.Timezone.AMERICA_YELLOWKNIFE -> GBFSData.Timezone.AMERICA_YELLOWKNIFE;
            case GBFSData.Timezone.ANTARCTICA_CASEY -> GBFSData.Timezone.ANTARCTICA_CASEY;
            case GBFSData.Timezone.ANTARCTICA_DAVIS -> GBFSData.Timezone.ANTARCTICA_DAVIS;
            case GBFSData.Timezone.ANTARCTICA_DUMONT_D_URVILLE -> GBFSData.Timezone.ANTARCTICA_DUMONT_D_URVILLE;
            case GBFSData.Timezone.ANTARCTICA_MACQUARIE -> GBFSData.Timezone.ANTARCTICA_MACQUARIE;
            case GBFSData.Timezone.ANTARCTICA_MAWSON -> GBFSData.Timezone.ANTARCTICA_MAWSON;
            case GBFSData.Timezone.ANTARCTICA_MC_MURDO -> GBFSData.Timezone.ANTARCTICA_MC_MURDO;
            case GBFSData.Timezone.ANTARCTICA_PALMER -> GBFSData.Timezone.ANTARCTICA_PALMER;
            case GBFSData.Timezone.ANTARCTICA_ROTHERA -> GBFSData.Timezone.ANTARCTICA_ROTHERA;
            case GBFSData.Timezone.ANTARCTICA_SOUTH_POLE -> GBFSData.Timezone.ANTARCTICA_SOUTH_POLE;
            case GBFSData.Timezone.ANTARCTICA_SYOWA -> GBFSData.Timezone.ANTARCTICA_SYOWA;
            case GBFSData.Timezone.ANTARCTICA_TROLL -> GBFSData.Timezone.ANTARCTICA_TROLL;
            case GBFSData.Timezone.ANTARCTICA_VOSTOK -> GBFSData.Timezone.ANTARCTICA_VOSTOK;
            case GBFSData.Timezone.ARCTIC_LONGYEARBYEN -> GBFSData.Timezone.ARCTIC_LONGYEARBYEN;
            case GBFSData.Timezone.ASIA_ADEN -> GBFSData.Timezone.ASIA_ADEN;
            case GBFSData.Timezone.ASIA_ALMATY -> GBFSData.Timezone.ASIA_ALMATY;
            case GBFSData.Timezone.ASIA_AMMAN -> GBFSData.Timezone.ASIA_AMMAN;
            case GBFSData.Timezone.ASIA_ANADYR -> GBFSData.Timezone.ASIA_ANADYR;
            case GBFSData.Timezone.ASIA_AQTAU -> GBFSData.Timezone.ASIA_AQTAU;
            case GBFSData.Timezone.ASIA_AQTOBE -> GBFSData.Timezone.ASIA_AQTOBE;
            case GBFSData.Timezone.ASIA_ASHGABAT -> GBFSData.Timezone.ASIA_ASHGABAT;
            case GBFSData.Timezone.ASIA_ASHKHABAD -> GBFSData.Timezone.ASIA_ASHKHABAD;
            case GBFSData.Timezone.ASIA_ATYRAU -> GBFSData.Timezone.ASIA_ATYRAU;
            case GBFSData.Timezone.ASIA_BAGHDAD -> GBFSData.Timezone.ASIA_BAGHDAD;
            case GBFSData.Timezone.ASIA_BAHRAIN -> GBFSData.Timezone.ASIA_BAHRAIN;
            case GBFSData.Timezone.ASIA_BAKU -> GBFSData.Timezone.ASIA_BAKU;
            case GBFSData.Timezone.ASIA_BANGKOK -> GBFSData.Timezone.ASIA_BANGKOK;
            case GBFSData.Timezone.ASIA_BARNAUL -> GBFSData.Timezone.ASIA_BARNAUL;
            case GBFSData.Timezone.ASIA_BEIRUT -> GBFSData.Timezone.ASIA_BEIRUT;
            case GBFSData.Timezone.ASIA_BISHKEK -> GBFSData.Timezone.ASIA_BISHKEK;
            case GBFSData.Timezone.ASIA_BRUNEI -> GBFSData.Timezone.ASIA_BRUNEI;
            case GBFSData.Timezone.ASIA_CALCUTTA -> GBFSData.Timezone.ASIA_CALCUTTA;
            case GBFSData.Timezone.ASIA_CHITA -> GBFSData.Timezone.ASIA_CHITA;
            case GBFSData.Timezone.ASIA_CHOIBALSAN -> GBFSData.Timezone.ASIA_CHOIBALSAN;
            case GBFSData.Timezone.ASIA_CHONGQING -> GBFSData.Timezone.ASIA_CHONGQING;
            case GBFSData.Timezone.ASIA_CHUNGKING -> GBFSData.Timezone.ASIA_CHUNGKING;
            case GBFSData.Timezone.ASIA_COLOMBO -> GBFSData.Timezone.ASIA_COLOMBO;
            case GBFSData.Timezone.ASIA_DACCA -> GBFSData.Timezone.ASIA_DACCA;
            case GBFSData.Timezone.ASIA_DAMASCUS -> GBFSData.Timezone.ASIA_DAMASCUS;
            case GBFSData.Timezone.ASIA_DHAKA -> GBFSData.Timezone.ASIA_DHAKA;
            case GBFSData.Timezone.ASIA_DILI -> GBFSData.Timezone.ASIA_DILI;
            case GBFSData.Timezone.ASIA_DUBAI -> GBFSData.Timezone.ASIA_DUBAI;
            case GBFSData.Timezone.ASIA_DUSHANBE -> GBFSData.Timezone.ASIA_DUSHANBE;
            case GBFSData.Timezone.ASIA_FAMAGUSTA -> GBFSData.Timezone.ASIA_FAMAGUSTA;
            case GBFSData.Timezone.ASIA_GAZA -> GBFSData.Timezone.ASIA_GAZA;
            case GBFSData.Timezone.ASIA_HARBIN -> GBFSData.Timezone.ASIA_HARBIN;
            case GBFSData.Timezone.ASIA_HEBRON -> GBFSData.Timezone.ASIA_HEBRON;
            case GBFSData.Timezone.ASIA_HO_CHI_MINH -> GBFSData.Timezone.ASIA_HO_CHI_MINH;
            case GBFSData.Timezone.ASIA_HONG_KONG -> GBFSData.Timezone.ASIA_HONG_KONG;
            case GBFSData.Timezone.ASIA_HOVD -> GBFSData.Timezone.ASIA_HOVD;
            case GBFSData.Timezone.ASIA_IRKUTSK -> GBFSData.Timezone.ASIA_IRKUTSK;
            case GBFSData.Timezone.ASIA_ISTANBUL -> GBFSData.Timezone.ASIA_ISTANBUL;
            case GBFSData.Timezone.ASIA_JAKARTA -> GBFSData.Timezone.ASIA_JAKARTA;
            case GBFSData.Timezone.ASIA_JAYAPURA -> GBFSData.Timezone.ASIA_JAYAPURA;
            case GBFSData.Timezone.ASIA_JERUSALEM -> GBFSData.Timezone.ASIA_JERUSALEM;
            case GBFSData.Timezone.ASIA_KABUL -> GBFSData.Timezone.ASIA_KABUL;
            case GBFSData.Timezone.ASIA_KAMCHATKA -> GBFSData.Timezone.ASIA_KAMCHATKA;
            case GBFSData.Timezone.ASIA_KARACHI -> GBFSData.Timezone.ASIA_KARACHI;
            case GBFSData.Timezone.ASIA_KASHGAR -> GBFSData.Timezone.ASIA_KASHGAR;
            case GBFSData.Timezone.ASIA_KATHMANDU -> GBFSData.Timezone.ASIA_KATHMANDU;
            case GBFSData.Timezone.ASIA_KATMANDU -> GBFSData.Timezone.ASIA_KATMANDU;
            case GBFSData.Timezone.ASIA_KHANDYGA -> GBFSData.Timezone.ASIA_KHANDYGA;
            case GBFSData.Timezone.ASIA_KOLKATA -> GBFSData.Timezone.ASIA_KOLKATA;
            case GBFSData.Timezone.ASIA_KRASNOYARSK -> GBFSData.Timezone.ASIA_KRASNOYARSK;
            case GBFSData.Timezone.ASIA_KUALA_LUMPUR -> GBFSData.Timezone.ASIA_KUALA_LUMPUR;
            case GBFSData.Timezone.ASIA_KUCHING -> GBFSData.Timezone.ASIA_KUCHING;
            case GBFSData.Timezone.ASIA_KUWAIT -> GBFSData.Timezone.ASIA_KUWAIT;
            case GBFSData.Timezone.ASIA_MACAO -> GBFSData.Timezone.ASIA_MACAO;
            case GBFSData.Timezone.ASIA_MACAU -> GBFSData.Timezone.ASIA_MACAU;
            case GBFSData.Timezone.ASIA_MAGADAN -> GBFSData.Timezone.ASIA_MAGADAN;
            case GBFSData.Timezone.ASIA_MAKASSAR -> GBFSData.Timezone.ASIA_MAKASSAR;
            case GBFSData.Timezone.ASIA_MANILA -> GBFSData.Timezone.ASIA_MANILA;
            case GBFSData.Timezone.ASIA_MUSCAT -> GBFSData.Timezone.ASIA_MUSCAT;
            case GBFSData.Timezone.ASIA_NICOSIA -> GBFSData.Timezone.ASIA_NICOSIA;
            case GBFSData.Timezone.ASIA_NOVOKUZNETSK -> GBFSData.Timezone.ASIA_NOVOKUZNETSK;
            case GBFSData.Timezone.ASIA_NOVOSIBIRSK -> GBFSData.Timezone.ASIA_NOVOSIBIRSK;
            case GBFSData.Timezone.ASIA_OMSK -> GBFSData.Timezone.ASIA_OMSK;
            case GBFSData.Timezone.ASIA_ORAL -> GBFSData.Timezone.ASIA_ORAL;
            case GBFSData.Timezone.ASIA_PHNOM_PENH -> GBFSData.Timezone.ASIA_PHNOM_PENH;
            case GBFSData.Timezone.ASIA_PONTIANAK -> GBFSData.Timezone.ASIA_PONTIANAK;
            case GBFSData.Timezone.ASIA_PYONGYANG -> GBFSData.Timezone.ASIA_PYONGYANG;
            case GBFSData.Timezone.ASIA_QATAR -> GBFSData.Timezone.ASIA_QATAR;
            case GBFSData.Timezone.ASIA_QOSTANAY -> GBFSData.Timezone.ASIA_QOSTANAY;
            case GBFSData.Timezone.ASIA_QYZYLORDA -> GBFSData.Timezone.ASIA_QYZYLORDA;
            case GBFSData.Timezone.ASIA_RANGOON -> GBFSData.Timezone.ASIA_RANGOON;
            case GBFSData.Timezone.ASIA_RIYADH -> GBFSData.Timezone.ASIA_RIYADH;
            case GBFSData.Timezone.ASIA_SAIGON -> GBFSData.Timezone.ASIA_SAIGON;
            case GBFSData.Timezone.ASIA_SAKHALIN -> GBFSData.Timezone.ASIA_SAKHALIN;
            case GBFSData.Timezone.ASIA_SAMARKAND -> GBFSData.Timezone.ASIA_SAMARKAND;
            case GBFSData.Timezone.ASIA_SEOUL -> GBFSData.Timezone.ASIA_SEOUL;
            case GBFSData.Timezone.ASIA_SHANGHAI -> GBFSData.Timezone.ASIA_SHANGHAI;
            case GBFSData.Timezone.ASIA_SINGAPORE -> GBFSData.Timezone.ASIA_SINGAPORE;
            case GBFSData.Timezone.ASIA_SREDNEKOLYMSK -> GBFSData.Timezone.ASIA_SREDNEKOLYMSK;
            case GBFSData.Timezone.ASIA_TAIPEI -> GBFSData.Timezone.ASIA_TAIPEI;
            case GBFSData.Timezone.ASIA_TASHKENT -> GBFSData.Timezone.ASIA_TASHKENT;
            case GBFSData.Timezone.ASIA_TBILISI -> GBFSData.Timezone.ASIA_TBILISI;
            case GBFSData.Timezone.ASIA_TEHRAN -> GBFSData.Timezone.ASIA_TEHRAN;
            case GBFSData.Timezone.ASIA_TEL_AVIV -> GBFSData.Timezone.ASIA_TEL_AVIV;
            case GBFSData.Timezone.ASIA_THIMBU -> GBFSData.Timezone.ASIA_THIMBU;
            case GBFSData.Timezone.ASIA_THIMPHU -> GBFSData.Timezone.ASIA_THIMPHU;
            case GBFSData.Timezone.ASIA_TOKYO -> GBFSData.Timezone.ASIA_TOKYO;
            case GBFSData.Timezone.ASIA_TOMSK -> GBFSData.Timezone.ASIA_TOMSK;
            case GBFSData.Timezone.ASIA_UJUNG_PANDANG -> GBFSData.Timezone.ASIA_UJUNG_PANDANG;
            case GBFSData.Timezone.ASIA_ULAANBAATAR -> GBFSData.Timezone.ASIA_ULAANBAATAR;
            case GBFSData.Timezone.ASIA_ULAN_BATOR -> GBFSData.Timezone.ASIA_ULAN_BATOR;
            case GBFSData.Timezone.ASIA_URUMQI -> GBFSData.Timezone.ASIA_URUMQI;
            case GBFSData.Timezone.ASIA_UST_NERA -> GBFSData.Timezone.ASIA_UST_NERA;
            case GBFSData.Timezone.ASIA_VIENTIANE -> GBFSData.Timezone.ASIA_VIENTIANE;
            case GBFSData.Timezone.ASIA_VLADIVOSTOK -> GBFSData.Timezone.ASIA_VLADIVOSTOK;
            case GBFSData.Timezone.ASIA_YAKUTSK -> GBFSData.Timezone.ASIA_YAKUTSK;
            case GBFSData.Timezone.ASIA_YANGON -> GBFSData.Timezone.ASIA_YANGON;
            case GBFSData.Timezone.ASIA_YEKATERINBURG -> GBFSData.Timezone.ASIA_YEKATERINBURG;
            case GBFSData.Timezone.ASIA_YEREVAN -> GBFSData.Timezone.ASIA_YEREVAN;
            case GBFSData.Timezone.ATLANTIC_AZORES -> GBFSData.Timezone.ATLANTIC_AZORES;
            case GBFSData.Timezone.ATLANTIC_BERMUDA -> GBFSData.Timezone.ATLANTIC_BERMUDA;
            case GBFSData.Timezone.ATLANTIC_CANARY -> GBFSData.Timezone.ATLANTIC_CANARY;
            case GBFSData.Timezone.ATLANTIC_CAPE_VERDE -> GBFSData.Timezone.ATLANTIC_CAPE_VERDE;
            case GBFSData.Timezone.ATLANTIC_FAEROE -> GBFSData.Timezone.ATLANTIC_FAEROE;
            case GBFSData.Timezone.ATLANTIC_FAROE -> GBFSData.Timezone.ATLANTIC_FAROE;
            case GBFSData.Timezone.ATLANTIC_JAN_MAYEN -> GBFSData.Timezone.ATLANTIC_JAN_MAYEN;
            case GBFSData.Timezone.ATLANTIC_MADEIRA -> GBFSData.Timezone.ATLANTIC_MADEIRA;
            case GBFSData.Timezone.ATLANTIC_REYKJAVIK -> GBFSData.Timezone.ATLANTIC_REYKJAVIK;
            case GBFSData.Timezone.ATLANTIC_SOUTH_GEORGIA -> GBFSData.Timezone.ATLANTIC_SOUTH_GEORGIA;
            case GBFSData.Timezone.ATLANTIC_ST_HELENA -> GBFSData.Timezone.ATLANTIC_ST_HELENA;
            case GBFSData.Timezone.ATLANTIC_STANLEY -> GBFSData.Timezone.ATLANTIC_STANLEY;
            case GBFSData.Timezone.AUSTRALIA_ACT -> GBFSData.Timezone.AUSTRALIA_ACT;
            case GBFSData.Timezone.AUSTRALIA_ADELAIDE -> GBFSData.Timezone.AUSTRALIA_ADELAIDE;
            case GBFSData.Timezone.AUSTRALIA_BRISBANE -> GBFSData.Timezone.AUSTRALIA_BRISBANE;
            case GBFSData.Timezone.AUSTRALIA_BROKEN_HILL -> GBFSData.Timezone.AUSTRALIA_BROKEN_HILL;
            case GBFSData.Timezone.AUSTRALIA_CANBERRA -> GBFSData.Timezone.AUSTRALIA_CANBERRA;
            case GBFSData.Timezone.AUSTRALIA_CURRIE -> GBFSData.Timezone.AUSTRALIA_CURRIE;
            case GBFSData.Timezone.AUSTRALIA_DARWIN -> GBFSData.Timezone.AUSTRALIA_DARWIN;
            case GBFSData.Timezone.AUSTRALIA_EUCLA -> GBFSData.Timezone.AUSTRALIA_EUCLA;
            case GBFSData.Timezone.AUSTRALIA_HOBART -> GBFSData.Timezone.AUSTRALIA_HOBART;
            case GBFSData.Timezone.AUSTRALIA_LHI -> GBFSData.Timezone.AUSTRALIA_LHI;
            case GBFSData.Timezone.AUSTRALIA_LINDEMAN -> GBFSData.Timezone.AUSTRALIA_LINDEMAN;
            case GBFSData.Timezone.AUSTRALIA_LORD_HOWE -> GBFSData.Timezone.AUSTRALIA_LORD_HOWE;
            case GBFSData.Timezone.AUSTRALIA_MELBOURNE -> GBFSData.Timezone.AUSTRALIA_MELBOURNE;
            case GBFSData.Timezone.AUSTRALIA_NORTH -> GBFSData.Timezone.AUSTRALIA_NORTH;
            case GBFSData.Timezone.AUSTRALIA_NSW -> GBFSData.Timezone.AUSTRALIA_NSW;
            case GBFSData.Timezone.AUSTRALIA_PERTH -> GBFSData.Timezone.AUSTRALIA_PERTH;
            case GBFSData.Timezone.AUSTRALIA_QUEENSLAND -> GBFSData.Timezone.AUSTRALIA_QUEENSLAND;
            case GBFSData.Timezone.AUSTRALIA_SOUTH -> GBFSData.Timezone.AUSTRALIA_SOUTH;
            case GBFSData.Timezone.AUSTRALIA_SYDNEY -> GBFSData.Timezone.AUSTRALIA_SYDNEY;
            case GBFSData.Timezone.AUSTRALIA_TASMANIA -> GBFSData.Timezone.AUSTRALIA_TASMANIA;
            case GBFSData.Timezone.AUSTRALIA_VICTORIA -> GBFSData.Timezone.AUSTRALIA_VICTORIA;
            case GBFSData.Timezone.AUSTRALIA_WEST -> GBFSData.Timezone.AUSTRALIA_WEST;
            case GBFSData.Timezone.AUSTRALIA_YANCOWINNA -> GBFSData.Timezone.AUSTRALIA_YANCOWINNA;
            case GBFSData.Timezone.BRAZIL_ACRE -> GBFSData.Timezone.BRAZIL_ACRE;
            case GBFSData.Timezone.BRAZIL_DE_NORONHA -> GBFSData.Timezone.BRAZIL_DE_NORONHA;
            case GBFSData.Timezone.BRAZIL_EAST -> GBFSData.Timezone.BRAZIL_EAST;
            case GBFSData.Timezone.BRAZIL_WEST -> GBFSData.Timezone.BRAZIL_WEST;
            case GBFSData.Timezone.CANADA_ATLANTIC -> GBFSData.Timezone.CANADA_ATLANTIC;
            case GBFSData.Timezone.CANADA_CENTRAL -> GBFSData.Timezone.CANADA_CENTRAL;
            case GBFSData.Timezone.CANADA_EASTERN -> GBFSData.Timezone.CANADA_EASTERN;
            case GBFSData.Timezone.CANADA_MOUNTAIN -> GBFSData.Timezone.CANADA_MOUNTAIN;
            case GBFSData.Timezone.CANADA_NEWFOUNDLAND -> GBFSData.Timezone.CANADA_NEWFOUNDLAND;
            case GBFSData.Timezone.CANADA_PACIFIC -> GBFSData.Timezone.CANADA_PACIFIC;
            case GBFSData.Timezone.CANADA_SASKATCHEWAN -> GBFSData.Timezone.CANADA_SASKATCHEWAN;
            case GBFSData.Timezone.CANADA_YUKON -> GBFSData.Timezone.CANADA_YUKON;
            case GBFSData.Timezone.CET -> GBFSData.Timezone.CET;
            case GBFSData.Timezone.CHILE_CONTINENTAL -> GBFSData.Timezone.CHILE_CONTINENTAL;
            case GBFSData.Timezone.CHILE_EASTER_ISLAND -> GBFSData.Timezone.CHILE_EASTER_ISLAND;
            case GBFSData.Timezone.CST_6_CDT -> GBFSData.Timezone.CST_6_CDT;
            case GBFSData.Timezone.CUBA -> GBFSData.Timezone.CUBA;
            case GBFSData.Timezone.EET -> GBFSData.Timezone.EET;
            case GBFSData.Timezone.EGYPT -> GBFSData.Timezone.EGYPT;
            case GBFSData.Timezone.EIRE -> GBFSData.Timezone.EIRE;
            case GBFSData.Timezone.EST -> GBFSData.Timezone.EST;
            case GBFSData.Timezone.EST_5_EDT -> GBFSData.Timezone.EST_5_EDT;
            case GBFSData.Timezone.ETC_GMT -> GBFSData.Timezone.ETC_GMT;
            case GBFSData.Timezone.ETC_GMT_0 -> GBFSData.Timezone.ETC_GMT_0;
            case GBFSData.Timezone.ETC_GMT_1 -> GBFSData.Timezone.ETC_GMT_1;
            case GBFSData.Timezone.ETC_GMT_10 -> GBFSData.Timezone.ETC_GMT_10;
            case GBFSData.Timezone.ETC_GMT_11 -> GBFSData.Timezone.ETC_GMT_11;
            case GBFSData.Timezone.ETC_GMT_12 -> GBFSData.Timezone.ETC_GMT_12;
            case GBFSData.Timezone.ETC_GMT_2 -> GBFSData.Timezone.ETC_GMT_2;
            case GBFSData.Timezone.ETC_GMT_3 -> GBFSData.Timezone.ETC_GMT_3;
            case GBFSData.Timezone.ETC_GMT_4 -> GBFSData.Timezone.ETC_GMT_4;
            case GBFSData.Timezone.ETC_GMT_5 -> GBFSData.Timezone.ETC_GMT_5;
            case GBFSData.Timezone.ETC_GMT_6 -> GBFSData.Timezone.ETC_GMT_6;
            case GBFSData.Timezone.ETC_GMT_7 -> GBFSData.Timezone.ETC_GMT_7;
            case GBFSData.Timezone.ETC_GMT_8 -> GBFSData.Timezone.ETC_GMT_8;
            case GBFSData.Timezone.ETC_GMT_9 -> GBFSData.Timezone.ETC_GMT_9;
            case GBFSData.Timezone.ETC_GMT_0_ -> GBFSData.Timezone.ETC_GMT_0_;
            case GBFSData.Timezone.ETC_GMT_1_ -> GBFSData.Timezone.ETC_GMT_1_;
            case GBFSData.Timezone.ETC_GMT_10_ -> GBFSData.Timezone.ETC_GMT_10_;
            case GBFSData.Timezone.ETC_GMT_11_ -> GBFSData.Timezone.ETC_GMT_11_;
            case GBFSData.Timezone.ETC_GMT_12_ -> GBFSData.Timezone.ETC_GMT_12_;
            case GBFSData.Timezone.ETC_GMT_13 -> GBFSData.Timezone.ETC_GMT_13;
            case GBFSData.Timezone.ETC_GMT_14 -> GBFSData.Timezone.ETC_GMT_14;
            case GBFSData.Timezone.ETC_GMT_2_ -> GBFSData.Timezone.ETC_GMT_2_;
            case GBFSData.Timezone.ETC_GMT_3_ -> GBFSData.Timezone.ETC_GMT_3_;
            case GBFSData.Timezone.ETC_GMT_4_ -> GBFSData.Timezone.ETC_GMT_4_;
            case GBFSData.Timezone.ETC_GMT_5_ -> GBFSData.Timezone.ETC_GMT_5_;
            case GBFSData.Timezone.ETC_GMT_6_ -> GBFSData.Timezone.ETC_GMT_6_;
            case GBFSData.Timezone.ETC_GMT_7_ -> GBFSData.Timezone.ETC_GMT_7_;
            case GBFSData.Timezone.ETC_GMT_8_ -> GBFSData.Timezone.ETC_GMT_8_;
            case GBFSData.Timezone.ETC_GMT_9_ -> GBFSData.Timezone.ETC_GMT_9_;
            case GBFSData.Timezone.ETC_GMT_0__ -> GBFSData.Timezone.ETC_GMT_0__;
            case GBFSData.Timezone.ETC_GREENWICH -> GBFSData.Timezone.ETC_GREENWICH;
            case GBFSData.Timezone.ETC_UCT -> GBFSData.Timezone.ETC_UCT;
            case GBFSData.Timezone.ETC_UNIVERSAL -> GBFSData.Timezone.ETC_UNIVERSAL;
            case GBFSData.Timezone.ETC_UTC -> GBFSData.Timezone.ETC_UTC;
            case GBFSData.Timezone.ETC_ZULU -> GBFSData.Timezone.ETC_ZULU;
            case GBFSData.Timezone.EUROPE_AMSTERDAM -> GBFSData.Timezone.EUROPE_AMSTERDAM;
            case GBFSData.Timezone.EUROPE_ANDORRA -> GBFSData.Timezone.EUROPE_ANDORRA;
            case GBFSData.Timezone.EUROPE_ASTRAKHAN -> GBFSData.Timezone.EUROPE_ASTRAKHAN;
            case GBFSData.Timezone.EUROPE_ATHENS -> GBFSData.Timezone.EUROPE_ATHENS;
            case GBFSData.Timezone.EUROPE_BELFAST -> GBFSData.Timezone.EUROPE_BELFAST;
            case GBFSData.Timezone.EUROPE_BELGRADE -> GBFSData.Timezone.EUROPE_BELGRADE;
            case GBFSData.Timezone.EUROPE_BERLIN -> GBFSData.Timezone.EUROPE_BERLIN;
            case GBFSData.Timezone.EUROPE_BRATISLAVA -> GBFSData.Timezone.EUROPE_BRATISLAVA;
            case GBFSData.Timezone.EUROPE_BRUSSELS -> GBFSData.Timezone.EUROPE_BRUSSELS;
            case GBFSData.Timezone.EUROPE_BUCHAREST -> GBFSData.Timezone.EUROPE_BUCHAREST;
            case GBFSData.Timezone.EUROPE_BUDAPEST -> GBFSData.Timezone.EUROPE_BUDAPEST;
            case GBFSData.Timezone.EUROPE_BUSINGEN -> GBFSData.Timezone.EUROPE_BUSINGEN;
            case GBFSData.Timezone.EUROPE_CHISINAU -> GBFSData.Timezone.EUROPE_CHISINAU;
            case GBFSData.Timezone.EUROPE_COPENHAGEN -> GBFSData.Timezone.EUROPE_COPENHAGEN;
            case GBFSData.Timezone.EUROPE_DUBLIN -> GBFSData.Timezone.EUROPE_DUBLIN;
            case GBFSData.Timezone.EUROPE_GIBRALTAR -> GBFSData.Timezone.EUROPE_GIBRALTAR;
            case GBFSData.Timezone.EUROPE_GUERNSEY -> GBFSData.Timezone.EUROPE_GUERNSEY;
            case GBFSData.Timezone.EUROPE_HELSINKI -> GBFSData.Timezone.EUROPE_HELSINKI;
            case GBFSData.Timezone.EUROPE_ISLE_OF_MAN -> GBFSData.Timezone.EUROPE_ISLE_OF_MAN;
            case GBFSData.Timezone.EUROPE_ISTANBUL -> GBFSData.Timezone.EUROPE_ISTANBUL;
            case GBFSData.Timezone.EUROPE_JERSEY -> GBFSData.Timezone.EUROPE_JERSEY;
            case GBFSData.Timezone.EUROPE_KALININGRAD -> GBFSData.Timezone.EUROPE_KALININGRAD;
            case GBFSData.Timezone.EUROPE_KIEV -> GBFSData.Timezone.EUROPE_KIEV;
            case GBFSData.Timezone.EUROPE_KIROV -> GBFSData.Timezone.EUROPE_KIROV;
            case GBFSData.Timezone.EUROPE_KYIV -> GBFSData.Timezone.EUROPE_KYIV;
            case GBFSData.Timezone.EUROPE_LISBON -> GBFSData.Timezone.EUROPE_LISBON;
            case GBFSData.Timezone.EUROPE_LJUBLJANA -> GBFSData.Timezone.EUROPE_LJUBLJANA;
            case GBFSData.Timezone.EUROPE_LONDON -> GBFSData.Timezone.EUROPE_LONDON;
            case GBFSData.Timezone.EUROPE_LUXEMBOURG -> GBFSData.Timezone.EUROPE_LUXEMBOURG;
            case GBFSData.Timezone.EUROPE_MADRID -> GBFSData.Timezone.EUROPE_MADRID;
            case GBFSData.Timezone.EUROPE_MALTA -> GBFSData.Timezone.EUROPE_MALTA;
            case GBFSData.Timezone.EUROPE_MARIEHAMN -> GBFSData.Timezone.EUROPE_MARIEHAMN;
            case GBFSData.Timezone.EUROPE_MINSK -> GBFSData.Timezone.EUROPE_MINSK;
            case GBFSData.Timezone.EUROPE_MONACO -> GBFSData.Timezone.EUROPE_MONACO;
            case GBFSData.Timezone.EUROPE_MOSCOW -> GBFSData.Timezone.EUROPE_MOSCOW;
            case GBFSData.Timezone.EUROPE_NICOSIA -> GBFSData.Timezone.EUROPE_NICOSIA;
            case GBFSData.Timezone.EUROPE_OSLO -> GBFSData.Timezone.EUROPE_OSLO;
            case GBFSData.Timezone.EUROPE_PARIS -> GBFSData.Timezone.EUROPE_PARIS;
            case GBFSData.Timezone.EUROPE_PODGORICA -> GBFSData.Timezone.EUROPE_PODGORICA;
            case GBFSData.Timezone.EUROPE_PRAGUE -> GBFSData.Timezone.EUROPE_PRAGUE;
            case GBFSData.Timezone.EUROPE_RIGA -> GBFSData.Timezone.EUROPE_RIGA;
            case GBFSData.Timezone.EUROPE_ROME -> GBFSData.Timezone.EUROPE_ROME;
            case GBFSData.Timezone.EUROPE_SAMARA -> GBFSData.Timezone.EUROPE_SAMARA;
            case GBFSData.Timezone.EUROPE_SAN_MARINO -> GBFSData.Timezone.EUROPE_SAN_MARINO;
            case GBFSData.Timezone.EUROPE_SARAJEVO -> GBFSData.Timezone.EUROPE_SARAJEVO;
            case GBFSData.Timezone.EUROPE_SARATOV -> GBFSData.Timezone.EUROPE_SARATOV;
            case GBFSData.Timezone.EUROPE_SIMFEROPOL -> GBFSData.Timezone.EUROPE_SIMFEROPOL;
            case GBFSData.Timezone.EUROPE_SKOPJE -> GBFSData.Timezone.EUROPE_SKOPJE;
            case GBFSData.Timezone.EUROPE_SOFIA -> GBFSData.Timezone.EUROPE_SOFIA;
            case GBFSData.Timezone.EUROPE_STOCKHOLM -> GBFSData.Timezone.EUROPE_STOCKHOLM;
            case GBFSData.Timezone.EUROPE_TALLINN -> GBFSData.Timezone.EUROPE_TALLINN;
            case GBFSData.Timezone.EUROPE_TIRANE -> GBFSData.Timezone.EUROPE_TIRANE;
            case GBFSData.Timezone.EUROPE_TIRASPOL -> GBFSData.Timezone.EUROPE_TIRASPOL;
            case GBFSData.Timezone.EUROPE_ULYANOVSK -> GBFSData.Timezone.EUROPE_ULYANOVSK;
            case GBFSData.Timezone.EUROPE_UZHGOROD -> GBFSData.Timezone.EUROPE_UZHGOROD;
            case GBFSData.Timezone.EUROPE_VADUZ -> GBFSData.Timezone.EUROPE_VADUZ;
            case GBFSData.Timezone.EUROPE_VATICAN -> GBFSData.Timezone.EUROPE_VATICAN;
            case GBFSData.Timezone.EUROPE_VIENNA -> GBFSData.Timezone.EUROPE_VIENNA;
            case GBFSData.Timezone.EUROPE_VILNIUS -> GBFSData.Timezone.EUROPE_VILNIUS;
            case GBFSData.Timezone.EUROPE_VOLGOGRAD -> GBFSData.Timezone.EUROPE_VOLGOGRAD;
            case GBFSData.Timezone.EUROPE_WARSAW -> GBFSData.Timezone.EUROPE_WARSAW;
            case GBFSData.Timezone.EUROPE_ZAGREB -> GBFSData.Timezone.EUROPE_ZAGREB;
            case GBFSData.Timezone.EUROPE_ZAPOROZHYE -> GBFSData.Timezone.EUROPE_ZAPOROZHYE;
            case GBFSData.Timezone.EUROPE_ZURICH -> GBFSData.Timezone.EUROPE_ZURICH;
            case GBFSData.Timezone.FACTORY -> GBFSData.Timezone.FACTORY;
            case GBFSData.Timezone.GB -> GBFSData.Timezone.GB;
            case GBFSData.Timezone.GB_EIRE -> GBFSData.Timezone.GB_EIRE;
            case GBFSData.Timezone.GMT -> GBFSData.Timezone.GMT;
            case GBFSData.Timezone.GMT_0 -> GBFSData.Timezone.GMT_0;
            case GBFSData.Timezone.GMT_0_ -> GBFSData.Timezone.GMT_0_;
            case GBFSData.Timezone.GMT_0__ -> GBFSData.Timezone.GMT_0__;
            case GBFSData.Timezone.GREENWICH -> GBFSData.Timezone.GREENWICH;
            case GBFSData.Timezone.HONGKONG -> GBFSData.Timezone.HONGKONG;
            case GBFSData.Timezone.HST -> GBFSData.Timezone.HST;
            case GBFSData.Timezone.ICELAND -> GBFSData.Timezone.ICELAND;
            case GBFSData.Timezone.INDIAN_ANTANANARIVO -> GBFSData.Timezone.INDIAN_ANTANANARIVO;
            case GBFSData.Timezone.INDIAN_CHAGOS -> GBFSData.Timezone.INDIAN_CHAGOS;
            case GBFSData.Timezone.INDIAN_CHRISTMAS -> GBFSData.Timezone.INDIAN_CHRISTMAS;
            case GBFSData.Timezone.INDIAN_COCOS -> GBFSData.Timezone.INDIAN_COCOS;
            case GBFSData.Timezone.INDIAN_COMORO -> GBFSData.Timezone.INDIAN_COMORO;
            case GBFSData.Timezone.INDIAN_KERGUELEN -> GBFSData.Timezone.INDIAN_KERGUELEN;
            case GBFSData.Timezone.INDIAN_MAHE -> GBFSData.Timezone.INDIAN_MAHE;
            case GBFSData.Timezone.INDIAN_MALDIVES -> GBFSData.Timezone.INDIAN_MALDIVES;
            case GBFSData.Timezone.INDIAN_MAURITIUS -> GBFSData.Timezone.INDIAN_MAURITIUS;
            case GBFSData.Timezone.INDIAN_MAYOTTE -> GBFSData.Timezone.INDIAN_MAYOTTE;
            case GBFSData.Timezone.INDIAN_REUNION -> GBFSData.Timezone.INDIAN_REUNION;
            case GBFSData.Timezone.IRAN -> GBFSData.Timezone.IRAN;
            case GBFSData.Timezone.ISRAEL -> GBFSData.Timezone.ISRAEL;
            case GBFSData.Timezone.JAMAICA -> GBFSData.Timezone.JAMAICA;
            case GBFSData.Timezone.JAPAN -> GBFSData.Timezone.JAPAN;
            case GBFSData.Timezone.KWAJALEIN -> GBFSData.Timezone.KWAJALEIN;
            case GBFSData.Timezone.LIBYA -> GBFSData.Timezone.LIBYA;
            case GBFSData.Timezone.MET -> GBFSData.Timezone.MET;
            case GBFSData.Timezone.MEXICO_BAJA_NORTE -> GBFSData.Timezone.MEXICO_BAJA_NORTE;
            case GBFSData.Timezone.MEXICO_BAJA_SUR -> GBFSData.Timezone.MEXICO_BAJA_SUR;
            case GBFSData.Timezone.MEXICO_GENERAL -> GBFSData.Timezone.MEXICO_GENERAL;
            case GBFSData.Timezone.MST -> GBFSData.Timezone.MST;
            case GBFSData.Timezone.MST_7_MDT -> GBFSData.Timezone.MST_7_MDT;
            case GBFSData.Timezone.NAVAJO -> GBFSData.Timezone.NAVAJO;
            case GBFSData.Timezone.NZ -> GBFSData.Timezone.NZ;
            case GBFSData.Timezone.NZ_CHAT -> GBFSData.Timezone.NZ_CHAT;
            case GBFSData.Timezone.PACIFIC_APIA -> GBFSData.Timezone.PACIFIC_APIA;
            case GBFSData.Timezone.PACIFIC_AUCKLAND -> GBFSData.Timezone.PACIFIC_AUCKLAND;
            case GBFSData.Timezone.PACIFIC_BOUGAINVILLE -> GBFSData.Timezone.PACIFIC_BOUGAINVILLE;
            case GBFSData.Timezone.PACIFIC_CHATHAM -> GBFSData.Timezone.PACIFIC_CHATHAM;
            case GBFSData.Timezone.PACIFIC_CHUUK -> GBFSData.Timezone.PACIFIC_CHUUK;
            case GBFSData.Timezone.PACIFIC_EASTER -> GBFSData.Timezone.PACIFIC_EASTER;
            case GBFSData.Timezone.PACIFIC_EFATE -> GBFSData.Timezone.PACIFIC_EFATE;
            case GBFSData.Timezone.PACIFIC_ENDERBURY -> GBFSData.Timezone.PACIFIC_ENDERBURY;
            case GBFSData.Timezone.PACIFIC_FAKAOFO -> GBFSData.Timezone.PACIFIC_FAKAOFO;
            case GBFSData.Timezone.PACIFIC_FIJI -> GBFSData.Timezone.PACIFIC_FIJI;
            case GBFSData.Timezone.PACIFIC_FUNAFUTI -> GBFSData.Timezone.PACIFIC_FUNAFUTI;
            case GBFSData.Timezone.PACIFIC_GALAPAGOS -> GBFSData.Timezone.PACIFIC_GALAPAGOS;
            case GBFSData.Timezone.PACIFIC_GAMBIER -> GBFSData.Timezone.PACIFIC_GAMBIER;
            case GBFSData.Timezone.PACIFIC_GUADALCANAL -> GBFSData.Timezone.PACIFIC_GUADALCANAL;
            case GBFSData.Timezone.PACIFIC_GUAM -> GBFSData.Timezone.PACIFIC_GUAM;
            case GBFSData.Timezone.PACIFIC_HONOLULU -> GBFSData.Timezone.PACIFIC_HONOLULU;
            case GBFSData.Timezone.PACIFIC_JOHNSTON -> GBFSData.Timezone.PACIFIC_JOHNSTON;
            case GBFSData.Timezone.PACIFIC_KANTON -> GBFSData.Timezone.PACIFIC_KANTON;
            case GBFSData.Timezone.PACIFIC_KIRITIMATI -> GBFSData.Timezone.PACIFIC_KIRITIMATI;
            case GBFSData.Timezone.PACIFIC_KOSRAE -> GBFSData.Timezone.PACIFIC_KOSRAE;
            case GBFSData.Timezone.PACIFIC_KWAJALEIN -> GBFSData.Timezone.PACIFIC_KWAJALEIN;
            case GBFSData.Timezone.PACIFIC_MAJURO -> GBFSData.Timezone.PACIFIC_MAJURO;
            case GBFSData.Timezone.PACIFIC_MARQUESAS -> GBFSData.Timezone.PACIFIC_MARQUESAS;
            case GBFSData.Timezone.PACIFIC_MIDWAY -> GBFSData.Timezone.PACIFIC_MIDWAY;
            case GBFSData.Timezone.PACIFIC_NAURU -> GBFSData.Timezone.PACIFIC_NAURU;
            case GBFSData.Timezone.PACIFIC_NIUE -> GBFSData.Timezone.PACIFIC_NIUE;
            case GBFSData.Timezone.PACIFIC_NORFOLK -> GBFSData.Timezone.PACIFIC_NORFOLK;
            case GBFSData.Timezone.PACIFIC_NOUMEA -> GBFSData.Timezone.PACIFIC_NOUMEA;
            case GBFSData.Timezone.PACIFIC_PAGO_PAGO -> GBFSData.Timezone.PACIFIC_PAGO_PAGO;
            case GBFSData.Timezone.PACIFIC_PALAU -> GBFSData.Timezone.PACIFIC_PALAU;
            case GBFSData.Timezone.PACIFIC_PITCAIRN -> GBFSData.Timezone.PACIFIC_PITCAIRN;
            case GBFSData.Timezone.PACIFIC_POHNPEI -> GBFSData.Timezone.PACIFIC_POHNPEI;
            case GBFSData.Timezone.PACIFIC_PONAPE -> GBFSData.Timezone.PACIFIC_PONAPE;
            case GBFSData.Timezone.PACIFIC_PORT_MORESBY -> GBFSData.Timezone.PACIFIC_PORT_MORESBY;
            case GBFSData.Timezone.PACIFIC_RAROTONGA -> GBFSData.Timezone.PACIFIC_RAROTONGA;
            case GBFSData.Timezone.PACIFIC_SAIPAN -> GBFSData.Timezone.PACIFIC_SAIPAN;
            case GBFSData.Timezone.PACIFIC_SAMOA -> GBFSData.Timezone.PACIFIC_SAMOA;
            case GBFSData.Timezone.PACIFIC_TAHITI -> GBFSData.Timezone.PACIFIC_TAHITI;
            case GBFSData.Timezone.PACIFIC_TARAWA -> GBFSData.Timezone.PACIFIC_TARAWA;
            case GBFSData.Timezone.PACIFIC_TONGATAPU -> GBFSData.Timezone.PACIFIC_TONGATAPU;
            case GBFSData.Timezone.PACIFIC_TRUK -> GBFSData.Timezone.PACIFIC_TRUK;
            case GBFSData.Timezone.PACIFIC_WAKE -> GBFSData.Timezone.PACIFIC_WAKE;
            case GBFSData.Timezone.PACIFIC_WALLIS -> GBFSData.Timezone.PACIFIC_WALLIS;
            case GBFSData.Timezone.PACIFIC_YAP -> GBFSData.Timezone.PACIFIC_YAP;
            case GBFSData.Timezone.POLAND -> GBFSData.Timezone.POLAND;
            case GBFSData.Timezone.PORTUGAL -> GBFSData.Timezone.PORTUGAL;
            case GBFSData.Timezone.PRC -> GBFSData.Timezone.PRC;
            case GBFSData.Timezone.PST_8_PDT -> GBFSData.Timezone.PST_8_PDT;
            case GBFSData.Timezone.ROC -> GBFSData.Timezone.ROC;
            case GBFSData.Timezone.ROK -> GBFSData.Timezone.ROK;
            case GBFSData.Timezone.SINGAPORE -> GBFSData.Timezone.SINGAPORE;
            case GBFSData.Timezone.TURKEY -> GBFSData.Timezone.TURKEY;
            case GBFSData.Timezone.UCT -> GBFSData.Timezone.UCT;
            case GBFSData.Timezone.UNIVERSAL -> GBFSData.Timezone.UNIVERSAL;
            case GBFSData.Timezone.US_ALASKA -> GBFSData.Timezone.US_ALASKA;
            case GBFSData.Timezone.US_ALEUTIAN -> GBFSData.Timezone.US_ALEUTIAN;
            case GBFSData.Timezone.US_ARIZONA -> GBFSData.Timezone.US_ARIZONA;
            case GBFSData.Timezone.US_CENTRAL -> GBFSData.Timezone.US_CENTRAL;
            case GBFSData.Timezone.US_EAST_INDIANA -> GBFSData.Timezone.US_EAST_INDIANA;
            case GBFSData.Timezone.US_EASTERN -> GBFSData.Timezone.US_EASTERN;
            case GBFSData.Timezone.US_HAWAII -> GBFSData.Timezone.US_HAWAII;
            case GBFSData.Timezone.US_INDIANA_STARKE -> GBFSData.Timezone.US_INDIANA_STARKE;
            case GBFSData.Timezone.US_MICHIGAN -> GBFSData.Timezone.US_MICHIGAN;
            case GBFSData.Timezone.US_MOUNTAIN -> GBFSData.Timezone.US_MOUNTAIN;
            case GBFSData.Timezone.US_PACIFIC -> GBFSData.Timezone.US_PACIFIC;
            case GBFSData.Timezone.US_SAMOA -> GBFSData.Timezone.US_SAMOA;
            case GBFSData.Timezone.UTC -> GBFSData.Timezone.UTC;
            case GBFSData.Timezone.W_SU -> GBFSData.Timezone.W_SU;
            case GBFSData.Timezone.WET -> GBFSData.Timezone.WET;
            case GBFSData.Timezone.ZULU -> GBFSData.Timezone.ZULU;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + timezone);
        };
    }

    protected GBFSBrandAssets gBFSBrandAssetsToGBFSBrandAssets1(org.mobilitydata.gbfs.v3_0.system_information.GBFSBrandAssets gBFSBrandAssets, String language) {
        Map map;
        if (gBFSBrandAssets == null) {
            return null;
        }
        GBFSBrandAssets gBFSBrandAssets1 = new GBFSBrandAssets();
        gBFSBrandAssets1.setBrandLastModified(gBFSBrandAssets.getBrandLastModified());
        gBFSBrandAssets1.setBrandTermsUrl(gBFSBrandAssets.getBrandTermsUrl());
        gBFSBrandAssets1.setBrandImageUrl(gBFSBrandAssets.getBrandImageUrl());
        gBFSBrandAssets1.setBrandImageUrlDark(gBFSBrandAssets.getBrandImageUrlDark());
        gBFSBrandAssets1.setColor(gBFSBrandAssets.getColor());
        if (gBFSBrandAssets1.getAdditionalProperties() != null && (map = gBFSBrandAssets.getAdditionalProperties()) != null) {
            gBFSBrandAssets1.getAdditionalProperties().putAll(map);
        }
        return gBFSBrandAssets1;
    }

    protected org.mobilitydata.gbfs.v2_3.system_information.GBFSAndroid gBFSAndroidToGBFSAndroid1(GBFSAndroid gBFSAndroid, String language) {
        Map map;
        if (gBFSAndroid == null) {
            return null;
        }
        org.mobilitydata.gbfs.v2_3.system_information.GBFSAndroid gBFSAndroid1 = new org.mobilitydata.gbfs.v2_3.system_information.GBFSAndroid();
        gBFSAndroid1.setStoreUri(gBFSAndroid.getStoreUri());
        gBFSAndroid1.setDiscoveryUri(gBFSAndroid.getDiscoveryUri());
        if (gBFSAndroid1.getAdditionalProperties() != null && (map = gBFSAndroid.getAdditionalProperties()) != null) {
            gBFSAndroid1.getAdditionalProperties().putAll(map);
        }
        return gBFSAndroid1;
    }

    protected org.mobilitydata.gbfs.v2_3.system_information.GBFSIos gBFSIosToGBFSIos1(GBFSIos gBFSIos, String language) {
        Map map;
        if (gBFSIos == null) {
            return null;
        }
        org.mobilitydata.gbfs.v2_3.system_information.GBFSIos gBFSIos1 = new org.mobilitydata.gbfs.v2_3.system_information.GBFSIos();
        gBFSIos1.setStoreUri(gBFSIos.getStoreUri());
        gBFSIos1.setDiscoveryUri(gBFSIos.getDiscoveryUri());
        if (gBFSIos1.getAdditionalProperties() != null && (map = gBFSIos.getAdditionalProperties()) != null) {
            gBFSIos1.getAdditionalProperties().putAll(map);
        }
        return gBFSIos1;
    }

    protected GBFSRentalApps gBFSRentalAppsToGBFSRentalApps1(org.mobilitydata.gbfs.v3_0.system_information.GBFSRentalApps gBFSRentalApps, String language) {
        Map map;
        if (gBFSRentalApps == null) {
            return null;
        }
        GBFSRentalApps gBFSRentalApps1 = new GBFSRentalApps();
        gBFSRentalApps1.setAndroid(this.gBFSAndroidToGBFSAndroid1(gBFSRentalApps.getAndroid(), language));
        gBFSRentalApps1.setIos(this.gBFSIosToGBFSIos1(gBFSRentalApps.getIos(), language));
        if (gBFSRentalApps1.getAdditionalProperties() != null && (map = gBFSRentalApps.getAdditionalProperties()) != null) {
            gBFSRentalApps1.getAdditionalProperties().putAll(map);
        }
        return gBFSRentalApps1;
    }
}

