/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.validation.validator.rules;

import com.jayway.jsonpath.Criteria;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.List;
import java.util.Map;
import org.entur.gbfs.validation.validator.rules.CustomRuleSchemaPatcher;
import org.json.JSONArray;
import org.json.JSONObject;

public class NoMissingCurrentRangeMetersInVehicleStatusForMotorizedVehicles
implements CustomRuleSchemaPatcher {
    private final String fileName;
    private static final Filter motorizedVehicleTypesFilter = Filter.filter((Predicate)Criteria.where((String)"propulsion_type").in(List.of("electric_assist", "electric", "combustion")));
    private static final String BIKE_ITEMS_SCHEMA_PATH = "$.properties.data.properties.bikes.items";
    private static final String VEHICLE_ITEMS_SCHEMA_PATH = "$.properties.data.properties.vehicles.items";

    public NoMissingCurrentRangeMetersInVehicleStatusForMotorizedVehicles(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public DocumentContext addRule(DocumentContext rawSchemaDocumentContext, Map<String, JSONObject> feeds) {
        JSONObject vehicleTypesFeed = feeds.get("vehicle_types");
        JSONArray motorizedVehicleTypeIds = null;
        if (vehicleTypesFeed != null) {
            motorizedVehicleTypeIds = (JSONArray)JsonPath.parse((Object)vehicleTypesFeed).read("$.data.vehicle_types[?].vehicle_type_id", new Predicate[]{motorizedVehicleTypesFilter});
        }
        String schemaPath = VEHICLE_ITEMS_SCHEMA_PATH;
        if (this.fileName.equals("free_bike_status")) {
            schemaPath = BIKE_ITEMS_SCHEMA_PATH;
        }
        JSONObject bikeItemsSchema = (JSONObject)rawSchemaDocumentContext.read(schemaPath, new Predicate[0]);
        if (motorizedVehicleTypeIds != null && motorizedVehicleTypeIds.length() > 0) {
            bikeItemsSchema.put("errorMessage", (Object)new JSONObject().put("required", (Object)new JSONObject().put("vehicle_type_id", (Object)"'vehicle_type_id' is required for this vehicle type")));
            bikeItemsSchema.put("if", (Object)new JSONObject().put("properties", (Object)new JSONObject().put("vehicle_type_id", (Object)new JSONObject().put("enum", (Object)motorizedVehicleTypeIds))).put("required", (Object)new JSONArray().put((Object)"vehicle_type_id"))).put("then", (Object)new JSONObject().put("required", (Object)new JSONArray().put((Object)"current_range_meters")));
        }
        return rawSchemaDocumentContext.set(schemaPath, (Object)bikeItemsSchema, new Predicate[0]);
    }
}

