/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.validation.validator;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.entur.gbfs.validation.model.FileValidationError;
import org.entur.gbfs.validation.model.FileValidationResult;
import org.entur.gbfs.validation.validator.versions.Version;
import org.entur.gbfs.validation.validator.versions.VersionFactory;
import org.everit.json.schema.ValidationException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileValidator {
    private static final Logger logger = LoggerFactory.getLogger(FileValidator.class);
    private final Version version;
    private static final Map<String, FileValidator> FILE_VALIDATORS = new ConcurrentHashMap<String, FileValidator>();

    public static FileValidator getFileValidator(String detectedVersion) {
        if (FILE_VALIDATORS.containsKey(detectedVersion)) {
            return FILE_VALIDATORS.get(detectedVersion);
        }
        Version version = VersionFactory.createVersion(detectedVersion);
        FileValidator fileValidator = new FileValidator(version);
        FILE_VALIDATORS.put(detectedVersion, fileValidator);
        return fileValidator;
    }

    protected FileValidator(Version version) {
        this.version = version;
    }

    public FileValidationResult validate(String feedName, Map<String, JSONObject> feedMap) {
        if (this.version.getFileNames().contains(feedName)) {
            JSONObject feed = feedMap.get(feedName);
            FileValidationResult fileValidationResult = new FileValidationResult();
            fileValidationResult.setFile(feedName);
            fileValidationResult.setRequired(this.isRequired(feedName));
            fileValidationResult.setExists(feed != null);
            fileValidationResult.setSchema(this.version.getSchema(feedName, feedMap).toString());
            fileValidationResult.setFileContents(Optional.ofNullable(feed).map(JSONObject::toString).orElse(null));
            fileValidationResult.setVersion(this.version.getVersionString());
            try {
                this.version.validate(feedName, feedMap);
            }
            catch (ValidationException validationException) {
                fileValidationResult.setErrors(this.mapToValidationErrors(validationException));
                fileValidationResult.setErrorsCount(validationException.getViolationCount());
            }
            return fileValidationResult;
        }
        logger.warn("Schema not found for gbfs feed={} version={}", (Object)feedName, (Object)this.version.getVersionString());
        return null;
    }

    List<FileValidationError> mapToValidationErrors(ValidationException validationException) {
        if (validationException.getCausingExceptions().isEmpty()) {
            FileValidationError error = new FileValidationError();
            error.setSchemaPath(validationException.getSchemaLocation());
            error.setViolationPath(validationException.getPointerToViolation());
            error.setMessage(validationException.getMessage());
            return Collections.singletonList(error);
        }
        return validationException.getCausingExceptions().stream().map(this::mapToValidationErrors).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private boolean isRequired(String feedName) {
        return this.version.isFileRequired(feedName);
    }

    public void validateMissingFile(FileValidationResult fvr) {
        if (this.version.getFileNames().contains(fvr.getFile())) {
            fvr.setVersion(this.version.getVersionString());
            fvr.setSchema(this.version.getSchema(fvr.getFile()).toString());
            fvr.setRequired(this.version.isFileRequired(fvr.getFile()));
        }
    }
}

