/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.validation.validator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.entur.gbfs.validation.GbfsValidator;
import org.entur.gbfs.validation.model.FileValidationResult;
import org.entur.gbfs.validation.model.ValidationResult;
import org.entur.gbfs.validation.model.ValidationSummary;
import org.entur.gbfs.validation.validator.FileValidator;
import org.entur.gbfs.validation.validator.versions.Version;
import org.entur.gbfs.validation.validator.versions.VersionFactory;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GbfsJsonValidator
implements GbfsValidator {
    private static final Logger LOG = LoggerFactory.getLogger(GbfsJsonValidator.class);
    private static final String DEFAULT_VERSION = "2.3";
    private static final List<String> FEEDS = Arrays.asList("gbfs", "gbfs_versions", "system_information", "vehicle_types", "station_information", "station_status", "free_bike_status", "vehicle_status", "system_hours", "system_alerts", "system_alerts", "system_calendar", "system_regions", "system_pricing_plans", "geofencing_zones");

    @Override
    public ValidationResult validate(Map<String, InputStream> rawFeeds) {
        Map<String, JSONObject> feedMap = this.parseFeeds(rawFeeds);
        ValidationResult result = new ValidationResult();
        ValidationSummary summary = new ValidationSummary();
        HashMap<String, FileValidationResult> fileValidations = new HashMap<String, FileValidationResult>();
        FEEDS.forEach(feed -> fileValidations.put((String)feed, this.validateFile((String)feed, feedMap)));
        Version version = this.findVersion(fileValidations);
        this.handleMissingFiles(fileValidations, version);
        summary.setVersion(version.getVersionString());
        summary.setTimestamp(System.currentTimeMillis());
        summary.setErrorsCount(fileValidations.values().stream().filter(Objects::nonNull).map(FileValidationResult::getErrorsCount).reduce(Integer::sum).orElse(0));
        result.setSummary(summary);
        result.setFiles(fileValidations);
        return result;
    }

    @Override
    public FileValidationResult validateFile(String fileName, InputStream file) {
        return this.validateFile(fileName, Map.of(fileName, new JSONObject(new JSONTokener(file))));
    }

    private void handleMissingFiles(Map<String, FileValidationResult> fileValidations, Version version) {
        FileValidator fileValidator = FileValidator.getFileValidator(version.getVersionString());
        fileValidations.values().stream().filter(fvr -> !fvr.isExists()).forEach(fileValidator::validateMissingFile);
    }

    private Version findVersion(Map<String, FileValidationResult> fileValidations) {
        Set versions = fileValidations.values().stream().filter(Objects::nonNull).map(FileValidationResult::getVersion).filter(Objects::nonNull).collect(Collectors.toSet());
        if (versions.size() > 1) {
            LOG.warn("Found multiple versions in files while during validation: {}", versions);
        }
        return VersionFactory.createVersion(versions.stream().findFirst().orElse(DEFAULT_VERSION));
    }

    private FileValidationResult validateFile(String feedName, Map<String, JSONObject> feedMap) {
        JSONObject feed = feedMap.get(feedName);
        if (feed == null) {
            FileValidationResult result = new FileValidationResult();
            result.setFile(feedName);
            result.setExists(false);
            return result;
        }
        String detectedVersion = "1.0";
        if (feed.has("version")) {
            detectedVersion = feed.getString("version");
        }
        FileValidator fileValidator = FileValidator.getFileValidator(detectedVersion);
        return fileValidator.validate(feedName, feedMap);
    }

    private Map<String, JSONObject> parseFeeds(Map<String, InputStream> rawFeeds) {
        HashMap<String, JSONObject> feedMap = new HashMap<String, JSONObject>();
        rawFeeds.forEach((name, value) -> feedMap.put((String)name, this.parseFeed((InputStream)value)));
        return feedMap;
    }

    private JSONObject parseFeed(InputStream raw) {
        String asString = this.getFeedAsString(raw);
        return new JSONObject(asString);
    }

    private String getFeedAsString(InputStream rawFeed) {
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(rawFeed));){
            String line;
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
        }
        catch (IOException e) {
            return null;
        }
        return stringBuilder.toString();
    }
}

