/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.validation.validator.versions;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.spi.json.JsonOrgJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JsonOrgMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.io.InputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.entur.gbfs.validation.validator.FileValidator;
import org.entur.gbfs.validation.validator.URIFormatValidator;
import org.entur.gbfs.validation.validator.rules.CustomRuleSchemaPatcher;
import org.entur.gbfs.validation.validator.versions.Version;
import org.everit.json.schema.FormatValidator;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractVersion
implements Version {
    private static final Logger logger = LoggerFactory.getLogger(AbstractVersion.class);
    private final String versionString;
    private final List<String> feeds;
    private Map<String, JSONObject> schemas = new ConcurrentHashMap<String, JSONObject>();
    private final Map<String, List<CustomRuleSchemaPatcher>> customRules;

    protected AbstractVersion(String versionString, List<String> feeds, Map<String, List<CustomRuleSchemaPatcher>> customRules) {
        this.versionString = versionString;
        this.feeds = feeds;
        this.customRules = customRules;
    }

    protected AbstractVersion(String versionString, List<String> feeds) {
        this.versionString = versionString;
        this.feeds = feeds;
        this.customRules = Map.of();
    }

    @Override
    public String getVersionString() {
        return this.versionString;
    }

    @Override
    public List<String> getFileNames() {
        return this.feeds;
    }

    @Override
    public boolean isFileRequired(String file) {
        return "system_information".equals(file);
    }

    @Override
    public void validate(String fileName, Map<String, JSONObject> feedMap) throws ValidationException {
        this.getSchema(fileName, feedMap).validate((Object)feedMap.get(fileName));
    }

    @Override
    public Schema getSchema(String feedName, Map<String, JSONObject> feedMap) {
        return this.loadSchema(this.applyCustomRules(feedName, this.getRawSchema(feedName), feedMap));
    }

    @Override
    public Schema getSchema(String feedName) {
        return this.loadSchema(this.getRawSchema(feedName));
    }

    private JSONObject getRawSchema(String feedName) {
        return this.schemas.computeIfAbsent(feedName, this::loadRawSchema);
    }

    private JSONObject applyCustomRules(String feedName, JSONObject rawSchema, Map<String, JSONObject> feedMap) {
        return this.getCustomRules(feedName).stream().reduce(rawSchema, (schema, patcher) -> this.applyRule((JSONObject)schema, (CustomRuleSchemaPatcher)patcher, feedMap), (a, b) -> a);
    }

    private List<CustomRuleSchemaPatcher> getCustomRules(String fileName) {
        return Optional.ofNullable(this.customRules.get(fileName)).orElse(Collections.emptyList());
    }

    private JSONObject applyRule(JSONObject schema, CustomRuleSchemaPatcher patcher, Map<String, JSONObject> feedMap) {
        return (JSONObject)patcher.addRule(JsonPath.parse((Object)new JSONObject(schema.toMap())), feedMap).json();
    }

    private JSONObject loadRawSchema(String feedName) {
        InputStream inputStream = FileValidator.class.getClassLoader().getResourceAsStream("schema/v" + this.versionString + "/" + feedName + ".json");
        if (inputStream == null) {
            logger.warn("Unable to load schema version={} feedName={}", (Object)this.versionString, (Object)feedName);
            return null;
        }
        return new JSONObject(new JSONTokener(inputStream));
    }

    private Schema loadSchema(JSONObject rawSchema) {
        SchemaLoader schemaLoader = SchemaLoader.builder().enableOverrideOfBuiltInFormatValidators().addFormatValidator((FormatValidator)new URIFormatValidator()).schemaJson(rawSchema).build();
        return schemaLoader.load().build();
    }

    static {
        Configuration.setDefaults((Configuration.Defaults)new Configuration.Defaults(){
            final JsonProvider jsonProvider = new JsonOrgJsonProvider();
            final MappingProvider mappingProvider = new JsonOrgMappingProvider();

            public JsonProvider jsonProvider() {
                return this.jsonProvider;
            }

            public Set<Option> options() {
                return EnumSet.noneOf(Option.class);
            }

            public MappingProvider mappingProvider() {
                return this.mappingProvider;
            }
        });
    }
}

