/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.validation.validator.rules;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.Map;
import org.entur.gbfs.validation.validator.rules.CustomRuleSchemaPatcher;
import org.json.JSONArray;
import org.json.JSONObject;

public class NoInvalidReferenceToPricingPlansInVehicleTypes
implements CustomRuleSchemaPatcher {
    public static final String DEFAULT_PRICING_PLAN_ID_SCHEMA_PATH = "$.properties.data.properties.vehicle_types.items.properties.default_pricing_plan_id";
    public static final String PRICING_PLAN_IDS_SCHEMA_PATH = "$.properties.data.properties.vehicle_types.items.properties.pricing_plan_ids.items";

    @Override
    public DocumentContext addRule(DocumentContext rawSchemaDocumentContext, Map<String, JSONObject> feeds) {
        JSONObject pricingPlansFeed = feeds.get("system_pricing_plans");
        JSONObject defaultPricingPlanIdSchema = (JSONObject)rawSchemaDocumentContext.read(DEFAULT_PRICING_PLAN_ID_SCHEMA_PATH, new Predicate[0]);
        JSONObject pricingPlanIdsSchema = (JSONObject)rawSchemaDocumentContext.read(PRICING_PLAN_IDS_SCHEMA_PATH, new Predicate[0]);
        if (pricingPlansFeed != null) {
            JSONArray pricingPlanIds = (JSONArray)JsonPath.parse((Object)pricingPlansFeed).read("$.data.plans[*].plan_id", new Predicate[0]);
            defaultPricingPlanIdSchema.put("enum", (Object)pricingPlanIds);
            pricingPlanIdsSchema.put("enum", (Object)pricingPlanIds);
        }
        return rawSchemaDocumentContext.set(DEFAULT_PRICING_PLAN_ID_SCHEMA_PATH, (Object)defaultPricingPlanIdSchema, new Predicate[0]).set(PRICING_PLAN_IDS_SCHEMA_PATH, (Object)pricingPlanIdsSchema, new Predicate[0]);
    }
}

