/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.validation.validator.rules;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.Map;
import org.entur.gbfs.validation.validator.rules.CustomRuleSchemaPatcher;
import org.json.JSONArray;
import org.json.JSONObject;

public class NoMissingOrInvalidVehicleTypeIdInVehicleStatusWhenVehicleTypesExist
implements CustomRuleSchemaPatcher {
    private final String fileName;
    private static final String BIKE_ITEMS_SCHEMA_PATH = "$.properties.data.properties.bikes.items";
    private static final String VEHICLE_ITEMS_SCHEMA_PATH = "$.properties.data.properties.vehicles.items";

    public NoMissingOrInvalidVehicleTypeIdInVehicleStatusWhenVehicleTypesExist(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public DocumentContext addRule(DocumentContext rawSchemaDocumentContext, Map<String, JSONObject> feeds) {
        JSONObject vehicleTypesFeed = feeds.get("vehicle_types");
        String requiredPath = VEHICLE_ITEMS_SCHEMA_PATH;
        if (this.fileName.equals("free_bike_status")) {
            requiredPath = BIKE_ITEMS_SCHEMA_PATH;
        }
        JSONObject vehicleItemsSchema = (JSONObject)rawSchemaDocumentContext.read(requiredPath, new Predicate[0]);
        if (vehicleTypesFeed != null) {
            vehicleItemsSchema.append("required", (Object)"vehicle_type_id");
        }
        JSONArray vehicleTypeIds = vehicleTypesFeed != null ? (JSONArray)JsonPath.parse((Object)vehicleTypesFeed).read("$.data.vehicle_types[*].vehicle_type_id", new Predicate[0]) : new JSONArray();
        vehicleItemsSchema.getJSONObject("properties").getJSONObject("vehicle_type_id").put("enum", (Object)vehicleTypeIds);
        return rawSchemaDocumentContext.set(requiredPath, (Object)vehicleItemsSchema, new Predicate[0]);
    }
}

