/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.validation.model;

import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import org.entur.gbfs.validation.model.FileValidationError;
import org.entur.gbfs.validation.model.ValidationResultComponentIdentity;

public record FileValidationResult(String file, boolean required, boolean exists, int errorsCount, String schema, String fileContents, String version, List<FileValidationError> errors) implements ValidationResultComponentIdentity<FileValidationResult>
{
    @Override
    public String toString() {
        return "FileValidationResult{file='" + this.file + "', required=" + this.required + ", exists=" + this.exists + ", errorsCount=" + this.errorsCount + ", schema='" + this.schema + "', fileContents='" + this.fileContents + "', version='" + this.version + "', errors=" + this.errors + "}";
    }

    @Override
    public boolean sameAs(FileValidationResult other) {
        if (other == null) {
            return false;
        }
        if (this.required != other.required) {
            return false;
        }
        if (this.exists != other.exists) {
            return false;
        }
        if (this.errorsCount != other.errorsCount) {
            return false;
        }
        if (!Objects.equals(this.file, other.file)) {
            return false;
        }
        if (!Objects.equals(this.version, other.version)) {
            return false;
        }
        return IntStream.range(0, this.errors.size()).allMatch(i -> this.errors.get(i).sameAs(other.errors.get(i)));
    }
}

