/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.validation.validator;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.entur.gbfs.validation.model.FileValidationError;
import org.entur.gbfs.validation.model.FileValidationResult;
import org.entur.gbfs.validation.validator.versions.Version;
import org.entur.gbfs.validation.validator.versions.VersionFactory;
import org.everit.json.schema.ValidationException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileValidator {
    private static final Logger logger = LoggerFactory.getLogger(FileValidator.class);
    private final Version version;
    private static final Map<String, FileValidator> FILE_VALIDATORS = new ConcurrentHashMap<String, FileValidator>();

    public static FileValidator getFileValidator(String detectedVersion) {
        if (FILE_VALIDATORS.containsKey(detectedVersion)) {
            return FILE_VALIDATORS.get(detectedVersion);
        }
        Version version = VersionFactory.createVersion(detectedVersion);
        FileValidator fileValidator = new FileValidator(version);
        FILE_VALIDATORS.put(detectedVersion, fileValidator);
        return fileValidator;
    }

    protected FileValidator(Version version) {
        this.version = version;
    }

    public FileValidationResult validate(String feedName, Map<String, JSONObject> feedMap) {
        if (this.version.getFileNames().contains(feedName)) {
            JSONObject feed = feedMap.get(feedName);
            int errorsCount = 0;
            List<FileValidationError> validationErrors = List.of();
            try {
                this.version.validate(feedName, feedMap);
            }
            catch (ValidationException validationException) {
                errorsCount = validationException.getViolationCount();
                validationErrors = this.mapToValidationErrors(validationException);
            }
            return new FileValidationResult(feedName, this.isRequired(feedName), feed != null, errorsCount, this.version.getSchema(feedName, feedMap).toString(), Optional.ofNullable(feed).map(JSONObject::toString).orElse(null), this.version.getVersionString(), validationErrors);
        }
        logger.warn("Schema not found for gbfs feed={} version={}", (Object)feedName, (Object)this.version.getVersionString());
        return null;
    }

    List<FileValidationError> mapToValidationErrors(ValidationException validationException) {
        if (validationException.getCausingExceptions().isEmpty()) {
            return List.of(new FileValidationError(validationException.getSchemaLocation(), validationException.getPointerToViolation(), validationException.getMessage()));
        }
        return validationException.getCausingExceptions().stream().map(this::mapToValidationErrors).flatMap(Collection::stream).toList();
    }

    private boolean isRequired(String feedName) {
        return this.version.isFileRequired(feedName);
    }

    public FileValidationResult validateMissingFile(String file) {
        boolean isRequired;
        return new FileValidationResult(file, isRequired, false, (isRequired = this.version.isFileRequired(file)) ? 1 : 0, this.version.getSchema(file).toString(), null, this.version.getVersionString(), List.of());
    }
}

