/*
 * Decompiled with CFR 0.152.
 */
package org.entur.gbfs.validation.validator.rules;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.Map;
import org.entur.gbfs.validation.validator.rules.CustomRuleSchemaPatcher;
import org.json.JSONArray;
import org.json.JSONObject;

public class NoInvalidReferenceToPricingPlansInVehicleStatus
implements CustomRuleSchemaPatcher {
    public static final String VEHICLE_PRICING_PLAN_ID_SCHEMA_PATH = "$.properties.data.properties.vehicles.items.properties.pricing_plan_id";
    public static final String BIKE_PRICING_PLAN_ID_SCHEMA_PATH = "$.properties.data.properties.bikes.items.properties.pricing_plan_id";
    private final String fileName;

    public NoInvalidReferenceToPricingPlansInVehicleStatus(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public DocumentContext addRule(DocumentContext rawSchemaDocumentContext, Map<String, JSONObject> feeds) {
        JSONObject pricingPlansFeed = feeds.get("system_pricing_plans");
        String requiredPath = VEHICLE_PRICING_PLAN_ID_SCHEMA_PATH;
        if (this.fileName.equals("free_bike_status")) {
            requiredPath = BIKE_PRICING_PLAN_ID_SCHEMA_PATH;
        }
        JSONObject pricingPlanIdSchema = (JSONObject)rawSchemaDocumentContext.read(requiredPath, new Predicate[0]);
        JSONArray pricingPlanIds = pricingPlansFeed != null ? (JSONArray)JsonPath.parse((Object)pricingPlansFeed).read("$.data.plans[*].plan_id", new Predicate[0]) : new JSONArray();
        pricingPlanIdSchema.put("enum", (Object)pricingPlanIds);
        return rawSchemaDocumentContext.set(requiredPath, (Object)pricingPlanIdSchema, new Predicate[0]);
    }
}

