/*
 * Decompiled with CFR 0.152.
 */
package org.entur.jwt.spring.test;

import java.util.HashMap;
import java.util.Map;
import org.entur.jwt.junit5.configuration.resolve.ResourceServerConfiguration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class JwtEnvironmentResourceServerConfiguration
implements ResourceServerConfiguration {
    private final Environment environment;
    private final String prefix;
    private final String enabled;

    public JwtEnvironmentResourceServerConfiguration(Environment environment, String propertyPrefix, String enabledPropertyName) {
        this.environment = environment;
        this.prefix = propertyPrefix;
        this.enabled = enabledPropertyName;
    }

    public String getProperty(String id, String propertyName) {
        if ((id == null || id.isEmpty()) && this.environment instanceof ConfigurableEnvironment) {
            ConfigurableEnvironment configurableEnvironment = (ConfigurableEnvironment)this.environment;
            MutablePropertySources propertySources = configurableEnvironment.getPropertySources();
            Map<String, String> props = this.extractEnabledProperty(propertySources, propertyName);
            if (props.size() == 1) {
                return props.entrySet().iterator().next().getValue();
            }
            throw new IllegalArgumentException("Authorization server id must be specified in token when using multiple (" + props.size() + ") tenants");
        }
        return this.environment.getProperty(this.prefix + "." + id + "." + propertyName);
    }

    public Map<String, String> extractEnabledProperty(MutablePropertySources sources, String propertyName) {
        HashMap<String, String> props = new HashMap<String, String>();
        for (PropertySource propertySource : sources) {
            if (!(propertySource instanceof EnumerablePropertySource)) continue;
            EnumerablePropertySource epSource = (EnumerablePropertySource)propertySource;
            for (String name : epSource.getPropertyNames()) {
                boolean enabled;
                if (!name.startsWith(this.prefix) || !name.endsWith(propertyName) || !(enabled = this.isNotDisabled(name))) continue;
                props.put(name, (String)this.environment.getProperty(name, String.class));
            }
        }
        return props;
    }

    private boolean isNotDisabled(String name) {
        int index = name.indexOf(46, this.prefix.length() + 1);
        String enabler = name.substring(0, index) + this.enabled;
        String nullOrEnabled = (String)this.environment.getProperty(enabler, String.class);
        boolean isEnabled = nullOrEnabled == null || !nullOrEnabled.equals("false");
        return isEnabled;
    }
}

