/*
 * Decompiled with CFR 0.152.
 */
package org.rutebanken.netex.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.rutebanken.netex.model.ObjectFactory;
import org.rutebanken.netex.model.PublicationDeliveryStructure;
import org.rutebanken.netex.validation.NeTExValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class PublicationDeliveryClient {
    private static final Logger logger = LoggerFactory.getLogger(PublicationDeliveryClient.class);
    private final ObjectFactory objectFactory = new ObjectFactory();
    private final String publicationDeliveryUrl;
    private final JAXBContext jaxbContext;
    private final boolean validateAgainstSchema;
    private NeTExValidator neTExValidator = null;

    public PublicationDeliveryClient(String publicationDeliveryUrl, boolean validateAgainstSchema) throws JAXBException, IOException, SAXException {
        this.publicationDeliveryUrl = publicationDeliveryUrl;
        this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{PublicationDeliveryStructure.class});
        this.validateAgainstSchema = validateAgainstSchema;
        if (validateAgainstSchema) {
            this.neTExValidator = new NeTExValidator();
        }
    }

    public PublicationDeliveryClient(String publicationDeliveryUrl) throws JAXBException, IOException, SAXException {
        this(publicationDeliveryUrl, false);
    }

    public PublicationDeliveryStructure sendPublicationDelivery(PublicationDeliveryStructure publicationDelivery) throws JAXBException, IOException, SAXException {
        Marshaller marshaller = this.jaxbContext.createMarshaller();
        Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        if (this.validateAgainstSchema) {
            marshaller.setSchema(this.neTExValidator.getSchema());
        }
        URL url = new URL(this.publicationDeliveryUrl);
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-type", "application/xml");
            connection.setDoOutput(true);
            logger.info("About to start marshalling publication delivery to output stream {}", (Object)publicationDelivery);
            marshaller.marshal(this.objectFactory.createPublicationDelivery(publicationDelivery), connection.getOutputStream());
            logger.info("Done marshalling publication delivery to output stream. (Schema validation was set to {}) {}", (Object)this.validateAgainstSchema, (Object)publicationDelivery);
            int responseCode = connection.getResponseCode();
            logger.info("Got response code {} after posting publication delivery to URL : {}", (Object)responseCode, (Object)url);
            InputStream inputStream = connection.getInputStream();
            JAXBElement element = (JAXBElement)unmarshaller.unmarshal(inputStream);
            PublicationDeliveryStructure publicationDeliveryStructure = (PublicationDeliveryStructure)element.getValue();
            return publicationDeliveryStructure;
        }
        catch (Exception e) {
            throw new IOException("Error posting XML to " + this.publicationDeliveryUrl, e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

