/*
 * Decompiled with CFR 0.152.
 */
package org.rutebanken.netex.validation;

import java.io.IOException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class NeTExValidator {
    private static final Logger logger = LoggerFactory.getLogger(NeTExValidator.class);
    private final Schema neTExSchema;
    public static final NetexVersion LATEST = NetexVersion.v1_0_8;

    public NeTExValidator() throws IOException, SAXException {
        this(LATEST);
    }

    public NeTExValidator(NetexVersion version) throws IOException, SAXException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        String resourceName = "xsd/" + (Object)((Object)version) + "/NeTEx_publication.xsd";
        logger.info("Loading resource: {}", (Object)resourceName);
        URL resource = this.getClass().getClassLoader().getResource(resourceName);
        if (resource == null) {
            throw new IOException("Cannot load resource " + resourceName);
        }
        this.neTExSchema = factory.newSchema(resource);
    }

    public Schema getSchema() throws SAXException, IOException {
        return this.neTExSchema;
    }

    public void validate(Source source) throws IOException, SAXException {
        Validator validator = this.neTExSchema.newValidator();
        validator.validate(source);
    }

    public static enum NetexVersion {
        V1_0_4beta("1.04beta"),
        V1_0_7("1.07"),
        v1_0_8("1.08");

        private final String folderName;

        private NetexVersion(String folderName) {
            this.folderName = folderName;
        }

        public String toString() {
            return this.folderName;
        }
    }
}

