/*
 * Decompiled with CFR 0.152.
 */
package org.rutebanken.netex.validation;

import java.io.IOException;
import java.net.URL;
import java.util.EnumMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class NeTExValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(NeTExValidator.class);
    private final Schema neTExSchema;
    public static final NetexVersion LATEST = NetexVersion.v1_14;
    private static final Map<NetexVersion, NeTExValidator> VALIDATORS_PER_VERSION = new EnumMap<NetexVersion, NeTExValidator>(NetexVersion.class);

    private static synchronized NeTExValidator createValidator(NetexVersion version) throws IOException, SAXException {
        NeTExValidator validator = VALIDATORS_PER_VERSION.get((Object)version);
        if (validator == null) {
            validator = new NeTExValidator(version);
            VALIDATORS_PER_VERSION.put(version, validator);
        }
        return validator;
    }

    public static NeTExValidator getNeTExValidator(NetexVersion version) throws IOException, SAXException {
        NeTExValidator validator;
        if (version == null) {
            version = LATEST;
        }
        if ((validator = VALIDATORS_PER_VERSION.get((Object)version)) == null) {
            validator = NeTExValidator.createValidator(version);
        }
        return validator;
    }

    public static NeTExValidator getNeTExValidator() throws IOException, SAXException {
        return NeTExValidator.getNeTExValidator(null);
    }

    public NeTExValidator() throws IOException, SAXException {
        this(LATEST);
    }

    public NeTExValidator(NetexVersion version) throws IOException, SAXException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        String resourceName = "xsd/" + version + "/NeTEx_publication.xsd";
        LOGGER.info("Loading resource: {}", (Object)resourceName);
        URL resource = this.getClass().getClassLoader().getResource(resourceName);
        if (resource == null) {
            throw new IOException("Cannot load resource " + resourceName);
        }
        this.neTExSchema = factory.newSchema(resource);
    }

    public Schema getSchema() {
        return this.neTExSchema;
    }

    public void validate(Source source) throws IOException, SAXException {
        Validator validator = this.neTExSchema.newValidator();
        validator.validate(source);
    }

    public static enum NetexVersion {
        V1_0_4beta("1.04beta"),
        V1_0_7("1.07"),
        v1_0_8("1.08"),
        v1_0_9("1.09"),
        v1_10("1.10"),
        v1_11("1.11"),
        v1_12("1.12"),
        v1_13("1.13"),
        v1_14("1.14");

        private final String folderName;

        private NetexVersion(String folderName) {
            this.folderName = folderName;
        }

        public String toString() {
            return this.folderName;
        }
    }
}

