/*
 * Decompiled with CFR 0.152.
 */
package org.rutebanken.util;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;

public class LocalDateXmlAdapter
extends XmlAdapter<String, LocalDateTime> {
    private static final DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd").optionalStart().appendPattern("XXXXX").optionalEnd().parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).parseDefaulting(ChronoField.OFFSET_SECONDS, OffsetDateTime.now().getLong(ChronoField.OFFSET_SECONDS)).toFormatter();

    public LocalDateTime unmarshal(String inputDate) {
        return LocalDateTime.parse(inputDate, formatter);
    }

    public String marshal(LocalDateTime inputDate) {
        if (inputDate != null) {
            return formatter.format(inputDate);
        }
        return null;
    }
}

