/*
 * Decompiled with CFR 0.152.
 */
package org.entur.netex.loader.parser;

import java.util.Collection;
import org.entur.netex.index.api.NetexEntitiesIndex;
import org.rutebanken.netex.model.VersionFrame_VersionStructure;
import org.slf4j.Logger;

abstract class NetexParser<T> {
    NetexParser() {
    }

    abstract void parse(T var1);

    abstract void setResultOnIndex(NetexEntitiesIndex var1);

    static void verifyCommonUnusedPropertiesIsNotSet(Logger log, VersionFrame_VersionStructure rel) {
        NetexParser.informOnElementIntentionallySkipped(log, rel.getTypeOfFrameRef());
        NetexParser.informOnElementIntentionallySkipped(log, rel.getBaselineVersionFrameRef());
        NetexParser.informOnElementIntentionallySkipped(log, rel.getCodespaces());
        NetexParser.informOnElementIntentionallySkipped(log, rel.getFrameDefaults());
        NetexParser.informOnElementIntentionallySkipped(log, rel.getVersions());
        NetexParser.informOnElementIntentionallySkipped(log, rel.getTraces());
        NetexParser.informOnElementIntentionallySkipped(log, rel.getContentValidityConditions());
        NetexParser.informOnElementIntentionallySkipped(log, rel.getKeyList());
        NetexParser.informOnElementIntentionallySkipped(log, rel.getExtensions());
        NetexParser.informOnElementIntentionallySkipped(log, rel.getBrandingRef());
    }

    static void informOnElementIntentionallySkipped(Logger log, Object rel) {
        if (rel == null) {
            return;
        }
        if (rel instanceof Collection) {
            throw new IllegalArgumentException("Do not pass in collections to this method.");
        }
        log.info("Netex import - Element skipped: {}", (Object)rel.getClass().getName());
    }
}

