/*
 * Decompiled with CFR 0.152.
 */
package org.entur.avro.realtime.siri.converter.avro2jaxb;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.entur.avro.realtime.siri.converter.avro2jaxb.Avro2JaxbEnumConverter;
import org.entur.avro.realtime.siri.model.EstimatedCallRecord;
import org.entur.avro.realtime.siri.model.EstimatedJourneyVersionFrameRecord;
import org.entur.avro.realtime.siri.model.EstimatedTimetableDeliveryRecord;
import org.entur.avro.realtime.siri.model.EstimatedVehicleJourneyRecord;
import org.entur.avro.realtime.siri.model.FramedVehicleJourneyRefRecord;
import org.entur.avro.realtime.siri.model.PassengerCapacityRecord;
import org.entur.avro.realtime.siri.model.RecordedCallRecord;
import org.entur.avro.realtime.siri.model.StopAssignmentRecord;
import org.entur.avro.realtime.siri.model.VehicleModeEnum;
import org.entur.avro.realtime.siri.model.VehicleOccupancyRecord;
import uk.org.siri.siri21.ArrivalBoardingActivityEnumeration;
import uk.org.siri.siri21.BlockRefStructure;
import uk.org.siri.siri21.CallStatusEnumeration;
import uk.org.siri.siri21.CompoundTrainRef;
import uk.org.siri.siri21.DatedVehicleJourneyRef;
import uk.org.siri.siri21.DepartureBoardingActivityEnumeration;
import uk.org.siri.siri21.DestinationRef;
import uk.org.siri.siri21.DirectionRefStructure;
import uk.org.siri.siri21.EntranceToVehicleRef;
import uk.org.siri.siri21.EstimatedCall;
import uk.org.siri.siri21.EstimatedTimetableDeliveryStructure;
import uk.org.siri.siri21.EstimatedVehicleJourney;
import uk.org.siri.siri21.EstimatedVersionFrameStructure;
import uk.org.siri.siri21.GroupOfLinesRefStructure;
import uk.org.siri.siri21.JourneyPatternRef;
import uk.org.siri.siri21.JourneyPlaceRefStructure;
import uk.org.siri.siri21.LineRef;
import uk.org.siri.siri21.NaturalLanguagePlaceNameStructure;
import uk.org.siri.siri21.NaturalLanguageStringStructure;
import uk.org.siri.siri21.OperatorRefStructure;
import uk.org.siri.siri21.PassengerCapacityStructure;
import uk.org.siri.siri21.ProductCategoryRefStructure;
import uk.org.siri.siri21.QuayRefStructure;
import uk.org.siri.siri21.RecordedCall;
import uk.org.siri.siri21.RouteRefStructure;
import uk.org.siri.siri21.ServiceFeatureRef;
import uk.org.siri.siri21.StopAssignmentStructure;
import uk.org.siri.siri21.StopPointRefStructure;
import uk.org.siri.siri21.TrainComponentRef;
import uk.org.siri.siri21.TrainRef;
import uk.org.siri.siri21.VehicleFeatureRefStructure;
import uk.org.siri.siri21.VehicleJourneyRef;
import uk.org.siri.siri21.VehicleModesEnumeration;
import uk.org.siri.siri21.VehicleOccupancyStructure;
import uk.org.siri.siri21.VehicleRef;

public class EstimatedTimetableDeliveryConverter
extends Avro2JaxbEnumConverter {
    static List<EstimatedTimetableDeliveryStructure> convert(List<EstimatedTimetableDeliveryRecord> estimatedTimetableDeliveries) {
        ArrayList<EstimatedTimetableDeliveryStructure> results = new ArrayList<EstimatedTimetableDeliveryStructure>();
        for (EstimatedTimetableDeliveryRecord delivery : estimatedTimetableDeliveries) {
            EstimatedTimetableDeliveryStructure estimatedTimetableDeliveryStructure = new EstimatedTimetableDeliveryStructure();
            estimatedTimetableDeliveryStructure.setResponseTimestamp(EstimatedTimetableDeliveryConverter.convertDate(delivery.getResponseTimestamp()));
            estimatedTimetableDeliveryStructure.setVersion(delivery.getVersion().toString());
            for (EstimatedJourneyVersionFrameRecord versionFrame : delivery.getEstimatedJourneyVersionFrames()) {
                estimatedTimetableDeliveryStructure.getEstimatedJourneyVersionFrames().add(EstimatedTimetableDeliveryConverter.convert(versionFrame));
            }
            results.add(estimatedTimetableDeliveryStructure);
        }
        return results;
    }

    private static EstimatedVersionFrameStructure convert(EstimatedJourneyVersionFrameRecord versionFrame) {
        EstimatedVersionFrameStructure estimatedVersionFrameStructure = new EstimatedVersionFrameStructure();
        estimatedVersionFrameStructure.setRecordedAtTime(EstimatedTimetableDeliveryConverter.convertDate(versionFrame.getRecordedAtTime()));
        estimatedVersionFrameStructure.getEstimatedVehicleJourneies().addAll(EstimatedTimetableDeliveryConverter.convertVehicleJourneys(versionFrame.getEstimatedVehicleJourneys()));
        return estimatedVersionFrameStructure;
    }

    private static List<EstimatedVehicleJourney> convertVehicleJourneys(List<EstimatedVehicleJourneyRecord> estimatedVehicleJourneies) {
        ArrayList<EstimatedVehicleJourney> estimatedVehicleJourneyRecords = new ArrayList<EstimatedVehicleJourney>();
        for (EstimatedVehicleJourneyRecord estimatedVehicleJourney : estimatedVehicleJourneies) {
            estimatedVehicleJourneyRecords.add(EstimatedTimetableDeliveryConverter.convert(estimatedVehicleJourney));
        }
        return estimatedVehicleJourneyRecords;
    }

    static EstimatedVehicleJourney convert(EstimatedVehicleJourneyRecord estimatedVehicleJourney) {
        EstimatedVehicleJourney mapped = new EstimatedVehicleJourney();
        if (estimatedVehicleJourney.getRecordedAtTime() != null) {
            mapped.setRecordedAtTime(EstimatedTimetableDeliveryConverter.convertDate(estimatedVehicleJourney.getRecordedAtTime()));
        }
        if (estimatedVehicleJourney.getLineRef() != null) {
            mapped.setLineRef(EstimatedTimetableDeliveryConverter.setValue(LineRef.class, estimatedVehicleJourney.getLineRef()));
        }
        if (estimatedVehicleJourney.getCancellation() != null) {
            mapped.setCancellation(estimatedVehicleJourney.getCancellation());
        }
        if (estimatedVehicleJourney.getExtraJourney() != null) {
            mapped.setExtraJourney(estimatedVehicleJourney.getExtraJourney());
        }
        if (estimatedVehicleJourney.getPredictionInaccurate() != null) {
            mapped.setPredictionInaccurate(estimatedVehicleJourney.getPredictionInaccurate());
        }
        if (estimatedVehicleJourney.getDirectionRef() != null) {
            mapped.setDirectionRef(EstimatedTimetableDeliveryConverter.setValue(DirectionRefStructure.class, estimatedVehicleJourney.getDirectionRef()));
        }
        if (estimatedVehicleJourney.getDatedVehicleJourneyRef() != null) {
            mapped.setDatedVehicleJourneyRef(EstimatedTimetableDeliveryConverter.setValue(DatedVehicleJourneyRef.class, estimatedVehicleJourney.getDatedVehicleJourneyRef()));
        }
        if (estimatedVehicleJourney.getFramedVehicleJourneyRef() != null) {
            mapped.setFramedVehicleJourneyRef(EstimatedTimetableDeliveryConverter.convert(estimatedVehicleJourney.getFramedVehicleJourneyRef()));
        }
        if (estimatedVehicleJourney.getEstimatedVehicleJourneyCode() != null) {
            mapped.setEstimatedVehicleJourneyCode(estimatedVehicleJourney.getEstimatedVehicleJourneyCode().toString());
        }
        if (estimatedVehicleJourney.getJourneyPatternRef() != null) {
            mapped.setJourneyPatternRef(EstimatedTimetableDeliveryConverter.setValue(JourneyPatternRef.class, estimatedVehicleJourney.getJourneyPatternRef()));
        }
        if (estimatedVehicleJourney.getRouteRef() != null) {
            mapped.setRouteRef(EstimatedTimetableDeliveryConverter.setValue(RouteRefStructure.class, estimatedVehicleJourney.getRouteRef()));
        }
        if (!EstimatedTimetableDeliveryConverter.isNullOrEmpty(estimatedVehicleJourney.getPublishedLineNames())) {
            mapped.getPublishedLineNames().addAll(EstimatedTimetableDeliveryConverter.setTranslatedValues(NaturalLanguageStringStructure.class, estimatedVehicleJourney.getPublishedLineNames()));
        }
        if (!EstimatedTimetableDeliveryConverter.isNullOrEmpty(estimatedVehicleJourney.getDestinationDisplayAtOrigins())) {
            mapped.getDestinationDisplayAtOrigins().addAll(EstimatedTimetableDeliveryConverter.setTranslatedValues(NaturalLanguagePlaceNameStructure.class, estimatedVehicleJourney.getDestinationDisplayAtOrigins()));
        }
        if (estimatedVehicleJourney.getGroupOfLinesRef() != null) {
            mapped.setGroupOfLinesRef(EstimatedTimetableDeliveryConverter.setValue(GroupOfLinesRefStructure.class, estimatedVehicleJourney.getGroupOfLinesRef()));
        }
        if (estimatedVehicleJourney.getExternalLineRef() != null) {
            mapped.setExternalLineRef(EstimatedTimetableDeliveryConverter.setValue(LineRef.class, estimatedVehicleJourney.getExternalLineRef()));
        }
        if (estimatedVehicleJourney.getVehicleModes() != null) {
            mapped.getVehicleModes().addAll(EstimatedTimetableDeliveryConverter.convertVehicleMode(estimatedVehicleJourney.getVehicleModes()));
        }
        if (!EstimatedTimetableDeliveryConverter.isNullOrEmpty(estimatedVehicleJourney.getOriginNames())) {
            mapped.getOriginNames().addAll(EstimatedTimetableDeliveryConverter.setTranslatedValues(NaturalLanguagePlaceNameStructure.class, estimatedVehicleJourney.getOriginNames()));
        }
        if (estimatedVehicleJourney.getOriginRef() != null) {
            mapped.setOriginRef(EstimatedTimetableDeliveryConverter.setValue(JourneyPlaceRefStructure.class, estimatedVehicleJourney.getOriginRef()));
        }
        if (!EstimatedTimetableDeliveryConverter.isNullOrEmpty(estimatedVehicleJourney.getDestinationNames())) {
            mapped.getDestinationNames().addAll(EstimatedTimetableDeliveryConverter.setTranslatedValues(NaturalLanguageStringStructure.class, estimatedVehicleJourney.getDestinationNames()));
        }
        if (estimatedVehicleJourney.getDestinationRef() != null) {
            mapped.setDestinationRef(EstimatedTimetableDeliveryConverter.setValue(DestinationRef.class, estimatedVehicleJourney.getDestinationRef()));
        }
        if (estimatedVehicleJourney.getOperatorRef() != null) {
            mapped.setOperatorRef(EstimatedTimetableDeliveryConverter.setValue(OperatorRefStructure.class, estimatedVehicleJourney.getOperatorRef()));
        }
        if (estimatedVehicleJourney.getOriginAimedDepartureTime() != null) {
            mapped.setOriginAimedDepartureTime(EstimatedTimetableDeliveryConverter.convertDate(estimatedVehicleJourney.getOriginAimedDepartureTime()));
        }
        if (estimatedVehicleJourney.getDestinationAimedArrivalTime() != null) {
            mapped.setDestinationAimedArrivalTime(EstimatedTimetableDeliveryConverter.convertDate(estimatedVehicleJourney.getDestinationAimedArrivalTime()));
        }
        if (estimatedVehicleJourney.getVehicleFeatureRefs() != null) {
            for (CharSequence ref : estimatedVehicleJourney.getVehicleFeatureRefs()) {
                mapped.getVehicleFeatureReves().add(EstimatedTimetableDeliveryConverter.setValue(VehicleFeatureRefStructure.class, ref));
            }
        }
        if (estimatedVehicleJourney.getProductCategoryRef() != null) {
            mapped.setProductCategoryRef(EstimatedTimetableDeliveryConverter.setValue(ProductCategoryRefStructure.class, estimatedVehicleJourney.getProductCategoryRef()));
        }
        if (estimatedVehicleJourney.getServiceFeatureRefs() != null) {
            for (CharSequence ref : estimatedVehicleJourney.getServiceFeatureRefs()) {
                mapped.getServiceFeatureReves().add(EstimatedTimetableDeliveryConverter.setValue(ServiceFeatureRef.class, ref));
            }
        }
        if (estimatedVehicleJourney.getMonitored() != null) {
            mapped.setMonitored(estimatedVehicleJourney.getMonitored());
        }
        if (estimatedVehicleJourney.getExtraJourney() != null) {
            mapped.setExtraJourney(estimatedVehicleJourney.getExtraJourney());
        }
        if (estimatedVehicleJourney.getDataSource() != null) {
            mapped.setDataSource(estimatedVehicleJourney.getDataSource().toString());
        }
        if (estimatedVehicleJourney.getOccupancy() != null) {
            mapped.setOccupancy(EstimatedTimetableDeliveryConverter.convert(estimatedVehicleJourney.getOccupancy()));
        }
        if (estimatedVehicleJourney.getBlockRef() != null) {
            mapped.setBlockRef(EstimatedTimetableDeliveryConverter.setValue(BlockRefStructure.class, estimatedVehicleJourney.getBlockRef()));
        }
        if (estimatedVehicleJourney.getVehicleJourneyRef() != null) {
            mapped.setVehicleJourneyRef(EstimatedTimetableDeliveryConverter.setValue(VehicleJourneyRef.class, estimatedVehicleJourney.getVehicleJourneyRef()));
        }
        if (!EstimatedTimetableDeliveryConverter.isNullOrEmpty(estimatedVehicleJourney.getAdditionalVehicleJourneyRef())) {
            for (FramedVehicleJourneyRefRecord refRecord : estimatedVehicleJourney.getAdditionalVehicleJourneyRef()) {
                mapped.getAdditionalVehicleJourneyReves().add(EstimatedTimetableDeliveryConverter.convert(refRecord));
            }
        }
        if (estimatedVehicleJourney.getVehicleRef() != null) {
            mapped.setVehicleRef(EstimatedTimetableDeliveryConverter.setValue(VehicleRef.class, estimatedVehicleJourney.getVehicleRef()));
        }
        if (!EstimatedTimetableDeliveryConverter.isNullOrEmpty(estimatedVehicleJourney.getRecordedCalls())) {
            mapped.setRecordedCalls(EstimatedTimetableDeliveryConverter.convertRecordedCalls(estimatedVehicleJourney.getRecordedCalls()));
        }
        if (!EstimatedTimetableDeliveryConverter.isNullOrEmpty(estimatedVehicleJourney.getEstimatedCalls())) {
            mapped.setEstimatedCalls(EstimatedTimetableDeliveryConverter.convertEstimatedCalls(estimatedVehicleJourney.getEstimatedCalls()));
        }
        if (estimatedVehicleJourney.getIsCompleteStopSequence() != null) {
            mapped.setIsCompleteStopSequence(estimatedVehicleJourney.getIsCompleteStopSequence());
        }
        return mapped;
    }

    private static EstimatedVehicleJourney.RecordedCalls convertRecordedCalls(List<RecordedCallRecord> calls) {
        ArrayList<RecordedCall> recordedCallList = new ArrayList<RecordedCall>();
        if (calls != null) {
            for (RecordedCallRecord call : calls) {
                recordedCallList.add(EstimatedTimetableDeliveryConverter.convert(call));
            }
        }
        if (EstimatedTimetableDeliveryConverter.isNullOrEmpty(recordedCallList)) {
            return null;
        }
        EstimatedVehicleJourney.RecordedCalls recordedCalls = new EstimatedVehicleJourney.RecordedCalls();
        recordedCalls.getRecordedCalls().addAll(recordedCallList);
        return recordedCalls;
    }

    private static EstimatedVehicleJourney.EstimatedCalls convertEstimatedCalls(List<EstimatedCallRecord> calls) {
        ArrayList<EstimatedCall> estimatedCallList = new ArrayList<EstimatedCall>();
        if (!EstimatedTimetableDeliveryConverter.isNullOrEmpty(calls)) {
            for (EstimatedCallRecord call : calls) {
                estimatedCallList.add(EstimatedTimetableDeliveryConverter.convert(call));
            }
        }
        EstimatedVehicleJourney.EstimatedCalls estimatedCalls = new EstimatedVehicleJourney.EstimatedCalls();
        estimatedCalls.getEstimatedCalls().addAll(estimatedCallList);
        return estimatedCalls;
    }

    private static Collection<VehicleModesEnumeration> convertVehicleMode(List<VehicleModeEnum> vehicleModes) {
        ArrayList<VehicleModesEnumeration> modes = new ArrayList<VehicleModesEnumeration>();
        for (VehicleModeEnum vehicleMode : vehicleModes) {
            modes.add(VehicleModesEnumeration.valueOf((String)vehicleMode.name()));
        }
        return modes;
    }

    private static RecordedCall convert(RecordedCallRecord call) {
        RecordedCall mapped = new RecordedCall();
        mapped.setStopPointRef(EstimatedTimetableDeliveryConverter.setValue(StopPointRefStructure.class, call.getStopPointRef()));
        if (!EstimatedTimetableDeliveryConverter.isNullOrEmpty(call.getStopPointNames())) {
            mapped.getStopPointNames().addAll(EstimatedTimetableDeliveryConverter.setTranslatedValues(NaturalLanguageStringStructure.class, call.getStopPointNames()));
        }
        if (call.getOrder() != null) {
            mapped.setOrder(BigInteger.valueOf(call.getOrder().intValue()));
        }
        if (call.getCancellation() != null) {
            mapped.setCancellation(call.getCancellation());
        }
        if (call.getRequestStop() != null) {
            mapped.setRequestStop(call.getRequestStop());
        }
        if (call.getExtraCall() != null) {
            mapped.setExtraCall(call.getExtraCall());
        }
        if (!EstimatedTimetableDeliveryConverter.isNullOrEmpty(call.getDestinationDisplays())) {
            mapped.getDestinationDisplaies().addAll(EstimatedTimetableDeliveryConverter.setTranslatedValues(NaturalLanguageStringStructure.class, call.getDestinationDisplays()));
        }
        if (call.getAimedArrivalTime() != null) {
            mapped.setAimedArrivalTime(EstimatedTimetableDeliveryConverter.convertDate(call.getAimedArrivalTime()));
        }
        if (call.getExpectedArrivalTime() != null) {
            mapped.setExpectedArrivalTime(EstimatedTimetableDeliveryConverter.convertDate(call.getExpectedArrivalTime()));
        }
        if (call.getActualArrivalTime() != null) {
            mapped.setActualArrivalTime(EstimatedTimetableDeliveryConverter.convertDate(call.getActualArrivalTime()));
        }
        if (call.getArrivalStatus() != null) {
            mapped.setArrivalStatus(CallStatusEnumeration.valueOf((String)call.getArrivalStatus().name()));
        }
        if (call.getArrivalBoardingActivity() != null) {
            mapped.setArrivalBoardingActivity(ArrivalBoardingActivityEnumeration.valueOf((String)call.getArrivalBoardingActivity().name()));
        }
        if (!EstimatedTimetableDeliveryConverter.isNullOrEmpty(call.getArrivalStopAssignments())) {
            mapped.getArrivalStopAssignments().addAll(EstimatedTimetableDeliveryConverter.convertStopAssignments(call.getArrivalStopAssignments()));
        }
        if (call.getArrivalPlatformName() != null) {
            mapped.setArrivalPlatformName(EstimatedTimetableDeliveryConverter.setValue(NaturalLanguageStringStructure.class, call.getArrivalPlatformName()));
        }
        if (call.getAimedDepartureTime() != null) {
            mapped.setAimedDepartureTime(EstimatedTimetableDeliveryConverter.convertDate(call.getAimedDepartureTime()));
        }
        if (call.getExpectedDepartureTime() != null) {
            mapped.setExpectedDepartureTime(EstimatedTimetableDeliveryConverter.convertDate(call.getExpectedDepartureTime()));
        }
        if (call.getActualDepartureTime() != null) {
            mapped.setActualDepartureTime(EstimatedTimetableDeliveryConverter.convertDate(call.getActualDepartureTime()));
        }
        if (call.getDeparturePlatformName() != null) {
            mapped.setDeparturePlatformName(EstimatedTimetableDeliveryConverter.setValue(NaturalLanguageStringStructure.class, call.getDeparturePlatformName()));
        }
        if (call.getDepartureStatus() != null) {
            mapped.setDepartureStatus(CallStatusEnumeration.valueOf((String)call.getDepartureStatus().name()));
        }
        if (call.getDepartureBoardingActivity() != null) {
            mapped.setDepartureBoardingActivity(DepartureBoardingActivityEnumeration.valueOf((String)call.getDepartureBoardingActivity().name()));
        }
        if (!EstimatedTimetableDeliveryConverter.isNullOrEmpty(call.getDepartureStopAssignments())) {
            mapped.getDepartureStopAssignments().addAll(EstimatedTimetableDeliveryConverter.convertStopAssignments(call.getDepartureStopAssignments()));
        }
        if (!EstimatedTimetableDeliveryConverter.isNullOrEmpty(call.getRecordedDepartureOccupancies())) {
            mapped.getRecordedDepartureOccupancies().addAll(EstimatedTimetableDeliveryConverter.convertOccupancies(call.getRecordedDepartureOccupancies()));
        }
        if (!EstimatedTimetableDeliveryConverter.isNullOrEmpty(call.getRecordedDepartureCapacities())) {
            mapped.getRecordedDepartureCapacities().addAll(EstimatedTimetableDeliveryConverter.convertCapacities(call.getRecordedDepartureCapacities()));
        }
        return mapped;
    }

    private static List<PassengerCapacityStructure> convertCapacities(List<PassengerCapacityRecord> capacities) {
        ArrayList<PassengerCapacityStructure> capacityStructures = new ArrayList<PassengerCapacityStructure>();
        if (!EstimatedTimetableDeliveryConverter.isNullOrEmpty(capacities)) {
            for (PassengerCapacityRecord capacity : capacities) {
                capacityStructures.add(EstimatedTimetableDeliveryConverter.convert(capacity));
            }
        }
        return capacityStructures;
    }

    private static PassengerCapacityStructure convert(PassengerCapacityRecord capacity) {
        PassengerCapacityStructure mapped = new PassengerCapacityStructure();
        mapped.setCompoundTrainRef(EstimatedTimetableDeliveryConverter.setValue(CompoundTrainRef.class, capacity.getCompoundTrainRef()));
        mapped.setTrainRef(EstimatedTimetableDeliveryConverter.setValue(TrainRef.class, capacity.getTrainRef()));
        mapped.setTrainComponentRef(EstimatedTimetableDeliveryConverter.setValue(TrainComponentRef.class, capacity.getTrainComponentRef()));
        mapped.setEntranceToVehicleRef(EstimatedTimetableDeliveryConverter.setValue(EntranceToVehicleRef.class, capacity.getEntranceToVehicleRef()));
        mapped.setPassengerCategory(EstimatedTimetableDeliveryConverter.setValue(NaturalLanguageStringStructure.class, capacity.getPassengerCategory()));
        mapped.setTotalCapacity(EstimatedTimetableDeliveryConverter.convert(capacity.getTotalCapacity()));
        mapped.setSeatingCapacity(EstimatedTimetableDeliveryConverter.convert(capacity.getSeatingCapacity()));
        mapped.setStandingCapacity(EstimatedTimetableDeliveryConverter.convert(capacity.getStandingCapacity()));
        mapped.setPushchairCapacity(EstimatedTimetableDeliveryConverter.convert(capacity.getPushchairCapacity()));
        mapped.setWheelchairPlaceCapacity(EstimatedTimetableDeliveryConverter.convert(capacity.getWheelchairPlaceCapacity()));
        mapped.setPramPlaceCapacity(EstimatedTimetableDeliveryConverter.convert(capacity.getPramPlaceCapacity()));
        mapped.setBicycleRackCapacity(EstimatedTimetableDeliveryConverter.convert(capacity.getBicycleRackCapacity()));
        return mapped;
    }

    private static List<VehicleOccupancyStructure> convertOccupancies(List<VehicleOccupancyRecord> occupancies) {
        ArrayList<VehicleOccupancyStructure> vehicleOccupancies = new ArrayList<VehicleOccupancyStructure>();
        if (!EstimatedTimetableDeliveryConverter.isNullOrEmpty(occupancies)) {
            for (VehicleOccupancyRecord occupancy : occupancies) {
                vehicleOccupancies.add(EstimatedTimetableDeliveryConverter.convert(occupancy));
            }
        }
        return vehicleOccupancies;
    }

    private static VehicleOccupancyStructure convert(VehicleOccupancyRecord occupancy) {
        VehicleOccupancyStructure mapped = new VehicleOccupancyStructure();
        mapped.setCompoundTrainRef(EstimatedTimetableDeliveryConverter.setValue(CompoundTrainRef.class, occupancy.getCompoundTrainRef()));
        mapped.setTrainRef(EstimatedTimetableDeliveryConverter.setValue(TrainRef.class, occupancy.getTrainRef()));
        mapped.setTrainComponentRef(EstimatedTimetableDeliveryConverter.setValue(TrainComponentRef.class, occupancy.getTrainComponentRef()));
        mapped.setEntranceToVehicleRef(EstimatedTimetableDeliveryConverter.setValue(EntranceToVehicleRef.class, occupancy.getEntranceToVehicleRef()));
        mapped.setPassengerCategory(EstimatedTimetableDeliveryConverter.setValue(NaturalLanguageStringStructure.class, occupancy.getPassengerCategory()));
        mapped.setOccupancyLevel(EstimatedTimetableDeliveryConverter.convert(occupancy.getOccupancyLevel()));
        mapped.setOccupancyPercentage(EstimatedTimetableDeliveryConverter.convert(occupancy.getOccupancyPercentage()));
        mapped.setAlightingCount(EstimatedTimetableDeliveryConverter.convert(occupancy.getAlightingCount()));
        mapped.setBoardingCount(EstimatedTimetableDeliveryConverter.convert(occupancy.getBoardingCount()));
        mapped.setOnboardCount(EstimatedTimetableDeliveryConverter.convert(occupancy.getOnboardCount()));
        mapped.setPushchairsOnboardCount(EstimatedTimetableDeliveryConverter.convert(occupancy.getPushchairsOnboardCount()));
        mapped.setWheelchairsOnboardCount(EstimatedTimetableDeliveryConverter.convert(occupancy.getWheelchairsOnboardCount()));
        mapped.setPramsOnboardCount(EstimatedTimetableDeliveryConverter.convert(occupancy.getPramsOnboardCount()));
        mapped.setBicycleOnboardCount(EstimatedTimetableDeliveryConverter.convert(occupancy.getBicycleOnboardCount()));
        mapped.setTotalNumberOfReservedSeats(EstimatedTimetableDeliveryConverter.convert(occupancy.getTotalNumberOfReservedSeats()));
        return mapped;
    }

    private static EstimatedCall convert(EstimatedCallRecord call) {
        EstimatedCall mapped = new EstimatedCall();
        mapped.setStopPointRef(EstimatedTimetableDeliveryConverter.setValue(StopPointRefStructure.class, call.getStopPointRef()));
        if (!EstimatedTimetableDeliveryConverter.isNullOrEmpty(call.getStopPointNames())) {
            mapped.getStopPointNames().addAll(EstimatedTimetableDeliveryConverter.setTranslatedValues(NaturalLanguageStringStructure.class, call.getStopPointNames()));
        }
        if (call.getOrder() != null) {
            mapped.setOrder(BigInteger.valueOf(call.getOrder().intValue()));
        }
        if (call.getCancellation() != null) {
            mapped.setCancellation(call.getCancellation());
        }
        if (call.getRequestStop() != null) {
            mapped.setRequestStop(call.getRequestStop());
        }
        if (call.getPredictionInaccurate() != null) {
            mapped.setPredictionInaccurate(call.getPredictionInaccurate());
        }
        if (call.getExtraCall() != null) {
            mapped.setExtraCall(call.getExtraCall());
        }
        if (!EstimatedTimetableDeliveryConverter.isNullOrEmpty(call.getDestinationDisplays())) {
            mapped.getDestinationDisplaies().addAll(EstimatedTimetableDeliveryConverter.setTranslatedValues(NaturalLanguageStringStructure.class, call.getDestinationDisplays()));
        }
        if (call.getAimedArrivalTime() != null) {
            mapped.setAimedArrivalTime(EstimatedTimetableDeliveryConverter.convertDate(call.getAimedArrivalTime()));
        }
        if (call.getExpectedArrivalTime() != null) {
            mapped.setExpectedArrivalTime(EstimatedTimetableDeliveryConverter.convertDate(call.getExpectedArrivalTime()));
        }
        if (call.getArrivalStatus() != null) {
            mapped.setArrivalStatus(CallStatusEnumeration.valueOf((String)call.getArrivalStatus().name()));
        }
        if (call.getArrivalBoardingActivity() != null) {
            mapped.setArrivalBoardingActivity(ArrivalBoardingActivityEnumeration.valueOf((String)call.getArrivalBoardingActivity().name()));
        }
        if (!EstimatedTimetableDeliveryConverter.isNullOrEmpty(call.getArrivalStopAssignments())) {
            mapped.getArrivalStopAssignments().addAll(EstimatedTimetableDeliveryConverter.convertStopAssignments(call.getArrivalStopAssignments()));
        }
        if (call.getArrivalPlatformName() != null) {
            mapped.setArrivalPlatformName(EstimatedTimetableDeliveryConverter.setValue(NaturalLanguageStringStructure.class, call.getArrivalPlatformName()));
        }
        if (call.getAimedDepartureTime() != null) {
            mapped.setAimedDepartureTime(EstimatedTimetableDeliveryConverter.convertDate(call.getAimedDepartureTime()));
        }
        if (call.getExpectedDepartureTime() != null) {
            mapped.setExpectedDepartureTime(EstimatedTimetableDeliveryConverter.convertDate(call.getExpectedDepartureTime()));
        }
        if (call.getDepartureStatus() != null) {
            mapped.setDepartureStatus(CallStatusEnumeration.valueOf((String)call.getDepartureStatus().name()));
        }
        if (call.getDepartureBoardingActivity() != null) {
            mapped.setDepartureBoardingActivity(DepartureBoardingActivityEnumeration.valueOf((String)call.getDepartureBoardingActivity().name()));
        }
        if (!EstimatedTimetableDeliveryConverter.isNullOrEmpty(call.getDepartureStopAssignments())) {
            mapped.getDepartureStopAssignments().addAll(EstimatedTimetableDeliveryConverter.convertStopAssignments(call.getDepartureStopAssignments()));
        }
        if (call.getDeparturePlatformName() != null) {
            mapped.setDeparturePlatformName(EstimatedTimetableDeliveryConverter.setValue(NaturalLanguageStringStructure.class, call.getDeparturePlatformName()));
        }
        if (!EstimatedTimetableDeliveryConverter.isNullOrEmpty(call.getExpectedDepartureOccupancies())) {
            mapped.getExpectedDepartureOccupancies().addAll(EstimatedTimetableDeliveryConverter.convertOccupancies(call.getExpectedDepartureOccupancies()));
        }
        if (!EstimatedTimetableDeliveryConverter.isNullOrEmpty(call.getExpectedDepartureCapacities())) {
            mapped.getExpectedDepartureCapacities().addAll(EstimatedTimetableDeliveryConverter.convertCapacities(call.getExpectedDepartureCapacities()));
        }
        return mapped;
    }

    private static List<StopAssignmentStructure> convertStopAssignments(List<StopAssignmentRecord> stopAssignmentRecords) {
        ArrayList<StopAssignmentStructure> stopAssignments = new ArrayList<StopAssignmentStructure>();
        if (!EstimatedTimetableDeliveryConverter.isNullOrEmpty(stopAssignmentRecords)) {
            for (StopAssignmentRecord assignmentRecord : stopAssignmentRecords) {
                stopAssignments.add(EstimatedTimetableDeliveryConverter.convert(assignmentRecord));
            }
        }
        return stopAssignments;
    }

    private static StopAssignmentStructure convert(StopAssignmentRecord stopAssignment) {
        StopAssignmentStructure stopAssignmentStructure = new StopAssignmentStructure();
        stopAssignmentStructure.setAimedQuayRef(EstimatedTimetableDeliveryConverter.setValue(QuayRefStructure.class, stopAssignment.getAimedQuayRef()));
        stopAssignmentStructure.setExpectedQuayRef(EstimatedTimetableDeliveryConverter.setValue(QuayRefStructure.class, stopAssignment.getExpectedQuayRef()));
        return stopAssignmentStructure;
    }
}

