/*
 * Decompiled with CFR 0.152.
 */
package org.entur.avro.realtime.siri.converter.avro2jaxb;

import java.util.List;
import org.entur.avro.realtime.siri.converter.CommonConverter;
import org.entur.avro.realtime.siri.converter.avro2jaxb.EstimatedTimetableDeliveryConverter;
import org.entur.avro.realtime.siri.converter.avro2jaxb.SituationExchangeDeliveryConverter;
import org.entur.avro.realtime.siri.converter.avro2jaxb.SubscriptionConverter;
import org.entur.avro.realtime.siri.converter.avro2jaxb.VehicleMonitoringDeliveryConverter;
import org.entur.avro.realtime.siri.model.ServiceDeliveryRecord;
import org.entur.avro.realtime.siri.model.ServiceRequestRecord;
import uk.org.siri.siri21.MessageRefStructure;
import uk.org.siri.siri21.RequestorRef;
import uk.org.siri.siri21.ServiceDelivery;
import uk.org.siri.siri21.ServiceRequest;

public class ServiceConverter
extends CommonConverter {
    static ServiceRequest convert(ServiceRequestRecord serviceRequest) {
        if (serviceRequest == null) {
            return null;
        }
        ServiceRequest result = new ServiceRequest();
        if (serviceRequest.getRequestTimestamp() != null) {
            result.setRequestTimestamp(ServiceConverter.convertDate(serviceRequest.getRequestTimestamp()));
        }
        if (serviceRequest.getRequestorRef() != null) {
            result.setRequestorRef(ServiceConverter.setValue(RequestorRef.class, serviceRequest.getRequestorRef()));
        }
        if (!ServiceConverter.isNullOrEmpty(serviceRequest.getEstimatedTimetableRequests())) {
            result.getEstimatedTimetableRequests().addAll(SubscriptionConverter.convertEtServiceRequests(serviceRequest.getEstimatedTimetableRequests()));
        }
        if (!ServiceConverter.isNullOrEmpty(serviceRequest.getVehicleMonitoringRequests())) {
            result.getVehicleMonitoringRequests().addAll(SubscriptionConverter.convertVmServiceRequests(serviceRequest.getVehicleMonitoringRequests()));
        }
        if (!ServiceConverter.isNullOrEmpty(serviceRequest.getSituationExchangeRequests())) {
            result.getSituationExchangeRequests().addAll(SubscriptionConverter.convertSxServiceRequests(serviceRequest.getSituationExchangeRequests()));
        }
        return result;
    }

    static ServiceDelivery convert(ServiceDeliveryRecord serviceDelivery) {
        List vmDeliveries;
        List sxDeliveries;
        List estimatedTimetableDeliveries;
        if (serviceDelivery == null) {
            return null;
        }
        ServiceDelivery mapped = new ServiceDelivery();
        if (serviceDelivery.getResponseTimestamp() != null) {
            mapped.setResponseTimestamp(CommonConverter.convertDate(serviceDelivery.getResponseTimestamp()));
        }
        if (serviceDelivery.getProducerRef() != null) {
            mapped.setProducerRef(CommonConverter.setValue(RequestorRef.class, serviceDelivery.getProducerRef()));
        }
        if (serviceDelivery.getRequestMessageRef() != null) {
            mapped.setRequestMessageRef(CommonConverter.setValue(MessageRefStructure.class, serviceDelivery.getRequestMessageRef()));
        }
        if (serviceDelivery.getMoreData() != null) {
            mapped.setMoreData(serviceDelivery.getMoreData());
        }
        if (!ServiceConverter.isNullOrEmpty(estimatedTimetableDeliveries = serviceDelivery.getEstimatedTimetableDeliveries())) {
            mapped.getEstimatedTimetableDeliveries().addAll(EstimatedTimetableDeliveryConverter.convert(estimatedTimetableDeliveries));
        }
        if (!ServiceConverter.isNullOrEmpty(sxDeliveries = serviceDelivery.getSituationExchangeDeliveries())) {
            mapped.getSituationExchangeDeliveries().addAll(SituationExchangeDeliveryConverter.convert(sxDeliveries));
        }
        if (!ServiceConverter.isNullOrEmpty(vmDeliveries = serviceDelivery.getVehicleMonitoringDeliveries())) {
            mapped.getVehicleMonitoringDeliveries().addAll(VehicleMonitoringDeliveryConverter.convert(vmDeliveries));
        }
        return mapped;
    }
}

