/*
 * Decompiled with CFR 0.152.
 */
package org.entur.avro.realtime.siri.converter.avro2jaxb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.entur.avro.realtime.siri.converter.CommonConverter;
import org.entur.avro.realtime.siri.model.EstimatedTimetableRequestRecord;
import org.entur.avro.realtime.siri.model.EstimatedTimetableSubscriptionRecord;
import org.entur.avro.realtime.siri.model.HeartbeatNotificationRecord;
import org.entur.avro.realtime.siri.model.ResponseStatusRecord;
import org.entur.avro.realtime.siri.model.ServiceRequestRecord;
import org.entur.avro.realtime.siri.model.SituationExchangeRequestRecord;
import org.entur.avro.realtime.siri.model.SituationExchangeSubscriptionRecord;
import org.entur.avro.realtime.siri.model.SubscriptionContextRecord;
import org.entur.avro.realtime.siri.model.SubscriptionRequestRecord;
import org.entur.avro.realtime.siri.model.SubscriptionResponseRecord;
import org.entur.avro.realtime.siri.model.TerminateSubscriptionRequestRecord;
import org.entur.avro.realtime.siri.model.TerminateSubscriptionResponseRecord;
import org.entur.avro.realtime.siri.model.TerminationResponseStatusRecord;
import org.entur.avro.realtime.siri.model.VehicleMonitoringRequestRecord;
import org.entur.avro.realtime.siri.model.VehicleMonitoringSubscriptionRecord;
import uk.org.siri.siri21.EstimatedTimetableRequestStructure;
import uk.org.siri.siri21.EstimatedTimetableSubscriptionStructure;
import uk.org.siri.siri21.HeartbeatNotificationStructure;
import uk.org.siri.siri21.MessageQualifierStructure;
import uk.org.siri.siri21.MessageRefStructure;
import uk.org.siri.siri21.OtherErrorStructure;
import uk.org.siri.siri21.RequestorRef;
import uk.org.siri.siri21.ResponseStatus;
import uk.org.siri.siri21.ServiceDeliveryErrorConditionElement;
import uk.org.siri.siri21.ServiceRequest;
import uk.org.siri.siri21.SituationExchangeRequestStructure;
import uk.org.siri.siri21.SituationExchangeSubscriptionStructure;
import uk.org.siri.siri21.SubscriptionContextStructure;
import uk.org.siri.siri21.SubscriptionQualifierStructure;
import uk.org.siri.siri21.SubscriptionRequest;
import uk.org.siri.siri21.SubscriptionResponseStructure;
import uk.org.siri.siri21.TerminateSubscriptionRequestStructure;
import uk.org.siri.siri21.TerminateSubscriptionResponseStructure;
import uk.org.siri.siri21.TerminationResponseStatusStructure;
import uk.org.siri.siri21.VehicleMonitoringRequestStructure;
import uk.org.siri.siri21.VehicleMonitoringSubscriptionStructure;

public class SubscriptionConverter
extends CommonConverter {
    static HeartbeatNotificationStructure convert(HeartbeatNotificationRecord heartbeatNotification) {
        if (heartbeatNotification == null) {
            return null;
        }
        HeartbeatNotificationStructure result = new HeartbeatNotificationStructure();
        result.setStatus(Boolean.valueOf(heartbeatNotification.getStatus()));
        if (heartbeatNotification.getProducerRef() != null) {
            result.setProducerRef(SubscriptionConverter.setValue(RequestorRef.class, heartbeatNotification.getProducerRef()));
        }
        if (heartbeatNotification.getRequestTimestamp() != null) {
            result.setRequestTimestamp(SubscriptionConverter.convertDate(heartbeatNotification.getRequestTimestamp()));
        }
        if (heartbeatNotification.getServiceStartedTime() != null) {
            result.setServiceStartedTime(SubscriptionConverter.convertDate(heartbeatNotification.getServiceStartedTime()));
        }
        return result;
    }

    public static SubscriptionRequest convert(SubscriptionRequestRecord subscriptionRequest) {
        if (subscriptionRequest == null) {
            return null;
        }
        SubscriptionRequest result = new SubscriptionRequest();
        if (subscriptionRequest.getRequestTimestamp() != null) {
            result.setRequestTimestamp(SubscriptionConverter.convertDate(subscriptionRequest.getRequestTimestamp()));
        }
        if (subscriptionRequest.getRequestorRef() != null) {
            result.setRequestorRef(SubscriptionConverter.setValue(RequestorRef.class, subscriptionRequest.getRequestorRef()));
        }
        if (subscriptionRequest.getAddress() != null) {
            result.setAddress(subscriptionRequest.getAddress().toString());
        }
        if (subscriptionRequest.getConsumerAddress() != null) {
            result.setConsumerAddress(subscriptionRequest.getConsumerAddress().toString());
        }
        if (subscriptionRequest.getMessageIdentifier() != null) {
            result.setMessageIdentifier(SubscriptionConverter.setValue(MessageQualifierStructure.class, subscriptionRequest.getMessageIdentifier()));
        }
        if (subscriptionRequest.getSubscriptionContext() != null) {
            result.setSubscriptionContext(SubscriptionConverter.convert(subscriptionRequest.getSubscriptionContext()));
        }
        if (!SubscriptionConverter.isNullOrEmpty(subscriptionRequest.getEstimatedTimetableSubscriptionRequests())) {
            result.getEstimatedTimetableSubscriptionRequests().addAll(SubscriptionConverter.convertEtSubRequests(subscriptionRequest.getEstimatedTimetableSubscriptionRequests()));
        }
        if (!SubscriptionConverter.isNullOrEmpty(subscriptionRequest.getVehicleMonitoringSubscriptionRequests())) {
            result.getVehicleMonitoringSubscriptionRequests().addAll(SubscriptionConverter.convertVmSubRequests(subscriptionRequest.getVehicleMonitoringSubscriptionRequests()));
        }
        if (!SubscriptionConverter.isNullOrEmpty(subscriptionRequest.getSituationExchangeSubscriptionRequests())) {
            result.getSituationExchangeSubscriptionRequests().addAll(SubscriptionConverter.convertSxSubRequests(subscriptionRequest.getSituationExchangeSubscriptionRequests()));
        }
        return result;
    }

    private static List<VehicleMonitoringSubscriptionStructure> convertVmSubRequests(List<VehicleMonitoringSubscriptionRecord> subscriptionRequests) {
        if (SubscriptionConverter.isNullOrEmpty(subscriptionRequests)) {
            return Collections.emptyList();
        }
        ArrayList<VehicleMonitoringSubscriptionStructure> records = new ArrayList<VehicleMonitoringSubscriptionStructure>();
        for (VehicleMonitoringSubscriptionRecord request : subscriptionRequests) {
            records.add(SubscriptionConverter.convert(request));
        }
        return records;
    }

    private static VehicleMonitoringSubscriptionStructure convert(VehicleMonitoringSubscriptionRecord request) {
        if (request == null) {
            return null;
        }
        VehicleMonitoringSubscriptionStructure result = new VehicleMonitoringSubscriptionStructure();
        if (request.getSubscriptionIdentifier() != null) {
            result.setSubscriptionIdentifier(SubscriptionConverter.setValue(SubscriptionQualifierStructure.class, request.getSubscriptionIdentifier()));
        }
        if (request.getSubscriberRef() != null) {
            result.setSubscriberRef(SubscriptionConverter.setValue(RequestorRef.class, request.getSubscriberRef()));
        }
        if (request.getIncrementalUpdates() != null) {
            result.setIncrementalUpdates(request.getIncrementalUpdates());
        }
        if (request.getInitialTerminationTime() != null) {
            result.setInitialTerminationTime(SubscriptionConverter.convertDate(request.getInitialTerminationTime()));
        }
        if (request.getChangeBeforeUpdates() != null) {
            result.setChangeBeforeUpdates(SubscriptionConverter.convertDuration(request.getChangeBeforeUpdates()));
        }
        if (request.getUpdateInterval() != null) {
            result.setUpdateInterval(SubscriptionConverter.convertDuration(request.getUpdateInterval()));
        }
        if (request.getVehicleMonitoringRequest() != null) {
            result.setVehicleMonitoringRequest(SubscriptionConverter.convert(request.getVehicleMonitoringRequest()));
        }
        return result;
    }

    private static VehicleMonitoringRequestStructure convert(VehicleMonitoringRequestRecord request) {
        if (request == null) {
            return null;
        }
        VehicleMonitoringRequestStructure result = new VehicleMonitoringRequestStructure();
        if (request.getVersion() != null) {
            result.setVersion(request.getVersion().toString());
        }
        if (request.getMessageIdentifier() != null) {
            result.setMessageIdentifier(SubscriptionConverter.setValue(MessageQualifierStructure.class, request.getMessageIdentifier()));
        }
        if (request.getRequestTimestamp() != null) {
            result.setRequestTimestamp(SubscriptionConverter.convertDate(request.getRequestTimestamp()));
        }
        return result;
    }

    private static List<SituationExchangeSubscriptionStructure> convertSxSubRequests(List<SituationExchangeSubscriptionRecord> subscriptionRequests) {
        if (SubscriptionConverter.isNullOrEmpty(subscriptionRequests)) {
            return Collections.emptyList();
        }
        ArrayList<SituationExchangeSubscriptionStructure> records = new ArrayList<SituationExchangeSubscriptionStructure>();
        for (SituationExchangeSubscriptionRecord request : subscriptionRequests) {
            records.add(SubscriptionConverter.convert(request));
        }
        return records;
    }

    private static SituationExchangeSubscriptionStructure convert(SituationExchangeSubscriptionRecord request) {
        if (request == null) {
            return null;
        }
        SituationExchangeSubscriptionStructure result = new SituationExchangeSubscriptionStructure();
        if (request.getSubscriberRef() != null) {
            result.setSubscriberRef(SubscriptionConverter.setValue(RequestorRef.class, request.getSubscriberRef()));
        }
        if (request.getSubscriptionIdentifier() != null) {
            result.setSubscriptionIdentifier(SubscriptionConverter.setValue(SubscriptionQualifierStructure.class, request.getSubscriptionIdentifier()));
        }
        result.setIncrementalUpdates(request.getIncrementalUpdates());
        if (request.getInitialTerminationTime() != null) {
            result.setInitialTerminationTime(SubscriptionConverter.convertDate(request.getInitialTerminationTime()));
        }
        if (request.getSituationExchangeRequest() != null) {
            result.setSituationExchangeRequest(SubscriptionConverter.convert(request.getSituationExchangeRequest()));
        }
        return result;
    }

    private static SituationExchangeRequestStructure convert(SituationExchangeRequestRecord request) {
        if (request == null) {
            return null;
        }
        SituationExchangeRequestStructure result = new SituationExchangeRequestStructure();
        if (request.getVersion() != null) {
            result.setVersion(request.getVersion().toString());
        }
        if (request.getMessageIdentifier() != null) {
            result.setMessageIdentifier(SubscriptionConverter.setValue(MessageQualifierStructure.class, request.getMessageIdentifier()));
        }
        if (request.getRequestTimestamp() != null) {
            result.setRequestTimestamp(SubscriptionConverter.convertDate(request.getRequestTimestamp()));
        }
        if (request.getPreviewInterval() != null) {
            result.setPreviewInterval(SubscriptionConverter.convertDuration(request.getPreviewInterval()));
        }
        return result;
    }

    private static List<EstimatedTimetableSubscriptionStructure> convertEtSubRequests(List<EstimatedTimetableSubscriptionRecord> subscriptionRequests) {
        if (SubscriptionConverter.isNullOrEmpty(subscriptionRequests)) {
            return Collections.emptyList();
        }
        ArrayList<EstimatedTimetableSubscriptionStructure> records = new ArrayList<EstimatedTimetableSubscriptionStructure>();
        for (EstimatedTimetableSubscriptionRecord request : subscriptionRequests) {
            records.add(SubscriptionConverter.convert(request));
        }
        return records;
    }

    private static EstimatedTimetableSubscriptionStructure convert(EstimatedTimetableSubscriptionRecord request) {
        if (request == null) {
            return null;
        }
        EstimatedTimetableSubscriptionStructure result = new EstimatedTimetableSubscriptionStructure();
        if (request.getSubscriberRef() != null) {
            result.setSubscriberRef(SubscriptionConverter.setValue(RequestorRef.class, request.getSubscriberRef()));
        }
        if (request.getSubscriptionIdentifier() != null) {
            result.setSubscriptionIdentifier(SubscriptionConverter.setValue(SubscriptionQualifierStructure.class, request.getSubscriptionIdentifier()));
        }
        result.setIncrementalUpdates(request.getIncrementalUpdates());
        if (request.getChangeBeforeUpdates() != null) {
            result.setChangeBeforeUpdates(SubscriptionConverter.convertDuration(request.getChangeBeforeUpdates()));
        }
        if (request.getInitialTerminationTime() != null) {
            result.setInitialTerminationTime(SubscriptionConverter.convertDate(request.getInitialTerminationTime()));
        }
        if (request.getEstimatedTimetableRequest() != null) {
            result.setEstimatedTimetableRequest(SubscriptionConverter.convert(request.getEstimatedTimetableRequest()));
        }
        return result;
    }

    private static EstimatedTimetableRequestStructure convert(EstimatedTimetableRequestRecord request) {
        if (request == null) {
            return null;
        }
        EstimatedTimetableRequestStructure result = new EstimatedTimetableRequestStructure();
        if (request.getVersion() != null) {
            result.setVersion(request.getVersion().toString());
        }
        if (request.getRequestTimestamp() != null) {
            result.setRequestTimestamp(SubscriptionConverter.convertDate(request.getRequestTimestamp()));
        }
        if (request.getPreviewInterval() != null) {
            result.setPreviewInterval(SubscriptionConverter.convertDuration(request.getPreviewInterval()));
        }
        if (request.getMessageIdentifier() != null) {
            result.setMessageIdentifier(SubscriptionConverter.setValue(MessageQualifierStructure.class, request.getMessageIdentifier()));
        }
        return result;
    }

    private static SubscriptionContextStructure convert(SubscriptionContextRecord subscriptionContext) {
        if (subscriptionContext == null) {
            return null;
        }
        SubscriptionContextStructure result = new SubscriptionContextStructure();
        if (subscriptionContext.getHeartbeatInterval() != null) {
            result.setHeartbeatInterval(SubscriptionConverter.convertDuration(subscriptionContext.getHeartbeatInterval()));
        }
        return result;
    }

    public static SubscriptionResponseStructure convert(SubscriptionResponseRecord response) {
        if (response == null) {
            return null;
        }
        SubscriptionResponseStructure result = new SubscriptionResponseStructure();
        if (response.getRequestMessageRef() != null) {
            result.setRequestMessageRef(SubscriptionConverter.setValue(MessageRefStructure.class, response.getRequestMessageRef()));
        }
        if (response.getResponderRef() != null) {
            result.setResponderRef(SubscriptionConverter.setValue(RequestorRef.class, response.getResponderRef()));
        }
        if (response.getResponseTimestamp() != null) {
            result.setResponseTimestamp(SubscriptionConverter.convertDate(response.getResponseTimestamp()));
        }
        if (!SubscriptionConverter.isNullOrEmpty(response.getResponseStatuses())) {
            result.getResponseStatuses().addAll(SubscriptionConverter.convertResponseStatuses(response.getResponseStatuses()));
        }
        return result;
    }

    private static List<ResponseStatus> convertResponseStatuses(List<ResponseStatusRecord> statuses) {
        if (SubscriptionConverter.isNullOrEmpty(statuses)) {
            return Collections.emptyList();
        }
        ArrayList<ResponseStatus> records = new ArrayList<ResponseStatus>();
        for (ResponseStatusRecord status : statuses) {
            records.add(SubscriptionConverter.convert(status));
        }
        return records;
    }

    private static ResponseStatus convert(ResponseStatusRecord status) {
        if (status == null) {
            return null;
        }
        ResponseStatus result = new ResponseStatus();
        if (status.getResponseTimestamp() != null) {
            result.setResponseTimestamp(SubscriptionConverter.convertDate(status.getResponseTimestamp()));
        }
        if (status.getRequestMessageRef() != null) {
            result.setRequestMessageRef(SubscriptionConverter.setValue(MessageRefStructure.class, status.getRequestMessageRef()));
        }
        result.setStatus(status.getStatus());
        if (status.getErrorText() != null) {
            ServiceDeliveryErrorConditionElement errorCondition = new ServiceDeliveryErrorConditionElement();
            OtherErrorStructure otherError = new OtherErrorStructure();
            otherError.setErrorText(status.getErrorText().toString());
            errorCondition.setOtherError(otherError);
            result.setErrorCondition(errorCondition);
        }
        return result;
    }

    public static TerminateSubscriptionRequestStructure convert(TerminateSubscriptionRequestRecord request) {
        if (request == null) {
            return null;
        }
        TerminateSubscriptionRequestStructure result = new TerminateSubscriptionRequestStructure();
        if (request.getMessageIdentifier() != null) {
            result.setMessageIdentifier(SubscriptionConverter.setValue(MessageQualifierStructure.class, request.getMessageIdentifier()));
        }
        if (request.getRequestorRef() != null) {
            result.setRequestorRef(SubscriptionConverter.setValue(RequestorRef.class, request.getRequestorRef()));
        }
        if (request.getRequestTimestamp() != null) {
            result.setRequestTimestamp(SubscriptionConverter.convertDate(request.getRequestTimestamp()));
        }
        if (!SubscriptionConverter.isNullOrEmpty(request.getSubscriptionRefs())) {
            result.getSubscriptionReves().addAll(SubscriptionConverter.setValues(SubscriptionQualifierStructure.class, request.getSubscriptionRefs()));
        }
        return result;
    }

    public static TerminateSubscriptionResponseStructure convert(TerminateSubscriptionResponseRecord request) {
        if (request == null) {
            return null;
        }
        TerminateSubscriptionResponseStructure result = new TerminateSubscriptionResponseStructure();
        if (request.getResponseTimestamp() != null) {
            result.setResponseTimestamp(SubscriptionConverter.convertDate(request.getResponseTimestamp()));
        }
        result.getTerminationResponseStatuses().addAll(SubscriptionConverter.convertStatuses(request.getStatuses()));
        return result;
    }

    private static List<TerminationResponseStatusStructure> convertStatuses(List<TerminationResponseStatusRecord> statuses) {
        if (SubscriptionConverter.isNullOrEmpty(statuses)) {
            return Collections.emptyList();
        }
        ArrayList<TerminationResponseStatusStructure> records = new ArrayList<TerminationResponseStatusStructure>();
        for (TerminationResponseStatusRecord status : statuses) {
            records.add(SubscriptionConverter.convert(status));
        }
        return records;
    }

    private static TerminationResponseStatusStructure convert(TerminationResponseStatusRecord status) {
        if (status == null) {
            return null;
        }
        TerminationResponseStatusStructure result = new TerminationResponseStatusStructure();
        result.setResponseTimestamp(SubscriptionConverter.convertDate(status.getResponseTimestamp()));
        result.setStatus(status.getStatus());
        result.setSubscriberRef(SubscriptionConverter.setValue(RequestorRef.class, status.getSubscriberRef()));
        result.setRequestMessageRef(SubscriptionConverter.setValue(MessageRefStructure.class, status.getRequestMessageRef()));
        result.setErrorCondition(SubscriptionConverter.createErrorCondition(status.getErrorText()));
        return result;
    }

    private static TerminationResponseStatusStructure.ErrorCondition createErrorCondition(CharSequence errorText) {
        if (errorText == null) {
            return null;
        }
        TerminationResponseStatusStructure.ErrorCondition errorCondition = new TerminationResponseStatusStructure.ErrorCondition();
        OtherErrorStructure otherError = new OtherErrorStructure();
        otherError.setErrorText(errorText.toString());
        errorCondition.setOtherError(otherError);
        return errorCondition;
    }

    public static ServiceRequest convert(ServiceRequestRecord serviceRequest) {
        if (serviceRequest == null) {
            return null;
        }
        ServiceRequest result = new ServiceRequest();
        if (serviceRequest.getRequestorRef() != null) {
            result.setRequestorRef(SubscriptionConverter.setValue(RequestorRef.class, serviceRequest.getRequestorRef()));
        }
        if (serviceRequest.getRequestTimestamp() != null) {
            result.setRequestTimestamp(SubscriptionConverter.convertDate(serviceRequest.getRequestTimestamp()));
        }
        if (SubscriptionConverter.isNullOrEmpty(serviceRequest.getVehicleMonitoringRequests())) {
            result.getVehicleMonitoringRequests().addAll(SubscriptionConverter.convertVmServiceRequests(serviceRequest.getVehicleMonitoringRequests()));
        }
        if (SubscriptionConverter.isNullOrEmpty(serviceRequest.getEstimatedTimetableRequests())) {
            result.getEstimatedTimetableRequests().addAll(SubscriptionConverter.convertEtServiceRequests(serviceRequest.getEstimatedTimetableRequests()));
        }
        if (SubscriptionConverter.isNullOrEmpty(serviceRequest.getSituationExchangeRequests())) {
            result.getSituationExchangeRequests().addAll(SubscriptionConverter.convertSxServiceRequests(serviceRequest.getSituationExchangeRequests()));
        }
        return result;
    }

    static List<VehicleMonitoringRequestStructure> convertVmServiceRequests(List<VehicleMonitoringRequestRecord> requests) {
        if (SubscriptionConverter.isNullOrEmpty(requests)) {
            return Collections.emptyList();
        }
        ArrayList<VehicleMonitoringRequestStructure> result = new ArrayList<VehicleMonitoringRequestStructure>();
        for (VehicleMonitoringRequestRecord request : requests) {
            result.add(SubscriptionConverter.convert(request));
        }
        return result;
    }

    static List<EstimatedTimetableRequestStructure> convertEtServiceRequests(List<EstimatedTimetableRequestRecord> requests) {
        if (SubscriptionConverter.isNullOrEmpty(requests)) {
            return Collections.emptyList();
        }
        ArrayList<EstimatedTimetableRequestStructure> result = new ArrayList<EstimatedTimetableRequestStructure>();
        for (EstimatedTimetableRequestRecord request : requests) {
            result.add(SubscriptionConverter.convert(request));
        }
        return result;
    }

    static List<SituationExchangeRequestStructure> convertSxServiceRequests(List<SituationExchangeRequestRecord> requests) {
        if (SubscriptionConverter.isNullOrEmpty(requests)) {
            return Collections.emptyList();
        }
        ArrayList<SituationExchangeRequestStructure> result = new ArrayList<SituationExchangeRequestStructure>();
        for (SituationExchangeRequestRecord request : requests) {
            result.add(SubscriptionConverter.convert(request));
        }
        return result;
    }
}

