/*
 * Decompiled with CFR 0.152.
 */
package org.entur.avro.realtime.siri.converter.avro2jaxb;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.entur.avro.realtime.siri.converter.avro2jaxb.Avro2JaxbEnumConverter;
import org.entur.avro.realtime.siri.model.CallRecord;
import org.entur.avro.realtime.siri.model.LocationRecord;
import org.entur.avro.realtime.siri.model.MonitoredVehicleJourneyRecord;
import org.entur.avro.realtime.siri.model.ProgressBetweenStopsRecord;
import org.entur.avro.realtime.siri.model.VehicleActivityRecord;
import org.entur.avro.realtime.siri.model.VehicleModeEnum;
import org.entur.avro.realtime.siri.model.VehicleMonitoringDeliveryRecord;
import uk.org.siri.siri21.DestinationRef;
import uk.org.siri.siri21.DirectionRefStructure;
import uk.org.siri.siri21.JourneyPlaceRefStructure;
import uk.org.siri.siri21.LineRef;
import uk.org.siri.siri21.LocationStructure;
import uk.org.siri.siri21.MonitoredCallStructure;
import uk.org.siri.siri21.NaturalLanguagePlaceNameStructure;
import uk.org.siri.siri21.NaturalLanguageStringStructure;
import uk.org.siri.siri21.OperatorRefStructure;
import uk.org.siri.siri21.ProgressBetweenStopsStructure;
import uk.org.siri.siri21.StopPointRefStructure;
import uk.org.siri.siri21.VehicleActivityStructure;
import uk.org.siri.siri21.VehicleJourneyRef;
import uk.org.siri.siri21.VehicleModesEnumeration;
import uk.org.siri.siri21.VehicleMonitoringDeliveryStructure;
import uk.org.siri.siri21.VehicleRef;

public class VehicleMonitoringDeliveryConverter
extends Avro2JaxbEnumConverter {
    public static Collection<VehicleMonitoringDeliveryStructure> convert(List<VehicleMonitoringDeliveryRecord> vmDeliveries) {
        ArrayList<VehicleMonitoringDeliveryStructure> results = new ArrayList<VehicleMonitoringDeliveryStructure>();
        for (VehicleMonitoringDeliveryRecord delivery : vmDeliveries) {
            VehicleMonitoringDeliveryStructure deliveryStructure = new VehicleMonitoringDeliveryStructure();
            if (delivery.getResponseTimestamp() != null) {
                deliveryStructure.setResponseTimestamp(VehicleMonitoringDeliveryConverter.convertDate(delivery.getResponseTimestamp()));
            }
            if (delivery.getVersion() != null) {
                deliveryStructure.setVersion(delivery.getVersion().toString());
            }
            for (VehicleActivityRecord vehicleActivityRecord : delivery.getVehicleActivities()) {
                deliveryStructure.getVehicleActivities().add(VehicleMonitoringDeliveryConverter.convert(vehicleActivityRecord));
            }
            results.add(deliveryStructure);
        }
        return results;
    }

    static VehicleActivityStructure convert(VehicleActivityRecord vehicleActivityRecord) {
        VehicleActivityStructure a = new VehicleActivityStructure();
        if (vehicleActivityRecord.getRecordedAtTime() != null) {
            a.setRecordedAtTime(VehicleMonitoringDeliveryConverter.convertDate(vehicleActivityRecord.getRecordedAtTime()));
        }
        if (vehicleActivityRecord.getValidUntilTime() != null) {
            a.setValidUntilTime(VehicleMonitoringDeliveryConverter.convertDate(vehicleActivityRecord.getValidUntilTime()));
        }
        if (vehicleActivityRecord.getProgressBetweenStops() != null) {
            a.setProgressBetweenStops(VehicleMonitoringDeliveryConverter.convert(vehicleActivityRecord.getProgressBetweenStops()));
        }
        if (vehicleActivityRecord.getMonitoredVehicleJourney() != null) {
            a.setMonitoredVehicleJourney(VehicleMonitoringDeliveryConverter.convert(vehicleActivityRecord.getMonitoredVehicleJourney()));
        }
        return a;
    }

    private static ProgressBetweenStopsStructure convert(ProgressBetweenStopsRecord progressBetweenStops) {
        ProgressBetweenStopsStructure progressBetweenStopsStructure = new ProgressBetweenStopsStructure();
        if (progressBetweenStops.getPercentage() != null) {
            progressBetweenStopsStructure.setPercentage(BigDecimal.valueOf(progressBetweenStops.getPercentage()));
        }
        if (progressBetweenStops.getLinkDistance() != null) {
            progressBetweenStopsStructure.setLinkDistance(BigDecimal.valueOf(progressBetweenStops.getLinkDistance()));
        }
        return progressBetweenStopsStructure;
    }

    private static VehicleActivityStructure.MonitoredVehicleJourney convert(MonitoredVehicleJourneyRecord rec) {
        VehicleActivityStructure.MonitoredVehicleJourney vehicleJourney = new VehicleActivityStructure.MonitoredVehicleJourney();
        if (rec.getLineRef() != null) {
            vehicleJourney.setLineRef(VehicleMonitoringDeliveryConverter.setValue(LineRef.class, rec.getLineRef()));
        }
        if (rec.getDirectionRef() != null) {
            vehicleJourney.setDirectionRef(VehicleMonitoringDeliveryConverter.setValue(DirectionRefStructure.class, rec.getDirectionRef()));
        }
        if (rec.getFramedVehicleJourneyRef() != null) {
            vehicleJourney.setFramedVehicleJourneyRef(VehicleMonitoringDeliveryConverter.convert(rec.getFramedVehicleJourneyRef()));
        }
        if (!VehicleMonitoringDeliveryConverter.isNullOrEmpty(rec.getVehicleModes())) {
            vehicleJourney.getVehicleModes().addAll(VehicleMonitoringDeliveryConverter.resolveVehicleModes(rec.getVehicleModes()));
        }
        if (!VehicleMonitoringDeliveryConverter.isNullOrEmpty(rec.getPublishedLineNames())) {
            vehicleJourney.getPublishedLineNames().addAll(VehicleMonitoringDeliveryConverter.setTranslatedValues(NaturalLanguageStringStructure.class, rec.getPublishedLineNames()));
        }
        if (rec.getOperatorRef() != null) {
            vehicleJourney.setOperatorRef(VehicleMonitoringDeliveryConverter.setValue(OperatorRefStructure.class, rec.getOperatorRef()));
        }
        if (rec.getOriginRef() != null) {
            vehicleJourney.setOriginRef(VehicleMonitoringDeliveryConverter.setValue(JourneyPlaceRefStructure.class, rec.getOriginRef()));
        }
        if (!VehicleMonitoringDeliveryConverter.isNullOrEmpty(rec.getOriginNames())) {
            vehicleJourney.getOriginNames().addAll(VehicleMonitoringDeliveryConverter.setTranslatedValues(NaturalLanguagePlaceNameStructure.class, rec.getOriginNames()));
        }
        if (rec.getDestinationRef() != null) {
            vehicleJourney.setDestinationRef(VehicleMonitoringDeliveryConverter.setValue(DestinationRef.class, rec.getDestinationRef()));
        }
        if (!VehicleMonitoringDeliveryConverter.isNullOrEmpty(rec.getDestinationNames())) {
            vehicleJourney.getDestinationNames().addAll(VehicleMonitoringDeliveryConverter.setTranslatedValues(NaturalLanguageStringStructure.class, rec.getDestinationNames()));
        }
        if (rec.getOriginAimedDepartureTime() != null) {
            vehicleJourney.setOriginAimedDepartureTime(VehicleMonitoringDeliveryConverter.convertDate(rec.getOriginAimedDepartureTime()));
        }
        if (rec.getDestinationAimedArrivalTime() != null) {
            vehicleJourney.setDestinationAimedArrivalTime(VehicleMonitoringDeliveryConverter.convertDate(rec.getDestinationAimedArrivalTime()));
        }
        vehicleJourney.setMonitored(rec.getMonitored());
        if (rec.getDataSource() != null) {
            vehicleJourney.setDataSource(rec.getDataSource().toString());
        }
        if (rec.getVehicleLocation() != null) {
            vehicleJourney.setVehicleLocation(VehicleMonitoringDeliveryConverter.convert(rec.getVehicleLocation()));
        }
        if (rec.getLocationRecordedAtTime() != null) {
            vehicleJourney.setLocationRecordedAtTime(VehicleMonitoringDeliveryConverter.convertDate(rec.getLocationRecordedAtTime()));
        }
        if (rec.getBearing() != null) {
            vehicleJourney.setBearing(rec.getBearing());
        }
        if (rec.getVelocity() != null) {
            vehicleJourney.setVelocity(BigInteger.valueOf(rec.getVelocity().intValue()));
        }
        if (rec.getOccupancy() != null) {
            vehicleJourney.setOccupancy(VehicleMonitoringDeliveryConverter.convert(rec.getOccupancy()));
        }
        if (rec.getDelay() != null) {
            vehicleJourney.setDelay(VehicleMonitoringDeliveryConverter.convertDuration(rec.getDelay()));
        }
        vehicleJourney.setInCongestion(rec.getInCongestion());
        if (rec.getVehicleStatus() != null) {
            vehicleJourney.setVehicleStatus(VehicleMonitoringDeliveryConverter.convert(rec.getVehicleStatus()));
        }
        if (rec.getVehicleJourneyRef() != null) {
            vehicleJourney.setVehicleJourneyRef(VehicleMonitoringDeliveryConverter.setValue(VehicleJourneyRef.class, rec.getVehicleJourneyRef()));
        }
        if (rec.getVehicleRef() != null) {
            vehicleJourney.setVehicleRef(VehicleMonitoringDeliveryConverter.setValue(VehicleRef.class, rec.getVehicleRef()));
        }
        if (rec.getMonitoredCall() != null) {
            vehicleJourney.setMonitoredCall(VehicleMonitoringDeliveryConverter.convert(rec.getMonitoredCall()));
        }
        vehicleJourney.setIsCompleteStopSequence(rec.getIsCompleteStopSequence());
        return vehicleJourney;
    }

    private static MonitoredCallStructure convert(CallRecord call) {
        MonitoredCallStructure monitoredCallStructure = new MonitoredCallStructure();
        if (call.getStopPointRef() != null) {
            monitoredCallStructure.setStopPointRef(VehicleMonitoringDeliveryConverter.setValue(StopPointRefStructure.class, call.getStopPointRef()));
        }
        if (call.getOrder() != null) {
            monitoredCallStructure.setOrder(BigInteger.valueOf(call.getOrder().intValue()));
        }
        if (!VehicleMonitoringDeliveryConverter.isNullOrEmpty(call.getStopPointNames())) {
            monitoredCallStructure.getStopPointNames().addAll(VehicleMonitoringDeliveryConverter.setTranslatedValues(NaturalLanguageStringStructure.class, call.getStopPointNames()));
        }
        if (call.getVehicleAtStop() != null) {
            monitoredCallStructure.setVehicleAtStop(call.getVehicleAtStop());
        }
        if (call.getVehicleLocationAtStop() != null) {
            monitoredCallStructure.setVehicleLocationAtStop(VehicleMonitoringDeliveryConverter.convert(call.getVehicleLocationAtStop()));
        }
        if (!VehicleMonitoringDeliveryConverter.isNullOrEmpty(call.getDestinationDisplays())) {
            monitoredCallStructure.getDestinationDisplaies().addAll(VehicleMonitoringDeliveryConverter.setTranslatedValues(NaturalLanguageStringStructure.class, call.getDestinationDisplays()));
        }
        return monitoredCallStructure;
    }

    private static LocationStructure convert(LocationRecord location) {
        LocationStructure loc = new LocationStructure();
        if (location.getSrsName() != null) {
            loc.setSrsName(location.getSrsName().toString());
        }
        if (location.getLatitude() != null) {
            loc.setLatitude(VehicleMonitoringDeliveryConverter.convert(location.getLatitude()));
        }
        if (location.getLongitude() != null) {
            loc.setLongitude(VehicleMonitoringDeliveryConverter.convert(location.getLongitude()));
        }
        return loc;
    }

    private static List<VehicleModesEnumeration> resolveVehicleModes(List<VehicleModeEnum> vehicleModes) {
        if (vehicleModes == null) {
            return null;
        }
        ArrayList<VehicleModesEnumeration> modes = new ArrayList<VehicleModesEnumeration>();
        for (VehicleModeEnum vehicleMode : vehicleModes) {
            modes.add(VehicleModesEnumeration.valueOf((String)vehicleMode.name()));
        }
        return modes;
    }
}

