/*
 * Decompiled with CFR 0.152.
 */
package org.entur.avro.realtime.siri.converter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import org.entur.avro.realtime.siri.model.FramedVehicleJourneyRefRecord;
import org.entur.avro.realtime.siri.model.TranslatedStringRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri21.DataFrameRefStructure;
import uk.org.siri.siri21.FramedVehicleJourneyRefStructure;
import uk.org.siri.siri21.SituationVersion;

public class CommonConverter {
    static final Logger LOG = LoggerFactory.getLogger(CommonConverter.class);
    static final DateTimeFormatter dateTimeFormatter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 6, true).appendZoneId().toFormatter();
    private static final DatatypeFactory datatypeFactory;
    protected static ZoneId forceTimeZone;

    protected static CharSequence getValue(Object item) {
        if (item == null) {
            return null;
        }
        try {
            return (CharSequence)item.getClass().getMethod("getValue", new Class[0]).invoke(item, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOG.warn("Unable to convert - returning null: ", (Throwable)e);
            return null;
        }
    }

    protected static boolean isNullOrEmpty(List items) {
        return items == null || items.isEmpty();
    }

    protected static List<CharSequence> getValues(List items) {
        if (items == null) {
            return Collections.emptyList();
        }
        try {
            ArrayList<CharSequence> values = new ArrayList<CharSequence>();
            for (Object item : items) {
                values.add((CharSequence)item.getClass().getMethod("getValue", new Class[0]).invoke(item, new Object[0]));
            }
            return values;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOG.warn("Unable to convert - returning empty list: ", (Throwable)e);
            return Collections.emptyList();
        }
    }

    protected static <T> T setValue(Class<T> clazz, CharSequence value) {
        try {
            T instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Method method = clazz.getMethod("setValue", String.class);
            method.invoke(instance, value.toString());
            return instance;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOG.warn("Unable to convert - returning null: ", (Throwable)e);
            return null;
        }
    }

    protected static <T> List<T> setValues(Class<T> clazz, List values) {
        if (values == null) {
            return Collections.emptyList();
        }
        try {
            ArrayList<T> result = new ArrayList<T>();
            for (Object value : values) {
                T instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Method method = clazz.getMethod("setValue", String.class);
                method.invoke(instance, value.toString());
                result.add(instance);
            }
            return result;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOG.warn("Unable to convert - returning empty list: ", (Throwable)e);
            return Collections.emptyList();
        }
    }

    protected static List<TranslatedStringRecord> getTranslatedValues(List items) {
        if (items == null) {
            return Collections.emptyList();
        }
        try {
            ArrayList<TranslatedStringRecord> values = new ArrayList<TranslatedStringRecord>();
            for (Object item : items) {
                values.add(TranslatedStringRecord.newBuilder().setValue((CharSequence)item.getClass().getMethod("getValue", new Class[0]).invoke(item, new Object[0])).setLanguage((CharSequence)item.getClass().getMethod("getLang", new Class[0]).invoke(item, new Object[0])).build());
            }
            return values;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOG.warn("Unable to convert - returning empty list: ", (Throwable)e);
            return Collections.emptyList();
        }
    }

    protected static <T> List<T> setTranslatedValues(Class<T> clazz, List<TranslatedStringRecord> value) {
        try {
            ArrayList<T> result = new ArrayList<T>();
            for (TranslatedStringRecord translatedStringRecord : value) {
                T instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Method setValue = clazz.getMethod("setValue", String.class);
                setValue.invoke(instance, "" + translatedStringRecord.getValue());
                if (translatedStringRecord.getLanguage() != null) {
                    Method setLanguage = clazz.getMethod("setLang", String.class);
                    setLanguage.invoke(instance, "" + translatedStringRecord.getLanguage());
                }
                result.add(instance);
            }
            return result;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOG.warn("Unable to convert - returning empty list: ", (Throwable)e);
            return Collections.emptyList();
        }
    }

    protected static CharSequence convert(ZonedDateTime responseTimestamp) {
        if (responseTimestamp == null) {
            return null;
        }
        return dateTimeFormatter.format(responseTimestamp.withZoneSameInstant(ZoneOffset.UTC));
    }

    protected static ZonedDateTime convertDate(CharSequence responseTimestamp) {
        if (responseTimestamp == null) {
            return null;
        }
        if (forceTimeZone != null) {
            return ZonedDateTime.parse(responseTimestamp, dateTimeFormatter).withZoneSameInstant(forceTimeZone);
        }
        return ZonedDateTime.parse(responseTimestamp, dateTimeFormatter);
    }

    protected static List<TranslatedStringRecord> convertNames(List names) {
        if (CommonConverter.isNullOrEmpty(names)) {
            return Collections.emptyList();
        }
        return CommonConverter.getTranslatedValues(names);
    }

    protected static SituationVersion convertVersion(Integer version) {
        SituationVersion situationVersion = new SituationVersion();
        situationVersion.setValue(BigInteger.valueOf(version.intValue()));
        return situationVersion;
    }

    protected static Integer convert(SituationVersion version) {
        if (version == null) {
            return null;
        }
        return version.getValue().intValue();
    }

    protected static Collection<String> convertStringList(List<CharSequence> strings) {
        return strings.stream().map(CharSequence::toString).collect(Collectors.toList());
    }

    protected static Integer convert(BigInteger bigInteger) {
        if (bigInteger == null) {
            return null;
        }
        return bigInteger.intValue();
    }

    protected static BigInteger convert(Integer integer) {
        if (integer == null) {
            return null;
        }
        return BigInteger.valueOf(integer.intValue());
    }

    protected static Double convert(BigDecimal d) {
        if (d == null) {
            return null;
        }
        return d.doubleValue();
    }

    protected static BigDecimal convert(Double d) {
        if (d == null) {
            return null;
        }
        return BigDecimal.valueOf(d);
    }

    protected static CharSequence convert(java.time.Duration duration) {
        if (duration == null) {
            return null;
        }
        return duration.toString();
    }

    protected static CharSequence convert(Duration duration) {
        if (duration == null) {
            return null;
        }
        return duration.toString();
    }

    protected static FramedVehicleJourneyRefStructure convert(FramedVehicleJourneyRefRecord framedVehicleJourneyRef) {
        FramedVehicleJourneyRefStructure framedVehicleJourneyRefStructure = new FramedVehicleJourneyRefStructure();
        if (framedVehicleJourneyRef.getDataFrameRef() != null) {
            framedVehicleJourneyRefStructure.setDataFrameRef(CommonConverter.setValue(DataFrameRefStructure.class, framedVehicleJourneyRef.getDataFrameRef()));
        }
        if (framedVehicleJourneyRef.getDatedVehicleJourneyRef() != null) {
            framedVehicleJourneyRefStructure.setDatedVehicleJourneyRef(framedVehicleJourneyRef.getDatedVehicleJourneyRef().toString());
        }
        return framedVehicleJourneyRefStructure;
    }

    protected static FramedVehicleJourneyRefRecord convert(FramedVehicleJourneyRefStructure framedVehicleJourneyRef) {
        if (framedVehicleJourneyRef == null) {
            return null;
        }
        if (framedVehicleJourneyRef.getDataFrameRef() != null && framedVehicleJourneyRef.getDatedVehicleJourneyRef() != null) {
            return FramedVehicleJourneyRefRecord.newBuilder().setDataFrameRef(CommonConverter.getValue(framedVehicleJourneyRef.getDataFrameRef())).setDatedVehicleJourneyRef((CharSequence)framedVehicleJourneyRef.getDatedVehicleJourneyRef()).build();
        }
        return null;
    }

    protected static java.time.Duration convertDuration(CharSequence duration) {
        return java.time.Duration.parse(duration);
    }

    static {
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
    }
}

